/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.connectionpool;

import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import jeus.jdbc.connectionpool.ConnectionPoolException;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.jdbc.connectionpool.ConnectionPoolInitializer;
import jeus.jdbc.datasource.DBDSBindInfo;
import jeus.jdbc.info.ConnectionPoolInfo;
import jeus.management.JMXUtility;
import jeus.management.RemoteMBeanServerFactory;
import jeus.server.service.JDBCDataSourceServiceMBean;

public class ClientSideConnectionPoolInitializer
implements ConnectionPoolInitializer {
    public Object makeConnectionPool(String dataSourceId, Hashtable env) throws ConnectionPoolException {
        try {
            MBeanServerConnection serverConn = RemoteMBeanServerFactory.getMBeanServer(env);
            ObjectName[] jdbcDataSourceServices = JMXUtility.queryJDBCDataSourceServices(serverConn, dataSourceId);
            if (jdbcDataSourceServices.length == 0) {
                throw new ConnectionPoolException("DataSource is not bound to JNDI : " + dataSourceId);
            }
            JDBCDataSourceServiceMBean serviceInstance = MBeanServerInvocationHandler.newProxyInstance(serverConn, jdbcDataSourceServices[0], JDBCDataSourceServiceMBean.class, false);
            DBDSBindInfo bindInfo = serviceInstance.getDescriptor();
            ConnectionPoolInfo poolInfo = new ConnectionPoolInfo(bindInfo);
            ConnectionPoolImpl pool = new ConnectionPoolImpl(poolInfo);
            pool.initialize(env);
            return pool;
        }
        catch (Throwable th) {
            if (th instanceof ConnectionPoolException) {
                throw (ConnectionPoolException)th;
            }
            throw new ConnectionPoolException("failed to make the ConnectionPool(" + dataSourceId + ")", th);
        }
    }

    public void destroyMBean() {
    }
}

