/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.connectionpool;

import java.util.Hashtable;
import java.util.Properties;
import javax.annotation.Resource;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.spi.ObjectFactory;
import jeus.container.resource.ResourceRefHelper;
import jeus.jdbc.connectionpool.ClientSideClusteredConnectionPoolInitializer;
import jeus.jdbc.connectionpool.ClusterDataSourceWrapper;
import jeus.jdbc.connectionpool.ClusteredConnectionPool;
import jeus.jdbc.connectionpool.ConnectionPoolException;
import jeus.jdbc.connectionpool.ConnectionPoolInitializer;
import jeus.jndi.jns.common.PropertyReference;
import jeus.security.util.LoginUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;

public class ClusterDataSourceFactory
implements ObjectFactory {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.jdbc");
    private static Hashtable<String, ClusteredConnectionPool> pools = new Hashtable();
    private static Object sync = new Object();
    private static ConnectionPoolInitializer poolInitializer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        try {
            if (!(obj instanceof PropertyReference)) {
                throw new Exception("Invalid reference object - " + obj);
            }
            PropertyReference ref = (PropertyReference)obj;
            String dataSourceId = (String)ref.get(0).getContent();
            ClusteredConnectionPool pool = pools.get(dataSourceId);
            if (pool == null) {
                Object object = sync;
                synchronized (object) {
                    pool = pools.get(dataSourceId);
                    if (poolInitializer == null) {
                        poolInitializer = new ClientSideClusteredConnectionPoolInitializer();
                    }
                    if (pool == null) {
                        LoginUtil.loginCodeSubjectWithRuntimeException();
                        try {
                            pool = (ClusteredConnectionPool)poolInitializer.makeConnectionPool(dataSourceId, env);
                            Object var10_10 = null;
                        }
                        catch (Throwable throwable) {
                            Object var10_11 = null;
                            LoginUtil.logoutWithRuntimeException();
                            throw throwable;
                        }
                        LoginUtil.logoutWithRuntimeException();
                        pools.put(dataSourceId, pool);
                    }
                }
            }
            Properties properties = ref.getProperties();
            boolean shareable = ResourceRefHelper.fetchShareable(properties);
            Resource.AuthenticationType resAuthType = ResourceRefHelper.fetchAppAuth(properties);
            return new ClusterDataSourceWrapper(pool, shareable, resAuthType);
        }
        catch (ConnectionPoolException t) {
            logger.log(JeusMessage_JDBC._323_LEVEL, JeusMessage_JDBC._323, (Object)name);
            throw t;
        }
    }

    public static ClusteredConnectionPool getClusteredConnectionPool(String exportName) {
        return pools.get(exportName);
    }

    public static void setPoolInitializer(ConnectionPoolInitializer serverSideInitializer) {
        poolInitializer = serverSideInitializer;
    }
}

