/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.connectionpool;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import jeus.jdbc.common.JeusPooledConnection;
import jeus.jdbc.connectionpool.ClusterDataSourceFactory;
import jeus.jdbc.connectionpool.ConnectionPoolException;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.jdbc.connectionpool.ConnectionPoolManager;
import jeus.jdbc.connectionpool.DataSourceFailedException;
import jeus.jdbc.connectionpool.WaitTimeoutException;
import jeus.jdbc.datasource.ClusterDSBindInfo;
import jeus.jdbc.helper.ClusterDataSourceLoadBalancer;
import jeus.jdbc.helper.DataSourceSelector;
import jeus.jdbc.helper.DefaultRoundRobinDataSourceSelector;
import jeus.jdbc.helper.SimpleRoundRobinLoadBalancer;
import jeus.jdbc.info.ClusterDataSourceInfo;
import jeus.jndi.jns.common.PropertyReference;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessageBundles;
import jeus.util.message.JeusMessage_JDBC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusteredConnectionPool
implements Referenceable {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.jdbc");
    private Hashtable env = new Hashtable();
    private Reference ref = null;
    private volatile ClusterDataSourceInfo poolInfo;
    private ConnectionPoolImpl currentConnectionPool = null;
    private int currentTarget;
    private ReentrantReadWriteLock clusteringLock = new ReentrantReadWriteLock();
    private AtomicBoolean onUpdate = new AtomicBoolean();
    private ClusterDataSourceLoadBalancer loadBalancer;
    private DataSourceSelector dataSourceSelector = null;

    public ClusteredConnectionPool(ClusterDSBindInfo info) throws ConnectionPoolException {
        this(info, null);
    }

    public ClusteredConnectionPool(ClusterDSBindInfo info, Hashtable env) throws ConnectionPoolException {
        this.poolInfo = new ClusterDataSourceInfo(info);
        this.env = env;
        this.setupDataSourceSelector();
    }

    public void initializePool() throws ConnectionPoolException {
        for (int i = 0; i < this.poolInfo.getDataSourceIdList().size(); ++i) {
            ConnectionPoolImpl pool = this.getTargetConnectionPool(i);
            if (pool == null) continue;
            this.currentConnectionPool = pool;
            this.currentTarget = i;
            break;
        }
        if (this.currentConnectionPool == null) {
            String err = JeusMessageBundles.getMessage(JeusMessage_JDBC._321, this.poolInfo.getDataSourceId());
            logger.log(JeusMessage_JDBC._321_LEVEL, err);
            throw new ConnectionPoolException(err);
        }
        if (this.poolInfo.isUseFastFailOver()) {
            this.prepareFastFailOver();
        }
    }

    private void prepareFastFailOver() {
        for (String dataSourceId : this.poolInfo.getDataSourceIdList()) {
            try {
                ConnectionPoolManager.createConnectionPool(dataSourceId, this.env);
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_JDBC._301_LEVEL)) continue;
                logger.logp(JeusMessage_JDBC._301_LEVEL, "ClusteredConnectionPool", "preMakeConnectionFromPool", JeusMessage_JDBC._301, dataSourceId, t);
            }
        }
    }

    public ConnectionPoolImpl getTargetConnectionPool(int target) {
        String dataSourceName = this.poolInfo.getDataSourceIdList().get(target);
        try {
            return ConnectionPoolManager.createConnectionPool(dataSourceName, this.env);
        }
        catch (Throwable th) {
            if (logger.isLoggable(JeusMessage_JDBC._301_LEVEL)) {
                logger.logp(JeusMessage_JDBC._301_LEVEL, "ClusteredConnectionPool", "getDataSource", JeusMessage_JDBC._301, dataSourceName, th);
            }
            return null;
        }
    }

    public Connection getConnection(String username, String password, boolean shareable) throws SQLException {
        if (this.dataSourceSelector != null) {
            if (!(this.dataSourceSelector instanceof DefaultRoundRobinDataSourceSelector)) {
                return this.getConnectionUsingDataSourceSelector(username, password, shareable);
            }
            return this.getConnectionForLoadBalance(username, password, shareable);
        }
        if (this.poolInfo.useFailback()) {
            return this.getConnectionForFailoverAndFailback(username, password, shareable);
        }
        return this.getConnectionForFailoverOnly(username, password, shareable);
    }

    /*
     * Exception decompiling
     */
    private Connection getConnectionForFailoverOnly(String username, String password, boolean shareable) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 11[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Connection getConnectionForFailoverAndFailback(String username, String password, boolean shareable) throws SQLException {
        for (int i = 0; i < this.poolInfo.getDataSourceIdList().size(); ++i) {
            String dataSourceName = this.poolInfo.getDataSourceIdList().get(i);
            try {
                ConnectionPoolImpl pool = ConnectionPoolManager.createConnectionPool(dataSourceName, this.env);
                if (pool == null || pool.isFailed()) continue;
                return pool.getConnection(username, password, shareable);
            }
            catch (Throwable th) {
                if (th instanceof WaitTimeoutException) {
                    throw new SQLException(th.getMessage());
                }
                logger.logp(JeusMessage_JDBC._305_LEVEL, "ClusteredConnectionPool", "getConnection", JeusMessage_JDBC._305, (Object)dataSourceName);
                logger.logp(JeusMessage_JDBC._322_LEVEL, "ClusteredConnectionPool", "getConnection", JeusMessage_JDBC._322, dataSourceName, th);
            }
        }
        throw new DataSourceFailedException(ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._304));
    }

    private Connection getConnectionForLoadBalance(String username, String password, boolean shareable) throws SQLException {
        ArrayList<Integer> failedList = new ArrayList<Integer>();
        int dataSourceListSize = this.dataSourceSelector.getDataSourceListSize();
        while (failedList.size() < dataSourceListSize) {
            int dataSourceIndex = this.dataSourceSelector.selectDataSource();
            String dataSourceId = this.dataSourceSelector.getDataSourceId(dataSourceIndex);
            if (failedList.contains(dataSourceIndex)) continue;
            try {
                ConnectionPoolImpl connectionPool = this.getTargetConnectionPool(dataSourceIndex);
                if (connectionPool != null && !connectionPool.isFailed()) {
                    return connectionPool.getConnection(username, password, shareable);
                }
            }
            catch (Throwable th) {
                if (th instanceof WaitTimeoutException) {
                    throw new SQLException(th.getMessage());
                }
                logger.logp(JeusMessage_JDBC._305_LEVEL, "ClusteredConnectionPool", "getConnection", JeusMessage_JDBC._305, (Object)dataSourceId);
                logger.logp(JeusMessage_JDBC._322_LEVEL, "ClusteredConnectionPool", "getConnection", JeusMessage_JDBC._322, dataSourceId, th);
            }
            failedList.add(dataSourceIndex);
        }
        throw new DataSourceFailedException(ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._304));
    }

    private Connection getConnectionUsingDataSourceSelector(String username, String password, boolean shareable) throws SQLException {
        int dataSourceListSize = this.dataSourceSelector.getDataSourceListSize();
        int dataSourceIndex = this.dataSourceSelector.selectDataSource();
        logger.log(JeusMessage_JDBC._389_LEVEL, JeusMessage_JDBC._389, (Object)this.poolInfo.getDataSourceId());
        do {
            String dataSourceId = this.dataSourceSelector.getDataSourceId(dataSourceIndex);
            try {
                ConnectionPoolImpl connectionPool = this.getTargetConnectionPool(dataSourceIndex);
                if (connectionPool != null && !connectionPool.isFailed()) {
                    return connectionPool.getConnection(username, password, shareable);
                }
            }
            catch (Throwable th) {
                if (th instanceof WaitTimeoutException) {
                    throw new SQLException(th.getMessage());
                }
                logger.logp(JeusMessage_JDBC._305_LEVEL, "ClusteredConnectionPool", "getConnection", JeusMessage_JDBC._305, (Object)dataSourceId);
                logger.logp(JeusMessage_JDBC._322_LEVEL, "ClusteredConnectionPool", "getConnection", JeusMessage_JDBC._322, dataSourceId, th);
            }
            if (dataSourceIndex == dataSourceListSize - 1) {
                dataSourceIndex = 0;
                continue;
            }
            ++dataSourceIndex;
        } while (dataSourceIndex != dataSourceListSize);
        throw new DataSourceFailedException(ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._304));
    }

    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    public void setLoginTimeout(int seconds) throws SQLException {
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    String getDataSourceId() {
        return this.poolInfo.getDataSourceId();
    }

    int getType() {
        return -1;
    }

    String getDriverVendorName() {
        return null;
    }

    @Override
    public Reference getReference() throws NamingException {
        if (this.ref == null) {
            this.ref = new PropertyReference(this.getClass().getName(), ClusterDataSourceFactory.class.getName(), null);
            this.ref.add(0, new StringRefAddr("data-source-id", this.poolInfo.getDataSourceId()));
        }
        return this.ref;
    }

    String getDataSourceList() {
        return this.poolInfo.getDataSourceIdListAsString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void failbackManually() throws ConnectionPoolException {
        if (this.poolInfo.useLoadBalancing()) {
            throw new ConnectionPoolException(JeusMessage_JDBC._63);
        }
        JeusPooledConnection testCon = null;
        if (this.poolInfo.useFailback()) {
            ConnectionPoolImpl primaryCP = this.getTargetConnectionPool(0);
            if (!primaryCP.isFailed()) throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._39, this.poolInfo.getDataSourceId()));
            try {
                testCon = primaryCP.createNewPooledConnectionForFailOver();
                assert (testCon != null);
                primaryCP.handleConnectionForFailOver(testCon);
                primaryCP.forcedShrink();
                primaryCP.changeFailedState(true, false);
                return;
            }
            catch (SQLException e) {
                throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._305, this.poolInfo.getDataSourceIdList().get(0)), (Throwable)e);
            }
        }
        this.clusteringLock.writeLock().lock();
        int prevTarget = this.currentTarget;
        try {
            if (this.currentTarget == 0) throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._39, this.poolInfo.getDataSourceId()));
            ConnectionPoolImpl prevConnectionPool = this.currentConnectionPool;
            this.currentConnectionPool = this.getTargetConnectionPool(0);
            if (this.currentConnectionPool == null) throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._301, this.poolInfo.getDataSourceIdList().get(0)));
            try {
                testCon = this.currentConnectionPool.createNewPooledConnectionForFailOver();
                assert (testCon != null);
                this.currentConnectionPool.handleConnectionForFailOver(testCon);
                this.currentConnectionPool.forcedShrink();
                this.currentTarget = 0;
            }
            catch (SQLException e) {
                if (this.currentConnectionPool == null) throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._305, this.poolInfo.getDataSourceIdList().get(0)), (Throwable)e);
                this.currentTarget = prevTarget;
                this.currentConnectionPool = prevConnectionPool;
                throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._305, this.poolInfo.getDataSourceIdList().get(0)), (Throwable)e);
            }
            Object var6_7 = null;
            this.clusteringLock.writeLock().unlock();
            return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.clusteringLock.writeLock().unlock();
            throw throwable;
        }
    }

    long getCheckQueryPeriod() {
        return this.currentConnectionPool.getConnectionPoolInfo().getCheckQueryPeriod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperties(Map<String, Object> properties) throws ConnectionPoolException {
        if (!this.onUpdate.compareAndSet(false, true)) {
            throw new ConnectionPoolException("update process is already progressing");
        }
        ClusterDataSourceInfo previousInfo = this.poolInfo;
        try {
            block15: {
                try {
                    String dataSourceIdList = previousInfo.getDataSourceIdListAsString();
                    boolean isDataSourceIdListChanged = false;
                    boolean useFailback = previousInfo.useFailback();
                    boolean useFastFailOver = previousInfo.isUseFastFailOver();
                    boolean useLoadbalancing = previousInfo.useLoadBalancing();
                    String value = (String)properties.get("DataSourceList");
                    if (value != null) {
                        if (dataSourceIdList.equals("")) {
                            throw new ConnectionPoolException("data source list can't be empty : " + previousInfo.getDataSourceId());
                        }
                        if (!dataSourceIdList.equals(value)) {
                            isDataSourceIdListChanged = true;
                            dataSourceIdList = value;
                        }
                    }
                    if ((value = (String)properties.get("UseFastFailOver")) != null) {
                        useFastFailOver = Boolean.parseBoolean(value);
                    }
                    if ((value = (String)properties.get("UseFailback")) != null) {
                        useFailback = Boolean.parseBoolean(value);
                    }
                    if ((value = (String)properties.get("UseLoadbalancing")) != null) {
                        useLoadbalancing = Boolean.parseBoolean(value);
                    }
                    ClusterDataSourceInfo newInfo = new ClusterDataSourceInfo(previousInfo.getDataSourceId());
                    newInfo.setDataSourceIdListAsString(dataSourceIdList);
                    newInfo.setUseFastFailOver(useFastFailOver);
                    newInfo.setUseFailback(useFailback);
                    newInfo.setUseLoadBalancing(useLoadbalancing);
                    if (isDataSourceIdListChanged && !useFailback) {
                        this.clusteringLock.writeLock().lock();
                        try {
                            this.poolInfo = newInfo;
                            this.setLoadBalancer();
                            this.initializePool();
                            Object var11_11 = null;
                            this.clusteringLock.writeLock().unlock();
                        }
                        catch (Throwable throwable) {
                            Object var11_12 = null;
                            this.clusteringLock.writeLock().unlock();
                            throw throwable;
                        }
                    }
                    this.poolInfo = newInfo;
                    this.setLoadBalancer();
                    if (!useFastFailOver) break block15;
                    this.prepareFastFailOver();
                }
                catch (Throwable th) {
                    this.poolInfo = previousInfo;
                    if (th instanceof ConnectionPoolException) {
                        throw (ConnectionPoolException)th;
                    }
                    throw new ConnectionPoolException(JeusMessageBundles.getMessage(JeusMessage_JDBC._206, this.poolInfo.getDataSourceId()), th);
                }
            }
            Object var13_14 = null;
            this.onUpdate.set(false);
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            this.onUpdate.set(false);
            throw throwable;
        }
    }

    private void setLoadBalancer() {
        if (this.poolInfo.useLoadBalancing()) {
            this.loadBalancer = new SimpleRoundRobinLoadBalancer(this.poolInfo.getDataSourceIdList(), this);
        }
    }

    private void setupDataSourceSelector() throws ConnectionPoolException {
        if (this.poolInfo.getDataSourceSelectorFQCN() != null) {
            try {
                Class<?> dataSourceSelectorClass = Class.forName(this.poolInfo.getDataSourceSelectorFQCN());
                this.dataSourceSelector = (DataSourceSelector)dataSourceSelectorClass.newInstance();
                this.dataSourceSelector.initialize(this.poolInfo.getDataSourceIdList());
            }
            catch (Exception e) {
                logger.log(JeusMessage_JDBC._388_LEVEL, JeusMessage_JDBC._388, (Object)this.poolInfo.getDataSourceId());
                throw new ConnectionPoolException("failed to set up data source selector of cluster data source : [{0}]", (Throwable)e);
            }
        } else if (this.poolInfo.useLoadBalancing()) {
            this.dataSourceSelector = new DefaultRoundRobinDataSourceSelector();
            this.dataSourceSelector.initialize(this.poolInfo.getDataSourceIdList());
        }
    }

    public Hashtable getEnv() {
        return this.env;
    }
}

