/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.connectionpool;

import com.sybase.jdbc2.jdbc.SybDriver;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import jeus.jdbc.common.AbstractJeusPooledConnection;
import jeus.jdbc.common.JeusConnection;
import jeus.jdbc.common.JeusConnectionImpl;
import jeus.jdbc.common.JeusPooledConnection;
import jeus.jdbc.connectionpool.CPObjectFactory;
import jeus.jdbc.connectionpool.ConnectionEventListenerImpl;
import jeus.jdbc.connectionpool.ConnectionPoolException;
import jeus.jdbc.connectionpool.JeusSQLException;
import jeus.jdbc.connectionpool.PooledConnectionProviderImpl;
import jeus.jdbc.helper.ConnectionPoolDBAHelper;
import jeus.jdbc.helper.LogicalConnectionPreparerImpl;
import jeus.jdbc.helper.PeriodicConnectionChecker;
import jeus.jdbc.info.CPInfo;
import jeus.jdbc.info.ConnectionPoolInfo;
import jeus.jdbc.info.DynamicPoolStatsAndInfo;
import jeus.jdbc.info.JDBCPooledConnectionInfo;
import jeus.jdbc.vendorhook.VendorHookFactory;
import jeus.jdbc.vendorhook.VendorSpecificHook;
import jeus.jdbc.xa.JDBCLocalXAResourceWrapper;
import jeus.jndi.jns.common.PropertyReference;
import jeus.jndi.objectfactory.SerializableRefAddr;
import jeus.management.j2ee.statistics.BoundedRangeStatisticImpl;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.server.enginecontainer.InvocationManagerCenter;
import jeus.transaction.TMCommonService;
import jeus.transaction.ThreadContexts;
import jeus.transaction.TransactionImpl;
import jeus.transaction.TransactionLocal;
import jeus.transaction.TxHelper;
import jeus.transaction.resources.LocalXAResourceWrapper;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessageBundles;
import jeus.util.message.JeusMessage_JDBC;
import jeus.util.properties.JeusJDBCProperties;
import jeus.util.properties.JeusManagerProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionPoolImpl
implements Referenceable {
    private static final JeusLogger logger;
    private PooledConnectionProviderImpl pooledConnectionProvider;
    private ConnectionPoolDBAHelper dbaHelper;
    private Object datasrc;
    private ConnectionPoolInfo info;
    private Reference ref;
    private volatile DataSource nonTxDelegatedDataSource;
    private VendorSpecificHook vendorHook;
    private LogicalConnectionPreparerImpl logicalConnectionPreparer;
    private PeriodicConnectionChecker periodicChecker;
    private DynamicPoolStatsAndInfo stats;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AtomicBoolean working = new AtomicBoolean(false);
    private final AtomicBoolean onUpdate = new AtomicBoolean(false);
    private final AtomicBoolean failed = new AtomicBoolean(false);
    private boolean isLocalXAPool = false;
    private boolean isXAPool = false;
    private boolean jtaSupported;
    private static TransactionManager txManager;
    private TransactionLocal<JeusPooledConnection> sharedPhysicalConnection = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConnectionPoolImpl(ConnectionPoolInfo info) {
        this(info, null);
    }

    public ConnectionPoolImpl(ConnectionPoolInfo info, Reference ref) {
        this.info = info;
    }

    public void initialize(Hashtable env) throws ConnectionPoolException {
        try {
            int type = this.info.getPoolType();
            if (this.info.isNonTxDelegatedDataSourceRequired() && (type == 2 || type == 3)) {
                this.setNonTxDelegatedDataSource((DataSource)new InitialContext(env).lookup(this.info.getNonTxDelegatedDataSourceName()));
            }
            if (this.info.isDbaDataSourceUsed()) {
                this.dbaHelper = new ConnectionPoolDBAHelper(this.info, env);
            }
            this.isLocalXAPool = this.info.getPoolType() == 3;
            boolean bl = this.isXAPool = this.info.getPoolType() == 2;
            if (this.isLocalXAPool || this.isXAPool) {
                this.sharedPhysicalConnection = new TransactionLocal();
                this.jtaSupported = true;
            }
            this.info.setUpDataSource();
            this.datasrc = this.info.getDataSource();
            this.stats = new DynamicPoolStatsAndInfo(this.info);
            this.vendorHook = VendorHookFactory.createHook(this.info.getDBMSType());
            this.vendorHook.initializeHook(this.datasrc, this.info);
            this.logicalConnectionPreparer = new LogicalConnectionPreparerImpl(this);
            this.pooledConnectionProvider = new PooledConnectionProviderImpl(this, this.stats);
            this.pooledConnectionProvider.initProvider();
            long checkQueryPeriod = this.info.getCheckQueryPeriod();
            if (this.info.needConnectionValidation() && checkQueryPeriod > 0L) {
                this.startPeriodicChecker(checkQueryPeriod);
            }
            this.initialized.set(true);
            this.working.set(true);
        }
        catch (Throwable th) {
            if (this.pooledConnectionProvider != null) {
                this.pooledConnectionProvider.destroy();
            }
            if (th instanceof ConnectionPoolException) {
                throw (ConnectionPoolException)th;
            }
            throw new ConnectionPoolException(JeusMessageBundles.getMessage(JeusMessage_JDBC._4, this.info.getDataSourceId()), th);
        }
    }

    public Object getOriginalDataSource() {
        return this.datasrc;
    }

    public void setNonTxDelegatedDataSource(DataSource dataSourceInstance) {
        this.nonTxDelegatedDataSource = dataSourceInstance;
    }

    public JeusConnectionImpl getConnectionToCheck() throws SQLException {
        this.checkWorkingNow();
        return this.innerGetConnection(null, null, true, false);
    }

    public void handleConnectionForFailOver(JeusPooledConnection pcon) {
        if (pcon.isDisposable()) {
            this.pooledConnectionProvider.closeConnection(pcon);
        } else {
            this.pooledConnectionProvider.returnConnection(pcon);
        }
    }

    public JeusPooledConnection createNewPooledConnectionForFailOver() throws SQLException {
        return this.pooledConnectionProvider.createNewConnectionForFailOver();
    }

    public ConnectionPoolDBAHelper getDbaHelper() {
        return this.dbaHelper;
    }

    public boolean isHandleNullTransaction() {
        return this.info.isNonTxDelegatedDataSourceRequired() && this.nonTxDelegatedDataSource != null;
    }

    public String getDriverVendorName() {
        return this.info.getDriverVendorName();
    }

    public void connectionClosed(JeusPooledConnection con) {
        this.closeConnection(con, false, false);
    }

    public void connectionErrorOccurred(JeusPooledConnection con) {
        this.closeConnection(con, true, false);
    }

    private void closeConnection(JeusPooledConnection pcon, boolean abnormalClose, boolean rawXAConnection) {
        logger.log(JeusMessage_JDBC._353_LEVEL, JeusMessage_JDBC._353, (Object)pcon);
        if (!pcon.changeToIdle()) {
            logger.log(JeusMessage_JDBC._375_LEVEL, JeusMessage_JDBC._375, (Object)pcon);
            return;
        }
        if (!rawXAConnection) {
            this.cleanupConnection(pcon, abnormalClose);
        }
        this.returnOrKillConnection(pcon, abnormalClose, rawXAConnection);
    }

    private void cleanupConnection(JeusPooledConnection pcon, boolean abnormalClose) {
        pcon.setDatabaseSessionId(null);
        pcon.setThreadNameInUse(null);
        this.logicalConnectionPreparer.stripConnectionHandleResource(pcon, abnormalClose);
        pcon.setAssociatedTransaction(false, null);
        pcon.removeConnectionEventListener();
        if (this.info.isConnectionTraceEnabled()) {
            pcon.clearAllConnectionTraces();
        }
    }

    private void returnOrKillConnection(JeusPooledConnection pcon, boolean abnormalClose, boolean rawXAConnection) {
        if (pcon.isClosed()) {
            return;
        }
        if (pcon.isDisposable()) {
            this.pooledConnectionProvider.closeConnection(pcon);
            return;
        }
        if (abnormalClose || pcon.shouldForciblyClosed()) {
            if (logger.isLoggable(JeusMessage_JDBC._341_LEVEL)) {
                logger.log(JeusMessage_JDBC._341_LEVEL, JeusMessage_JDBC._341, (Object)pcon);
            }
            try {
                this.pooledConnectionProvider.connectionAbnormallyClosed(pcon);
            }
            catch (Throwable ex) {
                if (logger.isLoggable(JeusMessage_JDBC._354_LEVEL)) {
                    logger.log(JeusMessage_JDBC._354_LEVEL, JeusMessage_JDBC._354, pcon, ex);
                }
            }
        } else {
            long currentTime = System.currentTimeMillis();
            pcon.setStateChangedTime(currentTime);
            if (rawXAConnection || !this.jtaSupported || !pcon.isShared() || !TxHelper.isTransactionActive()) {
                this.pooledConnectionProvider.returnConnection(pcon);
            }
        }
    }

    public Connection getConnection(String username, String password, boolean shareable) throws SQLException {
        this.checkWorkingNow();
        this.checkTransactionTimeout();
        this.checkThreadInterrupted();
        if ((this.isXAPool || this.isLocalXAPool) && this.info.isNonTxDelegatedDataSourceRequired() && this.nonTxDelegatedDataSource != null && TMCommonService.isAssociatedWithNullTransaction()) {
            return this.nonTxDelegatedDataSource.getConnection(username, password);
        }
        return this.innerGetConnection(username, password, false, shareable);
    }

    private JeusConnectionImpl innerGetConnection(String username, String password, boolean returnNullOnEmptyQueue, boolean shareable) throws SQLException {
        PooledConnection pcon = null;
        JeusConnectionImpl connection = null;
        try {
            Transaction tx = txManager.getTransaction();
            if (tx != null) {
                if (this.isLocalXAPool && !shareable) {
                    throw new SQLException(ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._342));
                }
                if (this.isLocalXAPool) {
                    pcon = this.checkAndGetEnlistedLocalXAConnection((TransactionImpl)tx);
                } else if (this.isXAPool && shareable) {
                    pcon = this.sharedPhysicalConnection.get();
                }
            }
            if (pcon == null && (pcon = this.prepareConnection(username, password, returnNullOnEmptyQueue, false)) != null) {
                tx = txManager.getTransaction();
                if (tx != null && this.jtaSupported && shareable) {
                    tx.registerSynchronization(new SharedConnectionSynchronization((JeusPooledConnection)pcon));
                    if (this.isLocalXAPool) {
                        this.enlistLocalXAConnection((TransactionImpl)tx, (JeusPooledConnection)pcon);
                    } else {
                        this.sharedPhysicalConnection.set((JeusPooledConnection)pcon);
                    }
                    pcon.setShared(true);
                    pcon.setClosable(false);
                } else {
                    pcon.setShared(false);
                }
            }
            if (pcon != null) {
                connection = pcon.getJeusConnection();
                if (!$assertionsDisabled && connection == null) {
                    throw new AssertionError();
                }
                this.registerConnectionResource((JeusPooledConnection)pcon, connection);
                pcon.setThreadNameInUse(Thread.currentThread().getName());
                if (this.info.isConnectionTraceEnabled()) {
                    connection.setConnectionTrace(new Throwable());
                    pcon.setConnectionTrace(connection);
                }
                this.vendorHook.beforeReturnConnection(connection);
                this.checkTransactionTimeout();
                this.checkThreadInterrupted();
                pcon.changeToActive();
                pcon.setStateChangedTime(System.currentTimeMillis());
            }
            return connection;
        }
        catch (Throwable th) {
            try {
                if (connection != null) {
                    connection.close();
                } else if (pcon != null) {
                    pcon.close();
                }
            }
            catch (SQLException ignored) {
                // empty catch block
            }
            logger.log(JeusMessage_JDBC._218_LEVEL, JeusMessage_JDBC._218, this.getDataSourceId(), th);
            if (th instanceof SQLException) {
                throw (SQLException)th;
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw new JeusSQLException(th);
        }
    }

    private JeusPooledConnection prepareConnection(String username, String password, boolean returnNullOnEmptyQueue, boolean rawXASupport) throws SQLException {
        JeusPooledConnection pcon = this.pooledConnectionProvider.getPooledConnection(username, password, returnNullOnEmptyQueue);
        if (pcon == null) {
            return null;
        }
        boolean needConnectionValidation = this.info.needConnectionValidation() && !pcon.isDisposable();
        int currentGeneration = pcon.getGeneration();
        int tryCount = needConnectionValidation ? (this.info.getDestoryPolicyOnCheckQuery() == 1 ? 2 + this.info.getCheckQueryRetrialCount() : 1 + this.info.getCheckQueryRetrialCount()) : 1;
        while (true) {
            try {
                if (rawXASupport) {
                    if (needConnectionValidation) {
                        Connection actualHandle = pcon.getActualHandle();
                        this.logicalConnectionPreparer.checkConnection(actualHandle, pcon);
                    }
                } else {
                    this.logicalConnectionPreparer.prepareConnectionHandle(pcon, this);
                    if (needConnectionValidation) {
                        Connection actualHandle = pcon.getActualHandle();
                        this.logicalConnectionPreparer.checkConnection(actualHandle, pcon);
                    }
                    if (this.dbaHelper != null) {
                        try {
                            this.dbaHelper.prepareDatabaseSessionId(pcon);
                        }
                        catch (SQLException e) {
                            logger.log(JeusMessage_JDBC._326_LEVEL, JeusMessage_JDBC._326, pcon.getConnectionId(), (Throwable)e);
                        }
                    }
                    pcon.addConnectionEventListener(new ConnectionEventListenerImpl(this, pcon));
                }
                return pcon;
            }
            catch (SQLException e) {
                --tryCount;
                if (pcon != null) {
                    if (logger.isLoggable(JeusMessage_JDBC._220_LEVEL)) {
                        logger.log(JeusMessage_JDBC._220_LEVEL, JeusMessage_JDBC._220, pcon, (Throwable)e);
                    }
                    this.cleanupConnection(pcon, true);
                    this.pooledConnectionProvider.closeConnection(pcon);
                }
                if (pcon != null && pcon.isDisposable()) {
                    throw new JeusSQLException(JeusMessage_JDBC._8, (Object)this.getDataSourceId(), (Throwable)e);
                }
                if (tryCount < 0) {
                    throw e;
                }
                if (needConnectionValidation) {
                    if (tryCount >= 1 && (pcon = this.pooledConnectionProvider.getPooledConnectionDirectly()) != null) continue;
                    if (this.info.getDestoryPolicyOnCheckQuery() == 1) {
                        this.pooledConnectionProvider.purgeAllConnections(currentGeneration);
                    }
                }
                if (logger.isLoggable(JeusMessage_JDBC._337_LEVEL)) {
                    logger.log(JeusMessage_JDBC._337_LEVEL, JeusMessage_JDBC._337, (Object)this.getDataSourceId());
                }
                try {
                    pcon = this.createNewPooledConnectionForFailOver();
                    needConnectionValidation = false;
                }
                catch (Throwable th) {
                    if (this.periodicChecker != null) {
                        this.changeFailedState(false, true);
                    }
                    if (th instanceof SQLException) {
                        throw (SQLException)th;
                    }
                    if (th instanceof RuntimeException) {
                        throw (RuntimeException)th;
                    }
                    throw new JeusSQLException(th);
                }
            }
        }
    }

    private JeusPooledConnection checkAndGetEnlistedLocalXAConnection(TransactionImpl tx) throws SQLException {
        JDBCLocalXAResourceWrapper jdbcLocalXA;
        LocalXAResourceWrapper lrsc = tx.getLocalXAResource();
        if (lrsc == null) {
            return null;
        }
        if (lrsc instanceof JDBCLocalXAResourceWrapper && (jdbcLocalXA = (JDBCLocalXAResourceWrapper)lrsc).getConnectionPool() == this) {
            JeusPooledConnection jeusConn = jdbcLocalXA.getJeusPooledConnection();
            if (logger.isLoggable(JeusMessage_JDBC._311_LEVEL)) {
                logger.log(JeusMessage_JDBC._311_LEVEL, JeusMessage_JDBC._311, (Object)jeusConn);
            }
            return jeusConn;
        }
        throw new SQLException(ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._344));
    }

    private void enlistLocalXAConnection(TransactionImpl tx, JeusPooledConnection pcon) throws SQLException {
        try {
            JDBCLocalXAResourceWrapper lrsc = new JDBCLocalXAResourceWrapper(pcon, this);
            tx.setLocalXAResource(lrsc);
            pcon.setAssociatedTransaction(true, tx.getGTID());
            if (logger.isLoggable(JeusMessage_JDBC._9_LEVEL)) {
                logger.log(JeusMessage_JDBC._9_LEVEL, JeusMessage_JDBC._9, (Object[])new String[]{this.info.getDataSourceId(), tx.getGTID().toString()});
            }
        }
        catch (Throwable ex) {
            logger.logp(JeusMessage_JDBC._11_LEVEL, "ConnectionPool", "enlistLocalXAResource", JeusMessage_JDBC._11, (Object)this.info.getDataSourceId());
            throw new JeusSQLException(ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._11, this.info.getDataSourceId()), ex);
        }
    }

    private void checkTransactionTimeout() throws SQLException {
        if ((this.isXAPool || this.isLocalXAPool) && TMCommonService.isTxTimeout()) {
            SQLException ex = new SQLException(ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._355, ThreadContexts.getAssociatedTransactionID()));
            if (logger.isLoggable(JeusMessage_JDBC._355_LEVEL)) {
                logger.log(JeusMessage_JDBC._355_LEVEL, "", (Throwable)ex);
            }
            throw ex;
        }
    }

    private void checkThreadInterrupted() throws SQLException {
        if (JeusManagerProperties.CHECK_INTERRUPTED_STATUS && Thread.interrupted()) {
            throw new SQLException("the current thread is interrupted");
        }
    }

    private void checkWorkingNow() throws SQLException {
        if (!this.working.get()) {
            String err = JeusMessageBundles.getMessage(JeusMessage_JDBC._14, this.info.getDataSourceId());
            logger.log(JeusMessage_JDBC._14_LEVEL, err);
            throw new SQLException(err);
        }
    }

    void registerConnectionResource(JeusPooledConnection pcon, JeusConnection vcon) {
        pcon.scheduleSessionKillTrigger(this.info.getSessionKillTimeout());
        InvocationManagerCenter.addResource(vcon.getManagedResource());
    }

    public void removeConnectionResource(JeusPooledConnection pcon, JeusConnection connection) {
        pcon.cancelSessionKillTrigger();
        InvocationManagerCenter.removeResource(connection.getManagedResource());
    }

    public JeusPooledConnection getXAControlConnection(boolean useDisposableOnly) throws SQLException {
        return this.pooledConnectionProvider.getXAControlConnection(useDisposableOnly);
    }

    public void closeControlConnection(JeusPooledConnection pcon) {
        this.returnOrKillConnection(pcon, false, false);
    }

    public XAConnection getRawXAConnection() throws SQLException {
        if (this.info.getPoolType() != 2) {
            throw new SQLException(ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._343));
        }
        this.checkWorkingNow();
        JeusPooledConnection pcon = this.prepareConnection(null, null, false, true);
        if (pcon == null) {
            throw new SQLException("There is no available connection");
        }
        pcon.setRawConnection(true);
        pcon.changeToActive();
        pcon.setStateChangedTime(System.currentTimeMillis());
        return pcon;
    }

    public void closeRawXAConnection(XAConnection con, boolean abnormalClose) throws SQLException {
        if (this.info.getPoolType() != 2) {
            throw new SQLException(ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._343));
        }
        if (!(con instanceof JeusPooledConnection)) {
            throw new SQLException("Not a JeusPooledConnection - " + con);
        }
        JeusPooledConnection pcon = (JeusPooledConnection)con;
        pcon.setRawConnection(false);
        this.closeConnection(pcon, abnormalClose, true);
    }

    public PrintWriter getLogWriter() throws SQLException {
        if (this.datasrc instanceof DataSource) {
            return ((DataSource)this.datasrc).getLogWriter();
        }
        if (this.datasrc instanceof ConnectionPoolDataSource) {
            return ((ConnectionPoolDataSource)this.datasrc).getLogWriter();
        }
        if (this.datasrc instanceof XADataSource) {
            return ((XADataSource)this.datasrc).getLogWriter();
        }
        throw new RuntimeException("Never happen");
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        if (this.datasrc instanceof DataSource) {
            ((DataSource)this.datasrc).setLogWriter(out);
        } else if (this.datasrc instanceof ConnectionPoolDataSource) {
            ((ConnectionPoolDataSource)this.datasrc).setLogWriter(out);
        } else if (this.datasrc instanceof XADataSource) {
            ((XADataSource)this.datasrc).setLogWriter(out);
        } else {
            throw new RuntimeException("Never happen");
        }
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        if (this.datasrc instanceof DataSource) {
            ((DataSource)this.datasrc).setLoginTimeout(seconds);
        } else if (this.datasrc instanceof ConnectionPoolDataSource) {
            ((ConnectionPoolDataSource)this.datasrc).setLoginTimeout(seconds);
        } else if (this.datasrc instanceof XADataSource) {
            ((XADataSource)this.datasrc).setLoginTimeout(seconds);
        } else {
            throw new RuntimeException("Never happen");
        }
    }

    public int getLoginTimeout() throws SQLException {
        if (this.datasrc instanceof DataSource) {
            return ((DataSource)this.datasrc).getLoginTimeout();
        }
        if (this.datasrc instanceof ConnectionPoolDataSource) {
            return ((ConnectionPoolDataSource)this.datasrc).getLoginTimeout();
        }
        if (this.datasrc instanceof XADataSource) {
            return ((XADataSource)this.datasrc).getLoginTimeout();
        }
        throw new RuntimeException("Never happen");
    }

    public void refresh() throws SQLException {
        this.pooledConnectionProvider.refresh();
    }

    @Override
    public Reference getReference() throws NamingException {
        if (this.ref == null) {
            this.ref = new PropertyReference(this.getClass().getName(), CPObjectFactory.class.getName(), null);
            this.ref.add(0, new StringRefAddr("data-source-id", this.info.getDataSourceId()));
        }
        return this.ref;
    }

    public Reference getXARecoveryReference() throws NamingException {
        PropertyReference ref = new PropertyReference(this.getClass().getName(), CPObjectFactory.class.getName(), null);
        ref.add(0, new SerializableRefAddr("connection-pool-info", this.info));
        return ref;
    }

    public void forcedShrink() {
        block2: {
            try {
                this.pooledConnectionProvider.resizePool(true);
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_JDBC._334_LEVEL)) break block2;
                logger.log(JeusMessage_JDBC._334_LEVEL, JeusMessage_JDBC._334, this.info.getDataSourceId(), (Throwable)e);
            }
        }
    }

    public void enable() {
        this.working.set(true);
    }

    public void disable() {
        this.working.set(false);
    }

    public void update(Map<String, Object> properties) throws ConnectionPoolException {
        if (!this.onUpdate.compareAndSet(false, true)) {
            logger.log(JeusMessage_JDBC._205_LEVEL, JeusMessage_JDBC._205, (Object)this.info.getDataSourceId());
            return;
        }
        try {
            this.pooledConnectionProvider.update(properties);
        }
        catch (Throwable th) {
            String errMsg = JeusMessageBundles.getMessage(JeusMessage_JDBC._207, this.getDataSourceId());
            logger.log(JeusMessage_JDBC._207_LEVEL, errMsg, th);
            if (th instanceof ConnectionPoolException) {
                throw (ConnectionPoolException)th;
            }
            throw new ConnectionPoolException(errMsg, th);
        }
        finally {
            this.onUpdate.set(false);
        }
    }

    public void destroy() {
        this.working.set(false);
        this.pooledConnectionProvider.destroy();
        if (this.periodicChecker != null) {
            this.periodicChecker.cancel();
        }
        this.stats.destroy();
    }

    public int getType() {
        return this.info.getPoolType();
    }

    public CPInfo getCPInfo() {
        CPInfo cpInfo = this.pooledConnectionProvider.getCPInfo();
        cpInfo.setWorking(this.working.get());
        cpInfo.setInitialized(this.initialized.get());
        return cpInfo;
    }

    public ConnectionPoolInfo getConnectionPoolInfo() {
        return this.info;
    }

    public boolean isWorking() {
        return this.working.get();
    }

    public String getInfo() {
        return this.ref.toString();
    }

    public long getWaitingThreadCount() {
        return this.stats.getWaitingThreadCountStat().getCurrent();
    }

    public String getName() {
        if (this.info != null) {
            return this.info.getDataSourceId();
        }
        return "<NOT INITIALIZED>";
    }

    public String getDataSourceId() {
        return this.info.getDataSourceId();
    }

    public JDBCPooledConnectionInfo[] getPooledConnectionInfoArray() {
        return this.stats.getPooledConnectionInfoArray();
    }

    public String getUserName() {
        return this.info.getUserName();
    }

    public StatisticImpl getCreateCountStatistic() {
        return this.stats.getCreatCountStat();
    }

    public StatisticImpl getWaitingThreadCountStatistic() {
        return this.stats.getWaitingThreadCountStat();
    }

    public StatisticImpl getReConnectCountStatistic() {
        return null;
    }

    public StatisticImpl getPoolSizeStatistic() {
        return this.stats.getPoolSizeStatistic();
    }

    public StatisticImpl getConnectionPoolMinSizeStat() {
        return this.stats.getMinSizeStat();
    }

    public StatisticImpl getConnectionPoolMaxSizeStat() {
        return this.stats.getMaxSizeStat();
    }

    public BoundedRangeStatisticImpl getFreePoolSizeStatistic() {
        return this.stats.getStatisticOfFreePoolSize();
    }

    public StatisticImpl getCloseCountStatistic() {
        return this.stats.getCloseCountStat();
    }

    public int getPoolSize() {
        return this.pooledConnectionProvider.size();
    }

    public int getCurrentPoolSize() {
        return this.stats.getCurrentPoolSize();
    }

    public StatisticImpl getWaitTimeStatistic() {
        return this.stats.getWaitTimeStatistic();
    }

    public StatisticImpl getUseTimeStatistic() {
        return this.stats.getUseTimeStatistic();
    }

    public StatisticImpl getDisposableConnectionSizeStatistic() {
        return this.stats.getDisposableConnectionSizeStatistic();
    }

    public DataSource getNonTxDelegatedDataSource() {
        return this.nonTxDelegatedDataSource;
    }

    public void changeFailedState(boolean expect, boolean update) {
        this.failed.compareAndSet(expect, update);
    }

    public boolean isFailed() {
        return this.failed.get();
    }

    public void cancelPeriodicConnectionChecker() {
        if (this.periodicChecker != null) {
            this.periodicChecker.cancel();
        }
    }

    public void putPooledConnectionBackForcibly(String connectionId) throws ConnectionPoolException {
        JDBCPooledConnectionInfo[] pooledConnections;
        for (JDBCPooledConnectionInfo pooledConnInfo : pooledConnections = this.stats.getPooledConnectionInfoArray()) {
            if (!pooledConnInfo.getConnectionId().equals(connectionId)) continue;
            AbstractJeusPooledConnection pcon = pooledConnInfo.getPhysicalConnection();
            try {
                pcon.closeConnectionHandleForcibly();
                break;
            }
            catch (SQLException e) {
                String error = ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._365, connectionId);
                logger.log(JeusMessage_JDBC._365_LEVEL, error, (Throwable)e);
                throw new ConnectionPoolException(error, (Throwable)e);
            }
        }
    }

    public List<String> putConnectionsBackForcibly(List<String> toBeReturnedConnectionIdList) {
        JDBCPooledConnectionInfo[] pooledConnections = this.stats.getPooledConnectionInfoArray();
        ArrayList<String> failedList = new ArrayList<String>(pooledConnections.length);
        for (JDBCPooledConnectionInfo pooledConnInfo : pooledConnections) {
            String connectionId = pooledConnInfo.getConnectionId();
            if (!toBeReturnedConnectionIdList.contains(connectionId)) continue;
            AbstractJeusPooledConnection pcon = pooledConnInfo.getPhysicalConnection();
            try {
                pcon.closeConnectionHandleForcibly();
            }
            catch (SQLException e) {
                failedList.add(connectionId);
                logger.log(JeusMessage_JDBC._365_LEVEL, JeusMessage_JDBC._365, connectionId, (Throwable)e);
            }
        }
        if (!failedList.isEmpty()) {
            logger.log(Level.FINE, "failed to put back connections : " + failedList.toString());
        }
        return failedList;
    }

    public void destroyConnectionDirectly(JeusPooledConnection pcon) {
        this.pooledConnectionProvider.closeConnection(pcon);
    }

    public void destroyConnectionForcibly(String connectionId) throws ConnectionPoolException {
        JDBCPooledConnectionInfo[] pooledConnections;
        for (JDBCPooledConnectionInfo pooledConnInfo : pooledConnections = this.stats.getPooledConnectionInfoArray()) {
            if (!pooledConnInfo.getConnectionId().equals(connectionId) || !pooledConnInfo.isActive()) continue;
            AbstractJeusPooledConnection pcon = pooledConnInfo.getPhysicalConnection();
            pcon.destroyPhysicalConnectionForcibly();
            break;
        }
    }

    public List<String> destroyConnectionsForcibly(List<String> toBeDestroyedConnectionIdList) {
        JDBCPooledConnectionInfo[] pooledConnections = this.stats.getPooledConnectionInfoArray();
        ArrayList<String> failedList = new ArrayList<String>(pooledConnections.length);
        for (JDBCPooledConnectionInfo pooledConnInfo : pooledConnections) {
            String connectionId = pooledConnInfo.getConnectionId();
            if (!toBeDestroyedConnectionIdList.contains(connectionId) || !pooledConnInfo.isActive()) continue;
            AbstractJeusPooledConnection pcon = pooledConnInfo.getPhysicalConnection();
            pcon.destroyPhysicalConnectionForcibly();
        }
        return failedList;
    }

    public static String getConnectionTraceAsString(Throwable trace) {
        StringBuffer strBuffer = new StringBuffer(256);
        StackTraceElement[] traces = trace.getStackTrace();
        for (int i = 3; i < traces.length; ++i) {
            strBuffer.append("\n    ").append(traces[i]);
        }
        return strBuffer.toString();
    }

    public void startPeriodicChecker(long period) {
        if (this.periodicChecker == null) {
            this.periodicChecker = new PeriodicConnectionChecker(this);
        }
        this.periodicChecker.start(period);
    }

    static {
        boolean bl = $assertionsDisabled = !ConnectionPoolImpl.class.desiredAssertionStatus();
        if (JeusJDBCProperties.SYBASE_DEBUG) {
            try {
                SybDriver driver = (SybDriver)Class.forName("com.sybase.jdbc2.jdbc.SybDriver").newInstance();
                driver.getDebug().debug(true, "ALL");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        logger = (JeusLogger)JeusLogger.getLogger("jeus.jdbc.pool");
        txManager = TxHelper.getTransactionManager();
    }

    private class SharedConnectionSynchronization
    implements Synchronization {
        private JeusPooledConnection pcon;

        public SharedConnectionSynchronization(JeusPooledConnection pcon) {
            this.pcon = pcon;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            try {
                this.pcon.closeConnectionHandleAfterTxCompletion();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

