/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.connectionpool;

import java.net.URL;
import java.net.URLClassLoader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import jeus.jdbc.connectionpool.ClientSideConnectionPoolInitializer;
import jeus.jdbc.connectionpool.ConnectionPoolException;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.jdbc.connectionpool.ConnectionPoolInitializer;
import jeus.jdbc.info.CPInfo;
import jeus.jdbc.info.ConnectionPoolInfo;
import jeus.transaction.RecoveryThread;
import jeus.transaction.TMCommonService;
import jeus.transaction.logging.JEUSXAResourceFactory;
import jeus.transaction.logging.XAResourceFactoryCreationException;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusRootClassLoader;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessageBundles;
import jeus.util.message.JeusMessage_JDBC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionPoolManager {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.jdbc");
    public static final Object sync = new Object();
    private static final ConcurrentHashMap<String, ConnectionPoolImpl> connectionPoolList = new ConcurrentHashMap();
    private static ConnectionPoolInitializer poolInitializer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionPoolImpl createConnectionPool(String dataSourceId, Hashtable env) throws ConnectionPoolException {
        ConnectionPoolImpl pool = connectionPoolList.get(dataSourceId);
        if (pool != null) {
            return pool;
        }
        Object object = sync;
        synchronized (object) {
            pool = connectionPoolList.get(dataSourceId);
            if (pool != null) {
                return pool;
            }
            if (poolInitializer == null) {
                poolInitializer = new ClientSideConnectionPoolInitializer();
            }
            try {
                pool = (ConnectionPoolImpl)poolInitializer.makeConnectionPool(dataSourceId, env);
                if (pool.getType() == 2) {
                    TMCommonService.registerDataSource(new JEUSXAResourceFactory(pool.getXARecoveryReference()), dataSourceId);
                }
            }
            catch (Throwable th) {
                logger.log(JeusMessage_JDBC._314_LEVEL, JeusMessage_JDBC._314, (Object)dataSourceId);
                if (th instanceof ConnectionPoolException) {
                    throw (ConnectionPoolException)th;
                }
                throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._314, dataSourceId), th);
            }
            connectionPoolList.put(dataSourceId, pool);
        }
        return pool;
    }

    public static ConnectionPoolImpl removeConnectionPool(String dataSourceId) {
        return connectionPoolList.remove(dataSourceId);
    }

    public static ConnectionPoolImpl getConnectionPool(String dataSourceId) {
        return connectionPoolList.get(dataSourceId);
    }

    public static XAConnection getControlSession(Reference ref) throws XAResourceFactoryCreationException, SQLException {
        XADataSource src;
        ConnectionPoolInfo obj = (ConnectionPoolInfo)ref.get(0).getContent();
        try {
            src = (XADataSource)ConnectionPoolManager.getDataSourceFromReference(obj.getDataSourceReference());
        }
        catch (ConnectionPoolException e) {
            logger.log(JeusMessage_JDBC._5_LEVEL, JeusMessage_JDBC._5, obj.getDataSourceId(), (Throwable)e);
            throw new XAResourceFactoryCreationException(JeusMessageBundles.getMessage(JeusMessage_JDBC._5, obj.getDataSourceId()));
        }
        return src.getXAConnection();
    }

    public static void refresh(String poolName) throws ConnectionPoolException {
        ConnectionPoolImpl pool = connectionPoolList.get(poolName);
        if (pool == null) {
            String error = ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._19, poolName);
            logger.log(JeusMessage_JDBC._19_LEVEL, error);
            throw new ConnectionPoolException(error);
        }
        try {
            pool.refresh();
        }
        catch (Exception e) {
            String error = ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._21, poolName);
            logger.log(JeusMessage_JDBC._21_LEVEL, error, (Throwable)e);
            throw new ConnectionPoolException(error, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy() {
        Object object = sync;
        synchronized (object) {
            for (ConnectionPoolImpl pool : connectionPoolList.values()) {
                pool.destroy();
                if (poolInitializer == null) continue;
                poolInitializer.destroyMBean();
            }
            connectionPoolList.clear();
        }
    }

    public static Object getDataSourceFromReference(Reference ref) throws ConnectionPoolException {
        String classurl = ref.getFactoryClassLocation();
        String classname = ref.getFactoryClassName();
        if (classname == null) {
            throw new ConnectionPoolException("wrong reference;factory class name is null : " + ref.toString());
        }
        try {
            Class<?> factorycl;
            if (classurl == null) {
                factorycl = JeusRootClassLoader.loader.loadClass(classname);
            } else {
                URL[] srcURL = new URL[]{new URL(ref.getFactoryClassLocation())};
                factorycl = new URLClassLoader(srcURL).loadClass(classname);
            }
            ObjectFactory factory = (ObjectFactory)factorycl.newInstance();
            return factory.getObjectInstance(ref, null, null, null);
        }
        catch (Throwable th) {
            if (th instanceof ConnectionPoolException) {
                throw (ConnectionPoolException)th;
            }
            throw new ConnectionPoolException(JeusMessage_JDBC._6, th);
        }
    }

    public static CPInfo[] getCPInfo() {
        ArrayList<CPInfo> cpInfoList = new ArrayList<CPInfo>();
        for (Map.Entry<String, ConnectionPoolImpl> entry : connectionPoolList.entrySet()) {
            String dataSourceId = entry.getKey();
            ConnectionPoolImpl connectionPool = entry.getValue();
            CPInfo cpInfo = connectionPool.getCPInfo();
            cpInfo.setDataSourceId(dataSourceId);
            cpInfoList.add(cpInfo);
        }
        return cpInfoList.toArray(new CPInfo[cpInfoList.size()]);
    }

    public static void enableCP(String cpname) throws ConnectionPoolException {
        ConnectionPoolImpl pool;
        if (logger.isLoggable(JeusMessage_JDBC._316_LEVEL)) {
            logger.log(JeusMessage_JDBC._316_LEVEL, JeusMessage_JDBC._316);
        }
        if ((pool = connectionPoolList.get(cpname)) == null) {
            if (logger.isLoggable(JeusMessage_JDBC._19_LEVEL)) {
                logger.logp(JeusMessage_JDBC._19_LEVEL, "ConnectionPoolManager", "enableCP", JeusMessage_JDBC._19, (Object)cpname);
            }
            throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._19, cpname));
        }
        pool.enable();
    }

    public static void disableCP(String cpname) throws ConnectionPoolException {
        ConnectionPoolImpl pool;
        if (logger.isLoggable(JeusMessage_JDBC._317_LEVEL)) {
            logger.log(JeusMessage_JDBC._317_LEVEL, JeusMessage_JDBC._317);
        }
        if ((pool = connectionPoolList.get(cpname)) == null) {
            if (logger.isLoggable(JeusMessage_JDBC._19_LEVEL)) {
                logger.logp(JeusMessage_JDBC._19_LEVEL, "ConnectionPoolManager", "disableCP", JeusMessage_JDBC._19, (Object)cpname);
            }
            throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._19, cpname));
        }
        pool.disable();
    }

    public static void shrinkCP(String cpname) throws ConnectionPoolException {
        ConnectionPoolImpl pool;
        if (logger.isLoggable(JeusMessage_JDBC._318_LEVEL)) {
            logger.log(JeusMessage_JDBC._318_LEVEL, JeusMessage_JDBC._318);
        }
        if ((pool = connectionPoolList.get(cpname)) == null) {
            if (logger.isLoggable(JeusMessage_JDBC._19_LEVEL)) {
                logger.logp(JeusMessage_JDBC._19_LEVEL, "ConnectionPoolManager", "shrinkCP", JeusMessage_JDBC._19, (Object)cpname);
            }
            throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._19, cpname));
        }
        pool.forcedShrink();
    }

    public static void resyncCP(String dataSourceId) throws ConnectionPoolException {
        ConnectionPoolImpl pool = connectionPoolList.get(dataSourceId);
        if (pool == null) {
            throw new ConnectionPoolException("not created connection pool : " + dataSourceId);
        }
        if (pool.getType() != 2) {
            return;
        }
        try {
            Reference ref = pool.getXARecoveryReference();
            RecoveryThread t = new RecoveryThread(new JEUSXAResourceFactory(ref));
            t.setDaemon(true);
            t.start();
            logger.log(JeusMessage_JDBC._94_LEVEL, JeusMessage_JDBC._94, (Object)dataSourceId);
        }
        catch (Throwable t) {
            logger.log(JeusMessage_JDBC._95_LEVEL, JeusMessage_JDBC._95, (Object)dataSourceId);
            throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._95, dataSourceId), t);
        }
    }

    public static void updateCP(String dataSourceId, Map<String, Object> properties) throws ConnectionPoolException {
        ConnectionPoolImpl pool = connectionPoolList.get(dataSourceId);
        if (pool == null) {
            logger.log(JeusMessage_JDBC._19_LEVEL, JeusMessage_JDBC._19, (Object)dataSourceId);
            return;
        }
        pool.update(properties);
    }

    public static void enableAll() {
        logger.log(JeusMessage_JDBC._316_LEVEL, JeusMessage_JDBC._316);
        ConnectionPoolImpl[] poolList = connectionPoolList.values().toArray(new ConnectionPoolImpl[connectionPoolList.size()]);
        for (int i = 0; i < poolList.length; ++i) {
            poolList[i].enable();
        }
    }

    public static void disableAll() {
        logger.log(JeusMessage_JDBC._316_LEVEL, JeusMessage_JDBC._317);
        ConnectionPoolImpl[] poolList = connectionPoolList.values().toArray(new ConnectionPoolImpl[connectionPoolList.size()]);
        for (int i = 0; i < poolList.length; ++i) {
            poolList[i].disable();
        }
    }

    public static void shrinkAll() {
        logger.log(JeusMessage_JDBC._316_LEVEL, JeusMessage_JDBC._318);
        ConnectionPoolImpl[] poolList = connectionPoolList.values().toArray(new ConnectionPoolImpl[connectionPoolList.size()]);
        for (int i = 0; i < poolList.length; ++i) {
            poolList[i].forcedShrink();
        }
    }

    public static void setPoolInitializer(ConnectionPoolInitializer serverSideInitializer) {
        poolInitializer = serverSideInitializer;
    }
}

