/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.connectionpool;

import java.sql.SQLException;
import java.util.logging.Level;
import jeus.jdbc.common.JeusConnectionImpl;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;
import jeus.util.message.JeusMessage_Manager1;
import jeus.util.trace.JeusManagedResource;

public class JDBCResource
implements JeusManagedResource {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.jdbc.connection");
    private final JeusConnectionImpl connection;
    private boolean shouldRollbackAutomatically;
    private int actionOnLeak;

    public JDBCResource(JeusConnectionImpl connection, int actionOnLeak) {
        this.connection = connection;
        this.actionOnLeak = actionOnLeak;
    }

    public void close() throws SQLException {
        if (!this.connection.isClosed()) {
            block6: {
                if (logger.isLoggable(JeusMessage_Manager1._410_LEVEL)) {
                    logger.log(JeusMessage_Manager1._410_LEVEL, JeusMessage_Manager1._410, (Object)this.connection.toString());
                }
                if (this.shouldRollbackAutomatically) {
                    try {
                        if (logger.isLoggable(Level.INFO)) {
                            logger.log(Level.INFO, JeusMessage_JDBC._363, (Object)this.connection);
                        }
                        this.connection.rollback();
                    }
                    catch (Throwable th) {
                        if (!logger.isLoggable(Level.INFO)) break block6;
                        logger.log(Level.INFO, JeusMessage_JDBC._364, th);
                    }
                }
            }
            this.connection.close();
        }
    }

    public String toString() {
        Throwable trace;
        StringBuffer strBuffer = new StringBuffer(256);
        strBuffer.append(this.connection.toString());
        String threadName = this.connection.getThreadNameInUse();
        if (threadName != null) {
            strBuffer.append("\n").append("Thread in use : ").append(threadName).append("\n");
        }
        if ((trace = this.connection.getConnectionTrace()) != null) {
            strBuffer.append(ConnectionPoolImpl.getConnectionTraceAsString(trace));
        }
        return strBuffer.toString();
    }

    public void setShouldRollbackAutomatically(boolean b) {
        this.shouldRollbackAutomatically = b;
    }

    public int getActionOnLeak() {
        return this.actionOnLeak;
    }
}

