/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.connectionpool;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.SQLException;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusLocalizedException;

public class JeusSQLException
extends SQLException
implements JeusLocalizedException {
    private static final long serialVersionUID = 4484398905435268242L;
    private transient int msgID = -1;
    private transient Object[] args;
    private Throwable t;

    public JeusSQLException(String s) {
        this(s, (Throwable)null);
    }

    public JeusSQLException(Throwable t) {
        this(null, t);
    }

    public JeusSQLException(int msgID) {
        this(msgID, (Object[])null, (Throwable)null);
    }

    public JeusSQLException(int msgID, Throwable t) {
        this(msgID, (Object[])null, t);
    }

    public JeusSQLException(int msgID, Object arg) {
        this(msgID, arg, null);
    }

    public JeusSQLException(int msgID, Object[] args) {
        this(msgID, args, (Throwable)null);
    }

    public JeusSQLException(int msgID, Object arg, Throwable t) {
        this(ErrorMsgManager.getErrorStringMessage(msgID, arg), t);
        this.msgID = msgID;
        if (arg != null) {
            this.args = new Object[]{arg};
        }
    }

    public JeusSQLException(int msgID, Object[] args, Throwable t) {
        this(ErrorMsgManager.getErrorStringMessage(msgID, args), t);
        this.msgID = msgID;
        this.args = args;
    }

    public JeusSQLException(String s, Throwable t) {
        super(s);
        this.t = t;
    }

    public int getMessageNumber() {
        return this.msgID;
    }

    public Object getParameter() {
        if (this.args != null && this.args.length == 1) {
            return this.args[0].toString();
        }
        return null;
    }

    public Object[] getParameters() {
        return this.args;
    }

    public Throwable getCause() {
        return this.t;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        if (this.msgID == 0) {
            this.msgID = -1;
        }
    }
}

