/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.connectionpool;

import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import jeus.jdbc.common.JeusPooledConnection;
import jeus.jdbc.connectionpool.ConnectionPoolException;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.jdbc.connectionpool.JeusSQLException;
import jeus.jdbc.connectionpool.WaitTimeoutException;
import jeus.jdbc.info.CPInfo;
import jeus.jdbc.info.ConnectionPoolInfo;
import jeus.jdbc.info.DynamicPoolStatsAndInfo;
import jeus.jdbc.queue.JDBCConnectionQueue;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PooledConnectionProviderImpl {
    private final JDBCConnectionQueue connectionQueue;
    private final ConnectionPoolImpl connectionPool;
    private final ConnectionPoolInfo info;
    private final DynamicPoolStatsAndInfo stats;
    private volatile boolean destroyed;
    private final AtomicBoolean onResizing = new AtomicBoolean(false);
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.jdbc");

    public PooledConnectionProviderImpl(ConnectionPoolImpl cp, DynamicPoolStatsAndInfo statHolder) {
        this.connectionPool = cp;
        this.info = cp.getConnectionPoolInfo();
        this.stats = statHolder;
        this.connectionQueue = new JDBCConnectionQueue(cp, this.stats);
    }

    public void initProvider() throws SQLException {
        this.connectionQueue.initConnectionQueue();
    }

    public JeusPooledConnection getXAControlConnection(boolean useDisposableOnly) throws SQLException {
        if (useDisposableOnly) {
            return this.connectionQueue.getSingleConnection(null, null, true);
        }
        return this.connectionQueue.getConnection(false, 0L, false);
    }

    public JeusPooledConnection getPooledConnection(String username, String password, boolean returnNullOnEmpty) throws SQLException {
        if (username != null) {
            return this.getNamedConnection(username, password);
        }
        long startTime = System.currentTimeMillis();
        boolean waiting = this.info.isWaiting();
        long waitTimeout = this.info.getWaitTime();
        try {
            if (waiting) {
                this.stats.incWaitThreadCount();
            }
            JeusPooledConnection pcon = this.connectionQueue.getConnection(waiting, waitTimeout, returnNullOnEmpty);
            if (logger.isLoggable(Level.FINEST) && pcon != null) {
                logger.log(Level.FINEST, "get the physical connection  " + pcon + "- [" + pcon.getConnectionId() + "] from connection pool");
            }
            JeusPooledConnection jeusPooledConnection = pcon;
            return jeusPooledConnection;
        }
        catch (Exception e) {
            if (e instanceof WaitTimeoutException) {
                throw (WaitTimeoutException)e;
            }
            throw new JeusSQLException(e.getMessage() + ", datasource = " + this.info.getDataSourceId(), (Throwable)e);
        }
        finally {
            if (waiting) {
                this.stats.decWaitThreadCount();
                this.stats.addToWaitTimeStat(System.currentTimeMillis() - startTime);
            }
        }
    }

    private JeusPooledConnection getNamedConnection(String username, String password) throws SQLException {
        try {
            return this.connectionQueue.getSingleConnection(username, password, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JeusSQLException(e.getMessage(), (Throwable)e);
        }
    }

    public JeusPooledConnection createNewConnectionForFailOver() throws SQLException {
        try {
            return this.connectionQueue.createNewConnectionForFailOver();
        }
        catch (SQLException sqle) {
            logger.log(JeusMessage_JDBC._338_LEVEL, JeusMessage_JDBC._338, this.info.getDataSourceId(), (Throwable)sqle);
            throw sqle;
        }
    }

    public void connectionAbnormallyClosed(JeusPooledConnection oldConnection) throws SQLException {
        try {
            this.connectionQueue.replaceUsedConnection(oldConnection);
        }
        catch (Exception e) {
            throw new JeusSQLException(e.getMessage(), (Throwable)e);
        }
    }

    public void closeConnection(JeusPooledConnection con) {
        this.connectionQueue.destroyConnection(con);
    }

    public void returnConnection(JeusPooledConnection pcon) {
        if (this.destroyed) {
            this.closeConnection(pcon);
            return;
        }
        if (pcon.getUseForValidationOnly()) {
            pcon.setUseForValidationOnly(false);
        } else {
            pcon.incUseCount();
        }
        if (this.info.getMaxUseCount() > 0 && pcon.getUseCount() >= this.info.getMaxUseCount()) {
            if (logger.isLoggable(JeusMessage_JDBC._356_LEVEL)) {
                logger.log(JeusMessage_JDBC._356_LEVEL, JeusMessage_JDBC._356, (Object)pcon.getConnectionId());
            }
            this.replacePooledConnection(pcon);
            return;
        }
        if (!this.connectionQueue.putConnection(pcon) && logger.isLoggable(JeusMessage_JDBC._357_LEVEL)) {
            logger.log(JeusMessage_JDBC._357_LEVEL, JeusMessage_JDBC._357, (Object)pcon.getConnectionId());
        }
    }

    private void replacePooledConnection(JeusPooledConnection pooledConn) {
        block2: {
            try {
                this.connectionQueue.replaceUsedConnection(pooledConn);
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_JDBC._358_LEVEL)) break block2;
                logger.log(JeusMessage_JDBC._358_LEVEL, JeusMessage_JDBC._358);
            }
        }
    }

    public void update(Map<String, Object> properties) throws ConnectionPoolException {
        this.connectionQueue.update(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resizePool(boolean forcedShrink) throws Exception {
        if (!this.onResizing.compareAndSet(false, true)) {
            return;
        }
        try {
            if (forcedShrink) {
                this.connectionQueue.shrinkPoolToMinimumSize();
            } else {
                this.connectionQueue.resizePool(false);
            }
        }
        finally {
            this.onResizing.set(false);
        }
    }

    public void refresh() throws SQLException {
        this.connectionQueue.refreshQueue();
    }

    public CPInfo getCPInfo() {
        CPInfo cpInfo = new CPInfo();
        cpInfo.setMin(this.info.getMinPoolSize());
        cpInfo.setMax(this.info.getMaxPoolSize());
        cpInfo.setStep(this.info.getIncreaseStep());
        this.connectionQueue.setCPInfo(cpInfo);
        cpInfo.setResizingPeriod(this.info.getPoolPeriod());
        cpInfo.setDataSourceId(this.info.getDataSourceId());
        cpInfo.setJndiExportName(this.info.getJndiExportName());
        cpInfo.setWaiting(this.info.isWaiting());
        if (this.info.isWaiting()) {
            cpInfo.setWaitingTime(this.info.getWaitTime());
        }
        return cpInfo;
    }

    public int size() {
        return this.connectionQueue.size();
    }

    public void destroy() {
        try {
            this.connectionQueue.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.destroyed = true;
    }

    public JeusPooledConnection getPooledConnectionDirectly() {
        return this.connectionQueue.getPooledConnectionDirectly();
    }

    public void purgeAllConnections(int currentGeneration) {
        this.connectionQueue.purgeAllConnections(currentGeneration);
    }
}

