/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.datasource;

import java.io.Serializable;
import java.util.List;
import jeus.util.JeusException;
import jeus.util.message.JeusMessage_JDBC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterDSBindInfo
implements Serializable {
    private static final long serialVersionUID = 60L;
    private String dataSourceId;
    private String jndiExportName;
    private List<String> clusterDsTargetList = null;
    private boolean isPreConn;
    private boolean useFailback;
    private List dataSourceList;
    private String backupDeletage = "";
    private boolean useLoadBalancing;
    private String dataSourceSelectorFQCN;

    public void validate() throws JeusException {
        if (this.dataSourceId == null || this.dataSourceId.equals("")) {
            throw new JeusException(JeusMessage_JDBC._44);
        }
        if (this.dataSourceList == null) {
            throw new JeusException(JeusMessage_JDBC._330);
        }
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public void setDataSourceId(String s) {
        this.dataSourceId = s;
    }

    public void setJndiExportName(String s) {
        this.jndiExportName = s;
    }

    public String getJndiExportName() {
        return this.jndiExportName;
    }

    public boolean isSetClusterDsTarget() {
        return this.clusterDsTargetList != null && !this.clusterDsTargetList.isEmpty();
    }

    public List<String> getClusterDsTargetList() {
        return this.clusterDsTargetList;
    }

    public void setClusterDsTargetList(List<String> clusterDsTargetList) {
        this.clusterDsTargetList = clusterDsTargetList;
    }

    public List getDataSourceList() {
        return this.dataSourceList;
    }

    public void setDataSourceList(List a) {
        this.dataSourceList = a;
    }

    public void setPreMakeBackupConnection(boolean b) {
        this.isPreConn = b;
    }

    public boolean isPreConn() {
        return this.isPreConn;
    }

    public String toString() {
        StringBuffer s = this.dsListToString();
        return this.dataSourceId + "(" + s.toString() + ")";
    }

    public String getDSList() {
        StringBuffer s = this.dsListToString();
        return s.toString();
    }

    private StringBuffer dsListToString() {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.dataSourceList.size(); ++i) {
            s.append((String)this.dataSourceList.get(i));
            if (i == this.dataSourceList.size() - 1) continue;
            s.append(",");
        }
        return s;
    }

    public String[] getDSListAsStringArray() {
        int size = this.dataSourceList.size();
        return this.dataSourceList.toArray(new String[size]);
    }

    public String getBackupDelegate() {
        return this.backupDeletage;
    }

    public void setBackupDelegate(String a) {
        this.backupDeletage = a;
    }

    public boolean isUseFailback() {
        return this.useFailback;
    }

    public void setUseFailback(boolean useFailback) {
        this.useFailback = useFailback;
    }

    public boolean isUseLoadBalancing() {
        return this.useLoadBalancing;
    }

    public void setUseLoadBalancing(boolean useLoadBalancing) {
        this.useLoadBalancing = useLoadBalancing;
    }

    public void setDataSourceSelectorFQCN(String dataSourceSelectorFQCN) {
        this.dataSourceSelectorFQCN = dataSourceSelectorFQCN;
    }

    public String getDataSourceSelectorFQCN() {
        return this.dataSourceSelectorFQCN;
    }
}

