/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.datasource;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import jeus.descriptor.bind.DBDSBindInfoJB;
import jeus.descriptor.jeusserver.ResourceConfigurationProperty;
import jeus.jdbc.common.DBMSType;
import jeus.jdbc.datasource.DBDataSourceException;
import jeus.util.JeusException;
import jeus.util.JeusRuntimeException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessageBundles;
import jeus.util.message.JeusMessage_JDBC;
import jeus.util.properties.JeusJDBCProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBDSBindInfo
implements Serializable {
    private static final long serialVersionUID = 60L;
    private static final JeusLogger logger;
    public static final int DS = 0;
    public static final int CPDS = 1;
    public static final int XADS = 2;
    public static final int LOCALXADS = 3;
    public static final int CLUSTER = 4;
    public static final int FAILED_CONNECTION_ONLY = 0;
    public static final int ALL_CONNECTIONS = 1;
    public static final String PR_DATABASE_NAME = "DatabaseName";
    public static final String PR_DATA_SOURCE_NAME = "DataSourceName";
    public static final String PR_SERVICE_NAME = "ServiceName";
    public static final String PR_DESCRIPTION = "Description";
    public static final String PR_NETWORK_PROTOCOL = "NetworkProtocol";
    public static final String PR_PASSWORD = "Password";
    public static final String PR_PORT_NUMBER = "PortNumber";
    public static final String PR_SERVER_NAME = "ServerName";
    public static final String PR_USER = "User";
    public static final String PR_DRIVER_TYPE = "DriverType";
    public static final String DS_ACCOUNTS_PROPERTIES_PATH;
    private static Properties DSAccountsProperties;
    private String vendor;
    private String dataSourceId;
    private String jndiExportName;
    private List<String> dataSourceTargetList = null;
    private String dataSourceClassName = "";
    public Vector properties = new Vector();
    private int datasourceType;
    private int min = 2;
    private int max = 10;
    private int step = 1;
    private long resizingPeriod = 1800000L;
    private boolean waiting;
    private long waitTime = 10000L;
    private boolean nonTxDelegatedDataSourceRequired;
    private String nonTxDelegatedDataSourceName = "";
    private int maxUseCount;
    private boolean dbaRequired;
    private String dbaDelegate = "";
    private int sessionKillTimeout = -1;
    private String checkQuery;
    private String backupDeletage = "";
    private int stmtCachingSize = -1;
    private int fetchSize = -1;
    private boolean useAutoCommitSetting;
    private boolean autoCommitValue;
    private String checkQueryClass;
    private long checkQueryPeriod;
    private String userName;
    private long stmtQueryTo = 0L;
    private boolean useConnectionTrace;
    private boolean useSQLTrace;
    private boolean useSetAutoCommtiTrace;
    private long nonValidationInterval;
    private boolean keepConnectionHandleOpen;
    private int destroyPolicyOnCheckQuery;
    private int validationRetrialCount;
    private int actionOnConnectionLeak;
    private long checkQueryTimeout;
    private boolean isDbaDataSourceUsed;
    private String dbaDataSourceName;
    private String initSql;

    public void validate() throws DBDataSourceException {
        if (this.dataSourceId == null || this.dataSourceId.equals("")) {
            throw new DBDataSourceException(JeusMessage_JDBC._44);
        }
        if (this.jndiExportName == null) {
            throw new DBDataSourceException(JeusMessage_JDBC._44);
        }
        if (this.vendor == null) {
            throw new DBDataSourceException(JeusMessage_JDBC._45, this.dataSourceId);
        }
        if (this.dataSourceClassName.equals("")) {
            throw new DBDataSourceException(JeusMessage_JDBC._100, this.dataSourceId);
        }
        DBMSType dbmsType = DBMSType.getType(this.vendor);
        if (dbmsType == null) {
            throw new DBDataSourceException(JeusMessage_JDBC._46, new String[]{this.dataSourceId, this.vendor});
        }
        Enumeration e = this.properties.elements();
        while (e.hasMoreElements()) {
            try {
                ((ResourceConfigurationProperty)e.nextElement()).validate();
            }
            catch (JeusException e1) {
                throw new DBDataSourceException("wrong property", (Throwable)e1);
            }
        }
        DBDSBindInfo.validateNumerics(this.dataSourceId, this.min, this.max, this.step, this.waiting, this.waitTime, this.resizingPeriod, this.maxUseCount, this.checkQueryPeriod);
        if (this.resizingPeriod < 1000L) {
            this.resizingPeriod = 1000L;
        }
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String s) {
        this.vendor = s;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public void setDataSourceId(String s) {
        this.dataSourceId = s;
    }

    public String getJndiExportName() {
        return this.jndiExportName;
    }

    public void setJndiExportName(String s) {
        this.jndiExportName = s;
    }

    public boolean isSetDataSourceTarget() {
        return this.dataSourceTargetList != null && !this.dataSourceTargetList.isEmpty();
    }

    public List<String> getDataSourceTargetList() {
        return this.dataSourceTargetList;
    }

    public void setDataSourceTargetList(List<String> dataSourceTarget) {
        this.dataSourceTargetList = dataSourceTarget;
    }

    public String getDataSourceClassName() {
        return this.dataSourceClassName;
    }

    public void setDataSourceClassName(String s) {
        this.dataSourceClassName = s;
    }

    public int getDataSourceType() {
        return this.datasourceType;
    }

    public void setDataSourceType(int t) {
        this.datasourceType = t;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int i) {
        this.min = i;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int i) {
        this.max = i;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int i) {
        this.step = i;
    }

    public long getResizingPeriod() {
        return this.resizingPeriod;
    }

    public void setResizingPeriod(long l) {
        this.resizingPeriod = l;
    }

    public boolean getWaiting() {
        return this.waiting;
    }

    public void setWaiting(boolean b) {
        this.waiting = b;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(long l) {
        this.waitTime = l;
    }

    public boolean isNonTxDelegatedDataSourceRequired() {
        return this.nonTxDelegatedDataSourceRequired;
    }

    public void setNonTxDelegatedDataSourceRequired(boolean b) {
        this.nonTxDelegatedDataSourceRequired = b;
    }

    public String getNonTxDelegatedDataSourceName() {
        return this.nonTxDelegatedDataSourceName;
    }

    public void setNonTxDelegatedDataSourceName(String s) {
        this.nonTxDelegatedDataSourceName = s;
    }

    public void setMaxUseCount(int count) {
        this.maxUseCount = count;
    }

    public int getMaxUseCount() {
        return this.maxUseCount;
    }

    public boolean isDBARequired() {
        return this.dbaRequired;
    }

    public void setDBARequired(boolean b) {
        this.dbaRequired = b;
    }

    public String getDBADelegate() {
        return this.dbaDelegate;
    }

    public void setDBADelegate(String s) {
        this.dbaDelegate = s;
    }

    public void setCheckQuery(String s) {
        this.checkQuery = s;
    }

    public String getCheckQuery() {
        if (this.checkQuery != null && this.checkQuery.equals("")) {
            this.checkQuery = null;
        }
        return this.checkQuery;
    }

    public String getBackupDelegate() {
        return this.backupDeletage;
    }

    public void setBackupDelegate(String a) {
        this.backupDeletage = a;
    }

    public void setStmtCachingSize(int b) {
        this.stmtCachingSize = b;
    }

    public int getStmtCachingSize() {
        return this.stmtCachingSize;
    }

    public String toString() {
        return this.dataSourceId + "(" + this.dataSourceClassName + ")";
    }

    public void setDataSourceType(String value) {
        this.datasourceType = DBDSBindInfo.getDataSourceType(value);
    }

    public static int getDataSourceType(String value) {
        if (value != null && value.equalsIgnoreCase("DataSource")) {
            return 0;
        }
        if (value != null && value.equalsIgnoreCase("ConnectionPoolDataSource")) {
            return 1;
        }
        if (value != null && value.equalsIgnoreCase("XADataSource")) {
            return 2;
        }
        if (value != null && value.equalsIgnoreCase("LocalXADataSource")) {
            return 3;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, "DBDSBindInfo", "getDataSourceType", JeusMessage_JDBC._331);
        }
        throw new JeusRuntimeException(JeusMessage_JDBC._331, value);
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int size) {
        this.fetchSize = size;
    }

    public boolean isUseAutoCommitSetting() {
        return this.useAutoCommitSetting;
    }

    public void setUseAutoCommitSetting(boolean useAutoCommitSetting) {
        this.useAutoCommitSetting = useAutoCommitSetting;
    }

    public void setAutoCommitValue(boolean autoCommitValue) {
        this.autoCommitValue = autoCommitValue;
    }

    public boolean getAutoCommitValue() {
        return this.autoCommitValue;
    }

    public void setCheckQueryClassName(String checkQueryClass) {
        this.checkQueryClass = checkQueryClass;
    }

    public String getCheckQueryClassName() {
        return this.checkQueryClass;
    }

    public void setCheckQueryPeriod(long checkQueryPeriod) {
        this.checkQueryPeriod = checkQueryPeriod;
    }

    public long getCheckQueryPeriod() {
        return this.checkQueryPeriod;
    }

    public void setUser(String user) {
        this.userName = user;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setStmtQueryTimeout(Long stmtQueryTimeout) {
        this.stmtQueryTo = stmtQueryTimeout;
    }

    public long getStmtQueryTimeout() {
        return this.stmtQueryTo;
    }

    public boolean getUseConnectionTrace() {
        return this.useConnectionTrace;
    }

    public void setUseConnectionTrace(boolean useConnectionTrace) {
        this.useConnectionTrace = useConnectionTrace;
    }

    public long getNonValidationInterval() {
        return this.nonValidationInterval;
    }

    public void setNonValidationInterval(long nonValidationInterval) {
        this.nonValidationInterval = nonValidationInterval;
    }

    public boolean isKeepConnectionHandleOpen() {
        return this.keepConnectionHandleOpen;
    }

    public void setKeepConnectionHandleOpen(boolean keepConnectionHandleOpen) {
        this.keepConnectionHandleOpen = keepConnectionHandleOpen;
    }

    public void addDBPropertyValue(String givenName, String value) {
        if (givenName == null || givenName.trim().equals("")) {
            return;
        }
        if (value == null || value.trim().equals("")) {
            return;
        }
        this.addDBPropertyValue(givenName, value, givenName.equals(PR_PORT_NUMBER) ? "java.lang.Integer" : "java.lang.String");
    }

    public void addDBPropertyValue(String givenName, String value, String type) {
        ResourceConfigurationProperty citem = new ResourceConfigurationProperty();
        citem.setName(givenName);
        citem.setType(type);
        citem.setValue(value);
        this.properties.add(citem);
    }

    public List getProperties() {
        return this.properties;
    }

    public boolean getUseSQLTrace() {
        return this.useSQLTrace;
    }

    public void setUseSQLTrace(boolean useSQLTrace) {
        this.useSQLTrace = useSQLTrace;
    }

    public boolean getUseSetAutoCommtiTrace() {
        return this.useSetAutoCommtiTrace;
    }

    public void setUseSetAutoCommitTrace(boolean useSetAutoCommtiTrace) {
        this.useSetAutoCommtiTrace = useSetAutoCommtiTrace;
    }

    public int getDestroyPolicyOnCheckQuery() {
        return this.destroyPolicyOnCheckQuery;
    }

    public void setDestroyPolicyOnCheckQuery(int policy) {
        this.destroyPolicyOnCheckQuery = policy;
    }

    public int getValidationRetrialCount() {
        return this.validationRetrialCount;
    }

    public void setValidationRetrialCount(int count) {
        this.validationRetrialCount = count;
    }

    public void setActionOnConnectionLeak(int policy) {
        this.actionOnConnectionLeak = policy;
    }

    public int getActionOnConnectionLeak() {
        return this.actionOnConnectionLeak;
    }

    public void setCheckQueryTimeout(long timeout) {
        this.checkQueryTimeout = timeout;
    }

    public long getCheckQueryTimeout() {
        return this.checkQueryTimeout;
    }

    public static void validateNumerics(String dataSourceId, int min, int max, int step, boolean enableWait, long waitingTime, long poolPeriod, int maxUseCount, long checkQueryPeriod) throws DBDataSourceException {
        if (min < 0) {
            throw new DBDataSourceException(JeusMessageBundles.getMessage(JeusMessage_JDBC._47, dataSourceId));
        }
        if (max < 0) {
            throw new DBDataSourceException(JeusMessageBundles.getMessage(JeusMessage_JDBC._48, dataSourceId));
        }
        if (min > max) {
            throw new DBDataSourceException(JeusMessageBundles.getMessage(JeusMessage_JDBC._52, dataSourceId));
        }
        if (step == 0) {
            if (min != max) {
                throw new DBDataSourceException(JeusMessageBundles.getMessage(JeusMessage_JDBC._56, dataSourceId));
            }
        } else if (step < 0) {
            throw new DBDataSourceException(JeusMessageBundles.getMessage(JeusMessage_JDBC._49, dataSourceId));
        }
        if (enableWait && waitingTime < 0L) {
            throw new DBDataSourceException(JeusMessageBundles.getMessage(JeusMessage_JDBC._51, dataSourceId));
        }
        if (poolPeriod < 0L) {
            throw new DBDataSourceException(JeusMessageBundles.getMessage(JeusMessage_JDBC._50, dataSourceId));
        }
        if (maxUseCount < 0) {
            throw new DBDataSourceException(JeusMessageBundles.getMessage(JeusMessage_JDBC._53, dataSourceId));
        }
        if (checkQueryPeriod < 0L) {
            throw new DBDataSourceException(JeusMessageBundles.getMessage(JeusMessage_JDBC._80, dataSourceId));
        }
    }

    public void setIsDbaDataSourceUsed(boolean b) {
        this.isDbaDataSourceUsed = b;
    }

    public boolean isDbaDataSourceUsed() {
        return this.isDbaDataSourceUsed;
    }

    public void setDbaDataSourceName(String name) {
        this.dbaDataSourceName = name;
    }

    public String getDbaDataSourceName() {
        return this.dbaDataSourceName;
    }

    public int getSessionKillTimeout() {
        return this.sessionKillTimeout;
    }

    public void setSessionKillTimeout(int timeout) {
        this.sessionKillTimeout = timeout;
    }

    public String getInitSql() {
        return this.initSql;
    }

    public void setInitSql(String initSql) {
        this.initSql = initSql;
    }

    public void mergeDSAccountsProperties() {
        if (DSAccountsProperties == null || DSAccountsProperties.isEmpty()) {
            return;
        }
        boolean userFound = false;
        String userKey = this.dataSourceId + "." + "user";
        String userValue = DSAccountsProperties.getProperty(userKey);
        if (userValue != null && !userValue.equals("")) {
            for (Object property : this.properties) {
                if (!((ResourceConfigurationProperty)property).getName().equals(PR_USER)) continue;
                userFound = true;
                ((ResourceConfigurationProperty)property).setValue(userValue);
                if (!logger.isLoggable(JeusMessage_JDBC._387_LEVEL)) break;
                logger.log(JeusMessage_JDBC._387_LEVEL, JeusMessage_JDBC._387, (Object)userKey);
                break;
            }
            if (!userFound) {
                DBDSBindInfoJB.setDBPropertyValue(this.properties, PR_USER, userValue);
                if (logger.isLoggable(JeusMessage_JDBC._387_LEVEL)) {
                    logger.log(JeusMessage_JDBC._387_LEVEL, JeusMessage_JDBC._387, (Object)userKey);
                }
            }
        }
        boolean passwordFound = false;
        String passwordKey = this.dataSourceId + "." + "password";
        String passwordValue = DSAccountsProperties.getProperty(passwordKey);
        if (passwordValue != null && !passwordValue.equals("")) {
            for (Object property : this.properties) {
                if (!((ResourceConfigurationProperty)property).getName().equals(PR_PASSWORD)) continue;
                passwordFound = true;
                ((ResourceConfigurationProperty)property).setValue(passwordValue);
                if (!logger.isLoggable(JeusMessage_JDBC._387_LEVEL)) break;
                logger.log(JeusMessage_JDBC._387_LEVEL, JeusMessage_JDBC._387, (Object)passwordKey);
                break;
            }
            if (!passwordFound) {
                DBDSBindInfoJB.setDBPropertyValue(this.properties, PR_PASSWORD, passwordValue);
                if (logger.isLoggable(JeusMessage_JDBC._387_LEVEL)) {
                    logger.log(JeusMessage_JDBC._387_LEVEL, JeusMessage_JDBC._387, (Object)passwordKey);
                }
            }
        }
    }

    static {
        block3: {
            logger = (JeusLogger)JeusLogger.getLogger("jeus.jdbc");
            DS_ACCOUNTS_PROPERTIES_PATH = JeusJDBCProperties.DS_ACCOUNTS_PROPERTIES_PATH;
            DSAccountsProperties = null;
            if (DS_ACCOUNTS_PROPERTIES_PATH != null) {
                DSAccountsProperties = new Properties();
                try {
                    DSAccountsProperties.load(new FileInputStream(DS_ACCOUNTS_PROPERTIES_PATH));
                }
                catch (IOException e) {
                    if (!logger.isLoggable(JeusMessage_JDBC._386_LEVEL)) break block3;
                    logger.log(JeusMessage_JDBC._386_LEVEL, JeusMessage_JDBC._386, DS_ACCOUNTS_PROPERTIES_PATH, (Throwable)e);
                }
            }
        }
    }
}

