/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.datasource;

import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import jeus.jdbc.connectionpool.ClusteredConnectionPool;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.jdbc.datasource.ClusterDSBindInfo;
import jeus.jdbc.datasource.DBDSBindInfo;
import jeus.jdbc.datasource.DBDataSourceException;
import jeus.jdbc.datasource.DataSourceGenerator;
import jeus.jdbc.info.ConnectionPoolInfo;
import jeus.util.JeusRootClassLoader;
import jeus.util.message.JeusMessageBundles;
import jeus.util.message.JeusMessage_JDBC;

public class DBDSBinder {
    public static void bind(DBDSBindInfo info, boolean forced, boolean local) throws DBDataSourceException {
        try {
            Object bindInstance = info.getDataSourceType() >= 1 ? new ConnectionPoolImpl(new ConnectionPoolInfo(info)) : DataSourceGenerator.getDataSource(info);
            InitialContext ctx = local ? DBDSBinder.makeInitialContext4LocalBinding() : DBDSBinder.makeInitialContext();
            if (forced) {
                ctx.rebind(info.getJndiExportName(), bindInstance);
            } else {
                ctx.bind(info.getJndiExportName(), bindInstance);
            }
        }
        catch (Throwable th) {
            if (th instanceof DBDataSourceException) {
                throw (DBDataSourceException)th;
            }
            throw new DBDataSourceException(JeusMessageBundles.getMessage(JeusMessage_JDBC._41, info.getDataSourceId()), th);
        }
    }

    public static void bind(ClusterDSBindInfo clusterInfo, boolean forced, boolean local) throws DBDataSourceException {
        try {
            ClusteredConnectionPool bindInstance = new ClusteredConnectionPool(clusterInfo);
            InitialContext ctx = local ? DBDSBinder.makeInitialContext4LocalBinding() : DBDSBinder.makeInitialContext();
            if (forced) {
                ctx.rebind(clusterInfo.getJndiExportName(), (Object)bindInstance);
            } else {
                ctx.bind(clusterInfo.getJndiExportName(), (Object)bindInstance);
            }
        }
        catch (Throwable th) {
            if (th instanceof DBDataSourceException) {
                throw (DBDataSourceException)th;
            }
            throw new DBDataSourceException(JeusMessageBundles.getMessage(JeusMessage_JDBC._41, clusterInfo.getDataSourceId()), th);
        }
    }

    public static void unbind(String exportName) {
        try {
            InitialContext ctx = DBDSBinder.makeInitialContext();
            ctx.unbind(exportName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static InitialContext makeInitialContext() throws NamingException {
        Hashtable<String, String> envs = new Hashtable<String, String>();
        envs.put("jeus.jndi.jns.replicatebindings", "false");
        envs.put("jeus.jndi.jns.forcedbindings", "true");
        InitialContext ctx = new InitialContext(envs);
        return ctx;
    }

    private static InitialContext makeInitialContext4LocalBinding() throws NamingException {
        Hashtable<String, String> envs = new Hashtable<String, String>();
        envs.put("jeus.jndi.jns.localbindings", "true");
        envs.put("jeus.jndi.jns.forcedbindings", "true");
        InitialContext ctx = new InitialContext(envs);
        return ctx;
    }

    public static ClassLoader getDSClassLoader() {
        return JeusRootClassLoader.loader;
    }

    public static void invokeMethod(Class cl, String methodName, Class[] argTypes, Object instance, Object[] args) throws Exception {
        Method m = cl.getMethod(methodName, argTypes);
        m.invoke(instance, args);
    }
}

