/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.helper;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import jeus.jdbc.common.DBMSType;
import jeus.jdbc.common.JeusPooledConnection;
import jeus.jdbc.connectionpool.JeusSQLException;
import jeus.jdbc.info.ConnectionPoolInfo;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessageBundles;
import jeus.util.message.JeusMessage_JDBC;

public final class ConnectionPoolDBAHelper {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.jdbc.pool.dbahelper");
    private static final String ORACLE_GET_SESSION_ID_SQL = "select userenv('SESSIONID') from dual";
    private static final String TIBERO_GET_SESSION_ID_SQL = "select userenv('TID') from dual";
    private static final String SYBASE_GET_SESSION_ID_SQL = "select @@spid";
    private static final String ORACLE_GET_SID_SERIAL_SQL = "select sid,serial# from v$session where audsid in ";
    private static final String TIBERO_GET_SID_SERIAL_SQL = "select sid,serial# from v$session where username=";
    private static final String ORACLE_KILL_SESSION_SQL = "alter system kill session ";
    private static final String SYBASE_KILL_SESSION_SQL = "kill ";
    private final ConnectionPoolInfo poolInfo;
    private final DataSource dbaDataSource;

    public ConnectionPoolDBAHelper(ConnectionPoolInfo poolInfo, Hashtable env) throws NamingException {
        this.dbaDataSource = (DataSource)new InitialContext(env).lookup(poolInfo.getDbaDataSourceName());
        this.poolInfo = poolInfo;
    }

    private void checkDatabaseVendor() throws SQLException {
        DBMSType dbmsType = this.poolInfo.getDBMSType();
        if (!(dbmsType.equals(DBMSType.ORACLE) || dbmsType.equals(DBMSType.SYBASE) || dbmsType.equals(DBMSType.TIBERO))) {
            throw new SQLException("unsupported vendor : " + dbmsType.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareDatabaseSessionId(JeusPooledConnection pcon) throws SQLException {
        this.checkDatabaseVendor();
        String getSessionIdSql = "";
        DBMSType dbmsType = this.poolInfo.getDBMSType();
        if (dbmsType.equals(DBMSType.ORACLE)) {
            getSessionIdSql = ORACLE_GET_SESSION_ID_SQL;
        } else if (dbmsType.equals(DBMSType.SYBASE)) {
            getSessionIdSql = SYBASE_GET_SESSION_ID_SQL;
        } else if (dbmsType.equals(DBMSType.TIBERO)) {
            getSessionIdSql = TIBERO_GET_SESSION_ID_SQL;
        }
        Connection actualHandle = pcon.getActualHandle();
        Statement stmt = actualHandle.createStatement();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(getSessionIdSql);
            if (!rs.next()) {
                throw new SQLException("no associated session id with " + getSessionIdSql);
            }
            String sid = rs.getString(1);
            pcon.setDatabaseSessionId(sid);
            if (logger.isLoggable(JeusMessage_JDBC._325_LEVEL)) {
                logger.log(JeusMessage_JDBC._325_LEVEL, JeusMessage_JDBC._325, new Object[]{sid, pcon.getConnectionId()});
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ignored) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ignored) {}
            }
        }
    }

    public void killDatabaseSession(String dbSessionId) throws SQLException {
        DBMSType dbmsType = this.poolInfo.getDBMSType();
        if (dbmsType.equals(DBMSType.ORACLE)) {
            this.killOracleSession(dbSessionId);
        } else if (dbmsType.equals(DBMSType.SYBASE)) {
            this.killSybaseSession(dbSessionId);
        } else if (dbmsType.equals(DBMSType.TIBERO)) {
            this.killTiberoSession(dbSessionId);
        }
    }

    private void killTiberoSession(String dbSessionId) throws SQLException {
        Statement stmt = null;
        Connection dbaConn = null;
        String dbaOperationSql = null;
        ResultSet rs = null;
        try {
            dbaConn = this.dbaDataSource.getConnection();
            stmt = dbaConn.createStatement();
            dbaOperationSql = "select sid,serial# from v$session where username='" + this.poolInfo.getUserName().toUpperCase() + "' and sid='" + dbSessionId + "'";
            logger.log(JeusMessage_JDBC._327_LEVEL, JeusMessage_JDBC._327, (Object)dbaOperationSql);
            rs = stmt.executeQuery(dbaOperationSql);
            if (!rs.next()) {
                logger.log(JeusMessage_JDBC._335_LEVEL, JeusMessage_JDBC._335, (Object)this.poolInfo.getDbaDataSourceName());
                throw new SQLException(JeusMessageBundles.getMessage(JeusMessage_JDBC._335, this.poolInfo.getDbaDataSourceName()));
            }
            String sid = rs.getString(1);
            String serial = rs.getString(2);
            dbaOperationSql = "alter system kill session (" + sid + "," + serial + ")";
            logger.log(JeusMessage_JDBC._328_LEVEL, JeusMessage_JDBC._328, (Object)dbaOperationSql);
            stmt.executeQuery(dbaOperationSql);
        }
        catch (SQLException se) {
            throw new JeusSQLException(JeusMessage_JDBC._351, new Object[]{dbaOperationSql, this.poolInfo.getDbaDataSourceName()}, (Throwable)se);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ignored) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ignored) {}
            }
            if (dbaConn != null) {
                try {
                    dbaConn.close();
                }
                catch (SQLException ignored) {}
            }
        }
    }

    private void killOracleSession(String dbSessionId) throws SQLException {
        Statement stmt = null;
        Connection dbaConn = null;
        String dbaOperationSql = null;
        ResultSet rs = null;
        try {
            dbaConn = this.dbaDataSource.getConnection();
            stmt = dbaConn.createStatement();
            dbaOperationSql = ORACLE_GET_SID_SERIAL_SQL + dbSessionId;
            if (logger.isLoggable(JeusMessage_JDBC._327_LEVEL)) {
                logger.log(JeusMessage_JDBC._327_LEVEL, JeusMessage_JDBC._327, (Object)dbaOperationSql);
            }
            if (!(rs = stmt.executeQuery(dbaOperationSql)).next()) {
                logger.log(JeusMessage_JDBC._329_LEVEL, JeusMessage_JDBC._329, (Object)dbSessionId);
                throw new SQLException(JeusMessageBundles.getMessage(JeusMessage_JDBC._329, dbSessionId));
            }
            String sid = rs.getString(1);
            String serial = rs.getString(2);
            dbaOperationSql = "alter system kill session '" + sid + "," + serial + "'";
            if (logger.isLoggable(JeusMessage_JDBC._328_LEVEL)) {
                logger.log(JeusMessage_JDBC._328_LEVEL, JeusMessage_JDBC._328, (Object)dbaOperationSql);
            }
            stmt.executeQuery(dbaOperationSql);
        }
        catch (SQLException se) {
            throw new JeusSQLException(JeusMessage_JDBC._351, new Object[]{dbaOperationSql, this.poolInfo.getDbaDataSourceName()}, (Throwable)se);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ignored) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ignored) {}
            }
            if (dbaConn != null) {
                try {
                    dbaConn.close();
                }
                catch (SQLException ignored) {}
            }
        }
    }

    private void killSybaseSession(String dbSessionId) throws SQLException {
        Statement stmt = null;
        Connection dbaConn = null;
        String killSidSQL = null;
        try {
            dbaConn = this.dbaDataSource.getConnection();
            stmt = dbaConn.createStatement();
            killSidSQL = SYBASE_KILL_SESSION_SQL + dbSessionId;
            if (logger.isLoggable(JeusMessage_JDBC._328_LEVEL)) {
                logger.log(JeusMessage_JDBC._328_LEVEL, JeusMessage_JDBC._328, (Object)killSidSQL);
            }
            stmt.executeUpdate(killSidSQL);
        }
        catch (SQLException se) {
            throw new JeusSQLException(JeusMessage_JDBC._349, new Object[]{killSidSQL, this.poolInfo.getDbaDataSourceName()}, (Throwable)se);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ignored) {}
            }
            if (dbaConn != null) {
                try {
                    dbaConn.close();
                }
                catch (SQLException ignored) {}
            }
        }
    }
}

