/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.helper;

import java.sql.SQLException;
import java.util.logging.Level;
import jeus.jdbc.common.JeusConnectionImpl;
import jeus.jdbc.common.JeusPooledConnection;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.util.ScheduleTask;
import jeus.util.ScheduledExecutor;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;

public class PeriodicConnectionChecker
extends ScheduleTask {
    private static final ScheduledExecutor executor = ScheduledExecutor.getInstance();
    private final ConnectionPoolImpl pool;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.jdbc");

    public PeriodicConnectionChecker(ConnectionPoolImpl pool) {
        this.pool = pool;
    }

    public void start(long period) {
        if (period <= 0L) {
            throw new IllegalArgumentException("Period should be bigger than zero.");
        }
        executor.scheduleWithFixedDelay(this, period, period);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (logger.isLoggable(JeusMessage_JDBC._339_LEVEL)) {
                logger.logp(JeusMessage_JDBC._339_LEVEL, "ConnectionPool", "checkConnection", JeusMessage_JDBC._339, (Object)this.pool.getDataSourceId());
            }
            if (this.pool.isFailed()) {
                JeusPooledConnection pcon = this.pool.createNewPooledConnectionForFailOver();
                this.pool.handleConnectionForFailOver(pcon);
                this.pool.forcedShrink();
                if (logger.isLoggable(JeusMessage_JDBC._306_LEVEL)) {
                    logger.log(JeusMessage_JDBC._306_LEVEL, JeusMessage_JDBC._306, new Object[]{this.pool.getDataSourceId()});
                }
                this.pool.changeFailedState(true, false);
                return;
            }
            int connections = this.pool.getPoolSize();
            for (int i = 0; i < connections; ++i) {
                JeusConnectionImpl con = null;
                try {
                    con = this.pool.getConnectionToCheck();
                    if (con != null) continue;
                    logger.log(Level.FINEST, "Periodic connection check finished : " + this.pool.getDataSourceId());
                    return;
                }
                catch (SQLException e) {
                    continue;
                }
                finally {
                    try {
                        if (con != null) {
                            con.setUseForValidationOnly(true);
                            con.close();
                        }
                    }
                    catch (SQLException e) {}
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

