/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.helper;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import jeus.jdbc.connectionpool.ClusteredConnectionPool;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.jdbc.connectionpool.DataSourceFailedException;
import jeus.jdbc.connectionpool.WaitTimeoutException;
import jeus.jdbc.helper.ClusterDataSourceLoadBalancer;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_JDBC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRoundRobinLoadBalancer
extends ClusterDataSourceLoadBalancer {
    private ClusteredConnectionPool clusterCP;
    private AtomicInteger dataSourceIndex = new AtomicInteger(0);

    public SimpleRoundRobinLoadBalancer(List<String> dataSourceList, ClusteredConnectionPool clusterCP) {
        super(dataSourceList);
        this.clusterCP = clusterCP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Connection getConnection(String username, String password, boolean shareable) throws SQLException {
        ArrayList<Integer> failedList = new ArrayList<Integer>();
        while (true) {
            Object var10_9;
            int index;
            block7: {
                if (failedList.size() >= this.dataSourceList.size()) {
                    throw new DataSourceFailedException(ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._304));
                }
                index = this.getConnection();
                if (!failedList.isEmpty() && failedList.contains(index)) continue;
                String dataSourceName = (String)this.dataSourceList.get(index);
                try {
                    try {
                        ConnectionPoolImpl pool = this.clusterCP.getTargetConnectionPool(index);
                        if (pool == null || pool.isFailed()) break block7;
                        Connection connection = pool.getConnection(username, password, shareable);
                        var10_9 = null;
                        failedList.add(index);
                        return connection;
                    }
                    catch (Throwable th) {
                        if (th instanceof WaitTimeoutException) {
                            throw new SQLException(th.getMessage());
                        }
                        logger.logp(JeusMessage_JDBC._305_LEVEL, "ClusteredConnectionPool", "getConnection", JeusMessage_JDBC._305, (Object)dataSourceName);
                        logger.logp(JeusMessage_JDBC._322_LEVEL, "ClusteredConnectionPool", "getConnection", JeusMessage_JDBC._322, dataSourceName, th);
                        var10_9 = null;
                        failedList.add(index);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var10_9 = null;
                    failedList.add(index);
                    throw throwable;
                }
            }
            var10_9 = null;
            failedList.add(index);
        }
    }

    private int getConnection() {
        return (this.dataSourceIndex.getAndIncrement() & Integer.MAX_VALUE) % this.dataSourceList.size();
    }
}

