/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.info;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import jeus.jdbc.datasource.ClusterDSBindInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterDataSourceInfo
implements Serializable {
    private static final long serialVersionUID = 60L;
    private final String dataSourceId;
    private String dataSourceIdListAsString;
    private transient List<String> dataSourceIdList;
    private boolean useFastFailOver;
    private boolean useFailback;
    private boolean useLoadBalancing;
    private String dataSourceSelectorFQCN;

    public ClusterDataSourceInfo(String id) {
        this.dataSourceId = id;
    }

    public ClusterDataSourceInfo(ClusterDSBindInfo info) {
        this.dataSourceId = info.getDataSourceId();
        this.setDataSourceIdListAsString(info.getDSList());
        this.useFastFailOver = info.isPreConn();
        this.useFailback = info.isUseFailback();
        this.useLoadBalancing = info.isUseLoadBalancing();
        this.dataSourceSelectorFQCN = info.getDataSourceSelectorFQCN();
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public String getDataSourceIdListAsString() {
        return this.dataSourceIdListAsString;
    }

    public void setDataSourceIdListAsString(String dataSourceIdListAsString) {
        this.dataSourceIdListAsString = dataSourceIdListAsString;
        this.dataSourceIdList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(dataSourceIdListAsString, ",");
        while (st.hasMoreTokens()) {
            String dsName = st.nextToken();
            this.dataSourceIdList.add(dsName.trim());
        }
    }

    public List<String> getDataSourceIdList() {
        return this.dataSourceIdList;
    }

    public boolean isUseFastFailOver() {
        return this.useFastFailOver;
    }

    public void setUseFastFailOver(boolean useFastFailOver) {
        this.useFastFailOver = useFastFailOver;
    }

    public boolean useFailback() {
        return this.useFailback;
    }

    public void setUseFailback(boolean useFailback) {
        this.useFailback = useFailback;
    }

    public boolean useLoadBalancing() {
        return this.useLoadBalancing;
    }

    public void setUseLoadBalancing(boolean useLoadBalancing) {
        this.useLoadBalancing = useLoadBalancing;
    }

    public void setDataSourceSelectorFQCN(String dataSourceSelectorFQCN) {
        this.dataSourceSelectorFQCN = dataSourceSelectorFQCN;
    }

    public String getDataSourceSelectorFQCN() {
        return this.dataSourceSelectorFQCN;
    }
}

