/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.info;

import java.io.Serializable;
import java.util.logging.Level;
import javax.naming.Reference;
import javax.naming.Referenceable;
import jeus.jdbc.common.DBMSType;
import jeus.jdbc.connectionpool.ConnectionPoolException;
import jeus.jdbc.connectionpool.DefaultConnectionChecker;
import jeus.jdbc.datasource.DBDSBindInfo;
import jeus.jdbc.datasource.DBDataSourceException;
import jeus.jdbc.datasource.DataSourceGenerator;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;

public class ConnectionPoolInfo
implements Serializable {
    private static final long serialVersionUID = -8145243471276316975L;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.jdbc");
    private transient Object datasrc;
    private transient Reference dataSrcReference;
    private final String dataSourceId;
    private final String jndiExportName;
    private final String driverVendorName;
    private transient DBMSType dbmsType;
    private final int type;
    private final DBDSBindInfo bindInfo;
    private volatile int minPoolSize;
    private volatile int maxPoolSize;
    private volatile int increaseStep;
    private volatile boolean waiting;
    private volatile long waitTime;
    private volatile boolean isNonTxDelegatedDataSourceRequired;
    private volatile String nonTxDelegatedDataSourceName;
    private volatile boolean needConnectionValidation;
    private volatile String checkQuery;
    private volatile long checkQueryTimeout;
    private String checkQueryClassName;
    private volatile long nonValidationInterval;
    private volatile int checkQueryRetrialCount;
    private volatile long checkQueryPeriod;
    private volatile int destroyPolicyOnCheckQuery;
    private volatile String initSql;
    private volatile int stmtCachingSize;
    private volatile long stmtQueryTimeout;
    private volatile int stmtFetchSize;
    private volatile boolean autoCommit;
    private volatile boolean useAutoCommit;
    private volatile boolean useConnectionTrace;
    private volatile boolean useSQLTrace;
    private volatile boolean useSetAutoCommitTrace;
    private volatile boolean useStatementWrapper;
    private volatile boolean keepConnectionHandleOpen;
    private volatile long poolPeriod;
    private volatile int maxUseCount;
    private volatile int actionOnConnectionLeak;
    private volatile boolean isDbaDataSourceUsed;
    private volatile String dbaDataSourceName;
    private final long sessionKillTimeout;

    public ConnectionPoolInfo(DBDSBindInfo info) {
        this.dataSourceId = info.getDataSourceId();
        this.jndiExportName = info.getJndiExportName();
        this.driverVendorName = info.getVendor();
        this.waiting = info.getWaiting();
        this.waitTime = this.waiting ? info.getWaitTime() : 0L;
        this.type = info.getDataSourceType();
        this.isNonTxDelegatedDataSourceRequired = info.isNonTxDelegatedDataSourceRequired();
        this.nonTxDelegatedDataSourceName = info.getNonTxDelegatedDataSourceName();
        this.minPoolSize = info.getMin();
        this.maxPoolSize = info.getMax();
        this.increaseStep = info.getStep();
        this.maxUseCount = info.getMaxUseCount();
        this.poolPeriod = info.getResizingPeriod();
        this.useAutoCommit = info.isUseAutoCommitSetting();
        this.autoCommit = info.getAutoCommitValue();
        this.checkQuery = info.getCheckQuery();
        this.checkQueryTimeout = info.getCheckQueryTimeout();
        this.checkQueryClassName = info.getCheckQueryClassName();
        this.checkQueryPeriod = info.getCheckQueryPeriod();
        this.nonValidationInterval = info.getNonValidationInterval();
        this.checkQueryRetrialCount = info.getValidationRetrialCount();
        this.keepConnectionHandleOpen = info.isKeepConnectionHandleOpen();
        if (this.checkQuery != null && !this.checkQuery.equals("") || this.checkQueryClassName != null && !this.checkQueryClassName.equals("")) {
            this.setNeedConnectionValidation(true);
            if (this.checkQueryClassName == null || this.checkQueryClassName.equals("")) {
                this.checkQueryClassName = DefaultConnectionChecker.class.getName();
            }
        } else {
            this.checkQueryClassName = DefaultConnectionChecker.class.getName();
        }
        this.initSql = info.getInitSql();
        this.stmtQueryTimeout = info.getStmtQueryTimeout();
        this.stmtCachingSize = info.getStmtCachingSize();
        this.stmtFetchSize = info.getFetchSize();
        this.useConnectionTrace = info.getUseConnectionTrace();
        this.useSQLTrace = info.getUseSQLTrace();
        this.useSetAutoCommitTrace = info.getUseSetAutoCommtiTrace();
        this.useStatementWrapper = this.useSQLTrace;
        this.destroyPolicyOnCheckQuery = info.getDestroyPolicyOnCheckQuery();
        this.actionOnConnectionLeak = info.getActionOnConnectionLeak();
        this.isDbaDataSourceUsed = info.isDbaDataSourceUsed();
        this.dbaDataSourceName = info.getDbaDataSourceName();
        this.sessionKillTimeout = info.getSessionKillTimeout();
        this.bindInfo = info;
    }

    public Object getDataSource() {
        return this.datasrc;
    }

    public void setUpDataSource() throws DBDataSourceException {
        if (this.datasrc == null) {
            this.datasrc = DataSourceGenerator.getDataSource(this.bindInfo);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Driver's DataSource instance[" + this.datasrc + "] is generated : " + this.dataSourceId);
            }
        }
    }

    public int getPoolType() {
        return this.type;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public String getJndiExportName() {
        return this.jndiExportName;
    }

    public String getDriverVendorName() {
        return this.driverVendorName;
    }

    public DBMSType getDBMSType() {
        if (this.dbmsType == null) {
            this.dbmsType = DBMSType.getType(this.driverVendorName);
            if (this.dbmsType == null) {
                this.dbmsType = DBMSType.OTHERS;
            }
        }
        return this.dbmsType;
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    public void setWaiting(boolean b) {
        this.waiting = b;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
    }

    public boolean isNonTxDelegatedDataSourceRequired() {
        return this.isNonTxDelegatedDataSourceRequired;
    }

    public void setNonTxDelegatedDataSourceRequired(boolean b) {
        this.isNonTxDelegatedDataSourceRequired = b;
    }

    public String getNonTxDelegatedDataSourceName() {
        return this.nonTxDelegatedDataSourceName;
    }

    public void setNonTxDelegatedDataSourceName(String exportName) {
        this.nonTxDelegatedDataSourceName = exportName;
    }

    public long getSessionKillTimeout() {
        return this.sessionKillTimeout;
    }

    public boolean needConnectionValidation() {
        return this.needConnectionValidation;
    }

    public void setNeedConnectionValidation(boolean b) {
        this.needConnectionValidation = b;
    }

    public String getCheckQuery() {
        return this.checkQuery;
    }

    public String getCheckQueryClassName() {
        return this.checkQueryClassName;
    }

    public boolean isDefaultConnectionCheckerUsed() {
        return DefaultConnectionChecker.class.getName().equals(this.checkQueryClassName);
    }

    public int getStmtCachingSize() {
        return this.stmtCachingSize;
    }

    public boolean getAutoCommitValue() {
        return this.autoCommit;
    }

    public void setAutoCommitValue(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public boolean isUseAutoCommit() {
        return this.useAutoCommit;
    }

    public void setIsAutoCommitUsed(boolean b) {
        this.useAutoCommit = b;
    }

    public int getStmtFetchSize() {
        return this.stmtFetchSize;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int max) {
        this.maxPoolSize = max;
    }

    public long getPoolPeriod() {
        return this.poolPeriod;
    }

    public void setPoolPeriod(long period) {
        this.poolPeriod = period;
    }

    public int getIncreaseStep() {
        return this.increaseStep;
    }

    public void setIncreaseStep(int step) {
        this.increaseStep = step;
    }

    public void setMinPoolSize(int min) {
        this.minPoolSize = min;
    }

    public int getMaxUseCount() {
        return this.maxUseCount;
    }

    public long getCheckQueryPeriod() {
        return this.checkQueryPeriod;
    }

    public long getNonValidationInterval() {
        return this.nonValidationInterval;
    }

    public int getCheckQueryRetrialCount() {
        return this.checkQueryRetrialCount;
    }

    public String getUserName() {
        return this.bindInfo.getUserName();
    }

    public long getStmtQueryTimeout() {
        return this.stmtQueryTimeout;
    }

    public String getInitSql() {
        return this.initSql;
    }

    public Reference getDataSourceReference() throws ConnectionPoolException {
        if (this.dataSrcReference == null) {
            try {
                this.dataSrcReference = ((Referenceable)DataSourceGenerator.getDataSource(this.bindInfo)).getReference();
            }
            catch (Exception ex) {
                logger.logp(JeusMessage_JDBC._3_LEVEL, "ConnectionPool", "<init>", JeusMessage_JDBC._3, (Object)this.getDataSourceId());
                throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString(JeusMessage_JDBC._3, this.getDataSourceId()), (Throwable)ex);
            }
        }
        return this.dataSrcReference;
    }

    public boolean isConnectionTraceEnabled() {
        return this.useConnectionTrace;
    }

    public void setConnectionTraceEnabled(boolean b) {
        this.useConnectionTrace = b;
    }

    public boolean isKeepConnectionHandleOpen() {
        return this.keepConnectionHandleOpen;
    }

    public void setKeepConnectionHandleOpen(boolean b) {
        this.keepConnectionHandleOpen = b;
    }

    public boolean isSqlTraceEnabled() {
        return this.useSQLTrace;
    }

    public void setUseSQLTrace(boolean b) {
        this.useSQLTrace = b;
    }

    public boolean isUseSetAutoCommitTrace() {
        return this.useSetAutoCommitTrace;
    }

    public void setUseSetAutoCommitTrace(boolean useSetAutoCommitTrace) {
        this.useSetAutoCommitTrace = useSetAutoCommitTrace;
    }

    public boolean shouldUseStatementWrapper() {
        return this.useStatementWrapper;
    }

    public void setUseStatementWrapper(boolean b) {
        this.useStatementWrapper = b;
    }

    public int getDestoryPolicyOnCheckQuery() {
        return this.destroyPolicyOnCheckQuery;
    }

    public void setDestoryPolicyOnCheckQuery(int policy) {
        this.destroyPolicyOnCheckQuery = policy;
    }

    public int getActionOnConnectionLeak() {
        return this.actionOnConnectionLeak;
    }

    public void setActionOnConnectionLeak(int action) {
        this.actionOnConnectionLeak = action;
    }

    public long getCheckQueryTimeout() {
        return this.checkQueryTimeout;
    }

    public void setCheckQueryPeriod(long period) {
        this.checkQueryPeriod = period;
    }

    public void setCheckQuery(String value) {
        this.checkQuery = value;
    }

    public void setCheckQueryTimeout(long timeout) {
        this.checkQueryTimeout = timeout;
    }

    public void setStatementQueryTimeout(long timeout) {
        this.stmtQueryTimeout = timeout;
    }

    public void setStatementCacheSize(int size) {
        this.stmtCachingSize = size;
    }

    public void setCheckQueryRetrialCount(int count) {
        this.checkQueryRetrialCount = count;
    }

    public void setNonValidationInterval(long nonValidationInterval) {
        this.nonValidationInterval = nonValidationInterval;
    }

    public void setStatementFetchSize(int size) {
        this.stmtFetchSize = size;
    }

    public void setMaxUseCount(int maxUseCount) {
        this.maxUseCount = maxUseCount;
    }

    public void setInitSql(String initSql) {
        this.initSql = initSql;
    }

    public boolean isDbaDataSourceUsed() {
        return this.isDbaDataSourceUsed;
    }

    public String getDbaDataSourceName() {
        return this.dbaDataSourceName;
    }
}

