/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.info;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jeus.jdbc.info.CPInfo;
import jeus.jdbc.info.ConnectionPoolInfo;
import jeus.jdbc.info.JDBCPooledConnectionInfo;
import jeus.jdbc.info.PooledConnectionInfo;
import jeus.management.j2ee.statistics.BoundedRangeStatisticImpl;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.management.j2ee.statistics.RangeStatisticImpl;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.management.j2ee.statistics.TimeStatisticImpl;

public class DynamicPoolStatsAndInfo {
    private volatile BoundedRangeStatisticImpl minPoolSizeStat;
    private volatile BoundedRangeStatisticImpl maxPoolSizeStat;
    private final BoundedRangeStatisticImpl currentPoolSize;
    private final BoundedRangeStatisticImpl freePoolSize;
    private final CountStatisticImpl closeCount;
    private final CountStatisticImpl createCount;
    private final RangeStatisticImpl waitingThreadCount;
    private final TimeStatisticImpl waitTimeStat;
    private final TimeStatisticImpl useTimeStat;
    private final RangeStatisticImpl disposableConnectionSizeStat;
    private final List<PooledConnectionInfo> infoList = Collections.synchronizedList(new ArrayList());

    public DynamicPoolStatsAndInfo(ConnectionPoolInfo config) {
        this.setMinPoolSizeStat(config.getMinPoolSize());
        this.setMaxPoolSizeStat(config.getMaxPoolSize());
        this.currentPoolSize = new BoundedRangeStatisticImpl("PoolSize", "connection", "the number of pooled connections", config.getMaxPoolSize(), 0L);
        this.freePoolSize = new BoundedRangeStatisticImpl("FreePoolSize", "connection", "the number of free connections in the pool", config.getMaxPoolSize(), 0L);
        this.disposableConnectionSizeStat = new RangeStatisticImpl("DisposableConnectionSize", "connection", "the number of disposable connections");
        this.closeCount = new CountStatisticImpl("CloseCount", "connection", "the number of connections closed");
        this.createCount = new CountStatisticImpl("CreateCount", "connection", "the number of connections created");
        this.waitingThreadCount = new RangeStatisticImpl("WaitingThreadCount", "thread", "the number of threads waiting for a connection");
        this.useTimeStat = new TimeStatisticImpl("UseTime", "millisecond", "the time spent using a connection");
        this.waitTimeStat = new TimeStatisticImpl("WaitTime", "millisecond", "the time spent waiting for a connection to be available");
    }

    public int getCurrentPoolSize() {
        return (int)this.currentPoolSize.getCurrent();
    }

    public StatisticImpl getPoolSizeStatistic() {
        return this.currentPoolSize;
    }

    public BoundedRangeStatisticImpl getStatisticOfFreePoolSize() {
        return this.freePoolSize;
    }

    public StatisticImpl getMinSizeStat() {
        return this.minPoolSizeStat;
    }

    public void setMinPoolSizeStat(int minPoolSize) {
        this.minPoolSizeStat = new BoundedRangeStatisticImpl("MinPoolSize", "connection", "the size of minimum connections", minPoolSize, minPoolSize);
    }

    public StatisticImpl getMaxSizeStat() {
        return this.maxPoolSizeStat;
    }

    public void setMaxPoolSizeStat(int maxPoolSize) {
        this.maxPoolSizeStat = new BoundedRangeStatisticImpl("MaxPoolSize", "connection", "the size of the maximum connections", maxPoolSize, maxPoolSize);
    }

    public void incWaitThreadCount() {
        this.waitingThreadCount.increase();
    }

    public void decWaitThreadCount() {
        this.waitingThreadCount.decrease();
    }

    public void incCreateCount() {
        this.createCount.increase();
    }

    public StatisticImpl getCreatCountStat() {
        return this.createCount;
    }

    public void incCloseCount() {
        this.closeCount.increase();
    }

    public StatisticImpl getCloseCountStat() {
        return this.closeCount;
    }

    public boolean removePooledConnectionInfo(PooledConnectionInfo info) {
        if (info.isDisposable()) {
            this.disposableConnectionSizeStat.decrease();
        } else {
            this.currentPoolSize.decrease();
        }
        return this.infoList.remove(info);
    }

    public void addPooledConnectionInfo(PooledConnectionInfo info) {
        if (info.isDisposable()) {
            this.disposableConnectionSizeStat.increase();
        } else {
            this.currentPoolSize.increase();
        }
        this.infoList.add(info);
    }

    public RangeStatisticImpl getWaitingThreadCountStat() {
        return this.waitingThreadCount;
    }

    public JDBCPooledConnectionInfo[] getPooledConnectionInfoArray() {
        return this.infoList.toArray(new JDBCPooledConnectionInfo[this.infoList.size()]);
    }

    public void destroy() {
        this.infoList.clear();
    }

    public void setCPInfo(CPInfo cpInfo) {
        int idleCount = (int)this.freePoolSize.getCurrent();
        cpInfo.setActive(this.getCurrentPoolSize() - idleCount);
        cpInfo.setIdle(idleCount);
        cpInfo.setDisposable((int)this.disposableConnectionSizeStat.getCurrent());
    }

    public void incIdleConnections() {
        this.freePoolSize.increase();
    }

    public void decIdleConnections() {
        this.freePoolSize.decrease();
    }

    public StatisticImpl getWaitTimeStatistic() {
        return this.waitTimeStat;
    }

    public StatisticImpl getUseTimeStatistic() {
        return this.useTimeStat;
    }

    public void addToUseTimeStat(long startTime) {
        this.useTimeStat.addData(System.currentTimeMillis() - startTime);
    }

    public void addToWaitTimeStat(long time) {
        this.waitTimeStat.addData(time);
    }

    public RangeStatisticImpl getDisposableConnectionSizeStatistic() {
        return this.disposableConnectionSizeStat;
    }
}

