/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.info;

import java.io.Serializable;
import jeus.jdbc.common.AbstractJeusPooledConnection;
import jeus.jdbc.info.PooledConnectionInfo;
import jeus.jdbc.info.SQLTraceInfo;

public class JDBCPooledConnectionInfo
extends PooledConnectionInfo
implements Serializable {
    private SQLTraceInfo sqlTraceInfo;
    private transient AbstractJeusPooledConnection pcon;

    public JDBCPooledConnectionInfo(AbstractJeusPooledConnection pcon, String connectionId, boolean isActive, int useCount, long stateChangedTime, int generation, boolean disposable, boolean useSQLTrace) {
        super(connectionId, isActive, useCount, stateChangedTime, generation, disposable);
        this.pcon = pcon;
        if (useSQLTrace) {
            this.sqlTraceInfo = new SQLTraceInfo();
        }
    }

    public void setSQLStatement(String sql, long startingTime) {
        if (this.sqlTraceInfo != null) {
            this.sqlTraceInfo.setSqlStatus(sql, startingTime);
        }
    }

    public SQLTraceInfo getCurrentSQLTraceInfo() {
        if (this.sqlTraceInfo != null) {
            return (SQLTraceInfo)this.sqlTraceInfo.clone();
        }
        return null;
    }

    public boolean shouldShowTraceInformation() {
        return super.shouldShowTraceInformation() || this.sqlTraceInfo != null;
    }

    public AbstractJeusPooledConnection getPhysicalConnection() {
        return this.pcon;
    }
}

