/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.info;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import jeus.jdbc.common.JeusConnectionImpl;

public class PooledConnectionInfo
implements Serializable {
    private static final long serialVersionUID = -3226315680404271470L;
    private int generation;
    private int useCount;
    private String connectionId;
    private AtomicBoolean isActive = new AtomicBoolean();
    private long stateChangedTime;
    private boolean disposable;
    private HashMap traceList;
    private volatile String threadNameInUse;

    public PooledConnectionInfo(String connectionId, boolean isActive, int useCount, long stateChangedTime, int generation, boolean disposable) {
        this.connectionId = connectionId;
        this.isActive.set(isActive);
        this.useCount = useCount;
        this.stateChangedTime = stateChangedTime;
        this.generation = generation;
        this.disposable = disposable;
        this.traceList = new HashMap();
    }

    public int getUseCount() {
        return this.useCount;
    }

    public void incUseCount() {
        ++this.useCount;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public boolean isActive() {
        return this.isActive.get();
    }

    public boolean compareAndSetIsActive(boolean b) {
        if (b) {
            return this.isActive.compareAndSet(false, b);
        }
        return this.isActive.compareAndSet(true, b);
    }

    public int getGeneration() {
        return this.generation;
    }

    public void setGeneration(int generation) {
        this.generation = generation;
    }

    public long getStateChangedTime() {
        return this.stateChangedTime;
    }

    public void setStateChangedTime(long stateChangedTime) {
        this.stateChangedTime = stateChangedTime;
    }

    public boolean isDisposable() {
        return this.disposable;
    }

    public void setDisposable(boolean disposable) {
        this.disposable = disposable;
    }

    public void setConnectionTrace(JeusConnectionImpl jeusConn) {
        this.traceList.put(jeusConn.toString(), jeusConn.getConnectionTrace());
    }

    public Map getConnectionTraces() {
        return (HashMap)this.traceList.clone();
    }

    public void unsetConnectionTrace(JeusConnectionImpl jeusConn) {
        this.traceList.remove(jeusConn.toString());
    }

    public void clearAllConnectionTraces() {
        this.traceList.clear();
    }

    public boolean shouldShowTraceInformation() {
        return !this.getConnectionTraces().isEmpty();
    }

    public void setThreadNameInUse(String name) {
        this.threadNameInUse = name;
    }

    public String getThreadNameInUse() {
        return this.threadNameInUse;
    }
}

