/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.queue;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import jeus.jdbc.connectionpool.ConnectionPoolException;
import jeus.jdbc.connectionpool.ConnectionPoolResizer;
import jeus.jdbc.queue.JDBCConnectionQueue;
import jeus.util.ScheduleTask;
import jeus.util.ScheduledExecutor;
import jeus.util.logging.JeusLogger;

public class DefaultConnectionPoolResizer
implements ConnectionPoolResizer {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.jdbc.pool.resizer");
    private JDBCConnectionQueue queue;
    private static final long SAMPLING_PERIOD = 2000L;
    private static final int MAX_HISTORY_SIZE = 150;
    private final List<Integer> sizeHistory = new ArrayList<Integer>(150);
    private ConnectionPoolSizeSampler poolSizeSampler;
    private static final ScheduledExecutor periodicJobExecutor = ScheduledExecutor.getInstance();
    private final Lock resizerLock = new ReentrantLock();
    private String poolName;

    public DefaultConnectionPoolResizer() {
    }

    DefaultConnectionPoolResizer(JDBCConnectionQueue queue) {
        this.queue = queue;
    }

    void setConnectionQueue(JDBCConnectionQueue queue) {
        this.queue = queue;
    }

    public void initialize(String poolName) throws ConnectionPoolException {
        assert (this.queue != null);
        this.poolName = poolName;
        this.poolSizeSampler = new ConnectionPoolSizeSampler();
        periodicJobExecutor.scheduleWithFixedDelay(this.poolSizeSampler, 2000L, 2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSizeToBeShrinked(int min, int max, int current) {
        block4: {
            block5: {
                this.resizerLock.lock();
                try {
                    if (!this.sizeHistory.isEmpty()) break block4;
                    if (current - min < 0) break block5;
                    int n = current - min;
                    Object var6_7 = null;
                    this.resizerLock.unlock();
                    return n;
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    this.resizerLock.unlock();
                    throw throwable;
                }
            }
            int n = -1;
            Object var6_8 = null;
            this.resizerLock.unlock();
            return n;
        }
        int n = this.retrieveMeanIdleNumAndClear();
        Object var6_9 = null;
        this.resizerLock.unlock();
        return n;
    }

    private int retrieveMeanIdleNumAndClear() {
        int sum = 0;
        for (int size : this.sizeHistory) {
            sum += size;
        }
        int meanOfIdle = sum / this.sizeHistory.size();
        this.sizeHistory.clear();
        this.sizeHistory.add(meanOfIdle);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Current mean number of idle connections of pool[" + this.poolName + "] : " + meanOfIdle);
        }
        return meanOfIdle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.resizerLock.lock();
        try {
            this.sizeHistory.clear();
            Object var2_1 = null;
            this.resizerLock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.resizerLock.unlock();
            throw throwable;
        }
    }

    public void destroy() {
        this.poolSizeSampler.cancel();
        this.refresh();
    }

    private class ConnectionPoolSizeSampler
    extends ScheduleTask {
        private ConnectionPoolSizeSampler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DefaultConnectionPoolResizer.this.resizerLock.lock();
            try {
                if (DefaultConnectionPoolResizer.this.sizeHistory.size() == 150) {
                    DefaultConnectionPoolResizer.this.retrieveMeanIdleNumAndClear();
                }
                DefaultConnectionPoolResizer.this.sizeHistory.add(DefaultConnectionPoolResizer.this.queue.size());
                Object var2_1 = null;
                DefaultConnectionPoolResizer.this.resizerLock.unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                DefaultConnectionPoolResizer.this.resizerLock.unlock();
                throw throwable;
            }
        }
    }
}

