/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.queue;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XADataSource;
import jeus.descriptor.bind.DBDSBindInfoJB;
import jeus.jdbc.common.AbstractJeusPooledConnection;
import jeus.jdbc.common.JeusCachePooledConnection;
import jeus.jdbc.common.JeusNonCachePooledConnection;
import jeus.jdbc.common.JeusPooledConnection;
import jeus.jdbc.connectionpool.ConnectionPoolException;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.jdbc.connectionpool.ConnectionPoolResizer;
import jeus.jdbc.connectionpool.JeusSQLException;
import jeus.jdbc.datasource.DBDSBindInfo;
import jeus.jdbc.info.CPInfo;
import jeus.jdbc.info.ConnectionPoolInfo;
import jeus.jdbc.info.DynamicPoolStatsAndInfo;
import jeus.jdbc.queue.DefaultConnectionPoolResizer;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.util.JeusRootClassLoader;
import jeus.util.ScheduleTask;
import jeus.util.ScheduledExecutor;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessageBundles;
import jeus.util.message.JeusMessage_JDBC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCConnectionQueue {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.jdbc");
    private final LinkedList<JeusPooledConnection> queue = new LinkedList();
    private final ConnectionPoolImpl connectionPool;
    private final ConnectionPoolInfo poolInfo;
    private final DynamicPoolStatsAndInfo stats;
    private final String idPrefix;
    private int generation;
    private boolean destroyed = false;
    private static final ScheduledExecutor systemScheduler = ScheduledExecutor.getInstance();
    private final PoolPeriodTask poolPeriodTask = new PoolPeriodTask();
    private static final String resizerQFCN = System.getProperty("jeus.jdbc.poolresizer");
    private ConnectionPoolResizer poolResizer;

    public JDBCConnectionQueue(ConnectionPoolImpl cp, DynamicPoolStatsAndInfo statHolder) {
        this.connectionPool = cp;
        this.stats = statHolder;
        this.poolInfo = cp.getConnectionPoolInfo();
        this.idPrefix = this.poolInfo.getDataSourceId() + "-";
    }

    public synchronized void initConnectionQueue() throws SQLException {
        this.generation = 0;
        String dataSourceSpecificResizer = System.getProperty("jeus.jdbc.poolresizer." + this.connectionPool.getName());
        if (dataSourceSpecificResizer != null) {
            this.initPoolResizer(dataSourceSpecificResizer);
        } else if (resizerQFCN != null) {
            this.initPoolResizer(resizerQFCN);
        }
        for (int i = 0; i < this.poolInfo.getMinPoolSize(); ++i) {
            this.putConnection(this.createPooledConnection(null, null, false));
        }
        long poolPeriod = this.poolInfo.getPoolPeriod();
        if (poolPeriod > 0L) {
            systemScheduler.scheduleWithFixedDelay(this.poolPeriodTask, poolPeriod, poolPeriod);
        }
    }

    private void initPoolResizer(String resizerName) {
        block5: {
            try {
                if (resizerName.equalsIgnoreCase("default")) {
                    this.poolResizer = new DefaultConnectionPoolResizer(this);
                } else {
                    Class<?> cl = JeusRootClassLoader.loader.loadClass(resizerName);
                    this.poolResizer = (ConnectionPoolResizer)cl.newInstance();
                    if (this.poolResizer instanceof DefaultConnectionPoolResizer) {
                        ((DefaultConnectionPoolResizer)this.poolResizer).setConnectionQueue(this);
                    }
                }
                this.poolResizer.initialize(this.poolInfo.getDataSourceId());
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_JDBC._361_LEVEL)) break block5;
                logger.log(JeusMessage_JDBC._361_LEVEL, JeusMessage_JDBC._361, (Object)e.getMessage());
            }
        }
    }

    /*
     * Exception decompiling
     */
    public JeusPooledConnection getConnection(boolean waiting, long timeout, boolean returnNullOnEmpty) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 10[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private JeusPooledConnection removeConnectionFromNonemptyQueue() {
        this.stats.decIdleConnections();
        return this.queue.removeFirst();
    }

    public JeusPooledConnection getSingleConnection(String username, String password, boolean disposable) throws SQLException {
        JeusPooledConnection pcon = this.createPooledConnection(username, password, disposable);
        pcon.setGeneration(this.generation);
        return pcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JeusPooledConnection createNewConnectionForFailOver() throws SQLException {
        JDBCConnectionQueue jDBCConnectionQueue = this;
        synchronized (jDBCConnectionQueue) {
            if (this.stats.getCurrentPoolSize() < this.poolInfo.getMaxPoolSize()) {
                return this.getSingleConnection(null, null, false);
            }
        }
        return this.getSingleConnection(null, null, true);
    }

    private void sizeUpQueue(int margin) throws SQLException {
        for (int i = 0; i < margin; ++i) {
            this.putConnection(this.createPooledConnection(null, null, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean putConnection(JeusPooledConnection pcon) {
        try {
            if (this.queue.size() >= this.poolInfo.getMaxPoolSize()) {
                this.destroyConnection(pcon);
                logger.log(JeusMessage_JDBC._345_LEVEL, JeusMessage_JDBC._345, (Object)this.poolInfo.getDataSourceId());
                boolean bl = false;
                return bl;
            }
            if (pcon.getGeneration() == -1) {
                pcon.setGeneration(this.generation);
            } else if (pcon.getGeneration() != this.generation) {
                this.destroyConnection(pcon);
                boolean bl = false;
                return bl;
            }
            long currentTime = System.currentTimeMillis();
            pcon.setStateChangedTime(currentTime);
            this.stats.incIdleConnections();
            this.queue.addLast(pcon);
            boolean bl = true;
            return bl;
        }
        finally {
            this.notify();
        }
    }

    public synchronized int size() {
        return this.queue.size();
    }

    public synchronized <E> E[] toArray(E[] array) {
        return this.queue.toArray(array);
    }

    public synchronized boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public void shrinkPoolToMinimumSize() throws SQLException {
        this.resizePool(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizePool(boolean forcedShrink) throws SQLException {
        ArrayList<JeusPooledConnection> toBeClosed = null;
        try {
            JDBCConnectionQueue jDBCConnectionQueue = this;
            synchronized (jDBCConnectionQueue) {
                block20: {
                    int margin;
                    int currentSize;
                    block19: {
                        currentSize = this.stats.getCurrentPoolSize();
                        if (logger.isLoggable(Level.FINER)) {
                            logger.log(Level.FINER, "pool resizer is triggered; name=" + this.poolInfo.getDataSourceId() + ", current size=" + currentSize + ", forcedShrink=" + forcedShrink);
                        }
                        if (currentSize > this.poolInfo.getMaxPoolSize()) {
                            currentSize = this.poolInfo.getMaxPoolSize();
                        }
                        if ((margin = currentSize - this.poolInfo.getMinPoolSize()) != 0) break block19;
                        return;
                    }
                    try {
                        if (margin > 0) {
                            int resultOfResizer;
                            if (this.poolResizer != null && !forcedShrink && (resultOfResizer = this.poolResizer.getSizeToBeShrinked(this.poolInfo.getMinPoolSize(), this.poolInfo.getMaxPoolSize(), currentSize)) >= 0 && resultOfResizer < margin) {
                                margin = resultOfResizer;
                            }
                            toBeClosed = new ArrayList<JeusPooledConnection>(margin);
                            for (int i = 0; i < margin; ++i) {
                                if (this.queue.isEmpty()) {
                                    break block20;
                                }
                                JeusPooledConnection pcon = this.removeConnectionFromNonemptyQueue();
                                toBeClosed.add(pcon);
                            }
                            break block20;
                        }
                        margin = -1 * margin;
                        this.sizeUpQueue(margin);
                    }
                    finally {
                        this.notifyAll();
                    }
                }
            }
        }
        finally {
            if (toBeClosed != null) {
                Iterator it = toBeClosed.iterator();
                while (it.hasNext()) {
                    JeusPooledConnection pcon = (JeusPooledConnection)it.next();
                    this.destroyConnection(pcon);
                    it.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyConnection(JeusPooledConnection pcon) {
        try {
            pcon.close();
        }
        catch (Exception e) {
            logger.log(JeusMessage_JDBC._352_LEVEL, JeusMessage_JDBC._352, pcon, (Throwable)e);
        }
        finally {
            this.stats.incCloseCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceUsedConnection(JeusPooledConnection pcon) throws SQLException {
        try {
            this.destroyConnection(pcon);
        }
        finally {
            JDBCConnectionQueue jDBCConnectionQueue = this;
            synchronized (jDBCConnectionQueue) {
                JeusPooledConnection newPCon;
                if (this.stats.getCurrentPoolSize() < this.poolInfo.getMaxPoolSize() && this.putConnection(newPCon = this.createPooledConnection(null, null, false)) && logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "connection is replaced successfully");
                }
            }
        }
    }

    private void clearQueue() throws SQLException {
        while (!this.queue.isEmpty()) {
            JeusPooledConnection pcon = this.removeConnectionFromNonemptyQueue();
            this.destroyConnection(pcon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Map<String, Object> properties) throws ConnectionPoolException {
        boolean autoCommit = this.poolInfo.getAutoCommitValue();
        boolean isAutoCommitUsed = this.poolInfo.isUseAutoCommit();
        int actionOnConnectionLeak = this.poolInfo.getActionOnConnectionLeak();
        long statementQueryTimeout = this.poolInfo.getStmtQueryTimeout();
        int minPoolSize = this.poolInfo.getMinPoolSize();
        int maxPoolSize = this.poolInfo.getMaxPoolSize();
        int poolSizeStep = this.poolInfo.getIncreaseStep();
        long poolPeriod = this.poolInfo.getPoolPeriod();
        boolean enableWait = this.poolInfo.isWaiting();
        long waitTime = this.poolInfo.getWaitTime();
        int maxUseCount = this.poolInfo.getMaxUseCount();
        boolean needConnectionValidation = this.poolInfo.needConnectionValidation();
        String checkQuery = this.poolInfo.getCheckQuery();
        long checkQueryPeriod = this.poolInfo.getCheckQueryPeriod();
        long checkQueryTimeout = this.poolInfo.getCheckQueryTimeout();
        long nonValidationInterval = this.poolInfo.getNonValidationInterval();
        int checkQueryRetrialCount = this.poolInfo.getCheckQueryRetrialCount();
        int destroyPolicyOnCheckQuery = this.poolInfo.getDestoryPolicyOnCheckQuery();
        int statementCacheSize = this.poolInfo.getStmtCachingSize();
        int statementFetchSize = this.poolInfo.getStmtFetchSize();
        boolean enableConnectionTrace = this.poolInfo.isConnectionTraceEnabled();
        boolean useSqlTrace = this.poolInfo.isSqlTraceEnabled();
        boolean useSetAutoCommitTrace = this.poolInfo.isUseSetAutoCommitTrace();
        boolean keepConnectionHandleOpen = this.poolInfo.isKeepConnectionHandleOpen();
        String nonTxDelegatedDataSourceName = this.poolInfo.getNonTxDelegatedDataSourceName();
        String initSql = this.poolInfo.getInitSql();
        DataSource nonTxDelegatedDataSource = this.connectionPool.getNonTxDelegatedDataSource();
        boolean needToRollbackPoolPeriodTaskOnError = false;
        boolean needToRollbackCheckQueryPeriodTaskOnError = false;
        try {
            String value = (String)properties.get("AutoCommit");
            if (value != null) {
                if (value.equals("")) {
                    isAutoCommitUsed = false;
                } else {
                    autoCommit = Boolean.parseBoolean(value);
                    isAutoCommitUsed = true;
                }
            }
            if ((value = (String)properties.get("ActionOnConnectionLeak")) != null) {
                actionOnConnectionLeak = DBDSBindInfoJB.convertActionOnConnectionLeakToInt(value);
            }
            if ((value = (String)properties.get("StatementQueryTimeout")) != null) {
                statementQueryTimeout = Long.parseLong(value);
            }
            if ((value = (String)properties.get("MinPoolSize")) != null) {
                minPoolSize = Integer.parseInt(value);
            }
            if ((value = (String)properties.get("MaxPoolSize")) != null) {
                maxPoolSize = Integer.parseInt(value);
            }
            if ((value = (String)properties.get("PoolSizeStep")) != null) {
                poolSizeStep = Integer.parseInt(value);
            }
            if ((value = (String)properties.get("PoolPeriod")) != null) {
                poolPeriod = Long.parseLong(value);
            }
            if (poolPeriod > 0L && poolPeriod < 1000L) {
                poolPeriod = 1000L;
            }
            if ((value = (String)properties.get("EnableWait")) != null) {
                enableWait = Boolean.parseBoolean(value);
            }
            if ((value = (String)properties.get("WaitTime")) != null) {
                waitTime = Long.parseLong(value);
            }
            if ((value = (String)properties.get("MaxUseCount")) != null) {
                maxUseCount = Integer.parseInt(value);
            }
            if ((value = (String)properties.get("CheckQuery")) != null && this.poolInfo.isDefaultConnectionCheckerUsed()) {
                needConnectionValidation = !value.equals("");
                checkQuery = value;
            }
            if ((value = (String)properties.get("InitSql")) != null) {
                initSql = value;
            }
            if ((value = (String)properties.get("CheckQueryPeriod")) != null) {
                checkQueryPeriod = Long.parseLong(value);
            }
            DBDSBindInfo.validateNumerics(this.poolInfo.getDataSourceId(), minPoolSize, maxPoolSize, poolSizeStep, enableWait, waitTime, poolPeriod, maxUseCount, checkQueryPeriod);
            value = (String)properties.get("CheckQueryTimeout");
            if (value != null) {
                checkQueryTimeout = Long.parseLong(value);
            }
            if ((value = (String)properties.get("NonValidationInterval")) != null) {
                nonValidationInterval = Long.parseLong(value);
            }
            if ((value = (String)properties.get("CheckQueryRetrialCount")) != null) {
                checkQueryRetrialCount = Integer.parseInt(value);
            }
            if ((value = (String)properties.get("DestroyPolicyOnCheckQuery")) != null) {
                destroyPolicyOnCheckQuery = DBDSBindInfoJB.convertDestroyPolicyToInt(value);
            }
            if ((value = (String)properties.get("StatementCachingSize")) != null) {
                statementCacheSize = Integer.parseInt(value);
            }
            if ((value = (String)properties.get("StatementFetchSize")) != null) {
                statementFetchSize = Integer.parseInt(value);
            }
            if ((value = (String)properties.get("EnableConnectionTrace")) != null) {
                enableConnectionTrace = Boolean.parseBoolean(value);
            }
            if ((value = (String)properties.get("UseSqlTrace")) != null) {
                useSqlTrace = Boolean.parseBoolean(value);
            }
            if ((value = (String)properties.get("UseSetAutoCommitTrace")) != null) {
                useSetAutoCommitTrace = Boolean.parseBoolean(value);
            }
            if ((value = (String)properties.get("KeepConnectionHandleOpen")) != null) {
                keepConnectionHandleOpen = Boolean.parseBoolean(value);
            }
            if ((value = (String)properties.get("DelegationDataSource")) != null && !value.equals("") && !value.equals(this.poolInfo.getNonTxDelegatedDataSourceName())) {
                if (this.poolInfo.getPoolType() == 3 || this.poolInfo.getPoolType() == 2) {
                    nonTxDelegatedDataSourceName = value;
                    nonTxDelegatedDataSource = (DataSource)new InitialContext().lookup(value);
                } else {
                    logger.log(JeusMessage_JDBC._372_LEVEL, JeusMessage_JDBC._372, (Object)this.poolInfo.getDataSourceId());
                }
            }
            if (poolPeriod > 0L && poolPeriod != this.poolInfo.getPoolPeriod()) {
                this.poolPeriodTask.cancel();
                systemScheduler.scheduleWithFixedDelay(this.poolPeriodTask, poolPeriod, poolPeriod);
                needToRollbackPoolPeriodTaskOnError = true;
            } else if (poolPeriod == 0L) {
                this.poolPeriodTask.cancel();
                needToRollbackPoolPeriodTaskOnError = true;
            }
            if (!needConnectionValidation || checkQueryPeriod == 0L) {
                this.connectionPool.cancelPeriodicConnectionChecker();
                needToRollbackCheckQueryPeriodTaskOnError = true;
            } else if (checkQueryPeriod != this.poolInfo.getCheckQueryPeriod()) {
                this.connectionPool.cancelPeriodicConnectionChecker();
                this.connectionPool.startPeriodicChecker(checkQueryPeriod);
                needToRollbackCheckQueryPeriodTaskOnError = true;
            }
        }
        catch (Throwable th) {
            if (needToRollbackPoolPeriodTaskOnError) {
                this.poolPeriodTask.cancel();
                if (this.poolInfo.getPoolPeriod() > 0L) {
                    systemScheduler.scheduleWithFixedDelay(this.poolPeriodTask, this.poolInfo.getPoolPeriod(), this.poolInfo.getPoolPeriod());
                }
            }
            if (needToRollbackCheckQueryPeriodTaskOnError) {
                this.connectionPool.cancelPeriodicConnectionChecker();
                if (this.poolInfo.needConnectionValidation() && this.poolInfo.getCheckQueryPeriod() > 0L) {
                    this.connectionPool.startPeriodicChecker(this.poolInfo.getCheckQueryPeriod());
                }
            }
            if (th instanceof ConnectionPoolException) {
                throw (ConnectionPoolException)th;
            }
            throw new ConnectionPoolException(JeusMessageBundles.getMessage(JeusMessage_JDBC._207, this.poolInfo.getDataSourceId()), th);
        }
        JDBCConnectionQueue jDBCConnectionQueue = this;
        synchronized (jDBCConnectionQueue) {
            this.poolInfo.setIsAutoCommitUsed(isAutoCommitUsed);
            this.poolInfo.setAutoCommitValue(autoCommit);
            this.poolInfo.setActionOnConnectionLeak(actionOnConnectionLeak);
            this.poolInfo.setStatementQueryTimeout(statementQueryTimeout);
            this.poolInfo.setMinPoolSize(minPoolSize);
            this.poolInfo.setMaxPoolSize(maxPoolSize);
            this.stats.setMinPoolSizeStat(minPoolSize);
            this.stats.setMaxPoolSizeStat(maxPoolSize);
            this.poolInfo.setIncreaseStep(poolSizeStep);
            this.poolInfo.setPoolPeriod(poolPeriod);
            this.poolInfo.setWaiting(enableWait);
            this.poolInfo.setWaitTime(waitTime);
            this.poolInfo.setNeedConnectionValidation(needConnectionValidation);
            this.poolInfo.setCheckQuery(checkQuery);
            this.poolInfo.setCheckQueryTimeout(checkQueryTimeout);
            this.poolInfo.setCheckQueryPeriod(checkQueryPeriod);
            this.poolInfo.setCheckQueryRetrialCount(checkQueryRetrialCount);
            this.poolInfo.setNonValidationInterval(nonValidationInterval);
            this.poolInfo.setDestoryPolicyOnCheckQuery(destroyPolicyOnCheckQuery);
            this.poolInfo.setInitSql(initSql);
            this.poolInfo.setStatementFetchSize(statementFetchSize);
            this.poolInfo.setStatementCacheSize(statementCacheSize);
            this.poolInfo.setMaxUseCount(maxUseCount);
            this.poolInfo.setConnectionTraceEnabled(enableConnectionTrace);
            this.poolInfo.setUseSQLTrace(useSqlTrace);
            this.poolInfo.setUseSetAutoCommitTrace(useSetAutoCommitTrace);
            this.poolInfo.setUseStatementWrapper(useSqlTrace);
            this.poolInfo.setKeepConnectionHandleOpen(keepConnectionHandleOpen);
            if (nonTxDelegatedDataSource == null) {
                this.poolInfo.setNonTxDelegatedDataSourceRequired(false);
            } else {
                this.poolInfo.setNonTxDelegatedDataSourceRequired(true);
            }
            this.poolInfo.setNonTxDelegatedDataSourceName(nonTxDelegatedDataSourceName);
            this.connectionPool.setNonTxDelegatedDataSource(nonTxDelegatedDataSource);
        }
        logger.log(JeusMessage_JDBC._373_LEVEL, JeusMessage_JDBC._373, (Object)this.poolInfo.getDataSourceId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshQueue() throws SQLException {
        JDBCConnectionQueue jDBCConnectionQueue = this;
        synchronized (jDBCConnectionQueue) {
            this.clearQueue();
            ++this.generation;
            for (int i = 0; i < this.poolInfo.getMinPoolSize(); ++i) {
                this.putConnection(this.createPooledConnection(null, null, false));
            }
        }
        if (this.poolResizer != null) {
            this.poolResizer.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        if (this.poolResizer != null) {
            this.poolResizer.destroy();
        }
        if (this.poolPeriodTask != null) {
            this.poolPeriodTask.cancel();
        }
        JDBCConnectionQueue jDBCConnectionQueue = this;
        synchronized (jDBCConnectionQueue) {
            this.clearQueue();
            this.destroyed = true;
            this.notifyAll();
        }
    }

    public synchronized void setCPInfo(CPInfo cpInfo) {
        this.stats.setCPInfo(cpInfo);
    }

    private JeusPooledConnection createPooledConnection(String username, String password, boolean disposable) throws SQLException {
        Object dataSrc = this.poolInfo.getDataSource();
        int type = this.poolInfo.getPoolType();
        PooledConnection pooledConn = type == 1 || type == 3 ? (username == null ? ((ConnectionPoolDataSource)dataSrc).getPooledConnection() : ((ConnectionPoolDataSource)dataSrc).getPooledConnection(username, password)) : (username == null ? ((XADataSource)dataSrc).getXAConnection() : ((XADataSource)dataSrc).getXAConnection(username, password));
        this.stats.incCreateCount();
        long createCount = ((CountStatisticImpl)this.stats.getCreatCountStat()).getCount();
        logger.log(JeusMessage_JDBC._310_LEVEL, JeusMessage_JDBC._310, (Object)pooledConn);
        AbstractJeusPooledConnection pcon = this.poolInfo.getStmtCachingSize() > 0 ? new JeusCachePooledConnection(pooledConn, this.idPrefix + createCount, this.stats, this.connectionPool, disposable) : new JeusNonCachePooledConnection(pooledConn, this.idPrefix + createCount, this.stats, this.connectionPool, disposable);
        String initsql = this.poolInfo.getInitSql();
        if (initsql != null && !initsql.equals("")) {
            this.executeInitSql(pcon, initsql);
        }
        return pcon;
    }

    private void executeInitSql(JeusPooledConnection pcon, String initsql) throws SQLException {
        Throwable throwable;
        block16: {
            throwable = null;
            Connection connectionHandle = null;
            Statement ps = null;
            ResultSet rs = null;
            boolean autoCommit = false;
            try {
                connectionHandle = pcon.getActualHandle();
                autoCommit = connectionHandle.getAutoCommit();
                connectionHandle.setAutoCommit(true);
                ps = connectionHandle.prepareStatement(initsql);
                boolean isResultSet = ps.execute();
                if (isResultSet) {
                    rs = ps.getResultSet();
                }
                logger.log(JeusMessage_JDBC._379_LEVEL, JeusMessage_JDBC._379, (Object)pcon);
            }
            catch (Throwable th) {
                throwable = th;
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (connectionHandle != null) {
                try {
                    connectionHandle.setAutoCommit(autoCommit);
                    if (throwable != null || !this.poolInfo.isKeepConnectionHandleOpen()) {
                        pcon.closeActualHandleDirectly();
                    }
                }
                catch (Throwable t) {
                    if (throwable != null) break block16;
                    throwable = t;
                }
            }
        }
        if (throwable != null) {
            try {
                pcon.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw new JeusSQLException(JeusMessageBundles.getMessage(JeusMessage_JDBC._380), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeAllConnections(int currentGeneration) {
        JeusPooledConnection pcon;
        ArrayList<JeusPooledConnection> toBeClosed;
        JDBCConnectionQueue jDBCConnectionQueue = this;
        synchronized (jDBCConnectionQueue) {
            if (currentGeneration < this.generation) {
                return;
            }
            ++this.generation;
            if (this.queue.isEmpty()) {
                return;
            }
            toBeClosed = new ArrayList<JeusPooledConnection>(this.queue.size());
            while (!this.queue.isEmpty()) {
                pcon = this.removeConnectionFromNonemptyQueue();
                toBeClosed.add(pcon);
            }
        }
        Iterator it = toBeClosed.iterator();
        while (it.hasNext()) {
            pcon = (JeusPooledConnection)it.next();
            this.destroyConnection(pcon);
            it.remove();
        }
    }

    public synchronized JeusPooledConnection getPooledConnectionDirectly() {
        if (this.queue.isEmpty()) {
            return null;
        }
        return this.removeConnectionFromNonemptyQueue();
    }

    private class PoolPeriodTask
    extends ScheduleTask {
        private PoolPeriodTask() {
        }

        public void run() {
            block2: {
                try {
                    JDBCConnectionQueue.this.resizePool(false);
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(JeusMessage_JDBC._334_LEVEL)) break block2;
                    logger.log(JeusMessage_JDBC._334_LEVEL, JeusMessage_JDBC._334, JDBCConnectionQueue.this.poolInfo.getDataSourceId(), t);
                }
            }
        }
    }
}

