/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.stmt;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import jeus.jdbc.common.JeusConnectionImpl;
import jeus.jdbc.stmt.StatementWrapper;

public class PreparedStatementWrapper
extends StatementWrapper
implements PreparedStatement {
    private PreparedStatement actualStmt;
    private String sql;
    private ArrayList<String> params;

    public PreparedStatementWrapper(JeusConnectionImpl jeusConn, PreparedStatement actualStmt, String sql, boolean useSQLTrace) {
        super(jeusConn, actualStmt, useSQLTrace);
        this.actualStmt = actualStmt;
        this.sql = sql;
        if (useSQLTrace) {
            this.params = new ArrayList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        boolean result;
        this.checkStatus(true);
        long startingTime = 0L;
        String fullQuery = null;
        if (this.shouldUseSQLTrace()) {
            startingTime = System.currentTimeMillis();
            fullQuery = this.getFullQuery();
            this.traceSQLStatement(fullQuery, startingTime);
        }
        try {
            result = this.actualStmt.execute();
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (this.shouldUseSQLTrace()) {
                this.traceSQLStatement(null, 0L);
                this.logSQLStatement(fullQuery, System.currentTimeMillis() - startingTime);
            }
            throw throwable;
        }
        if (this.shouldUseSQLTrace()) {
            this.traceSQLStatement(null, 0L);
            this.logSQLStatement(fullQuery, System.currentTimeMillis() - startingTime);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery() throws SQLException {
        ResultSet result;
        this.checkStatus(true);
        long startingTime = 0L;
        String fullQuery = null;
        if (this.shouldUseSQLTrace()) {
            startingTime = System.currentTimeMillis();
            fullQuery = this.getFullQuery();
            this.traceSQLStatement(fullQuery, startingTime);
        }
        try {
            result = this.actualStmt.executeQuery();
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (this.shouldUseSQLTrace()) {
                this.traceSQLStatement(null, 0L);
                this.logSQLStatement(fullQuery, System.currentTimeMillis() - startingTime);
            }
            throw throwable;
        }
        if (this.shouldUseSQLTrace()) {
            this.traceSQLStatement(null, 0L);
            this.logSQLStatement(fullQuery, System.currentTimeMillis() - startingTime);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException {
        int result;
        this.checkStatus(true);
        long startingTime = 0L;
        String fullQuery = null;
        if (this.shouldUseSQLTrace()) {
            startingTime = System.currentTimeMillis();
            fullQuery = this.getFullQuery();
            this.traceSQLStatement(fullQuery, startingTime);
        }
        try {
            result = this.actualStmt.executeUpdate();
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (this.shouldUseSQLTrace()) {
                this.traceSQLStatement(null, 0L);
                this.logSQLStatement(fullQuery, System.currentTimeMillis() - startingTime);
            }
            throw throwable;
        }
        if (this.shouldUseSQLTrace()) {
            this.traceSQLStatement(null, 0L);
            this.logSQLStatement(fullQuery, System.currentTimeMillis() - startingTime);
        }
        return result;
    }

    public void addBatch() throws SQLException {
        this.checkStatus(true);
        this.actualStmt.addBatch();
    }

    private String getFullQuery() {
        StringBuffer buff = new StringBuffer(this.sql);
        if (this.params.size() > 1) {
            buff.append(" | parameters: ");
            buff.append(this.params.get(1));
            for (int i = 2; i < this.params.size(); ++i) {
                buff.append(", ").append(this.params.get(i));
            }
        }
        return buff.toString();
    }

    private void traceParameter(int index, Object parameter) {
        if (this.params != null && index >= 0) {
            String strValue = parameter instanceof String || parameter instanceof Date ? "'" + parameter + "'" : (parameter == null ? "null" : parameter.toString());
            while (index >= this.params.size()) {
                this.params.add(null);
            }
            this.params.set(index, strValue);
        }
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setBoolean(parameterIndex, x);
        this.traceParameter(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setByte(parameterIndex, x);
        this.traceParameter(parameterIndex, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setShort(parameterIndex, x);
        this.traceParameter(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setInt(parameterIndex, x);
        this.traceParameter(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setLong(parameterIndex, x);
        this.traceParameter(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setFloat(parameterIndex, x);
        this.traceParameter(parameterIndex, Float.valueOf(x));
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setDouble(parameterIndex, x);
        this.traceParameter(parameterIndex, x);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setURL(parameterIndex, x);
        this.traceParameter(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setTime(parameterIndex, x);
        this.traceParameter(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x, Calendar arg2) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setTime(parameterIndex, x, arg2);
        this.traceParameter(parameterIndex, x);
    }

    public void setNull(int parameterIndex, int x) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setNull(parameterIndex, x);
        this.traceParameter(parameterIndex, null);
    }

    public void setNull(int parameterIndex, int x, String arg2) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setNull(parameterIndex, x, arg2);
        this.traceParameter(parameterIndex, null);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setBigDecimal(parameterIndex, x);
        this.traceParameter(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setString(parameterIndex, x);
        this.traceParameter(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setBytes(parameterIndex, x);
        this.traceParameter(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setDate(parameterIndex, x);
        this.traceParameter(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x, Calendar arg2) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setDate(parameterIndex, x, arg2);
        this.traceParameter(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar arg2) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setTimestamp(parameterIndex, x, arg2);
        this.traceParameter(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setTimestamp(parameterIndex, x);
        this.traceParameter(parameterIndex, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setAsciiStream(parameterIndex, x, length);
        this.traceParameter(parameterIndex, x);
    }

    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setUnicodeStream(parameterIndex, x, length);
        this.traceParameter(parameterIndex, x);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setBinaryStream(parameterIndex, x, length);
        this.traceParameter(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x, int arg2, int arg3) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setObject(parameterIndex, x, arg2, arg3);
        this.traceParameter(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x, int arg2) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setObject(parameterIndex, x, arg2);
        this.traceParameter(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setObject(parameterIndex, x);
        this.traceParameter(parameterIndex, x);
    }

    public void setCharacterStream(int parameterIndex, Reader x, int arg2) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setCharacterStream(parameterIndex, x, arg2);
        this.traceParameter(parameterIndex, x);
    }

    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setRef(parameterIndex, x);
        this.traceParameter(parameterIndex, x);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setBlob(i, x);
        this.traceParameter(i, x);
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setClob(i, x);
        this.traceParameter(i, x);
    }

    public void setArray(int i, Array x) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setArray(i, x);
        this.traceParameter(i, x);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkStatus(true);
        return this.actualStmt.getMetaData();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkStatus(true);
        return this.actualStmt.getParameterMetaData();
    }

    public void clearParameters() throws SQLException {
        this.checkStatus(true);
        this.actualStmt.clearParameters();
        if (this.params != null) {
            this.params.clear();
        }
    }
}

