/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.stmt;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import jeus.jdbc.common.JeusConnectionImpl;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;
import jeus.util.properties.JeusManagerProperties;

public class StatementWrapper
implements Statement {
    static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.jdbc.sql");
    private Statement actualStmt;
    JeusConnectionImpl jeusConn;
    private boolean cacheEnabled;
    private boolean isClosed;
    private boolean useSQLTrace;

    public StatementWrapper(JeusConnectionImpl jeusConn, Statement actualStmt, boolean useSQLTrace) {
        this.setJeusConnection(jeusConn);
        this.actualStmt = actualStmt;
        this.useSQLTrace = useSQLTrace;
    }

    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.setIsClosed(true);
        if (!this.cacheEnabled) {
            this.closeActually();
        }
    }

    public void closeActually() throws SQLException {
        this.actualStmt.close();
    }

    protected void checkStatus(boolean checkTxStatus) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("This statement has been already closed.");
        }
        if (this.jeusConn.isClosed()) {
            throw new SQLException("Connection associated with this statement has been already closed.");
        }
        if (checkTxStatus) {
            this.jeusConn.checkAssociatedTxStatus();
        }
        if (JeusManagerProperties.CHECK_INTERRUPTED_STATUS && Thread.interrupted()) {
            throw new SQLException("the current thread is interrupted");
        }
    }

    void logSQLStatement(String sql, long elapsedTime) {
        if (logger.isLoggable(JeusMessage_JDBC._360_LEVEL)) {
            logger.log(JeusMessage_JDBC._360_LEVEL, JeusMessage_JDBC._360, new Object[]{sql, elapsedTime, this.jeusConn.getConnectionId()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean result;
        this.checkStatus(true);
        long startingTime = 0L;
        if (this.shouldUseSQLTrace()) {
            startingTime = System.currentTimeMillis();
            this.traceSQLStatement(sql, startingTime);
        }
        try {
            result = this.actualStmt.execute(sql, autoGeneratedKeys);
            Object var7_5 = null;
            if (this.shouldUseSQLTrace()) {
                this.traceSQLStatement(null, 0L);
                this.logSQLStatement(sql, System.currentTimeMillis() - startingTime);
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (this.shouldUseSQLTrace()) {
                this.traceSQLStatement(null, 0L);
                this.logSQLStatement(sql, System.currentTimeMillis() - startingTime);
            }
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean result;
        this.checkStatus(true);
        long startingTime = 0L;
        if (this.shouldUseSQLTrace()) {
            startingTime = System.currentTimeMillis();
            this.traceSQLStatement(sql, startingTime);
        }
        try {
            result = this.actualStmt.execute(sql, columnIndexes);
            Object var7_5 = null;
            if (this.shouldUseSQLTrace()) {
                this.traceSQLStatement(null, 0L);
                this.logSQLStatement(sql, System.currentTimeMillis() - startingTime);
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (this.shouldUseSQLTrace()) {
                this.traceSQLStatement(null, 0L);
                this.logSQLStatement(sql, System.currentTimeMillis() - startingTime);
            }
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean result;
        this.checkStatus(true);
        long startingTime = 0L;
        if (this.shouldUseSQLTrace()) {
            startingTime = System.currentTimeMillis();
            this.traceSQLStatement(sql, startingTime);
        }
        try {
            result = this.actualStmt.execute(sql, columnNames);
            Object var7_5 = null;
            if (this.shouldUseSQLTrace()) {
                this.traceSQLStatement(null, 0L);
                this.logSQLStatement(sql, System.currentTimeMillis() - startingTime);
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (this.shouldUseSQLTrace()) {
                this.traceSQLStatement(null, 0L);
                this.logSQLStatement(sql, System.currentTimeMillis() - startingTime);
            }
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql) throws SQLException {
        boolean result;
        this.checkStatus(true);
        long startingTime = 0L;
        if (this.shouldUseSQLTrace()) {
            startingTime = System.currentTimeMillis();
            this.traceSQLStatement(sql, startingTime);
        }
        try {
            result = this.actualStmt.execute(sql);
            Object var6_4 = null;
            if (this.shouldUseSQLTrace()) {
                this.traceSQLStatement(null, 0L);
                this.logSQLStatement(sql, System.currentTimeMillis() - startingTime);
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (this.shouldUseSQLTrace()) {
                this.traceSQLStatement(null, 0L);
                this.logSQLStatement(sql, System.currentTimeMillis() - startingTime);
            }
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSet result;
        this.checkStatus(true);
        long startingTime = 0L;
        if (this.shouldUseSQLTrace()) {
            startingTime = System.currentTimeMillis();
            this.traceSQLStatement(sql, startingTime);
        }
        try {
            result = this.actualStmt.executeQuery(sql);
            Object var6_4 = null;
            if (this.shouldUseSQLTrace()) {
                this.traceSQLStatement(null, 0L);
                this.logSQLStatement(sql, System.currentTimeMillis() - startingTime);
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (this.shouldUseSQLTrace()) {
                this.traceSQLStatement(null, 0L);
                this.logSQLStatement(sql, System.currentTimeMillis() - startingTime);
            }
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql) throws SQLException {
        int result;
        this.checkStatus(true);
        long startingTime = 0L;
        if (this.shouldUseSQLTrace()) {
            startingTime = System.currentTimeMillis();
            this.traceSQLStatement(sql, startingTime);
        }
        try {
            result = this.actualStmt.executeUpdate(sql);
            Object var6_4 = null;
            if (this.shouldUseSQLTrace()) {
                this.traceSQLStatement(null, 0L);
                this.logSQLStatement(sql, System.currentTimeMillis() - startingTime);
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (this.shouldUseSQLTrace()) {
                this.traceSQLStatement(null, 0L);
                this.logSQLStatement(sql, System.currentTimeMillis() - startingTime);
            }
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        int result;
        this.checkStatus(true);
        long startingTime = 0L;
        if (this.shouldUseSQLTrace()) {
            startingTime = System.currentTimeMillis();
            this.traceSQLStatement(sql, startingTime);
        }
        try {
            result = this.actualStmt.executeUpdate(sql, columnNames);
            Object var7_5 = null;
            if (this.shouldUseSQLTrace()) {
                this.traceSQLStatement(null, 0L);
                this.logSQLStatement(sql, System.currentTimeMillis() - startingTime);
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (this.shouldUseSQLTrace()) {
                this.traceSQLStatement(null, 0L);
                this.logSQLStatement(sql, System.currentTimeMillis() - startingTime);
            }
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        int result;
        this.checkStatus(true);
        long startingTime = 0L;
        if (this.shouldUseSQLTrace()) {
            startingTime = System.currentTimeMillis();
            this.traceSQLStatement(sql, startingTime);
        }
        try {
            result = this.actualStmt.executeUpdate(sql, autoGeneratedKeys);
            Object var7_5 = null;
            if (this.shouldUseSQLTrace()) {
                this.traceSQLStatement(null, 0L);
                this.logSQLStatement(sql, System.currentTimeMillis() - startingTime);
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (this.shouldUseSQLTrace()) {
                this.traceSQLStatement(null, 0L);
                this.logSQLStatement(sql, System.currentTimeMillis() - startingTime);
            }
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        int result;
        this.checkStatus(true);
        long startingTime = 0L;
        if (this.shouldUseSQLTrace()) {
            startingTime = System.currentTimeMillis();
            this.traceSQLStatement(sql, startingTime);
        }
        try {
            result = this.actualStmt.executeUpdate(sql, columnIndexes);
            Object var7_5 = null;
            if (this.shouldUseSQLTrace()) {
                this.traceSQLStatement(null, 0L);
                this.logSQLStatement(sql, System.currentTimeMillis() - startingTime);
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (this.shouldUseSQLTrace()) {
                this.traceSQLStatement(null, 0L);
                this.logSQLStatement(sql, System.currentTimeMillis() - startingTime);
            }
            throw throwable;
        }
        return result;
    }

    public int getMaxFieldSize() throws SQLException {
        this.checkStatus(true);
        return this.actualStmt.getMaxFieldSize();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setMaxFieldSize(max);
    }

    public int getMaxRows() throws SQLException {
        this.checkStatus(true);
        return this.actualStmt.getMaxRows();
    }

    public void setMaxRows(int max) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setMaxRows(max);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setEscapeProcessing(enable);
    }

    public int getQueryTimeout() throws SQLException {
        this.checkStatus(true);
        return this.actualStmt.getQueryTimeout();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setQueryTimeout(seconds);
    }

    public void cancel() throws SQLException {
        this.checkStatus(true);
        this.actualStmt.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkStatus(true);
        return this.actualStmt.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.checkStatus(true);
        this.actualStmt.clearWarnings();
    }

    public void setCursorName(String arg0) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setCursorName(arg0);
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkStatus(true);
        return this.actualStmt.getResultSet();
    }

    public int getUpdateCount() throws SQLException {
        this.checkStatus(true);
        return this.actualStmt.getUpdateCount();
    }

    public boolean getMoreResults(int arg0) throws SQLException {
        this.checkStatus(true);
        return this.actualStmt.getMoreResults(arg0);
    }

    public boolean getMoreResults() throws SQLException {
        this.checkStatus(true);
        return this.actualStmt.getMoreResults();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        this.checkStatus(true);
        return this.actualStmt.getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        this.checkStatus(true);
        return this.actualStmt.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        this.checkStatus(true);
        return this.actualStmt.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        this.checkStatus(true);
        return this.actualStmt.getResultSetType();
    }

    public void addBatch(String sql) throws SQLException {
        this.checkStatus(true);
        this.actualStmt.addBatch(sql);
    }

    public void clearBatch() throws SQLException {
        this.checkStatus(true);
        this.actualStmt.clearBatch();
    }

    public int[] executeBatch() throws SQLException {
        this.checkStatus(true);
        return this.actualStmt.executeBatch();
    }

    public Connection getConnection() throws SQLException {
        return this.jeusConn;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkStatus(true);
        return this.actualStmt.getGeneratedKeys();
    }

    public int getResultSetHoldability() throws SQLException {
        this.checkStatus(true);
        return this.actualStmt.getResultSetHoldability();
    }

    public Statement getActualStatement() {
        return this.actualStmt;
    }

    void traceSQLStatement(String sql, long startingTime) {
        this.jeusConn.setSQLStatement(sql, startingTime);
    }

    public void setJeusConnection(JeusConnectionImpl jeusConn) {
        this.jeusConn = jeusConn;
    }

    public void setIsClosed(boolean closed) {
        this.isClosed = closed;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    protected boolean shouldUseSQLTrace() {
        return this.useSQLTrace;
    }
}

