/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.util;

import jeus.jdbc.util.RepositoryEvent;

public abstract class Cache {
    private int maxSize;
    private RepositoryEvent re;

    public Cache(int maxSize, RepositoryEvent re) {
        this.maxSize = maxSize;
        this.re = re;
    }

    public final void addObject(Object userKey) {
        this.remove(userKey);
        this.shrinkToSize(this.getMaxSize() - 1);
        this.createNode(userKey);
    }

    public final void getObject(Object key) {
        this.refreshNode(key);
    }

    public final synchronized void remove(Object key) {
        this.delete(key);
    }

    protected final int getMaxSize() {
        return this.maxSize;
    }

    private synchronized int shrinkToSize(int desiredSize) {
        int deleted = 0;
        if (desiredSize >= 0) {
            while (this.size() > desiredSize) {
                this.re.removeFromRepository(this.removeLeastValuableNode());
                ++deleted;
            }
        }
        return deleted;
    }

    public synchronized void clear() {
        this.shrinkToSize(0);
    }

    public abstract void refreshNode(Object var1);

    public abstract int size();

    public abstract void delete(Object var1);

    public abstract Object removeLeastValuableNode();

    public abstract Object createNode(Object var1);
}

