/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.xa;

import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import jeus.jdbc.common.JeusPooledConnection;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.transaction.JeusXAException;
import jeus.transaction.resources.LocalXAResourceWrapper;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessageBundles;
import jeus.util.message.JeusMessage_JDBC;

public final class JDBCLocalXAResourceWrapper
extends LocalXAResourceWrapper {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.jdbc");
    private final ConnectionPoolImpl connectionPool;
    private final JeusPooledConnection jeusPooledConn;

    public JDBCLocalXAResourceWrapper(JeusPooledConnection jeusPooledConn, ConnectionPoolImpl connectionpool) {
        this.jeusPooledConn = jeusPooledConn;
        this.connectionPool = connectionpool;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (!onePhase) {
            logger.log(JeusMessage_JDBC._23_LEVEL, JeusMessage_JDBC._23, new Object[]{this.jeusPooledConn.getConnectionId(), xid});
            throw new JeusXAException(JeusMessageBundles.getMessage(JeusMessage_JDBC._23, this.jeusPooledConn.getConnectionId(), xid));
        }
        try {
            this.jeusPooledConn.commitConnectionHandle();
        }
        catch (Throwable t) {
            logger.log(JeusMessage_JDBC._24_LEVEL, JeusMessage_JDBC._24, new Object[]{this.jeusPooledConn.getConnectionId(), xid}, t);
            throw new JeusXAException(JeusMessageBundles.getMessage(JeusMessage_JDBC._24, this.jeusPooledConn.getConnectionId(), xid), t);
        }
    }

    public void rollback(Xid xid) throws XAException {
        try {
            this.jeusPooledConn.rollbackConnectionHandle();
        }
        catch (Throwable t) {
            logger.log(JeusMessage_JDBC._32_LEVEL, JeusMessage_JDBC._32, new Object[]{this.jeusPooledConn.getConnectionId(), xid}, t);
            throw new JeusXAException(JeusMessageBundles.getMessage(JeusMessage_JDBC._32, this.jeusPooledConn.getConnectionId(), xid), t);
        }
    }

    public void enforceEnd() {
    }

    public String getName() {
        if (this.connectionPool != null) {
            return this.connectionPool.getDataSourceId();
        }
        return null;
    }

    public JeusPooledConnection getJeusPooledConnection() {
        return this.jeusPooledConn;
    }

    public ConnectionPoolImpl getConnectionPool() {
        return this.connectionPool;
    }
}

