/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.xa;

import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.jdbc.common.JeusPooledConnection;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.transaction.JeusXAException;
import jeus.transaction.resources.XAResourceWrapper;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessageBundles;
import jeus.util.message.JeusMessage_JDBC;
import jeus.util.properties.JeusJDBCProperties;

public class JDBCXAResourceWrapper
extends XAResourceWrapper {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.jdbc");
    private JeusPooledConnection pcon;
    private ConnectionPoolImpl pool;
    private JeusPooledConnection xaControlConnection;
    private boolean useControlConnection;
    private boolean useFastRollback;
    private boolean useDisposableOnly;

    public JDBCXAResourceWrapper(XAResource resource, JeusPooledConnection pcon, ConnectionPoolImpl pool) {
        super(resource);
        this.pcon = pcon;
        this.pool = pool;
    }

    public void enforceEnd() throws XAException {
        try {
            if (this.inTx) {
                this.end(this.xid, 0x4000000);
            } else {
                this.useControlConnection = true;
            }
        }
        catch (Throwable th) {
            if (!JeusJDBCProperties.IGNORE_XA_END_ERROR) {
                if (th instanceof XAException) {
                    this.useFastRollback = true;
                    this.useDisposableOnly = true;
                    this.pcon.setShouldForciblyClosed(true);
                }
                if (th instanceof XAException) {
                    throw (XAException)th;
                }
                throw new JeusXAException(JeusMessageBundles.getMessage(JeusMessage_JDBC._102, this.pcon.getConnectionId(), this.xid), th);
            }
            logger.log(JeusMessage_JDBC._102_LEVEL, JeusMessage_JDBC._102, new Object[]{this.pcon.getConnectionId(), this.xid}, th);
        }
    }

    public int prepare(Xid xid) throws XAException {
        int result = -100;
        JeusPooledConnection usedConnection = this.pcon;
        try {
            if (this.useControlConnection) {
                this.xaControlConnection = this.pool.getXAControlConnection(this.useDisposableOnly);
                this.resource = this.xaControlConnection.getXAResource();
                usedConnection = this.xaControlConnection;
            }
            int n = result = this.resource.prepare(xid);
            Object var6_6 = null;
            if (result == 3 && this.useControlConnection && this.xaControlConnection != null) {
                this.useControlConnection = false;
                this.pool.closeControlConnection(this.xaControlConnection);
            }
            return n;
        }
        catch (Throwable th) {
            try {
                logger.log(JeusMessage_JDBC._37_LEVEL, JeusMessage_JDBC._37, new Object[]{usedConnection.getConnectionId(), xid}, th);
                if (th instanceof XAException) {
                    throw (XAException)th;
                }
                throw new JeusXAException(JeusMessageBundles.getMessage(JeusMessage_JDBC._37, usedConnection.getConnectionId(), xid), th);
            }
            catch (Throwable throwable) {
                block7: {
                    Object var6_7 = null;
                    if (result != 3 || !this.useControlConnection || this.xaControlConnection == null) break block7;
                    this.useControlConnection = false;
                    this.pool.closeControlConnection(this.xaControlConnection);
                }
                throw throwable;
            }
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        JeusPooledConnection usedConnection = this.pcon;
        try {
            try {
                if (onePhase && this.useControlConnection) {
                    this.xaControlConnection = this.pool.getXAControlConnection(this.useDisposableOnly);
                    this.resource = this.xaControlConnection.getXAResource();
                    usedConnection = this.xaControlConnection;
                }
                this.resource.commit(xid, onePhase);
            }
            catch (Throwable th) {
                logger.log(JeusMessage_JDBC._24_LEVEL, JeusMessage_JDBC._24, new Object[]{usedConnection.getConnectionId(), xid}, th);
                if (th instanceof XAException) {
                    throw (XAException)th;
                }
                throw new JeusXAException(JeusMessageBundles.getMessage(JeusMessage_JDBC._24, usedConnection.getConnectionId(), xid), th);
            }
            Object var6_4 = null;
            if (this.useControlConnection && this.xaControlConnection != null) {
                this.useControlConnection = false;
                this.pool.closeControlConnection(this.xaControlConnection);
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (this.useControlConnection && this.xaControlConnection != null) {
                this.useControlConnection = false;
                this.pool.closeControlConnection(this.xaControlConnection);
            }
            throw throwable;
        }
    }

    public void rollback(Xid xid) throws XAException {
        JeusPooledConnection usedConnection = this.pcon;
        try {
            block8: {
                try {
                    if ((this.useControlConnection || this.useFastRollback) && this.xaControlConnection == null) {
                        this.xaControlConnection = this.pool.getXAControlConnection(this.useDisposableOnly);
                        this.resource = this.xaControlConnection.getXAResource();
                        usedConnection = this.xaControlConnection;
                    }
                    this.resource.rollback(xid);
                    if (!this.useControlConnection && !this.useFastRollback || this.xaControlConnection == null) break block8;
                    logger.log(JeusMessage_JDBC._103_LEVEL, JeusMessage_JDBC._103, new Object[]{this.xaControlConnection.getConnectionId(), this.pcon.getConnectionId(), xid});
                }
                catch (Throwable th) {
                    logger.log(JeusMessage_JDBC._32_LEVEL, JeusMessage_JDBC._32, new Object[]{usedConnection.getConnectionId(), xid}, th);
                    if (th instanceof XAException) {
                        throw (XAException)th;
                    }
                    throw new JeusXAException(JeusMessageBundles.getMessage(JeusMessage_JDBC._32, usedConnection.getConnectionId(), xid), th);
                }
            }
            Object var5_3 = null;
            if ((this.useControlConnection || this.useFastRollback) && this.xaControlConnection != null) {
                this.useControlConnection = false;
                this.pool.closeControlConnection(this.xaControlConnection);
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if ((this.useControlConnection || this.useFastRollback) && this.xaControlConnection != null) {
                this.useControlConnection = false;
                this.pool.closeControlConnection(this.xaControlConnection);
            }
            throw throwable;
        }
    }

    public XAConnection getXAConnection() {
        return this.xaControlConnection;
    }

    public String getPoolUserName() {
        return this.pool.getUserName();
    }

    public String getName() {
        if (this.pool != null) {
            return this.pool.getDataSourceId();
        }
        return null;
    }
}

