/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import jeus.jndi.JEUSFailoverContext;
import jeus.jndi.JNSContext;
import jeus.jndi.JNSContextFactory;
import jeus.jndi.jns.common.ClusterManager;
import jeus.util.message.JeusMessage_JNDI;

public class JEUSClusterContext
extends JEUSFailoverContext {
    private static final Map<String, JNSContext> contexts = new Hashtable<String, JNSContext>();
    public static final Random random = new Random(System.currentTimeMillis());

    public JEUSClusterContext(String[] links, Hashtable table) throws NamingException {
        super(links, table);
    }

    protected void initFailover() {
    }

    private JNSContext connectJNSServer(String serverName) throws NamingException {
        this.env.put("java.naming.provider.url", serverName);
        JNSContext context = (JNSContext)JNSContextFactory.getInternalInitialContext(this.env, true);
        contexts.put(serverName, context);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getAliveContext() throws ServiceUnavailableException {
        ArrayList<String> list = new ArrayList<String>();
        for (String linkName : this.linkNames) {
            if (ClusterManager.isFailedServer(linkName)) continue;
            list.add(linkName);
        }
        while (list.size() > 0) {
            int currentIndex;
            Random len$ = random;
            synchronized (len$) {
                currentIndex = random.nextInt(list.size());
            }
            String serverName = (String)list.get(currentIndex);
            JNSContext ctx = contexts.get(serverName);
            if (ctx != null && ctx.getJNSLocal() != null && ctx.getJNSLocal().isRunning()) {
                this.serverName = serverName;
                this.context = ctx;
                return;
            }
            try {
                this.context = this.connectJNSServer(serverName);
                this.serverName = serverName;
                return;
            }
            catch (Throwable nse) {
                nse.printStackTrace();
                list.remove(currentIndex);
                this.handleFailedServer(serverName);
            }
        }
        this.checkFailedNodes();
    }

    protected boolean failoverForNameNotFoundException() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getAliveContextForLookup(List notFoundServerList) {
        ArrayList<String> list = new ArrayList<String>();
        for (String linkName : this.linkNames) {
            if (ClusterManager.isFailedServer(linkName) || notFoundServerList.contains(linkName)) continue;
            list.add(linkName);
        }
        while (list.size() > 0) {
            int currentIndex;
            Random len$ = random;
            synchronized (len$) {
                currentIndex = random.nextInt(list.size());
            }
            String serverName = (String)list.get(currentIndex);
            JNSContext ctx = contexts.get(serverName);
            if (ctx != null && ctx.getJNSLocal() != null && ctx.getJNSLocal().isRunning()) {
                this.serverName = serverName;
                this.context = ctx;
                return true;
            }
            try {
                this.context = this.connectJNSServer(serverName);
                this.serverName = serverName;
                return true;
            }
            catch (Throwable nse) {
                nse.printStackTrace();
                list.remove(currentIndex);
                this.handleFailedServer(serverName);
            }
        }
        return this.checkFailedNodesForLookup(notFoundServerList);
    }

    private void checkFailedNodes() throws ServiceUnavailableException {
        if (logger.isLoggable(JeusMessage_JNDI._65_LEVEL)) {
            logger.log(JeusMessage_JNDI._65_LEVEL, JeusMessage_JNDI._65);
        }
        for (String linkName : this.linkNames) {
            if (!ClusterManager.checkFailNode(linkName)) continue;
            try {
                this.context = this.connectJNSServer(linkName);
                ClusterManager.addCluster(linkName);
                this.serverName = linkName;
                return;
            }
            catch (NamingException e) {
                if (!logger.isLoggable(JeusMessage_JNDI._66_LEVEL)) continue;
                logger.log(JeusMessage_JNDI._66_LEVEL, JeusMessage_JNDI._66, linkName, (Throwable)e);
            }
        }
        throw new ServiceUnavailableException("[JEUSClusterContext] fail to connect naming server");
    }

    private boolean checkFailedNodesForLookup(List notFoundServerList) {
        if (logger.isLoggable(JeusMessage_JNDI._65_LEVEL)) {
            logger.log(JeusMessage_JNDI._65_LEVEL, JeusMessage_JNDI._65);
        }
        for (String linkName : this.linkNames) {
            if (notFoundServerList.contains(linkName) || !ClusterManager.checkFailNode(linkName)) continue;
            try {
                this.context = this.connectJNSServer(linkName);
                ClusterManager.addCluster(linkName);
                this.serverName = linkName;
                return true;
            }
            catch (NamingException e) {
                if (!logger.isLoggable(JeusMessage_JNDI._66_LEVEL)) continue;
                logger.log(JeusMessage_JNDI._66_LEVEL, JeusMessage_JNDI._66, linkName, (Throwable)e);
            }
        }
        return false;
    }

    protected void handleFailedServer(String serverName) {
        contexts.remove(serverName);
        ClusterManager.addFailList(serverName);
    }

    protected boolean stopFailover(int failoverCount) {
        return failoverCount > this.linkNames.length * 2;
    }

    public synchronized void close() throws NamingException {
        for (JNSContext jnsContext : contexts.values()) {
            jnsContext.close();
        }
    }
}

