/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.Reference;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.event.NamingListener;
import jeus.jndi.CacheableContext;
import jeus.jndi.JNSContext;
import jeus.jndi.JNSContextFactory;
import jeus.util.JeusException;
import jeus.util.JeusRuntimeException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JNDI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JEUSFailoverContext
implements CacheableContext {
    protected final Hashtable env;
    protected final String[] linkNames;
    protected JNSContext context;
    protected String serverName;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.jndi");
    public static boolean showException = true;

    public JEUSFailoverContext(String[] links, Hashtable env) throws NamingException {
        this.env = env;
        this.linkNames = links;
        this.initFailover();
        this.getAliveContext();
    }

    protected void initFailover() {
        this.serverName = this.linkNames[0];
        this.env.put("java.naming.provider.url", this.serverName);
    }

    protected void getAliveContext() throws ServiceUnavailableException {
        try {
            this.context = (JNSContext)JNSContextFactory.getInternalInitialContext(this.env, false);
        }
        catch (ServiceUnavailableException e) {
            throw e;
        }
        catch (NamingException e) {
            ServiceUnavailableException sue = new ServiceUnavailableException(e.getMessage());
            sue.initCause(e);
            throw sue;
        }
    }

    protected boolean getAliveContextForLookup(List aa) {
        try {
            this.context = (JNSContext)JNSContextFactory.getInternalInitialContext(this.env, false);
            return true;
        }
        catch (Throwable nse) {
            nse.printStackTrace();
            return false;
        }
    }

    protected JNSContext getCurrentContext() throws ServiceUnavailableException {
        if (this.context != null) {
            return this.context;
        }
        this.getAliveContext();
        assert (this.context != null);
        return this.context;
    }

    protected void handleFailedServer(String serverName) {
    }

    private void handleContextOperationException(NamingException ne, int failoverCount) throws NamingException {
        try {
            if (ne instanceof NoPermissionException) {
                throw ne;
            }
            if (this.stopFailover(failoverCount)) {
                throw ne;
            }
            if (ne instanceof ServiceUnavailableException) {
                throw ne;
            }
            Throwable rootCause = ne.getRootCause();
            if (rootCause instanceof JeusException || rootCause instanceof IOException || rootCause instanceof JeusRuntimeException || ne instanceof NameNotFoundException) {
                if (ne instanceof NameNotFoundException && !this.failoverForNameNotFoundException()) {
                    throw ne;
                }
                if (logger.isLoggable(JeusMessage_JNDI._72_LEVEL)) {
                    logger.log(JeusMessage_JNDI._72_LEVEL, JeusMessage_JNDI._72, new Object[]{this.serverName, rootCause.getMessage()}, rootCause);
                }
                this.handleFailedServer(this.serverName);
                if (logger.isLoggable(JeusMessage_JNDI._74_LEVEL)) {
                    logger.log(JeusMessage_JNDI._74_LEVEL, JeusMessage_JNDI._74, new Object[]{"exception occured during JNDI operation"});
                }
            } else {
                throw ne;
            }
            this.context.getJNSLocal().cancel();
            this.context.close();
            this.context = null;
            this.getAliveContext();
        }
        catch (NamingException ex) {
            if (showException && !(ne instanceof NameNotFoundException) && logger.isLoggable(JeusMessage_JNDI._73_LEVEL)) {
                logger.log(JeusMessage_JNDI._73_LEVEL, JeusMessage_JNDI._73, (Throwable)ex);
            }
            throw ex;
        }
    }

    private void handleContextOperationExceptionForLookup(NamingException ne, List<String> nameNotFoundContextList, int failoverCount) throws NamingException {
        block15: {
            try {
                if (ne instanceof NoPermissionException) {
                    throw ne;
                }
                if (this.stopFailover(failoverCount) || !this.getCurrentContext().getFailoverException()) {
                    throw ne;
                }
                if (ne instanceof NameNotFoundException) {
                    if (this.failoverForNameNotFoundException()) {
                        this.context.close();
                        this.context = null;
                        nameNotFoundContextList.add(this.serverName);
                        if (!this.getAliveContextForLookup(nameNotFoundContextList)) {
                            throw ne;
                        }
                        break block15;
                    }
                    throw ne;
                }
                if (ne instanceof ServiceUnavailableException) {
                    throw ne;
                }
                Throwable rootCause = ne.getRootCause();
                if (rootCause instanceof InterruptedIOException) {
                    this.handleFailedServer(this.serverName);
                    if (logger.isLoggable(JeusMessage_JNDI._74_LEVEL)) {
                        logger.log(JeusMessage_JNDI._74_LEVEL, JeusMessage_JNDI._74, new Object[]{"InterruptedIOException occured during lookup"});
                    }
                    this.context.getJNSLocal().cancel();
                    this.context.close();
                    this.context = null;
                    throw ne;
                }
                if (rootCause instanceof JeusException || rootCause instanceof IOException || rootCause instanceof JeusRuntimeException) {
                    if (logger.isLoggable(JeusMessage_JNDI._72_LEVEL)) {
                        logger.log(JeusMessage_JNDI._72_LEVEL, JeusMessage_JNDI._72, new Object[]{this.serverName, rootCause.getMessage()}, rootCause);
                    }
                    this.handleFailedServer(this.serverName);
                    if (logger.isLoggable(JeusMessage_JNDI._74_LEVEL)) {
                        logger.log(JeusMessage_JNDI._74_LEVEL, JeusMessage_JNDI._74, new Object[]{"fatal exception occured during lookup"});
                    }
                    this.context.getJNSLocal().cancel();
                    this.context.close();
                    this.context = null;
                    if (!this.getAliveContextForLookup(nameNotFoundContextList)) {
                        throw ne;
                    }
                    break block15;
                }
                throw ne;
            }
            catch (NamingException ex) {
                if (showException && !(ne instanceof NameNotFoundException) && logger.isLoggable(JeusMessage_JNDI._73_LEVEL)) {
                    logger.log(JeusMessage_JNDI._73_LEVEL, JeusMessage_JNDI._73, (Throwable)ex);
                }
                throw ex;
            }
        }
    }

    protected boolean stopFailover(int failoverCount) {
        return failoverCount > 0;
    }

    protected boolean failoverForNameNotFoundException() {
        return false;
    }

    @Override
    public synchronized Object lookup(Name name) throws NamingException {
        int failoverCount = 0;
        Vector<String> notFoundContextList = new Vector<String>();
        while (true) {
            try {
                JNSContext context = this.getCurrentContext();
                if (logger.isLoggable(JeusMessage_JNDI._64_LEVEL)) {
                    logger.log(JeusMessage_JNDI._64_LEVEL, JeusMessage_JNDI._64, new Object[]{"lookup", name, context.env.get("java.naming.provider.url")});
                }
                return context.lookup(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationExceptionForLookup(ne, notFoundContextList, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized Object lookup(String name) throws NamingException {
        int failoverCount = 0;
        Vector<String> nameNotFoundContextList = new Vector<String>();
        while (true) {
            try {
                JNSContext context = this.getCurrentContext();
                if (logger.isLoggable(JeusMessage_JNDI._64_LEVEL)) {
                    logger.log(JeusMessage_JNDI._64_LEVEL, JeusMessage_JNDI._64, new Object[]{"lookup", name, context.env.get("java.naming.provider.url")});
                }
                return context.lookup(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationExceptionForLookup(ne, nameNotFoundContextList, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void bind(Name name, Object obj) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().bind(name, obj);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void bind(String name, Object obj) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().bind(name, obj);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void rebind(Name name, Object obj) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().rebind(name, obj);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void rebind(String name, Object obj) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().rebind(name, obj);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void unbind(Name name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().unbind(name);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void unbind(String name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().unbind(name);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void rename(Name oldName, Name newName) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().rename(oldName, newName);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void rename(String oldName, String newName) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().rename(oldName, newName);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NamingEnumeration list(Name name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().list(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NamingEnumeration list(String name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().list(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NamingEnumeration listBindings(Name name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().listBindings(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NamingEnumeration listBindings(String name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().listBindings(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void destroySubcontext(Name name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().destroySubcontext(name);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void destroySubcontext(String name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().destroySubcontext(name);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized Context createSubcontext(Name name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().createSubcontext(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized Context createSubcontext(String name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().createSubcontext(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized Object lookupLink(Name name) throws NamingException {
        int failoverCount = 0;
        Vector<String> nameNotFoundContextList = new Vector<String>();
        while (true) {
            try {
                JNSContext context = this.getCurrentContext();
                if (logger.isLoggable(JeusMessage_JNDI._64_LEVEL)) {
                    logger.log(JeusMessage_JNDI._64_LEVEL, JeusMessage_JNDI._64, new Object[]{"lookupLink", name, context.env.get("java.naming.provider.url")});
                }
                return context.lookupLink(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationExceptionForLookup(ne, nameNotFoundContextList, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized Object lookupLink(String name) throws NamingException {
        int failoverCount = 0;
        Vector<String> nameNotFoundContextList = new Vector<String>();
        while (true) {
            try {
                JNSContext context = this.getCurrentContext();
                if (logger.isLoggable(JeusMessage_JNDI._64_LEVEL)) {
                    logger.log(JeusMessage_JNDI._64_LEVEL, JeusMessage_JNDI._64, new Object[]{"lookupLink", name, context.env.get("java.naming.provider.url")});
                }
                return context.lookupLink(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationExceptionForLookup(ne, nameNotFoundContextList, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized NameParser getNameParser(Name name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().getNameParser(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized NameParser getNameParser(String name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().getNameParser(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized Name composeName(Name name, Name prefix) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().composeName(name, prefix);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized String composeName(String name, String prefix) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().composeName(name, prefix);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized Object addToEnvironment(String propName, Object propVal) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().addToEnvironment(propName, propVal);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized Object removeFromEnvironment(String propName) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().removeFromEnvironment(propName);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)this.env.clone();
    }

    @Override
    public synchronized void close() throws NamingException {
        if (this.context != null) {
            this.context.close();
        }
    }

    @Override
    public synchronized String getNameInNamespace() throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().getNameInNamespace();
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized Attributes getAttributes(Name name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().getAttributes(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized Attributes getAttributes(String name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().getAttributes(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().getAttributes(name, attrIds);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().getAttributes(name, attrIds);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().modifyAttributes(name, mod_op, attrs);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().modifyAttributes(name, mod_op, attrs);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().modifyAttributes(name, mods);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().modifyAttributes(name, mods);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().bind(name, obj, attrs);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void bind(String name, Object obj, Attributes attrs) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().bind(name, obj, attrs);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().rebind(name, obj, attrs);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().rebind(name, obj, attrs);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().createSubcontext(name, attrs);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().createSubcontext(name, attrs);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized DirContext getSchema(Name name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().getSchema(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized DirContext getSchema(String name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().getSchema(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized DirContext getSchemaClassDefinition(Name name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().getSchemaClassDefinition(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized DirContext getSchemaClassDefinition(String name) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().getSchemaClassDefinition(name);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NamingEnumeration search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().search(name, matchingAttributes, attributesToReturn);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().search(name, matchingAttributes, attributesToReturn);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NamingEnumeration search(Name name, Attributes matchingAttributes) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().search(name, matchingAttributes);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().search(name, matchingAttributes);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NamingEnumeration search(Name name, String filter, SearchControls cons) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().search(name, filter, cons);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().search(name, filter, cons);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NamingEnumeration search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().search(name, filterExpr, filterArgs, cons);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    public synchronized NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().search(name, filterExpr, filterArgs, cons);
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void addNamingListener(Name target, int scope, NamingListener l) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().addNamingListener(target, scope, l);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void addNamingListener(String target, int scope, NamingListener l) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().addNamingListener(target, scope, l);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void removeNamingListener(NamingListener l) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().removeNamingListener(l);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized boolean targetMustExist() throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().targetMustExist();
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void addNamingListener(Name target, String filter, SearchControls ctls, NamingListener l) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().addNamingListener(target, filter, ctls, l);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void addNamingListener(String target, String filter, SearchControls ctls, NamingListener l) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().addNamingListener(target, filter, ctls, l);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void addNamingListener(Name target, String filter, Object[] filterArgs, SearchControls ctls, NamingListener l) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().addNamingListener(target, filter, filterArgs, ctls, l);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void addNamingListener(String target, String filter, Object[] filterArgs, SearchControls ctls, NamingListener l) throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                this.getCurrentContext().addNamingListener(target, filter, filterArgs, ctls, l);
                return;
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized Reference getReference() throws NamingException {
        int failoverCount = 0;
        while (true) {
            try {
                return this.getCurrentContext().getReference();
            }
            catch (NamingException ne) {
                this.handleContextOperationException(ne, failoverCount);
                ++failoverCount;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void removeCache(String name) {
        if (this.context == null) {
            return;
        }
        this.context.removeCache(name);
    }
}

