/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.ServiceUnavailableException;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeModificationException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.event.NamingListener;
import javax.naming.spi.NamingManager;
import jeus.jndi.CacheableContext;
import jeus.jndi.jns.common.BindingEnumeration;
import jeus.jndi.jns.common.DynamicLinkRef;
import jeus.jndi.jns.common.Environment;
import jeus.jndi.jns.common.JNS;
import jeus.jndi.jns.common.JNSNameParser;
import jeus.jndi.jns.common.NameEnumerationImpl;
import jeus.jndi.jns.local.DirService;
import jeus.jndi.jns.local.JNSLocal;
import jeus.jndi.jns.util.RMIStubWrapper;
import jeus.security.base.AnonymousSubject;
import jeus.security.base.SecurityException;
import jeus.security.base.Subject;
import jeus.security.spi.LoginService;
import jeus.util.ErrorMsgManager;
import jeus.util.JNDIUtil;
import jeus.util.JeusException;
import jeus.util.JeusRuntimeException;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.SimpleFormatter;
import jeus.util.message.JeusMessage_JNDI;
import jeus.util.properties.JeusPropertyValues;

public class JNSContext
implements CacheableContext {
    public static final String RESOLUTION = "jeus.jndi.jns.resolution";
    public static final String CONNECT_TIMEOUT = "jeus.jndi.jns.connecttimeout";
    public static final String CONNECTION_DURATION = "jeus.jndi.jns.connectionduration";
    public static final String REPLICATE_BINDINGS = "jeus.jndi.jns.replicatebindings";
    public static final String CACHE_BINDINGS = "jeus.jndi.jns.cachebindings";
    public static final String LOCAL_BINDINGS = "jeus.jndi.jns.localbindings";
    public static final String LOCAL_CONTEXT_BINDING = "jeus.jndi.jns.localcontextbindings";
    public static final String FORCED_BINDINGS = "jeus.jndi.jns.forcedbindings";
    public static final String CLUSTER_BINDINGS = "jeus.jndi.jns.clusterbindings";
    public static final String ENABLE_CACHE = "jeus.jndi.enable.cache";
    public static final String REPLICATE_CONTEXT_BINDING = "jeus.jndi.replicate.context";
    public static final String CLUSTERLINK_SELECTION_POLICY = "jeus.jndi.clusterlink.selection-policy";
    public static final String PKEY_DELEGATE_ENABLE = "jeus.jndi.delegate.enable";
    public static final String PKEY_DELEGATE_ENVIRONMENT = "jeus.jndi.delegate.environment";
    public static Integer OBJECT_CHANGE_LISTENER = 1;
    public static Integer NAMESPACE_CHANGE_LISTENER = 2;
    public static Integer ETC_LISTENER = 3;
    protected JNSLocal localServer;
    protected DirService dirService;
    protected Hashtable env;
    protected Environment bindingEnv;
    protected String nameInNamespace;
    protected static final NameParser nameparser = new JNSNameParser();
    protected Attributes attrs = null;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.jndi");
    public static final String LOGIN_SUBJECT = "jeus.jndi.jns.loginsubject";
    private byte[] subjectBytes = null;
    private transient Thread loginThread = null;
    private CompositeName compositeNameInNamespace;
    public static final ThreadLocal currentContextEnvironment = new ThreadLocal();
    public static final ThreadLocal<byte[]> subjectThreadLocal = new ThreadLocal();
    private boolean failover = true;

    private JNSContext(JNSLocal server, Hashtable env, Environment envValue, String name) throws NamingException {
        this(server, env, envValue, name, null);
    }

    public JNSContext(JNSLocal server, Hashtable env, String name) throws NamingException {
        this(server, (Hashtable)env.clone(), new Environment(env), name);
    }

    protected JNSContext(JNSLocal _server, Hashtable _env, Environment _envValue, String _name, Attributes _attrs) throws NamingException {
        try {
            if (_server == null) {
                throw new RuntimeException("internal error");
            }
            this.env = _env == null ? new Hashtable() : (Hashtable)_env.clone();
            this.bindingEnv = _envValue;
            this.setJNSLocal(_server);
            this.nameInNamespace = _name;
            this.compositeNameInNamespace = new CompositeName(_name);
            Subject loginSubject = (Subject)this.env.get(LOGIN_SUBJECT);
            if (loginSubject != null) {
                try {
                    this.subjectBytes = loginSubject.serialize();
                }
                catch (SecurityException ex) {
                    this.subjectBytes = AnonymousSubject.DEFAULT_APPLICATION_DOMAIN_ANONYMOUSSUBJECT.serialize();
                }
            }
            this.attrs = _attrs;
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_JNDI._1_LEVEL)) {
                logger.logp(JeusMessage_JNDI._1_LEVEL, "JNSContext", "<init>", JeusMessage_JNDI._1);
            }
            throw new ServiceUnavailableException(ErrorMsgManager.getLocalizedString(JeusMessage_JNDI._1));
        }
    }

    private void setJNSLocal(JNSLocal _server) {
        this.localServer = _server;
        this.dirService = this.localServer.getDirService();
    }

    JNSContext(JNSLocal server, Hashtable env, String name, Attributes _attrs) throws NamingException {
        this(server, env, new Environment(env), name, _attrs);
    }

    JNSContext(JNSLocal server, Hashtable env, int envValue, String name, Attributes _attrs) throws NamingException {
        this(server, env, new Environment(envValue), name, _attrs);
    }

    protected JNSContext makeContext(JNSLocal localServer, Hashtable env, String ctxName) throws NamingException {
        return new JNSContext(localServer, env, ctxName);
    }

    protected JNSContext makeContext(JNSLocal localServer, Hashtable env, String ctxName, Attributes attrs) throws NamingException {
        return new JNSContext(localServer, env, ctxName, attrs);
    }

    public Reference getReference() throws NamingException {
        Reference ref = new Reference("jeus.jndi.JNSContext", "jeus.jndi.JNSContextFactory", null);
        ref.add(0, new StringRefAddr("bindingEnv", Integer.toString(this.bindingEnv.toInt())));
        ref.add(1, new StringRefAddr("namePrefix", this.nameInNamespace));
        return ref;
    }

    public static Environment getBindingEnvFromReference(Reference ref) {
        RefAddr bindingEnvAddr = ref.get(0);
        int bindingEnvValue = Integer.parseInt((String)bindingEnvAddr.getContent());
        return new Environment(bindingEnvValue);
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.env == null) {
            this.env = new Hashtable(5, 0.75f);
        }
        Object oldEnv = this.env.put(propName, propVal);
        this.bindingEnv = new Environment(this.env);
        return oldEnv;
    }

    public void close() throws NamingException {
        if (logger.isLoggable(JeusMessage_JNDI._6_LEVEL)) {
            logger.log(JeusMessage_JNDI._6_LEVEL, JeusMessage_JNDI._6);
        }
        this.env = null;
        this.bindingEnv = null;
        this.dirService = null;
        this.localServer = null;
        this.nameInNamespace = null;
        this.compositeNameInNamespace = null;
        if (this.loginThread != null) {
            if (this.loginThread != Thread.currentThread()) {
                if (logger.isLoggable(JeusMessage_JNDI._63_LEVEL)) {
                    logger.log(JeusMessage_JNDI._63_LEVEL, JeusMessage_JNDI._63);
                }
            } else {
                try {
                    LoginService.logout();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.loginThread = null;
        }
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(new CompositeName(name), obj, null);
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name, obj, null);
    }

    private String handleCtxNotFoundException(String ctxName) throws NamingException {
        if (this.bindingEnv.getForced()) {
            try {
                block5: {
                    JNSContext newCtx = this.makeContext(this.localServer, this.env, ctxName);
                    Reference newCtxRef = newCtx.getReference();
                    try {
                        this.dirService.bind(ctxName, newCtxRef, this.bindingEnv);
                    }
                    catch (NameAlreadyBoundException ex) {
                        if (!logger.isLoggable(JeusMessage_JNDI._70_LEVEL)) break block5;
                        logger.log(JeusMessage_JNDI._70_LEVEL, JeusMessage_JNDI._70, (Throwable)ex);
                    }
                }
                ctxName = ctxName + "/";
            }
            catch (Exception some_e) {
                throw JNDIUtil.makeNamingException(some_e);
            }
        }
        throw new NameNotFoundException(ErrorMsgManager.getLocalizedString(JeusMessage_JNDI._5, ctxName));
        return ctxName;
    }

    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(new CompositeName(name), new CompositeName(prefix)).toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name newName = (Name)prefix.clone();
        return newName.addAll(name);
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(new CompositeName(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (logger.isLoggable(JeusMessage_JNDI._8_LEVEL)) {
            logger.log(JeusMessage_JNDI._8_LEVEL, JeusMessage_JNDI._8, new Object[]{this.nameInNamespace, name});
        }
        Name newName = this.composeName(name, this.compositeNameInNamespace);
        JNSContext newContext = this.makeContext(this.localServer, this.env, newName.toString());
        this.bind(name, (Object)newContext);
        return newContext;
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(new CompositeName(name));
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (logger.isLoggable(JeusMessage_JNDI._9_LEVEL)) {
            logger.log(JeusMessage_JNDI._9_LEVEL, JeusMessage_JNDI._9, new Object[]{this.nameInNamespace, name});
        }
        this.authorize(name.toString(), "modify");
        Object subctx = this.lookup(name);
        if (subctx instanceof Context) {
            try {
                if (!this.bindingEnv.getForced() && this.list(name).hasMoreElements()) {
                    throw new ContextNotEmptyException(ErrorMsgManager.getLocalizedString(JeusMessage_JNDI._11, name));
                }
                this.localDestroySubcontext(name.toString());
                if (this.bindingEnv.getLocalContextBinding()) {
                    return;
                }
                this.unbind(name);
            }
            catch (NamingException namingException) {}
        } else {
            throw new NotContextException(ErrorMsgManager.getLocalizedString(JeusMessage_JNDI._12, name));
        }
    }

    private void localDestroySubcontext(String name) {
        block2: {
            try {
                this.dirService.localDestroySubcontext(name);
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_JNDI._13_LEVEL)) break block2;
                logger.logp(JeusMessage_JNDI._13_LEVEL, "JNSContext", "localDestroySubcontext", JeusMessage_JNDI._13, e.toString(), (Throwable)e);
            }
        }
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)this.env.clone();
    }

    public String getNameInNamespace() throws NamingException {
        return this.nameInNamespace;
    }

    public NameParser getNameParser(String name) throws NamingException {
        return nameparser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return nameparser;
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (logger.isLoggable(JeusMessage_JNDI._10_LEVEL)) {
            logger.log(JeusMessage_JNDI._10_LEVEL, JeusMessage_JNDI._10, new Object[]{this.nameInNamespace, name});
        }
        name = this.composeName(name, this.compositeNameInNamespace);
        try {
            this.prepareJNDICall();
            this.authorize(name.toString(), "list");
            NameEnumerationImpl nameEnumerationImpl = this.getList(name.toString(), false);
            Object var4_4 = null;
            this.cleanupJNDICall();
            return nameEnumerationImpl;
        }
        catch (Exception e) {
            try {
                throw JNDIUtil.makeNamingException(e);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.cleanupJNDICall();
                throw throwable;
            }
        }
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (logger.isLoggable(JeusMessage_JNDI._15_LEVEL)) {
            logger.log(JeusMessage_JNDI._15_LEVEL, JeusMessage_JNDI._15, (Object)name);
        }
        name = this.composeName(name, this.compositeNameInNamespace);
        String nameString = name.toString();
        try {
            this.prepareJNDICall();
            this.authorize(name.toString(), "list");
            NameEnumerationImpl enumeration = this.getList(nameString, true);
            BindingEnumeration bindingEnumeration = new BindingEnumeration(this.makeContext(this.localServer, this.env, nameString), enumeration);
            Object var6_6 = null;
            this.cleanupJNDICall();
            return bindingEnumeration;
        }
        catch (Exception e) {
            try {
                throw JNDIUtil.makeNamingException(e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.cleanupJNDICall();
                throw throwable;
            }
        }
    }

    private NameEnumerationImpl getList(String nameString, boolean includeBindingObject) throws Exception {
        NameEnumerationImpl listInServer;
        NameEnumerationImpl listInLocal;
        block8: {
            block7: {
                listInLocal = null;
                try {
                    listInLocal = this.dirService.localList(nameString, includeBindingObject);
                }
                catch (NameNotFoundException ne) {
                    if (!logger.isLoggable(Level.FINEST)) break block7;
                    logger.log(Level.FINEST, "stack trace for debug", (Throwable)ne);
                }
            }
            listInServer = null;
            try {
                listInServer = this.dirService.list(nameString, includeBindingObject);
            }
            catch (NameNotFoundException ne) {
                if (!logger.isLoggable(Level.FINEST)) break block8;
                logger.log(Level.FINEST, "stack trace for debug", (Throwable)ne);
            }
        }
        if (listInLocal == null && listInServer == null) {
            throw new NameNotFoundException(nameString + " does not exist");
        }
        if (listInLocal != null) {
            if (listInServer != null) {
                listInLocal.getList().addAll(listInServer.getList());
            }
            return listInLocal;
        }
        return listInServer;
    }

    public Object lookup(String name) throws NamingException {
        if ("".equals(name)) {
            return this;
        }
        return this.lookup(new CompositeName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(Name name) throws NamingException {
        if (logger.isLoggable(JeusMessage_JNDI._17_LEVEL)) {
            logger.log(JeusMessage_JNDI._17_LEVEL, JeusMessage_JNDI._17, new Object[]{this.nameInNamespace, name});
        }
        name = this.composeName(name, this.compositeNameInNamespace);
        String nameString = name.toString();
        try {
            this.prepareJNDICall();
            Object object = this.lookupInternal(nameString, name, true);
            Object var6_5 = null;
            this.cleanupJNDICall();
            return object;
        }
        catch (Throwable e) {
            try {
                Object object = this.handleLookupException(e);
                Object var6_6 = null;
                this.cleanupJNDICall();
                return object;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.cleanupJNDICall();
                throw throwable;
            }
        }
    }

    private Object handleLookupException(Throwable e) throws NamingException {
        if (e instanceof ExceptionInInitializerError) {
            e = ((ExceptionInInitializerError)e).getException();
        }
        if (e instanceof NamingException) {
            throw (NamingException)e;
        }
        if (e instanceof JeusException || e instanceof JeusRuntimeException) {
            StringWriter sw = new StringWriter();
            PrintWriter pr = new PrintWriter(sw);
            Throwable causeException = SimpleFormatter.getCauseException(e);
            if (causeException != null) {
                causeException.printStackTrace(pr);
            }
            NamingException ne = new NamingException(sw.toString());
            ne.setRootCause(e);
            throw ne;
        }
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        NamingException ne = new NamingException(sw.toString());
        ne.setRootCause(e);
        throw ne;
    }

    private Object lookupInternal(String nameString, Name name, boolean dereference) throws Exception {
        Object obj;
        if (this.dirService.needAuthorizationForLookup(nameString)) {
            this.authorize(nameString, "lookup");
        }
        if ((obj = this.dirService.lookup(nameString, dereference)) instanceof Reference) {
            Reference ref = (Reference)obj;
            try {
                obj = NamingManager.getObjectInstance(ref, name, this, this.env);
            }
            catch (Exception e) {
                if (!(e instanceof NamingException)) {
                    this.setFailoverException(false);
                }
                throw e;
            }
        }
        if (obj instanceof RMIStubWrapper) {
            obj = ((RMIStubWrapper)obj).getRMIStub();
        }
        return obj;
    }

    public void setFailoverException(boolean failover) {
        this.failover = failover;
    }

    public boolean getFailoverException() {
        return this.failover;
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(new CompositeName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookupLink(Name name) throws NamingException {
        if (logger.isLoggable(JeusMessage_JNDI._18_LEVEL)) {
            logger.log(JeusMessage_JNDI._18_LEVEL, JeusMessage_JNDI._18, (Object)name);
        }
        name = this.composeName(name, this.compositeNameInNamespace);
        try {
            this.prepareJNDICall();
            Object object = this.lookupInternal(name.toString(), name, false);
            Object var5_4 = null;
            this.cleanupJNDICall();
            return object;
        }
        catch (Exception e) {
            try {
                Object object = this.handleLookupException(e);
                Object var5_5 = null;
                this.cleanupJNDICall();
                return object;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.cleanupJNDICall();
                throw throwable;
            }
        }
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(new CompositeName(name), obj, null);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name, obj, null);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        Object obj = null;
        if (this.env != null) {
            obj = this.env.remove(propName);
            if (this.env.size() == 0) {
                this.env = null;
            }
        }
        this.bindingEnv = this.env != null ? new Environment(this.env) : Environment.defaultEnv;
        return obj;
    }

    public void rename(String oldName, String newName) throws NamingException {
        if (logger.isLoggable(JeusMessage_JNDI._25_LEVEL)) {
            logger.log(JeusMessage_JNDI._25_LEVEL, JeusMessage_JNDI._25, (Object[])new String[]{oldName, newName});
        }
        oldName = this.composeName(oldName, this.nameInNamespace);
        newName = this.composeName(newName, this.nameInNamespace);
        try {
            try {
                this.prepareJNDICall();
                this.authorize(oldName, "modify");
                this.dirService.rename(oldName, newName, this.bindingEnv);
            }
            catch (Exception e) {
                throw JNDIUtil.makeNamingException(e);
            }
            Object var5_3 = null;
            this.cleanupJNDICall();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.cleanupJNDICall();
            throw throwable;
        }
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this.rename(oldName.toString(), newName.toString());
    }

    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }

    public void unbind(Name name) throws NamingException {
        if (logger.isLoggable(JeusMessage_JNDI._27_LEVEL)) {
            logger.log(JeusMessage_JNDI._27_LEVEL, JeusMessage_JNDI._27, (Object)name);
        }
        name = this.composeName(name, this.compositeNameInNamespace);
        String nameString = name.toString();
        try {
            block6: {
                try {
                    this.prepareJNDICall();
                    this.authorize(name.toString(), "modify");
                    Object obj = this.dirService.lookup(nameString, false);
                    if (obj instanceof LinkRef || obj instanceof DynamicLinkRef) {
                        this.dirService.unbind(nameString, this.bindingEnv, false);
                        break block6;
                    }
                    this.dirService.unbind(nameString, this.bindingEnv, true);
                }
                catch (Exception e) {
                    throw JNDIUtil.makeNamingException(e);
                }
            }
            Object var5_5 = null;
            this.cleanupJNDICall();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.cleanupJNDICall();
            throw throwable;
        }
    }

    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        String newName = this.composeName(name, this.nameInNamespace);
        JNSContext newContext = this.makeContext(this.localServer, this.env, newName, attrs);
        this.bind(name, (Object)newContext);
        return newContext;
    }

    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        return this.createSubcontext(name.toString(), attrs);
    }

    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        this.bind(new CompositeName(name), obj, attrs);
    }

    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.bindInternal(name, obj, attrs, false);
    }

    private void bindInternal(Name name, Object obj, Attributes attrs, boolean rebind) throws NamingException {
        if (logger.isLoggable(JeusMessage_JNDI._29_LEVEL)) {
            logger.log(JeusMessage_JNDI._29_LEVEL, JeusMessage_JNDI._29, new Object[]{this.nameInNamespace, name, obj, attrs});
        }
        if ((name = this.composeName(name, this.compositeNameInNamespace)).isEmpty()) {
            if (logger.isLoggable(JeusMessage_JNDI._3_LEVEL)) {
                logger.logp(JeusMessage_JNDI._3_LEVEL, "JNSContext", "bind", JeusMessage_JNDI._3);
            }
            throw new InvalidNameException(ErrorMsgManager.getLocalizedString(JeusMessage_JNDI._3));
        }
        try {
            block18: {
                try {
                    this.prepareJNDICall();
                    this.authorize(name.toString(), "modify");
                    if (obj instanceof LinkRef) {
                        String linkname = ((LinkRef)obj).getLinkName();
                        if (linkname == null) {
                            throw new NamingException(ErrorMsgManager.getLocalizedString(JeusMessage_JNDI._21));
                        }
                        if (linkname.startsWith(".")) {
                            linkname = this.getNameInNamespace() + linkname.substring(1);
                            obj = new LinkRef(linkname);
                        }
                    }
                    if (obj instanceof Referenceable) {
                        obj = ((Referenceable)obj).getReference();
                    }
                    String ctxName = "";
                    Enumeration<String> names = name.getAll();
                    while (names.hasMoreElements()) {
                        Object ctxObj;
                        String atomicName = names.nextElement();
                        ctxName = ctxName + atomicName;
                        if (!names.hasMoreElements()) continue;
                        try {
                            ctxObj = this.dirService.lookup(ctxName, true);
                        }
                        catch (Exception ctx_not_found_e) {
                            ctxName = this.handleCtxNotFoundException(ctxName);
                            continue;
                        }
                        if (JNS.isJNSContext(ctxObj) && names.hasMoreElements()) {
                            Environment env;
                            if (!this.bindingEnv.getLocal() && (env = JNSContext.getBindingEnvFromReference((Reference)ctxObj)).getLocalContextBinding()) {
                                throw new NamingException("The object with replicate binding cannot be bound to context with local binding : " + ctxName);
                            }
                            ctxName = this.dirService.dereference(ctxName, true, false, true) + "/";
                            continue;
                        }
                        if (logger.isLoggable(JeusMessage_JNDI._4_LEVEL)) {
                            logger.logp(JeusMessage_JNDI._4_LEVEL, "JNSContext", "bind", JeusMessage_JNDI._4);
                        }
                        throw new OperationNotSupportedException(ErrorMsgManager.getLocalizedString(JeusMessage_JNDI._4));
                    }
                    if (rebind) {
                        this.dirService.rebind(ctxName, obj, this.bindingEnv, attrs);
                        break block18;
                    }
                    this.dirService.bind(ctxName, obj, this.bindingEnv, attrs);
                }
                catch (Exception e) {
                    throw JNDIUtil.makeNamingException(e);
                }
            }
            Object var11_12 = null;
            this.cleanupJNDICall();
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.cleanupJNDICall();
            throw throwable;
        }
    }

    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        this.rebind(new CompositeName(name), obj, attrs);
    }

    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.bindInternal(name, obj, attrs, true);
    }

    public Attributes getAttributes(String name) throws NamingException {
        return this.getAttributes(new CompositeName(name));
    }

    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        return this.getAttributes(new CompositeName(name), attrIds);
    }

    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name, null);
    }

    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        if (logger.isLoggable(JeusMessage_JNDI._33_LEVEL)) {
            logger.log(JeusMessage_JNDI._33_LEVEL, JeusMessage_JNDI._33, new Object[]{this.nameInNamespace, name});
        }
        name = this.composeName(name, this.compositeNameInNamespace);
        try {
            this.prepareJNDICall();
            this.authorize(name.toString(), "lookup");
            Attributes attributes = this.dirService.getAttributes(name.toString(), attrIds);
            Object var5_5 = null;
            this.cleanupJNDICall();
            return attributes;
        }
        catch (Exception e) {
            try {
                throw JNDIUtil.makeNamingException(e);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.cleanupJNDICall();
                throw throwable;
            }
        }
    }

    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        this.modifyAttributes(new CompositeName(name), mod_op, attrs);
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        this.modifyAttributes(new CompositeName(name), mods);
    }

    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        if (logger.isLoggable(JeusMessage_JNDI._35_LEVEL)) {
            logger.log(JeusMessage_JNDI._35_LEVEL, JeusMessage_JNDI._35, new Object[]{this.nameInNamespace, name});
        }
        this.authorize(name.toString(), "modify");
        name = this.composeName(name, this.compositeNameInNamespace);
        try {
            if (attrs == null) {
                return;
            }
            if (mod_op < 1 || mod_op > 3) {
                throw new AttributeModificationException(ErrorMsgManager.getLocalizedString(JeusMessage_JNDI._36));
            }
            ModificationItem[] mods = new ModificationItem[attrs.size()];
            int i = 0;
            NamingEnumeration<? extends Attribute> e = attrs.getAll();
            while (e.hasMore()) {
                mods[i++] = new ModificationItem(mod_op, e.next());
            }
            this.modifyAttributes(name, mods);
        }
        catch (Exception e) {
            throw JNDIUtil.makeNamingException(e);
        }
    }

    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        if (logger.isLoggable(JeusMessage_JNDI._35_LEVEL)) {
            logger.log(JeusMessage_JNDI._35_LEVEL, JeusMessage_JNDI._35, new Object[]{this.nameInNamespace, name});
        }
        name = this.composeName(name, this.compositeNameInNamespace);
        try {
            try {
                block10: {
                    block9: {
                        this.prepareJNDICall();
                        if (mods == null) break block9;
                        if (mods.length != 0) break block10;
                    }
                    Object var5_3 = null;
                    this.cleanupJNDICall();
                    return;
                }
                this.dirService.modifyAttributes(name.toString(), mods);
            }
            catch (Exception e) {
                throw JNDIUtil.makeNamingException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.cleanupJNDICall();
            throw throwable;
        }
        Object var5_4 = null;
        this.cleanupJNDICall();
    }

    public NamingEnumeration search(String name, Attributes attrs) throws NamingException {
        return this.search(new CompositeName(name), attrs);
    }

    public NamingEnumeration search(String name, Attributes attrs, String[] attrIds) throws NamingException {
        return this.search((Name)new CompositeName(name), attrs, attrIds);
    }

    public NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        return this.search((Name)new CompositeName(name), filter, cons);
    }

    public NamingEnumeration search(String name, String filter, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.search(new CompositeName(name), filter, filterArgs, cons);
    }

    public NamingEnumeration search(Name name, Attributes attrs) throws NamingException {
        return this.search(name, attrs, null);
    }

    public NamingEnumeration search(Name name, Attributes attrs, String[] attrIds) throws NamingException {
        if (logger.isLoggable(JeusMessage_JNDI._38_LEVEL)) {
            logger.log(JeusMessage_JNDI._38_LEVEL, JeusMessage_JNDI._38, new Object[]{this.nameInNamespace, name});
        }
        name = this.composeName(name, this.compositeNameInNamespace);
        try {
            this.prepareJNDICall();
            this.authorize(name.toString(), "lookup");
            NameEnumerationImpl nameEnumerationImpl = new NameEnumerationImpl(this.dirService.search(name.toString(), attrs, attrIds), true);
            Object var6_6 = null;
            this.cleanupJNDICall();
            return nameEnumerationImpl;
        }
        catch (Exception e) {
            try {
                throw JNDIUtil.makeNamingException(e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.cleanupJNDICall();
                throw throwable;
            }
        }
    }

    public NamingEnumeration search(Name name, String filterExpr, SearchControls cons) throws NamingException {
        return this.search(name, filterExpr, null, cons);
    }

    public NamingEnumeration search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        if (logger.isLoggable(JeusMessage_JNDI._38_LEVEL)) {
            logger.log(JeusMessage_JNDI._38_LEVEL, JeusMessage_JNDI._38, new Object[]{this.nameInNamespace, name});
        }
        name = this.composeName(name, this.compositeNameInNamespace);
        try {
            this.prepareJNDICall();
            NameEnumerationImpl nameEnumerationImpl = new NameEnumerationImpl(this.dirService.search(name.toString(), filterExpr, filterArgs, cons), true);
            Object var7_7 = null;
            this.cleanupJNDICall();
            return nameEnumerationImpl;
        }
        catch (Exception e) {
            try {
                throw JNDIUtil.makeNamingException(e);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.cleanupJNDICall();
                throw throwable;
            }
        }
    }

    public DirContext getSchema(String name) throws NamingException {
        throw new OperationNotSupportedException(ErrorMsgManager.getLocalizedString(JeusMessage_JNDI._40));
    }

    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new OperationNotSupportedException(ErrorMsgManager.getLocalizedString(JeusMessage_JNDI._41));
    }

    public DirContext getSchema(Name name) throws NamingException {
        throw new OperationNotSupportedException(ErrorMsgManager.getLocalizedString(JeusMessage_JNDI._42));
    }

    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        throw new OperationNotSupportedException(ErrorMsgManager.getLocalizedString(JeusMessage_JNDI._43));
    }

    public void addNamingListener(String name, int scope, NamingListener listener) throws NamingException {
        this.addNamingListener(new CompositeName(name), scope, listener);
    }

    public void addNamingListener(Name name, int scope, NamingListener listener) throws NamingException {
        if (logger.isLoggable(JeusMessage_JNDI._44_LEVEL)) {
            logger.log(JeusMessage_JNDI._44_LEVEL, JeusMessage_JNDI._44, new Object[]{this.nameInNamespace, name});
        }
        name = this.composeName(name, this.compositeNameInNamespace);
        try {
            try {
                this.prepareJNDICall();
                this.authorize(name.toString(), "lookup");
                this.dirService.addNamingListener(name.toString(), scope, listener);
            }
            catch (Exception e) {
                throw JNDIUtil.makeNamingException(e);
            }
            Object var6_4 = null;
            this.cleanupJNDICall();
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.cleanupJNDICall();
            throw throwable;
        }
    }

    public void removeNamingListener(NamingListener listener) throws NamingException {
        if (logger.isLoggable(JeusMessage_JNDI._46_LEVEL)) {
            logger.log(JeusMessage_JNDI._46_LEVEL, JeusMessage_JNDI._46);
        }
        try {
            try {
                this.prepareJNDICall();
                this.dirService.removeNamingListener(listener);
            }
            catch (Exception e) {
                throw JNDIUtil.makeNamingException(e);
            }
            Object var4_2 = null;
            this.cleanupJNDICall();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.cleanupJNDICall();
            throw throwable;
        }
    }

    private void cleanupJNDICall() {
        currentContextEnvironment.set(null);
        subjectThreadLocal.set(null);
    }

    private void prepareJNDICall() throws NamingException {
        currentContextEnvironment.set(this.env);
        subjectThreadLocal.set(this.subjectBytes);
    }

    public boolean targetMustExist() throws NamingException {
        return true;
    }

    public void addNamingListener(String name, String filterExpr, SearchControls cons, NamingListener listener) throws NamingException {
        this.addNamingListener(new CompositeName(name), filterExpr, cons, listener);
    }

    public void addNamingListener(String name, String filterExpr, Object[] filterArgs, SearchControls cons, NamingListener listener) throws NamingException {
        this.addNamingListener(new CompositeName(name), filterExpr, cons, listener);
    }

    public void addNamingListener(Name name, String filterExpr, SearchControls cons, NamingListener listener) throws NamingException {
        this.addNamingListener(name, filterExpr, null, cons, listener);
    }

    public void addNamingListener(Name name, String filterExpr, Object[] filterArgs, SearchControls cons, NamingListener listener) throws NamingException {
        if (logger.isLoggable(JeusMessage_JNDI._44_LEVEL)) {
            logger.log(JeusMessage_JNDI._44_LEVEL, JeusMessage_JNDI._44, new Object[]{this.nameInNamespace, name});
        }
        try {
            try {
                this.prepareJNDICall();
                this.authorize(name.toString(), "lookup");
                this.dirService.addNamingListener(name.toString(), filterExpr, filterArgs, cons, listener);
            }
            catch (Exception e) {
                throw JNDIUtil.makeNamingException(e);
            }
            Object var8_6 = null;
            this.cleanupJNDICall();
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.cleanupJNDICall();
            throw throwable;
        }
    }

    public void enableLogoutClose() {
        this.loginThread = Thread.currentThread();
    }

    public JNSLocal getJNSLocal() {
        return this.localServer;
    }

    private void authorize(String name, String action) throws NamingException {
        if (JeusPropertyValues.JEUS_CATEGORY != 0) {
            this.dirService.serverAuthorize(name, action);
        } else {
            this.dirService.clientAuthorize(name, action);
        }
    }

    public static void main(String[] args) {
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "jeus.jndi.JNSContextFactory");
            env.put("java.naming.factory.url.pkgs", "jeus.jndi.jns.url");
            env.put(LOCAL_BINDINGS, "true");
            InitialContext ctx = new InitialContext(env);
            ctx.bind("test", (Object)"ok");
            System.in.read();
            ctx.unbind("test");
            ctx.close();
            env = new Hashtable();
            env.put("java.naming.factory.initial", "jeus.jndi.JNSContextFactory");
            env.put("java.naming.factory.url.pkgs", "jeus.jndi.jns.url");
            env.put(REPLICATE_BINDINGS, "true");
            ctx = new InitialContext(env);
            ctx.rebind("test", (Object)"ok");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Object lookupRawObject(String name) throws NamingException {
        if ("".equals(name)) {
            return this;
        }
        return this.lookupRawObject(new CompositeName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookupRawObject(Name name) throws NamingException {
        if (logger.isLoggable(JeusMessage_JNDI._17_LEVEL)) {
            logger.log(JeusMessage_JNDI._17_LEVEL, JeusMessage_JNDI._17, new Object[]{this.nameInNamespace, name});
        }
        name = this.composeName(name, this.compositeNameInNamespace);
        String nameString = name.toString();
        try {
            this.prepareJNDICall();
            Object object = this.dirService.lookup(nameString, false);
            Object var6_5 = null;
            this.cleanupJNDICall();
            return object;
        }
        catch (Throwable e) {
            try {
                Object object = this.handleLookupException(e);
                Object var6_6 = null;
                this.cleanupJNDICall();
                return object;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.cleanupJNDICall();
                throw throwable;
            }
        }
    }

    public void removeCache(String dynamicLinkName) {
        this.dirService.removeCache(dynamicLinkName);
    }
}

