/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi;

import com.sun.jndi.cosnaming.CNCtxFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;
import jeus.corba.ORBManager;
import jeus.jndi.JEUSClusterContext;
import jeus.jndi.JEUSFailoverContext;
import jeus.jndi.JNSContext;
import jeus.jndi.jns.common.JNS;
import jeus.jndi.jns.delegate.JEUSRemoteContext;
import jeus.jndi.jns.delegate.JEUSRemoteDirContext;
import jeus.jndi.jns.delegate.RemoteContext;
import jeus.jndi.jns.delegate.RemoteContextFactory;
import jeus.jndi.jns.delegate.RemoteDirContext;
import jeus.jndi.jns.local.JNSLocal;
import jeus.jndi.util.StringUtil;
import jeus.security.base.Subject;
import jeus.security.spi.LoginService;
import jeus.security.util.LoginUtil;
import jeus.transaction.TMException;
import jeus.transaction.TMService;
import jeus.util.ExecutionContext;
import jeus.util.HostInfo;
import jeus.util.JeusPort;
import jeus.util.SecurityUtil;
import jeus.util.properties.JeusNetPropertyValues;
import jeus.util.properties.JeusPropertyValues;
import jeus.util.properties.JeusTMProperties;
import org.omg.CORBA.ORB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNSContextFactory
implements InitialContextFactory,
ObjectFactory {
    private static final Map<String, String> dnsTable = new Hashtable<String, String>();
    private static final Map<String, String> namingPropertiesMap = new HashMap<String, String>();

    public Context getInitialContext(Hashtable table) throws NamingException {
        String fullServerName = (String)table.get("java.naming.provider.url");
        if (fullServerName != null && (fullServerName.startsWith("iiop:") || fullServerName.startsWith("iiopname:") || fullServerName.startsWith("corbaname:") || fullServerName.startsWith("corbaloc:"))) {
            if (table.get("java.naming.corba.orb") == null) {
                ORB orb = ORBManager.getORBForNaming(JNS.getLocation() != 0);
                table.put("java.naming.corba.orb", orb);
            }
            return new CNCtxFactory().getInitialContext(table);
        }
        if (fullServerName == null || fullServerName.lastIndexOf(",") == -1) {
            if (fullServerName == null) {
                fullServerName = "localhost";
            }
            return new JEUSFailoverContext(new String[]{fullServerName}, table);
        }
        return this.makeClusterContext(fullServerName, table);
    }

    private Context makeClusterContext(String fullServerName, Hashtable table) throws NamingException {
        ArrayList<String> allLinks = new ArrayList<String>();
        StringTokenizer token = new StringTokenizer(fullServerName, ",");
        while (token.hasMoreTokens()) {
            allLinks.add(token.nextToken().trim());
        }
        return new JEUSClusterContext(allLinks.toArray(new String[allLinks.size()]), table);
    }

    public static Context getInternalInitialContext(Hashtable table) throws NamingException {
        return JNSContextFactory.getInternalInitialContext(table, false);
    }

    public static Context getInternalInitialContext(Hashtable table, boolean checkFailList) throws NamingException {
        Map map;
        if (table == null) {
            table = new Hashtable<Object, Object>();
        }
        HashMap<Object, Object> env = new HashMap<Object, Object>();
        env.putAll(namingPropertiesMap);
        env.putAll(table);
        if (env.get("java.naming.factory.initial") == null) {
            env.put("java.naming.factory.initial", "jeus.jndi.JNSContextFactory");
        }
        if (env.get("java.naming.factory.url.pkgs") == null) {
            env.put("java.naming.factory.url.pkgs", "jeus.jndi.jns.url");
        }
        if (env.get("jeus.jndi.clusterlink.selection-policy") == null) {
            env.put("jeus.jndi.clusterlink.selection-policy", "locallinkPreference");
        }
        if ((map = (Map)ExecutionContext.getFromContextStacks("JNDI_PROPERTIES")) != null) {
            for (Map.Entry obj : map.entrySet()) {
                Map.Entry entry = obj;
                Object key = entry.getKey();
                if (env.containsKey(key)) continue;
                env.put(key, entry.getValue());
            }
        }
        boolean enableDelegate = JNSContextFactory.checkContextDelegate(env);
        String serverAddress = HostInfo.composeServerAddress(JeusNetPropertyValues.LOCAL_LOOPBACK_ADDRESS, JeusPort.JeusBase);
        if (env.get("java.naming.provider.url") != null) {
            serverAddress = (String)env.get("java.naming.provider.url");
            serverAddress = HostInfo.fromServerAddress(serverAddress);
        }
        env.put("java.naming.provider.url", serverAddress);
        boolean isLogin = JNSContextFactory.initSecurity(env, serverAddress);
        JNSContextFactory.initTM();
        table.putAll(env);
        if (enableDelegate && env.get("jeus.jndi.delegate.environment") != null) {
            return JNSContextFactory.makeRemoteContext(serverAddress, table, checkFailList);
        }
        return JNSContextFactory.makeContext(table, isLogin, checkFailList);
    }

    private static Context makeContext(Hashtable table, boolean login, boolean checkFailList) throws NamingException {
        try {
            JNSContext context = new JNSContext(JNSLocal.getLocalServer(table, checkFailList), table, "");
            if (login) {
                context.enableLogoutClose();
            }
            return context;
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            NamingException ex = new NamingException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Context makeRemoteContext(String serverName, Hashtable table, boolean checkFailList) throws NamingException {
        try {
            HostInfo hostInfo = HostInfo.fromServerAddressToHostInfo(serverName);
            String hostname = hostInfo.getHostname();
            if (hostname.equals(JeusNetPropertyValues.LOCAL_LOOPBACK_ADDRESS) || hostname.equals(JeusNetPropertyValues.LOCAL_HOSTADDRESS) || hostname.equals("localhost")) {
                hostname = JeusNetPropertyValues.LOCAL_HOSTNAME;
            } else if (!hostname.equals(JeusNetPropertyValues.LOCAL_HOSTNAME)) {
                String _hostname = dnsTable.get(serverName);
                if (_hostname == null) {
                    Map<String, String> map = dnsTable;
                    synchronized (map) {
                        _hostname = dnsTable.get(serverName);
                        if (_hostname == null) {
                            _hostname = JeusNetPropertyValues.getByName(serverName).getHostName();
                            dnsTable.put(serverName, _hostname);
                        }
                    }
                }
                hostname = _hostname;
            }
            JNSContext ctx = new JNSContext(JNSLocal.getLocalServer(table, checkFailList), table, "");
            RemoteContextFactory factory = (RemoteContextFactory)ctx.lookup("_" + hostname + "_jeus_RemoteContextFactory");
            RemoteContext rtCtx = factory.getContext(table);
            if (rtCtx instanceof RemoteDirContext) {
                return new JEUSRemoteDirContext((RemoteDirContext)rtCtx);
            }
            return new JEUSRemoteContext(rtCtx);
        }
        catch (Throwable t) {
            throw new NamingException(t.toString());
        }
    }

    private static boolean initSecurity(Map<Object, Object> env, String hostInfo) throws NamingException {
        boolean isLogin = false;
        Subject loginSubject = (Subject)env.get("jeus.jndi.jns.loginsubject");
        try {
            if (loginSubject == null) {
                Object credential = env.get("java.naming.security.credentials");
                if (credential != null) {
                    SecurityUtil.installClientSecurity(hostInfo);
                    SecurityUtil.changeServer(hostInfo);
                    String username = (String)env.get("java.naming.security.principal");
                    if (credential instanceof X509Certificate) {
                        loginSubject = new Subject(null, null);
                        loginSubject.getPublicCredentials().add(credential);
                        LoginUtil.loginWithRuntimeException(loginSubject);
                        isLogin = true;
                    } else if (username != null) {
                        loginSubject = Subject.makeSubject(username, (String)credential);
                        LoginUtil.loginWithRuntimeException(loginSubject);
                        isLogin = true;
                    }
                }
                loginSubject = LoginService.getCurrentSubject();
                env.put("jeus.jndi.jns.loginsubject", loginSubject);
            }
            return isLogin;
        }
        catch (Throwable e) {
            NamingException namingException = new NamingException("failed to login");
            namingException.initCause(e);
            throw namingException;
        }
    }

    protected static void initTM() throws NamingException {
        if (JeusPropertyValues.JEUS_CATEGORY != 0) {
            return;
        }
        if (JeusTMProperties.NOT_USE_TM) {
            return;
        }
        boolean tmServer = false;
        try {
            String jeusTmVersion = JeusTMProperties.TM_VERSION;
            if ("server".equals(jeusTmVersion)) {
                tmServer = true;
                TMService.initTMServerInClient(null, "client", JeusTMProperties.CLIENT_SPECIFIED_PORT, JeusPort.TMBase);
            } else {
                tmServer = false;
                TMService.initTMClient(null, JeusTMProperties.CLIENT_SPECIFIED_PORT, JeusPort.TMBase);
            }
        }
        catch (TMException e) {
            if (tmServer) {
                TMService.destroyTMServer();
            } else {
                TMService.destroyTMClient();
            }
            StringWriter sw = new StringWriter();
            PrintWriter pr = new PrintWriter(sw);
            e.printStackTrace(pr);
            throw new NamingException(e.toString() + " : " + sw.toString());
        }
    }

    protected static void destroyTM() {
        if (JeusPropertyValues.JEUS_CATEGORY != 0) {
            return;
        }
        if (JeusTMProperties.NOT_USE_TM) {
            return;
        }
        String jeusTmVersion = JeusTMProperties.TM_VERSION;
        if ("server".equals(jeusTmVersion)) {
            TMService.destroyTMServer();
        } else {
            TMService.destroyTMClient();
        }
    }

    private static boolean checkContextDelegate(Map table) {
        boolean enableDelegate = false;
        String value = (String)table.get("jeus.jndi.delegate.enable");
        if (value != null && !value.equals("")) {
            enableDelegate = Boolean.valueOf(value);
        }
        if (enableDelegate && table.get("jeus.jndi.delegate.environment") == null) {
            Hashtable delegate = new Hashtable();
            int skipLength = "jeus.jndi.delegate".length() + 1;
            for (String prefix : table.keySet()) {
                if (!prefix.startsWith("jeus.jndi.delegate")) continue;
                delegate.put(prefix.substring(skipLength), table.get(prefix));
            }
            if (delegate.size() > 0) {
                table.put("jeus.jndi.delegate.environment", delegate);
            }
        }
        return enableDelegate;
    }

    private static void addNamingProperties() {
        try {
            Properties prop = System.getProperties();
            Enumeration<?> names = prop.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!StringUtil.isNamingProperty(name) || namingPropertiesMap.get(name) != null) continue;
                namingPropertiesMap.put(name, prop.getProperty(name));
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (JNS.isJNSContext(obj)) {
            Reference ref = (Reference)obj;
            RefAddr bindingEnvAddr = ref.get(0);
            int bindingEnvValue = Integer.parseInt((String)bindingEnvAddr.getContent());
            String nameInNamespace = (String)ref.get(1).getContent();
            return new JNSContext(JNSLocal.getLocalServer(environment), environment, bindingEnvValue, nameInNamespace, null);
        }
        return null;
    }

    static {
        JNSContextFactory.addNamingProperties();
    }
}

