/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.common;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.ejb.EJBHome;
import javax.naming.LinkException;
import javax.naming.NamingException;
import javax.naming.Reference;
import jeus.ejb.bean.objectbase.JEUSClusterStub;
import jeus.ejb.client.BusinessHome;
import jeus.ejb.client.RemoteEJBHomeClientHandler;
import jeus.jndi.JEUSClusterContext;
import jeus.jndi.JNSContext;
import jeus.jndi.jns.common.ClusterManager;
import jeus.jndi.jns.common.JNS;
import jeus.jndi.jns.local.DirService;
import jeus.jndi.jns.local.JNSLocal;
import jeus.security.util.LoginUtil;
import jeus.util.HostInfo;
import jeus.util.JNDIUtil;
import jeus.util.JeusPort;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JNSCommon;
import jeus.util.properties.JeusEJBProperties;
import jeus.util.properties.JeusJNDIProperties;
import jeus.util.properties.JeusManagerPropertyValues;
import jeus.util.properties.JeusNetPropertyValues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicLinkRef
extends Reference {
    private static final long serialVersionUID = -5362040020503199925L;
    private final Vector<String> links = new Vector();
    private int roundRobinIndex = -1;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.ejb.cluster");
    private static final String JEUS_CLUSTER_PREFIX = "__jeus_cl@";
    private static final String JEUS_LINK_PREFIX = "__jeus_link@";
    private static final String JNDINAME_SEPARATOR = "_";
    private static final String LOCALOBJECTID_SEPARATOR = ":";
    private static final String LINK_ITEM_PREFIX = "_$item$_";
    private static final String CLUSTER_ADDR_PREFIX = "_$addr$_";
    private static final String DLR_LIST_REMOVE_ID = "remove";
    static int location = JNS.getLocation();
    static String jndiServerUrl;
    static String containerId;

    public DynamicLinkRef(String className, String name) {
        super(className);
        this.links.add(name);
    }

    public String getLinkName() throws NamingException {
        return (String)this.getLinkNameOrObject(true);
    }

    public Object getLinkObject() throws NamingException {
        return this.getLinkNameOrObject(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getLinkNameOrObject(boolean returnName) throws NamingException {
        String selectionPolicy;
        Hashtable env = (Hashtable)JNSContext.currentContextEnvironment.get();
        String string = selectionPolicy = env == null ? "locallinkPreference" : (String)env.get("jeus.jndi.clusterlink.selection-policy");
        if (selectionPolicy == null) {
            selectionPolicy = JeusJNDIProperties.DLR_PREFER_LOCAL_NODE ? "locallinkPreference" : "random";
        }
        try {
            if (selectionPolicy.equalsIgnoreCase("locallinkPreference") || selectionPolicy.equalsIgnoreCase("random")) {
                Object returnValue;
                if (selectionPolicy.equalsIgnoreCase("locallinkPreference")) {
                    Object returnValue2;
                    int linkSize;
                    ArrayList<String> localList = new ArrayList<String>();
                    ArrayList<String> localNodeList = new ArrayList<String>();
                    Vector<String> vector = this.links;
                    synchronized (vector) {
                        if (this.links.isEmpty()) {
                            throw new LinkException("There is no available link");
                        }
                        for (String string2 : this.links) {
                            if (!DynamicLinkRef.getClusterExportUrl(string2).equals(DynamicLinkRef.getLocalJndiServerUrl())) continue;
                            localNodeList.add(string2);
                            if (!containerId.equals(DynamicLinkRef.getContainerId(string2))) continue;
                            localList.add(string2);
                        }
                    }
                    if (location == 2 && (linkSize = localList.size()) > 0) {
                        String linkName;
                        if (linkSize == 1) {
                            linkName = (String)localList.get(0);
                        } else {
                            Random random = JEUSClusterContext.random;
                            synchronized (random) {
                                linkName = (String)localList.get(JEUSClusterContext.random.nextInt(linkSize));
                            }
                        }
                        Object object = this.lookupLinkObject("localhost", linkName);
                        if (object != null) {
                            if (returnName) {
                                return linkName;
                            }
                            return this.setClusterInfo(linkName, object);
                        }
                    }
                    if ((returnValue2 = this.selectLinkNameOrObject(returnName, localNodeList)) != null) {
                        return returnValue2;
                    }
                }
                if ((returnValue = this.selectLinkNameOrObject(returnName, this.getAvailableLinklist())) != null) {
                    return returnValue;
                }
                return this.checkFailedLinks(returnName);
            }
            if (selectionPolicy.equalsIgnoreCase("roundrobin")) {
                Object returnValue = this.selectLinkNameOrObjectByRoundRobin(returnName, this.getAvailableLinklist());
                if (returnValue != null) {
                    return returnValue;
                }
                return this.checkFailedLinks(returnName);
            }
        }
        catch (Throwable t) {
            if (!JNS.unitTestMode) {
                logger.log(JeusMessage_JNSCommon._11_LEVEL, JeusMessage_JNSCommon._11, t);
            }
            throw JNDIUtil.makeNamingException(t);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> getAvailableLinklist() throws LinkException {
        ArrayList<String> list = new ArrayList<String>();
        Vector<String> vector = this.links;
        synchronized (vector) {
            if (this.links.isEmpty()) {
                throw new LinkException("There is no available link");
            }
            for (String linkName : this.links) {
                String url = DynamicLinkRef.getClusterExportUrl(linkName);
                if (ClusterManager.isFailedServer(url)) continue;
                list.add(linkName);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object selectLinkNameOrObject(boolean returnName, ArrayList<String> list) {
        while (list.size() > 0) {
            Object object;
            int currentIndex;
            Random random = JEUSClusterContext.random;
            synchronized (random) {
                currentIndex = JEUSClusterContext.random.nextInt(list.size());
            }
            String linkName = list.get(currentIndex);
            String exportURL = DynamicLinkRef.getClusterExportUrl(linkName);
            if ((JNS.unitTestMode || !ClusterManager.isFailedServer(exportURL)) && (object = this.lookupLinkObject(linkName)) != null) {
                if (returnName) {
                    return linkName;
                }
                return this.setClusterInfo(linkName, object);
            }
            list.remove(currentIndex);
        }
        return null;
    }

    private Object selectLinkNameOrObjectByRoundRobin(boolean returnName, ArrayList<String> list) {
        int linkSize = list.size();
        for (int i = 0; i < linkSize; ++i) {
            Object object;
            ++this.roundRobinIndex;
            int currentIndex = this.roundRobinIndex % linkSize;
            String linkName = list.get(currentIndex);
            String exportURL = DynamicLinkRef.getClusterExportUrl(linkName);
            if (!JNS.unitTestMode && ClusterManager.isFailedServer(exportURL) || (object = this.lookupLinkObject(linkName)) == null) continue;
            if (returnName) {
                return linkName;
            }
            return this.setClusterInfo(linkName, object);
        }
        return null;
    }

    private Object lookupLinkObject(String name) {
        String exportUrl = DynamicLinkRef.getClusterExportUrl(name);
        return this.lookupLinkObject(exportUrl, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object lookupLinkObject(String exportUrl, String name) {
        if (JNS.unitTestMode) {
            return new Object();
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "jeus.jndi.JNSContextFactory");
        env.put("java.naming.provider.url", exportUrl);
        LoginUtil.loginCodeSubjectWithRuntimeException();
        try {
            JNSLocal localServer = JNSLocal.getLocalServer(env, true);
            DirService dirService = localServer.getDirService();
            Object object = dirService.lookup(name, true);
            if (object != null) {
                try {
                    if (object instanceof EJBHome) {
                        ((EJBHome)object).getEJBMetaData();
                    } else if (object instanceof BusinessHome) {
                        ((BusinessHome)object).ping();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Object var8_10 = null;
                    LoginUtil.logoutWithRuntimeException();
                    return var8_10;
                }
            }
            Object object2 = object;
            return object2;
        }
        catch (Exception ex) {
            if (logger.isLoggable(JeusMessage_JNSCommon._12_LEVEL)) {
                logger.log(JeusMessage_JNSCommon._12_LEVEL, JeusMessage_JNSCommon._12, exportUrl, (Throwable)ex);
            }
            Object var6_7 = null;
            return var6_7;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object checkFailedLinks(boolean returnName) throws LinkException {
        String[] linkNames;
        if (logger.isLoggable(JeusMessage_JNSCommon._13_LEVEL)) {
            logger.log(JeusMessage_JNSCommon._13_LEVEL, JeusMessage_JNSCommon._13);
        }
        Vector<String> vector = this.links;
        synchronized (vector) {
            linkNames = this.links.toArray(new String[this.links.size()]);
        }
        for (String linkName : linkNames) {
            String exportURL = DynamicLinkRef.getClusterExportUrl(linkName);
            ClusterManager.checkFailNode(exportURL);
            Object obj = this.lookupLinkObject(linkName);
            if (obj == null) continue;
            if (returnName) {
                return linkName;
            }
            return this.setClusterInfo(linkName, obj);
        }
        throw new LinkException("All link are failed to connect to JNDI Server");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addList(DynamicLinkRef obj) {
        Vector<String> targetLink = obj.links;
        if (logger.isLoggable(JeusMessage_JNSCommon._14_LEVEL)) {
            logger.log(JeusMessage_JNSCommon._14_LEVEL, JeusMessage_JNSCommon._14, targetLink);
        }
        Vector<String> vector = this.links;
        synchronized (vector) {
            for (int j = 0; j < targetLink.size(); ++j) {
                String _exportName = targetLink.elementAt(j);
                if (this.links.contains(_exportName)) continue;
                this.links.add(_exportName);
            }
        }
    }

    public boolean remove(String _exportName) {
        if (logger.isLoggable(JeusMessage_JNSCommon._15_LEVEL)) {
            logger.log(JeusMessage_JNSCommon._15_LEVEL, JeusMessage_JNSCommon._15, (Object)_exportName);
        }
        this.links.remove(_exportName);
        return this.links.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicate(String _exportName) {
        if (logger.isLoggable(JeusMessage_JNSCommon._16_LEVEL)) {
            logger.log(JeusMessage_JNSCommon._16_LEVEL, JeusMessage_JNSCommon._16, (Object)_exportName);
        }
        Vector<String> vector = this.links;
        synchronized (vector) {
            if (!this.links.contains(_exportName)) {
                this.links.add(_exportName);
            }
        }
    }

    public Object setClusterInfo(String exportName, Object obj) {
        InvocationHandler ih;
        if (obj instanceof JEUSClusterStub) {
            ((JEUSClusterStub)obj).__jeus_setCluster(exportName, this);
        } else if (obj instanceof Proxy && (ih = Proxy.getInvocationHandler(obj)) instanceof RemoteEJBHomeClientHandler) {
            RemoteEJBHomeClientHandler stub = (RemoteEJBHomeClientHandler)ih;
            stub.__jeus_setCluster(exportName, this);
        }
        return obj;
    }

    @Override
    public String toString() {
        return "DynamicLinkRef, links : " + this.links;
    }

    public Vector getLinks() {
        return this.links;
    }

    public static String getObjectId(String clusterLinkName) {
        if (clusterLinkName != null && clusterLinkName.startsWith(JEUS_CLUSTER_PREFIX)) {
            String s = clusterLinkName.substring(JEUS_CLUSTER_PREFIX.length());
            return s.substring(0, s.indexOf(JNDINAME_SEPARATOR));
        }
        return null;
    }

    public static String getContainerId(String clusterLinkName) {
        int index;
        String containerId = DynamicLinkRef.getObjectId(clusterLinkName);
        if (containerId != null && (index = containerId.indexOf(LOCALOBJECTID_SEPARATOR)) != -1) {
            containerId = containerId.substring(0, index);
        }
        return containerId;
    }

    public static String getClusterExportName(String clusterLinkName) {
        if (clusterLinkName != null && clusterLinkName.startsWith(JEUS_CLUSTER_PREFIX)) {
            String dynamicLinkName = clusterLinkName.substring(JEUS_CLUSTER_PREFIX.length());
            int addrIndex = dynamicLinkName.indexOf(CLUSTER_ADDR_PREFIX);
            dynamicLinkName = dynamicLinkName.substring(dynamicLinkName.indexOf(JNDINAME_SEPARATOR) + 1, addrIndex);
            return dynamicLinkName;
        }
        return null;
    }

    public static String getClusterExportUrl(String clusterLinkName) {
        int addrIndex;
        if (clusterLinkName != null && clusterLinkName.startsWith(JEUS_CLUSTER_PREFIX) && (addrIndex = clusterLinkName.indexOf(CLUSTER_ADDR_PREFIX)) != -1) {
            return clusterLinkName.substring(addrIndex + CLUSTER_ADDR_PREFIX.length());
        }
        return "localhost";
    }

    public static String getDynamicLinkExportName(String name) {
        if (name != null && name.startsWith(JEUS_LINK_PREFIX)) {
            String dynamicLinkName = name.substring(JEUS_LINK_PREFIX.length());
            int addrIndex = dynamicLinkName.indexOf(LINK_ITEM_PREFIX);
            dynamicLinkName = dynamicLinkName.substring(dynamicLinkName.indexOf(JNDINAME_SEPARATOR) + 1, addrIndex);
            return dynamicLinkName;
        }
        return null;
    }

    public static String getDynamicLinkItem(String name) {
        int addrIndex;
        if (name != null && name.startsWith(JEUS_LINK_PREFIX) && (addrIndex = name.indexOf(LINK_ITEM_PREFIX)) != -1) {
            return name.substring(addrIndex + LINK_ITEM_PREFIX.length());
        }
        return null;
    }

    public static String makeLinkName(String representativeName) {
        return "__jeus_link@remove_" + representativeName + LINK_ITEM_PREFIX + DynamicLinkRef.makeClusterLinkName(representativeName);
    }

    public static String makeClusterLinkName(String representativeName) {
        return DynamicLinkRef.makeClusterLinkName(null, representativeName);
    }

    public static String makeClusterLinkName(String localObjectId, String representativeName) {
        String objectId = containerId;
        if (localObjectId != null) {
            objectId = objectId + LOCALOBJECTID_SEPARATOR + localObjectId;
        }
        return JEUS_CLUSTER_PREFIX + objectId + JNDINAME_SEPARATOR + representativeName + CLUSTER_ADDR_PREFIX + DynamicLinkRef.getLocalJndiServerUrl();
    }

    private static String getLocalJndiServerUrl() {
        if (jndiServerUrl == null) {
            String host = JeusEJBProperties.USE_IP_FOR_DYNAMIC_REF ? JeusNetPropertyValues.LOCAL_HOSTADDRESS : JeusNetPropertyValues.LOCAL_HOSTNAME;
            jndiServerUrl = HostInfo.composeServerAddress(host, JeusPort.JeusBase);
        }
        return jndiServerUrl;
    }

    static {
        containerId = String.valueOf(JeusManagerPropertyValues.containerID);
    }
}

