/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.local;

import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import jeus.jndi.jns.common.ClusterManager;
import jeus.jndi.jns.common.JNS;
import jeus.jndi.jns.common.Message;
import jeus.jndi.jns.common.NamingServerException;
import jeus.jndi.jns.local.DirService;
import jeus.jndi.jns.local.JNSLocalConnection;
import jeus.jndi.jns.local.JNSLocalConnectionImpl;
import jeus.net.impl.NodeInfo;
import jeus.util.ErrorMsgManager;
import jeus.util.HostInfo;
import jeus.util.JeusPort;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JNDI;
import jeus.util.message.JeusMessage_JNSLocal;
import jeus.util.properties.JeusJNDIProperties;
import jeus.util.properties.JeusNetPropertyValues;

public class JNSLocal
extends JNS {
    private DirService dirService;
    private NodeInfo localServerID;
    private AtomicBoolean running = new AtomicBoolean();
    private static final Map<NodeInfo, JNSLocal> localServerTable = new ConcurrentHashMap<NodeInfo, JNSLocal>();
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.jndi");
    private JNSLocalConnection jnsLocalConnection;
    private boolean enableCache = true;
    private int connectTimeout;
    private int socketReadTimeout;
    private static final Map<NodeInfo, ReentrantLock> nodeInfoLockMap = new ConcurrentHashMap<NodeInfo, ReentrantLock>();
    public static final int JNDI_PROTOCOL_VERSION = 1;
    public static final String LOCAL_CONNECTION_IMPL_CLASS = "jeus.jndi.jns.localconnection.impl";

    private JNSLocal(NodeInfo nodeInfo, Hashtable table) throws NamingServerException {
        this.localServerID = nodeInfo;
        if (table != null) {
            String value = (String)table.get("jeus.jndi.enable.cache");
            if ("false".equalsIgnoreCase(value)) {
                this.enableCache = false;
            } else if ("false".equalsIgnoreCase(System.getProperty("jeus.jndi.enable.cache"))) {
                this.enableCache = false;
            }
            this.connectTimeout = this.getTimeout(table, "jeus.jndi.jns.connecttimeout");
            this.socketReadTimeout = this.getTimeout(table, "jeus.jndi.jns.connectionduration");
            Object conn = table.get(LOCAL_CONNECTION_IMPL_CLASS);
            if (conn != null) {
                this.jnsLocalConnection = (JNSLocalConnection)conn;
            }
        }
        this.dirService = new DirService(this, this.enableCache);
        if (this.jnsLocalConnection == null) {
            this.jnsLocalConnection = new JNSLocalConnectionImpl(this, this.connectTimeout, this.socketReadTimeout, this.localServerID);
        }
        if (logger.isLoggable(JeusMessage_JNSLocal._40_LEVEL)) {
            logger.log(JeusMessage_JNSLocal._40_LEVEL, JeusMessage_JNSLocal._40);
        }
    }

    private int getTimeout(Hashtable table, String key) throws NamingServerException {
        String value = (String)table.get(key);
        if (value == null && (value = System.getProperty(key)) == null) {
            return 0;
        }
        try {
            int timeout = Integer.parseInt(value);
            if (timeout < 0) {
                throw new NamingServerException(key + " cannot be negative");
            }
            return timeout;
        }
        catch (NumberFormatException e) {
            throw new NamingServerException("invalid value " + value + " for " + key);
        }
    }

    public DirService getDirService() {
        return this.dirService;
    }

    public JNSLocalConnection getLocalConnection() {
        return this.jnsLocalConnection;
    }

    public static JNSLocal getLocalServer() throws NamingServerException {
        int port = JeusJNDIProperties.USE_SSL ? JeusPort.JNDI_SSL : JeusPort.JeusBase;
        NodeInfo nodeInfo = new NodeInfo(JeusNetPropertyValues.LOCAL_LOOPBACK_ADDRESS, port, "JNSServer", 0);
        return JNSLocal.getLocalServer(nodeInfo, null, false);
    }

    public static JNSLocal getLocalServer(Hashtable table) throws NamingServerException, UnknownHostException {
        return JNSLocal.getLocalServer(table, false);
    }

    public static JNSLocal getLocalServer(Hashtable table, boolean checkFailList) throws NamingServerException, UnknownHostException {
        String serverUrl = (String)table.get("java.naming.provider.url");
        String serverAddress = JeusNetPropertyValues.LOCAL_LOOPBACK_ADDRESS;
        int serverPort = JeusPort.JeusBase;
        if (serverUrl != null && !serverUrl.equals("")) {
            HostInfo hostInfo = HostInfo.fromServerAddressToHostInfo(serverUrl);
            serverAddress = hostInfo.getHostname();
            serverPort = hostInfo.getPort();
        }
        serverAddress = JeusNetPropertyValues.getByName(serverAddress).getHostAddress();
        serverPort = JeusJNDIProperties.USE_SSL ? JeusPort.JNDI_SSL : serverPort;
        NodeInfo nodeInfo = new NodeInfo(serverAddress, serverPort, "JNSServer", 0);
        return JNSLocal.getLocalServer(nodeInfo, table, checkFailList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JNSLocal getLocalServer(NodeInfo nodeInfo, Hashtable table, boolean checkFailList) throws NamingServerException {
        JNSLocal localServer = localServerTable.get(nodeInfo);
        if (localServer == null) {
            ReentrantLock lock;
            if (checkFailList && ClusterManager.isFailedServer(nodeInfo.getHost(), nodeInfo.getBasePort())) {
                throw new NamingServerException("The target JNDI Server [" + HostInfo.composeServerAddress(nodeInfo.getHost(), nodeInfo.getBasePort()) + "] is in the fail list");
            }
            Map<NodeInfo, ReentrantLock> map = nodeInfoLockMap;
            synchronized (map) {
                lock = nodeInfoLockMap.get(nodeInfo);
                if (lock == null) {
                    lock = new ReentrantLock();
                    nodeInfoLockMap.put(nodeInfo, lock);
                }
            }
            try {
                lock.lockInterruptibly();
            }
            catch (InterruptedException e) {
                throw new NamingServerException("the current thread is interrupted", e);
            }
            try {
                block14: {
                    try {
                        localServer = localServerTable.get(nodeInfo);
                        if (localServer != null) break block14;
                        if (checkFailList && ClusterManager.isFailedServer(nodeInfo.getHost(), nodeInfo.getBasePort())) {
                            throw new NamingServerException("The target JNDI Server [" + HostInfo.composeServerAddress(nodeInfo.getHost(), nodeInfo.getBasePort()) + "] is in the fail list");
                        }
                        localServer = new JNSLocal(nodeInfo, table);
                        localServer.startup();
                        localServerTable.put(nodeInfo, localServer);
                        if (!logger.isLoggable(JeusMessage_JNSLocal._146_LEVEL)) break block14;
                        logger.log(JeusMessage_JNSLocal._146_LEVEL, JeusMessage_JNSLocal._146, (Object)nodeInfo);
                    }
                    catch (NamingServerException e) {
                        if (checkFailList) {
                            ClusterManager.addFailList(nodeInfo.getHost(), nodeInfo.getBasePort());
                        }
                        throw e;
                    }
                }
                Object var8_9 = null;
                lock.unlock();
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                lock.unlock();
                throw throwable;
            }
        }
        return localServer;
    }

    protected void startup() throws NamingServerException {
        this.running.set(true);
        if (logger.isLoggable(JeusMessage_JNSLocal._4_LEVEL)) {
            logger.log(JeusMessage_JNSLocal._4_LEVEL, JeusMessage_JNSLocal._4, (Object)this.localServerID);
        }
        try {
            this.jnsLocalConnection.openConnection();
            if (logger.isLoggable(JeusMessage_JNSLocal._5_LEVEL)) {
                logger.log(JeusMessage_JNSLocal._5_LEVEL, JeusMessage_JNSLocal._5, new Object[]{this, this.jnsLocalConnection});
            }
        }
        catch (Exception e) {
            logger.logp(JeusMessage_JNSLocal._6_LEVEL, "JNSLocal", "startup", JeusMessage_JNSLocal._6, (Throwable)e);
            if (logger.isLoggable(JeusMessage_JNDI._74_LEVEL)) {
                logger.log(JeusMessage_JNDI._74_LEVEL, JeusMessage_JNDI._74, new Object[]{"exception occured during JNSLocal startup"});
            }
            this.cancel();
            throw new NamingServerException(ErrorMsgManager.getLocalizedString(JeusMessage_JNSLocal._18));
        }
    }

    public Message sendMessage(Message req) throws Exception {
        return this.jnsLocalConnection.sendMessage(req);
    }

    public static void down() {
        JNSLocal[] locals;
        for (JNSLocal local : locals = localServerTable.values().toArray(new JNSLocal[0])) {
            if (logger.isLoggable(JeusMessage_JNDI._74_LEVEL)) {
                logger.log(JeusMessage_JNDI._74_LEVEL, JeusMessage_JNDI._74, new Object[]{"all JNSLocal down is requested"});
            }
            local.cancel();
        }
    }

    public static synchronized void down(String serverName) {
        HostInfo hostInfo = HostInfo.fromServerAddressToHostInfo(serverName);
        String hostName = hostInfo.getHostname();
        try {
            hostName = JeusNetPropertyValues.getByName(hostName).getHostName();
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        NodeInfo nodeInfo = new NodeInfo(hostName, hostInfo.getPort(), "JNSServer", 0);
        JNSLocal jnsLocal = localServerTable.remove(nodeInfo);
        if (jnsLocal != null) {
            if (logger.isLoggable(JeusMessage_JNSLocal._7_LEVEL)) {
                logger.log(JeusMessage_JNSLocal._7_LEVEL, JeusMessage_JNSLocal._7, (Object)nodeInfo);
            }
            if (logger.isLoggable(JeusMessage_JNDI._74_LEVEL)) {
                logger.log(JeusMessage_JNDI._74_LEVEL, JeusMessage_JNDI._74, new Object[]{"JNSLocal down is requested"});
            }
            jnsLocal.cancel();
        } else if (logger.isLoggable(JeusMessage_JNSLocal._8_LEVEL)) {
            logger.log(JeusMessage_JNSLocal._8_LEVEL, JeusMessage_JNSLocal._8, (Object)nodeInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void cancel() {
        if (!this.running.compareAndSet(true, false)) return;
        if (logger.isLoggable(JeusMessage_JNSLocal._9_LEVEL)) {
            logger.log(JeusMessage_JNSLocal._9_LEVEL, JeusMessage_JNSLocal._9, (Object)this.localServerID);
        }
        try {
            try {
                this.jnsLocalConnection.closeConnection();
                if (logger.isLoggable(JeusMessage_JNSLocal._10_LEVEL)) {
                    logger.log(JeusMessage_JNSLocal._10_LEVEL, JeusMessage_JNSLocal._10, new Object[]{this, this.jnsLocalConnection});
                }
                this.dirService.destroy();
            }
            catch (Exception e) {
                logger.log(JeusMessage_JNSLocal._11_LEVEL, JeusMessage_JNSLocal._11, (Throwable)e);
                Object var3_2 = null;
                localServerTable.remove(this.localServerID);
                nodeInfoLockMap.remove(this.localServerID);
                if (!logger.isLoggable(JeusMessage_JNSLocal._12_LEVEL)) return;
                logger.log(JeusMessage_JNSLocal._12_LEVEL, JeusMessage_JNSLocal._12, (Object)this.localServerID);
                return;
            }
            Object var3_1 = null;
            localServerTable.remove(this.localServerID);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            localServerTable.remove(this.localServerID);
            nodeInfoLockMap.remove(this.localServerID);
            if (!logger.isLoggable(JeusMessage_JNSLocal._12_LEVEL)) throw throwable;
            logger.log(JeusMessage_JNSLocal._12_LEVEL, JeusMessage_JNSLocal._12, (Object)this.localServerID);
            throw throwable;
        }
        nodeInfoLockMap.remove(this.localServerID);
        if (!logger.isLoggable(JeusMessage_JNSLocal._12_LEVEL)) return;
        logger.log(JeusMessage_JNSLocal._12_LEVEL, JeusMessage_JNSLocal._12, (Object)this.localServerID);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public static JeusLogger getLogger() {
        return logger;
    }
}

