/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.local;

import java.io.IOException;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import jeus.io.helper.JeusIOComponentCreator;
import jeus.jndi.io.JndiContentHandlerCreator;
import jeus.jndi.jns.common.Message;
import jeus.jndi.jns.local.JNSLocal;
import jeus.jndi.jns.local.JNSLocalConnection;
import jeus.jndi.jns.local.JNSLocalConnectionListener;
import jeus.net.ConnectionListener;
import jeus.net.ConnectionListenerFactory;
import jeus.net.ConnectorException;
import jeus.net.Endpoint;
import jeus.net.JeusSSLConfiguration;
import jeus.net.NoListenID;
import jeus.net.ReplyListener;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.net.helper.MsgSync;
import jeus.net.impl.NodeInfo;
import jeus.util.JeusRuntimeException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JNDI;
import jeus.util.message.JeusMessage_JNSLocal;
import jeus.util.properties.JeusJNDIProperties;
import jeus.util.properties.JeusNodeClusterProperties;

public class JNSLocalConnectionImpl
implements JNSLocalConnection {
    private static Endpoint connector;
    private SocketStream socketStream;
    private static Map<NodeInfo, JNSLocal> jnsLocalMap;
    private int connectTimeout;
    private int socketReadTimeout;
    private NodeInfo serverID;
    private static final JeusLogger logger;

    public JNSLocalConnectionImpl(JNSLocal jnsLocal, int connectTimeout, int socketReadTimeout, NodeInfo serverID) {
        this.connectTimeout = connectTimeout;
        this.socketReadTimeout = socketReadTimeout;
        this.serverID = serverID;
        jnsLocalMap.put(serverID, jnsLocal);
    }

    public void openConnection() throws ConnectorException {
        this.socketStream = connector.getSocketStream(this.serverID, JeusNodeClusterProperties.TERMINAL_CLUSTERING_RETRY_COUNT, 1, this.connectTimeout, this.socketReadTimeout);
    }

    public Message sendMessage(Message req) throws NamingException {
        MsgSync sync = new MsgSync(JeusJNDIProperties.JNDI_WAIT_TIME_OUT);
        try {
            if (this.isConnectionClosed()) {
                throw new IOException("JNSLocal connection is closed");
            }
            this.socketStream.write(req, (ReplyListener)sync);
            Object obj = null;
            try {
                obj = sync.waitReply();
                return (Message)obj;
            }
            catch (ClassCastException npe) {
                if (obj != null) {
                    if (logger.isLoggable(JeusMessage_JNSLocal._141_LEVEL)) {
                        logger.log(JeusMessage_JNSLocal._141_LEVEL, JeusMessage_JNSLocal._141, new Object[]{obj, obj.getClass(), obj.getClass().getClassLoader()});
                    }
                } else if (logger.isLoggable(JeusMessage_JNSLocal._142_LEVEL)) {
                    logger.log(JeusMessage_JNSLocal._142_LEVEL, JeusMessage_JNSLocal._142);
                }
                npe.printStackTrace();
                throw npe;
            }
        }
        catch (NullPointerException npe) {
            logger.log(JeusMessage_JNSLocal._143_LEVEL, JeusMessage_JNSLocal._143, (Throwable)npe);
            throw new NamingException("service is alreay stopped");
        }
        catch (Exception e) {
            JNSLocal jnsLocal;
            if (logger.isLoggable(JeusMessage_JNSLocal._144_LEVEL)) {
                logger.log(JeusMessage_JNSLocal._144_LEVEL, JeusMessage_JNSLocal._144, (Throwable)e);
            }
            if (logger.isLoggable(JeusMessage_JNDI._74_LEVEL)) {
                logger.log(JeusMessage_JNDI._74_LEVEL, JeusMessage_JNDI._74, new Object[]{"exception occured during sending"});
            }
            if ((jnsLocal = jnsLocalMap.get(this.serverID)) != null) {
                jnsLocal.cancel();
            }
            return new Message(402, null, (Object)e, null);
        }
    }

    public void closeConnection() {
        if (this.socketStream != null) {
            this.socketStream.destroy();
        }
        jnsLocalMap.remove(this.serverID);
    }

    public boolean isConnectionClosed() {
        return this.socketStream == null || this.socketStream.isClosed();
    }

    static {
        jnsLocalMap = new ConcurrentHashMap<NodeInfo, JNSLocal>();
        logger = JNSLocal.getLogger();
        String name = "JNSLocal";
        connector = new Endpoint(name, JeusIOComponentCreator.createSocketBlockingCreator("IO-" + name, 0), (SocketID)new NoListenID(), new JndiContentHandlerCreator(), new ConnectionListenerFactory(){

            public ConnectionListener createConnectionListener(Socket socket, SocketID socketID) {
                return new JNSLocalConnectionListener((JNSLocal)jnsLocalMap.get(socketID));
            }
        }, JeusJNDIProperties.USE_SSL ? JeusSSLConfiguration.sslContext : null);
        try {
            connector.export();
        }
        catch (IOException e) {
            throw new JeusRuntimeException(e);
        }
    }
}

