/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.local;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import jeus.jndi.jns.common.Message;
import jeus.jndi.jns.local.DirService;
import jeus.jndi.jns.local.JNSLocal;
import jeus.net.ConnectionListener;
import jeus.net.SocketStream;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JNDI;
import jeus.util.message.JeusMessage_JNSLocal;

public class JNSLocalConnectionListener
implements ConnectionListener {
    private JNSLocal jnsLocal;
    private static JeusLogger logger = JNSLocal.getLogger();

    public JNSLocalConnectionListener(JNSLocal jnsLocal) {
        this.jnsLocal = jnsLocal;
    }

    public void connectionConnected(SocketStream sockStream) throws SocketException {
    }

    public void connectionAccepted(SocketStream sockStream, int connectionType, Object piggybackedData) throws Exception {
    }

    public void runDelegatedTask(Runnable messageProcessor, boolean isReplyPacket, Object message) {
        messageProcessor.run();
    }

    public Object getPiggybackData(int msgType, SocketStream sockStream, Object piggybackedData) {
        return piggybackedData;
    }

    public void writeDone(SocketStream sockStream) {
    }

    public void receiveMessage(Object msg, SocketStream sockStream, Object controlInfo) throws Exception {
        block4: {
            try {
                if (logger.isLoggable(JeusMessage_JNSLocal._41_LEVEL)) {
                    logger.log(JeusMessage_JNSLocal._41_LEVEL, JeusMessage_JNSLocal._41, msg);
                }
                this.handle((Message)msg);
            }
            catch (Exception e) {
                logger.logp(JeusMessage_JNSLocal._46_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._46, (Throwable)e);
                logger.logp(JeusMessage_JNSLocal._43_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._43);
                logger.logp(JeusMessage_JNSLocal._44_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._44, (Object)this.toString());
                sockStream.destroy();
                if (logger.isLoggable(JeusMessage_JNDI._74_LEVEL)) {
                    logger.log(JeusMessage_JNDI._74_LEVEL, JeusMessage_JNDI._74, new Object[]{"exception occured during receiving"});
                }
                if (this.jnsLocal == null) break block4;
                this.jnsLocal.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(Exception exception, SocketStream socketStream) {
        try {
            if (exception != null) {
                if (exception instanceof ClassNotFoundException) {
                    logger.logp(JeusMessage_JNSLocal._42_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._42, (Throwable)exception);
                    logger.logp(JeusMessage_JNSLocal._43_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._43);
                    logger.logp(JeusMessage_JNSLocal._44_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._44, (Object)this);
                } else if (exception instanceof SocketException) {
                    logger.logp(JeusMessage_JNSLocal._61_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._61, (Throwable)exception);
                    logger.logp(JeusMessage_JNSLocal._43_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._43);
                    logger.logp(JeusMessage_JNSLocal._44_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._44, (Object)this);
                } else if (exception instanceof EOFException) {
                    logger.logp(JeusMessage_JNSLocal._43_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._43);
                    logger.logp(JeusMessage_JNSLocal._44_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._44, (Object)this);
                } else if (exception instanceof IOException) {
                    logger.logp(JeusMessage_JNSLocal._45_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._45, (Throwable)exception);
                    logger.logp(JeusMessage_JNSLocal._44_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._44, (Object)this);
                    logger.logp(JeusMessage_JNSLocal._63_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._63);
                } else {
                    logger.logp(JeusMessage_JNSLocal._46_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._46, (Throwable)exception);
                    logger.logp(JeusMessage_JNSLocal._43_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._43);
                    logger.logp(JeusMessage_JNSLocal._44_LEVEL, "Receiver", "dispatchMsg", JeusMessage_JNSLocal._44, (Object)this);
                }
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (logger.isLoggable(JeusMessage_JNDI._74_LEVEL)) {
                logger.log(JeusMessage_JNDI._74_LEVEL, JeusMessage_JNDI._74, new Object[]{"ConnectionClosed is requested"});
            }
            if (this.jnsLocal != null) {
                this.jnsLocal.cancel();
            }
            throw throwable;
        }
        if (logger.isLoggable(JeusMessage_JNDI._74_LEVEL)) {
            logger.log(JeusMessage_JNDI._74_LEVEL, JeusMessage_JNDI._74, new Object[]{"ConnectionClosed is requested"});
        }
        if (this.jnsLocal != null) {
            this.jnsLocal.cancel();
        }
    }

    private void handle(Message msg) {
        int msgType = msg.getType();
        if (this.jnsLocal == null) {
            logger.log(JeusMessage_JNSLocal._145_LEVEL, JeusMessage_JNSLocal._145);
            return;
        }
        DirService dirService = this.jnsLocal.getDirService();
        if (dirService == null) {
            logger.log(JeusMessage_JNSLocal._145_LEVEL, JeusMessage_JNSLocal._145);
            return;
        }
        block3 : switch (msgType) {
            case 3: {
                throw new RuntimeException();
            }
            case 405: {
                try {
                    dirService.dispatchEvent(msg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 2: {
                int opcode = msg.getCode();
                Object first = msg.get(0);
                Object second = msg.get(1);
                switch (opcode) {
                    case 301: {
                        try {
                            dirService.replicate((String)first, second);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break block3;
                    }
                    case 303: {
                        try {
                            dirService.drop((String)first);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break block3;
                    }
                }
                break;
            }
        }
    }
}

