/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.local;

import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.event.NamingListener;
import jeus.jndi.jns.common.Environment;
import jeus.jndi.jns.common.Message;
import jeus.jndi.jns.local.JNSLocal;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JNSLocal;

public class Service {
    protected JNSLocal jnsLocal;
    protected ConcurrentHashMap<String, Object> bindingCache;
    protected ConcurrentHashMap<String, Object> envCache;
    protected static ConcurrentHashMap<String, Object> localBindingRepository = new ConcurrentHashMap(100);
    protected static ConcurrentHashMap<String, Object> localEnvRepository = new ConcurrentHashMap(100);
    protected ConcurrentHashMap<Integer, NamingListener> listenerTable = new ConcurrentHashMap(20);
    protected ConcurrentHashMap<NamingListener, Integer> listenerReverseTable = new ConcurrentHashMap(20);
    protected int listenerID;
    protected static final JeusLogger logger = JNSLocal.getLogger();

    public Service(JNSLocal jnsLocal) {
        this.bindingCache = new ConcurrentHashMap(100);
        this.envCache = new ConcurrentHashMap(100);
        this.jnsLocal = jnsLocal;
    }

    public void destroy() {
        this.bindingCache.clear();
        this.envCache.clear();
        this.listenerTable.clear();
        this.listenerReverseTable.clear();
    }

    public static void clearLocalBindings() {
        localBindingRepository.clear();
        localEnvRepository.clear();
    }

    protected void addCache(String name, Object obj, Object env) {
        if (this.bindingCache != null) {
            if (env == null) {
                env = Environment.defaultEnv;
            }
            if (name != null && obj != null) {
                this.bindingCache.put(name, obj);
                this.envCache.put(name, env);
            }
        }
    }

    public Object removeCache(String name) {
        if (this.bindingCache != null) {
            this.envCache.remove(name);
            return this.bindingCache.remove(name);
        }
        return null;
    }

    protected void addRepository(String name, Object obj, Object env) {
        if (env == null) {
            env = Environment.defaultEnv;
        }
        if (name != null && obj != null) {
            localBindingRepository.put(name, obj);
            localEnvRepository.put(name, env);
        }
    }

    protected Object removeRepository(String name) {
        localEnvRepository.remove(name);
        return localBindingRepository.remove(name);
    }

    protected Message sendMessage(Message req) throws Exception {
        return this.jnsLocal.sendMessage(req);
    }

    protected boolean isJNSConnectionClosed() {
        return this.jnsLocal.getLocalConnection().isConnectionClosed();
    }

    public synchronized Integer getNextListenerID() {
        ++this.listenerID;
        if (this.listenerID == Integer.MAX_VALUE) {
            this.listenerID = 0;
        }
        return this.listenerID;
    }

    public String getKey(String str) {
        if (str.startsWith("//")) {
            return str.substring(str.indexOf(47, 2) + 1);
        }
        return str;
    }

    public void print() {
        if (logger.isLoggable(JeusMessage_JNSLocal._47_LEVEL)) {
            logger.log(JeusMessage_JNSLocal._47_LEVEL, JeusMessage_JNSLocal._47);
        }
        Enumeration<String> e = this.bindingCache.keys();
        while (e.hasMoreElements()) {
            String nm = e.nextElement();
            if (!logger.isLoggable(JeusMessage_JNSLocal._48_LEVEL)) continue;
            logger.log(JeusMessage_JNSLocal._48_LEVEL, JeusMessage_JNSLocal._48, (Object[])new String[]{nm, this.bindingCache.get(nm).getClass().getName()});
        }
        if (logger.isLoggable(JeusMessage_JNSLocal._49_LEVEL)) {
            logger.log(JeusMessage_JNSLocal._49_LEVEL, JeusMessage_JNSLocal._49);
        }
    }

    public void print2() {
        if (logger.isLoggable(JeusMessage_JNSLocal._47_LEVEL)) {
            logger.log(JeusMessage_JNSLocal._47_LEVEL, JeusMessage_JNSLocal._47);
        }
        Enumeration<String> e = this.bindingCache.keys();
        while (e.hasMoreElements()) {
            String nm = e.nextElement();
            if (!logger.isLoggable(JeusMessage_JNSLocal._50_LEVEL)) continue;
            logger.log(JeusMessage_JNSLocal._50_LEVEL, JeusMessage_JNSLocal._50, (Object)nm);
        }
        if (logger.isLoggable(JeusMessage_JNSLocal._49_LEVEL)) {
            logger.log(JeusMessage_JNSLocal._49_LEVEL, JeusMessage_JNSLocal._49);
        }
    }
}

