/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.jns.url.java;

import java.util.Hashtable;
import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.ServiceUnavailableException;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ResolveResult;
import jeus.client.container.AppClientClassLoader;
import jeus.corba.ORBManager;
import jeus.jndi.JNSContext;
import jeus.jndi.jns.common.JNS;
import jeus.jndi.jns.local.JNSLocal;
import jeus.jndi.jns.url.java.ReadOnlyContext;
import jeus.transaction.TxHelper;
import jeus.util.ErrorMsgManager;
import jeus.util.ExecutionContext;
import jeus.util.message.JeusMessage_JNDI;
import jeus.workarea.WorkAreaServiceHelper;

public class JavaURLContext
implements Context {
    public static final String USERTRANSACTION_URL = "java:comp/UserTransaction";
    public static final String ORB_URL = "java:comp/ORB";
    public static final String HANDLEDELEGATE_URL = "java:comp/HandleDelegate";
    public static final String TRANSACTIONMANAGER_URL = "java:/TransactionManager";
    public static final String GLASSFISH_TRANSACTIONMANAGER_URL = "java:appserver/TransactionManager";
    public static final String WSIT_TRANSACTIONMANAGER_URL = "java:wsit/TransactionManager";
    public static final String EJBCONTEXT_URL = "java:comp/EJBContext";
    public static final String TIMERSERVICE_URL = "java:comp/TimerService";
    public static final String TSR_URL = "java:comp/TransactionSynchronizationRegistry";
    public static final String USERWORKAREA_URL = "java:comp/UserWorkArea";
    protected Hashtable myEnv;

    public JavaURLContext(Hashtable env) {
        this.myEnv = env;
    }

    protected ResolveResult getRootURLContext(String url, Hashtable env) throws NamingException {
        String objName;
        boolean j2eeRef = true;
        if (!url.startsWith("java:")) {
            throw new IllegalArgumentException(url + " is not a Java URL");
        }
        if (url.equals(USERTRANSACTION_URL)) {
            objName = "UserTransaction";
        } else if (url.equals(ORB_URL)) {
            objName = "ORB";
        } else if (url.equals(HANDLEDELEGATE_URL)) {
            objName = "HandleDelegate";
        } else {
            j2eeRef = false;
            String string = objName = url.length() > 5 ? url.substring(5) : null;
        }
        if (objName != null && objName.startsWith("comp/env")) {
            j2eeRef = true;
            objName = objName.length() > 9 ? objName.substring(9) : null;
        }
        CompositeName remaining = objName != null ? new CompositeName(objName) : new CompositeName();
        try {
            JNSContext ctx = j2eeRef ? new JNSContext(JNSLocal.getLocalServer(env), env, this.getENCJndiPrefix()) : new JNSContext(JNSLocal.getLocalServer(env), env, "");
            return new ResolveResult((Object)ctx, remaining);
        }
        catch (Exception e) {
            throw new ServiceUnavailableException("Naming Server is not avail.");
        }
    }

    protected String getENCJndiPrefix() {
        return ExecutionContext.getExecutionContext().getENCJndiPrefix();
    }

    protected Context getContinuationContext(Name n) throws NamingException {
        Object obj = this.lookup(n.get(0));
        CannotProceedException cpe = new CannotProceedException();
        cpe.setResolvedObj(obj);
        cpe.setEnvironment(this.myEnv);
        return NamingManager.getContinuationContext(cpe);
    }

    public Object lookup(String name) throws NamingException {
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        Context ctx = (Context)res.getResolvedObj();
        if (name.equals(USERTRANSACTION_URL)) {
            return this.getUserTransaction();
        }
        if (name.equals(ORB_URL)) {
            return ORBManager.getORBForNaming(JNS.getLocation() != 0);
        }
        if (name.equals(USERWORKAREA_URL)) {
            return WorkAreaServiceHelper.getUserWorkArea();
        }
        if (name.equals(HANDLEDELEGATE_URL)) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class handleDelegateClass = loader instanceof AppClientClassLoader ? ((AppClientClassLoader)loader).loadClassWithoutDelegation("jeus.ejb.bean.HandleDelegateImplFor5", false) : loader.loadClass("jeus.ejb.bean.HandleDelegateImplFor5");
                return handleDelegateClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals(TRANSACTIONMANAGER_URL) || name.equals(GLASSFISH_TRANSACTIONMANAGER_URL)) {
            return TxHelper.getTransactionManager();
        }
        if (name.equals(WSIT_TRANSACTIONMANAGER_URL)) {
            return this.getWSITTransactionManager();
        }
        if (name.equals(TSR_URL)) {
            return TxHelper.getTransactionSynchronizationRegistry();
        }
        if (name.equals(EJBCONTEXT_URL)) {
            return this.getEJBContext();
        }
        if (name.equals(TIMERSERVICE_URL)) {
            return this.getTimerService();
        }
        if (res.getRemainingName().isEmpty()) {
            return new ReadOnlyContext(ctx);
        }
        try {
            return ctx.lookup(res.getRemainingName());
        }
        catch (NameNotFoundException nnfe) {
            NameNotFoundException newex = new NameNotFoundException(ErrorMsgManager.getLocalizedString(JeusMessage_JNDI._5, name));
            newex.initCause(nnfe);
            throw newex;
        }
    }

    protected Object getTimerService() throws NameNotFoundException {
        throw new NameNotFoundException("java:comp/TimerService is not available");
    }

    protected Object getEJBContext() throws NameNotFoundException {
        throw new NameNotFoundException("java:comp/EJBContext is not available");
    }

    protected Object getWSITTransactionManager() throws NameNotFoundException {
        throw new NameNotFoundException("java:wsit/TransactionManager is not available");
    }

    protected Object getUserTransaction() {
        return TxHelper.getUserTransaction();
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public void bind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void bind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(Name name, Name newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration list(String name) throws NamingException {
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        Context ctx = (Context)res.getResolvedObj();
        return ctx.list(res.getRemainingName());
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.list(name.get(0));
        }
        Context ctx = this.getContinuationContext(name);
        return ctx.list(name.getSuffix(1));
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        Context ctx = (Context)res.getResolvedObj();
        return ctx.listBindings(res.getRemainingName());
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.listBindings(name.get(0));
        }
        Context ctx = this.getContinuationContext(name);
        return ctx.listBindings(name.getSuffix(1));
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object lookupLink(String name) throws NamingException {
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        Context ctx = (Context)res.getResolvedObj();
        return ctx.lookupLink(res.getRemainingName());
    }

    public Object lookupLink(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.lookupLink(name.get(0));
        }
        Context ctx = this.getContinuationContext(name);
        return ctx.lookupLink(name.getSuffix(1));
    }

    public NameParser getNameParser(String name) throws NamingException {
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        Context ctx = (Context)res.getResolvedObj();
        return ctx.getNameParser(res.getRemainingName());
    }

    public NameParser getNameParser(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.getNameParser(name.get(0));
        }
        Context ctx = this.getContinuationContext(name);
        return ctx.getNameParser(name.getSuffix(1));
    }

    public String composeName(String name, String prefix) throws NamingException {
        if (prefix.equals("")) {
            return name;
        }
        if (name.equals("")) {
            return prefix;
        }
        return prefix + "/" + name;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public String getNameInNamespace() throws NamingException {
        return "";
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        this.myEnv = this.myEnv == null ? new Hashtable(11, 0.75f) : this.myEnv;
        return this.myEnv.put(propName, propVal);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            return new Hashtable(5, 0.75f);
        }
        return (Hashtable)this.myEnv.clone();
    }

    public void close() throws NamingException {
    }
}

