/*
 * Decompiled with CFR 0.152.
 */
package jeus.jndi.objectfactory;

import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import jeus.util.JeusException;
import jeus.util.JeusPort;
import jeus.util.message.JeusMessage_Util;
import jeus.util.properties.JeusNetPropertyValues;
import org.omg.CORBA.ORB;

public class CosNamingResourceFactory
implements ObjectFactory {
    public static final String urlServer = JeusNetPropertyValues.LOCAL_HOSTNAME + ":" + JeusPort.cosNameServer;

    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env) throws Exception {
        try {
            Reference ref = (Reference)obj;
            InitialContext cosnaming = CosNamingResourceFactory.getCNCtx((String)ref.get(0).getContent());
            String exportName = (String)ref.get(1).getContent();
            Object obj1 = cosnaming.lookup(exportName);
            return obj1;
        }
        catch (Throwable t) {
            throw new JeusException(JeusMessage_Util._24, t);
        }
    }

    public static InitialContext getCNCtx() throws NamingException {
        return CosNamingResourceFactory.getCNCtx(urlServer);
    }

    public static InitialContext getCNCtx(String address) throws NamingException {
        ORB orb = CosNamingResourceFactory.getORB();
        Properties iiopProps = new Properties();
        iiopProps.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
        iiopProps.put("java.naming.provider.url", "iiop://" + address);
        iiopProps.put("java.naming.corba.orb", orb);
        InitialContext ctx = new InitialContext(iiopProps);
        return ctx;
    }

    public static ORB getORB() throws NamingException {
        InitialContext ctx = new InitialContext();
        ORB orb = (ORB)ctx.lookup("java:comp/ORB");
        return orb;
    }
}

