/*
 * Decompiled with CFR 0.152.
 */
package jeus.management;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.StringValueExp;
import javax.management.ValueExp;
import jeus.management.util.StringUtil;
import jeus.server.service.ContainerManagerServiceMBean;
import jeus.util.IllegalJeusSystemNameException;
import jeus.util.JeusRuntimeException;
import jeus.util.message.JeusMessage_JMX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXUtility {
    public static ObjectName nodeObjectName;

    public static String[] getAsStringArray(Collection vms) {
        Iterator it = vms.iterator();
        String[] jvms = new String[vms.size()];
        int i = 0;
        while (it.hasNext()) {
            jvms[i++] = it.next().toString();
        }
        return jvms;
    }

    public static String[] getNameStringArray(ObjectName[] vms) {
        String[] jvms = new String[vms.length];
        for (int i = 0; i < vms.length; ++i) {
            ObjectName vm = vms[i];
            jvms[i] = vm.getKeyProperty("name");
        }
        return jvms;
    }

    public static String[] getJ2EEServerNameStringArray(ObjectName[] vms) {
        String[] jvms = new String[vms.length];
        for (int i = 0; i < vms.length; ++i) {
            ObjectName vm = vms[i];
            jvms[i] = vm.getKeyProperty("name");
        }
        return jvms;
    }

    public static String[] getStringNameArray(ObjectName[] objNames) {
        String[] names = new String[objNames.length];
        for (int i = 0; i < objNames.length; ++i) {
            names[i] = objNames[i].toString();
        }
        return names;
    }

    public static ObjectName[] getObjectNameArray(String[] names) throws MalformedObjectNameException {
        ObjectName[] objNames = new ObjectName[names.length];
        for (int i = 0; i < names.length; ++i) {
            objNames[i] = new ObjectName(names[i]);
        }
        return objNames;
    }

    public static Map<String, ObjectName> getNameMap(ObjectName[] vms) {
        HashMap<String, ObjectName> result = new HashMap<String, ObjectName>(vms.length);
        for (int i = 0; i < vms.length; ++i) {
            ObjectName name = vms[i];
            result.put(name.getKeyProperty("name"), name);
        }
        return result;
    }

    public static String getJ2eeType(ObjectName pName) {
        String lType = null;
        if (pName != null) {
            lType = pName.getKeyPropertyList().get("j2eeType");
        }
        return lType == null ? "" : lType;
    }

    public static String getJeusType(ObjectName pName) {
        String lType = null;
        if (pName != null) {
            lType = pName.getKeyPropertyList().get("jeusType");
        }
        return lType == null ? "" : lType;
    }

    public static String getNameValue(ObjectName objName) {
        String lType = null;
        if (objName != null) {
            lType = objName.getKeyPropertyList().get("name");
        }
        return lType == null ? "" : lType;
    }

    public static ObjectName getPatternedObjectName(String domain, Hashtable keyMap) throws MalformedObjectNameException {
        ObjectName name = new ObjectName(domain, keyMap);
        return new ObjectName(name.toString() + ",*");
    }

    public static String toMbeanName(String _name) {
        if (_name == null) {
            return null;
        }
        char[] data = _name.toCharArray();
        char[] _transForm = new char[data.length];
        for (int i = 0; i < data.length; ++i) {
            int c = data[i];
            _transForm[i] = c == 58 ? 95 : c;
        }
        return new String(_transForm);
    }

    public static ObjectName[] queryEJBs(MBeanServerConnection utility, String J2EEServerName, String EJBModuleName, String beanName) throws IOException, IllegalJeusSystemNameException {
        Set names = JMXUtility.queryEjbs(utility, J2EEServerName, EJBModuleName, beanName, "EntityBean");
        names.addAll(JMXUtility.queryEjbs(utility, J2EEServerName, EJBModuleName, beanName, "StatefulSessionBean"));
        names.addAll(JMXUtility.queryEjbs(utility, J2EEServerName, EJBModuleName, beanName, "StatelessSessionBean"));
        names.addAll(JMXUtility.queryEjbs(utility, J2EEServerName, EJBModuleName, beanName, "MessageDrivenBean"));
        return names.toArray(new ObjectName[names.size()]);
    }

    public static ObjectName[] queryEJBNames(MBeanServerConnection utility, String J2EEServerName, String EJBModuleName, String beanName) throws IOException, IllegalJeusSystemNameException {
        Set names = JMXUtility.queryEjbs(utility, J2EEServerName, EJBModuleName, beanName, "EntityBean");
        names.addAll(JMXUtility.queryEjbs(utility, J2EEServerName, EJBModuleName, beanName, "StatefulSessionBean"));
        names.addAll(JMXUtility.queryEjbs(utility, J2EEServerName, EJBModuleName, beanName, "StatelessSessionBean"));
        names.addAll(JMXUtility.queryEjbs(utility, J2EEServerName, EJBModuleName, beanName, "MessageDrivenBean"));
        return names.toArray(new ObjectName[names.size()]);
    }

    private static Set queryEjbs(MBeanServerConnection utility, String containerName, String moduleName, String beanName, String beanType) throws IOException, IllegalJeusSystemNameException {
        ObjectName queryName;
        if (beanType == null && moduleName == null && containerName == null && beanName == null) {
            throw new JeusRuntimeException("all parameters are null");
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (beanType != null) {
            table.put("j2eeType", beanType);
        }
        if (moduleName != null) {
            table.put("EJBModule", moduleName);
        }
        if (containerName != null) {
            table.put("J2EEServer", containerName);
            table.put("JMXManager", jeus.util.StringUtil.getJMXManagerValue(containerName));
        }
        if (beanName != null) {
            table.put("name", beanName);
        }
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_55, new String[]{moduleName, beanName});
        }
        return utility.queryNames(queryName, null);
    }

    public static ObjectName queryJ2EEServer(MBeanServerConnection utility, String containerName) throws IOException, IllegalJeusSystemNameException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "J2EEServer");
        if (containerName != null) {
            table.put("name", containerName);
            table.put("JMXManager", jeus.util.StringUtil.getJMXManagerValue(containerName));
        }
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56, (Throwable)e);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        if (names.size() == 0) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_57, containerName);
        }
        return names.iterator().next();
    }

    private static void setJMXManagerKey(String containerName, Hashtable table) throws IllegalJeusSystemNameException {
        String JMXManagerValue = jeus.util.StringUtil.isDefaultContainerName(containerName) ? jeus.util.StringUtil.getNodeNameFromContainerName(containerName) : containerName;
        table.put("JMXManager", JMXManagerValue);
    }

    public static ObjectName queryEJBEngine(MBeanServerConnection utility, String containerName) throws IOException, IllegalJeusSystemNameException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JeusService");
        table.put("jeusType", "EJBEngine");
        if (containerName != null) {
            table.put("J2EEServer", containerName);
            table.put("JMXManager", jeus.util.StringUtil.getJMXManagerValue(containerName));
        }
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_139, (Throwable)e);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_140);
        }
        if (names.size() == 0) {
            return null;
        }
        return names.iterator().next();
    }

    public static ObjectName queryJMSEngine(MBeanServerConnection utility, String J2EEServerName) throws IOException, IllegalJeusSystemNameException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JeusService");
        table.put("jeusType", "JMSEngine");
        table.put("J2EEServer", J2EEServerName);
        JMXUtility.setJMXManagerKey(J2EEServerName, table);
        return JMXUtility.queryMBean(table, utility);
    }

    private static ObjectName queryMBean(Hashtable table, MBeanServerConnection utility) throws IOException {
        ObjectName queryName;
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56, (Throwable)e);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        if (names.size() == 0) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_58, table.get("J2EEServer"));
        }
        return names.iterator().next();
    }

    public static ObjectName[] queryMBean(MBeanServerConnection msc, String containerName, String j2ee_type, String jeus_type, String name_key, String attribute_name, String attribute_value) throws IOException, IllegalJeusSystemNameException {
        ObjectName queryName;
        if (name_key == null && jeus_type == null && j2ee_type == null && containerName == null) {
            throw new JeusRuntimeException("all parameters are null");
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (name_key != null) {
            table.put("name", name_key);
        }
        if (jeus_type == null) {
            if (j2ee_type != null) {
                table.put("j2eeType", j2ee_type);
            }
        } else {
            table.put("jeusType", jeus_type);
            table.put("j2eeType", "JeusService");
        }
        if (containerName != null) {
            table.put("J2EEServer", containerName);
            table.put("JMXManager", jeus.util.StringUtil.getJMXManagerValue(containerName));
        }
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_59, name_key);
        }
        QueryExp exp = null;
        if (attribute_name != null && attribute_value != null) {
            exp = Query.match(Query.attr(attribute_name), Query.value("*" + attribute_value + "*"));
        }
        Set<ObjectName> names = msc.queryNames(queryName, exp);
        ObjectName[] result = new ObjectName[names.size()];
        return names.toArray(result);
    }

    public static ObjectName[] findJ2eeMBean(MBeanServerConnection msc, String j2eeServer, String j2eeType, String name) throws IOException, IllegalJeusSystemNameException {
        return JMXUtility.queryMBean(msc, j2eeServer, j2eeType, null, name, null, null);
    }

    public static ObjectName[] findJeusMBean(MBeanServerConnection msc, String j2eeServer, String jeusType, String name) throws IOException, IllegalJeusSystemNameException {
        return JMXUtility.queryMBean(msc, j2eeServer, null, jeusType, name, null, null);
    }

    public static ObjectName[] queryJeusMBean(MBeanServerConnection msc, String j2eeServer, String jeusType, String attribute, String value) throws IOException, IllegalJeusSystemNameException {
        return JMXUtility.queryMBean(msc, j2eeServer, null, jeusType, null, attribute, value);
    }

    public static ObjectName[] merge(ObjectName[] a, ObjectName[] b) {
        if (a == null && b == null) {
            return null;
        }
        if (a != null && b == null) {
            return a;
        }
        if (a == null && b != null) {
            return b;
        }
        ObjectName[] m = new ObjectName[a.length + b.length];
        System.arraycopy(a, 0, m, 0, a.length);
        System.arraycopy(b, 0, m, a.length, b.length);
        return m;
    }

    public static ObjectName queryEJBModule(MBeanServerConnection msc, String j2eeServerName, String ejbModuleName) throws IOException, IllegalJeusSystemNameException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "EJBModule");
        table.put("name", ejbModuleName);
        table.put("J2EEServer", j2eeServerName);
        JMXUtility.setJMXManagerKey(j2eeServerName, table);
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_59, ejbModuleName);
        }
        Set<ObjectName> names = msc.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_60, new String[]{ejbModuleName, j2eeServerName});
        }
        if (names.size() == 0) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_61, new String[]{ejbModuleName, j2eeServerName});
        }
        return names.iterator().next();
    }

    public static ObjectName[] queryEJBModules(MBeanServerConnection utility, String j2eeServerName) throws IOException, IllegalJeusSystemNameException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "EJBModule");
        table.put("J2EEServer", j2eeServerName);
        JMXUtility.setJMXManagerKey(j2eeServerName, table);
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56, (Throwable)e);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        ObjectName[] result = new ObjectName[names.size()];
        return names.toArray(result);
    }

    public static ObjectName queryJeusManager(MBeanServerConnection utility, String nodeName) throws IOException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JeusService");
        table.put("jeusType", "JeusManager");
        if (nodeName != null) {
            table.put("name", nodeName);
            table.put("JMXManager", nodeName);
        }
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56, (Throwable)e);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        if (names.size() == 0) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_62, nodeName);
        }
        return names.iterator().next();
    }

    public static <T> T[] getProxy(MBeanServerConnection utility, String[] serverNames, Class<T> interfaceClass, boolean notificationBroadcaster) throws MalformedObjectNameException {
        Object[] proxies = (Object[])Array.newInstance(interfaceClass, serverNames.length);
        for (int i = 0; i < serverNames.length; ++i) {
            ObjectName serverName = new ObjectName(serverNames[i]);
            proxies[i] = MBeanServerInvocationHandler.newProxyInstance(utility, serverName, interfaceClass, notificationBroadcaster);
        }
        return proxies;
    }

    public static <T> T getProxy(MBeanServerConnection utility, ObjectName name, Class<T> interfaceClass, boolean notificationBroadcaster) {
        return MBeanServerInvocationHandler.newProxyInstance(utility, name, interfaceClass, notificationBroadcaster);
    }

    public static String[] getNameStringArray(String[] serverNames) throws MalformedObjectNameException {
        String[] names = new String[serverNames.length];
        for (int i = 0; i < serverNames.length; ++i) {
            names[i] = new ObjectName(serverNames[i]).getKeyProperty("name");
        }
        return names;
    }

    public static <T> T[] getProxy(MBeanServerConnection utility, ObjectName[] objectNames, Class<T> interfaceClass, boolean notificationBroadcaster) {
        Object[] proxies = (Object[])Array.newInstance(interfaceClass, objectNames.length);
        for (int i = 0; i < objectNames.length; ++i) {
            proxies[i] = MBeanServerInvocationHandler.newProxyInstance(utility, objectNames[i], interfaceClass, notificationBroadcaster);
        }
        return proxies;
    }

    public static Set queryContainerManager(MBeanServerConnection utility, String nodeName) throws IOException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JeusService");
        table.put("jeusType", "ContainerManagerService");
        if (nodeName != null) {
            table.put("JeusManager", nodeName);
            table.put("JMXManager", nodeName);
        }
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        return utility.queryNames(queryName, null);
    }

    public static ObjectName queryJVM(MBeanServerConnection utility, String nodeName, String containerName) throws IOException, IllegalJeusSystemNameException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JVM");
        if (nodeName != null) {
            table.put("JeusManager", nodeName);
        }
        if (containerName == null) {
            containerName = "null";
            if (nodeName != null) {
                table.put("JMXManager", nodeName);
            }
        } else {
            table.put("JMXManager", jeus.util.StringUtil.getJMXManagerValue(containerName));
        }
        table.put("J2EEServer", containerName);
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        if (names.size() == 0) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_65, new String[]{nodeName, containerName});
        }
        return names.iterator().next();
    }

    public static ObjectName[] querySessionManagerMo(MBeanServerConnection utility, String nodeName) throws IOException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JeusService");
        table.put("jeusType", "SessionManager");
        if (nodeName != null) {
            table.put("JeusManager", nodeName);
            table.put("JMXManager", nodeName);
        }
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        return names.toArray(new ObjectName[names.size()]);
    }

    public static ObjectName[] queryJ2EEServers(MBeanServerConnection utility, String nodeName) throws IOException {
        Vector<ObjectName> objectNames = new Vector<ObjectName>();
        Vector containers = JMXUtility.getContainerNames(utility, nodeName);
        Iterator iter = containers.iterator();
        while (iter.hasNext()) {
            try {
                objectNames.add(JMXUtility.queryJ2EEServer(utility, (String)iter.next()));
            }
            catch (IllegalJeusSystemNameException e) {}
        }
        return objectNames.toArray(new ObjectName[objectNames.size()]);
    }

    public static ObjectName[] queryJDBCResourceInternals(MBeanServerConnection utility, String nodeName) throws IOException {
        Vector<ObjectName> objectNames = new Vector<ObjectName>();
        Vector containers = JMXUtility.getContainerNames(utility, nodeName);
        Iterator iter = containers.iterator();
        while (iter.hasNext()) {
            try {
                objectNames.add(JMXUtility.queryJDBCResourceInternal(utility, (String)iter.next()));
            }
            catch (IllegalJeusSystemNameException e) {}
        }
        return objectNames.toArray(new ObjectName[objectNames.size()]);
    }

    public static ObjectName queryJDBCResourceInternal(MBeanServerConnection utility, String containerName) throws IOException, IllegalJeusSystemNameException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JDBCResource");
        if (containerName != null) {
            table.put("J2EEServer", containerName);
            table.put("JMXManager", jeus.util.StringUtil.getJMXManagerValue(containerName));
        }
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        if (names.size() == 0) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_66, containerName);
        }
        return names.iterator().next();
    }

    public static ObjectName[] queryJCAResourceInternals(MBeanServerConnection utility, String containerName) throws IOException, IllegalJeusSystemNameException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JCAResource");
        if (containerName != null) {
            table.put("J2EEServer", containerName);
            table.put("JMXManager", jeus.util.StringUtil.getJMXManagerValue(containerName));
        }
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        return names.toArray(new ObjectName[names.size()]);
    }

    public static ObjectName[] queryJDBCDataSourceServices(MBeanServerConnection serverConn, String dataSourceId) throws Exception {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JeusService");
        table.put("jeusType", "JDBCDataSourceService");
        table.put("name", dataSourceId);
        ObjectName queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        Set<ObjectName> names = serverConn.queryNames(queryName, null);
        if (names.size() == 0) {
            throw new JeusRuntimeException(JeusMessage_JMX._120, dataSourceId);
        }
        return names.toArray(new ObjectName[names.size()]);
    }

    public static ObjectName queryJDBCDataSourceService(MBeanServerConnection serverConn, String nodeName, String dataSourceId) throws Exception {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JeusService");
        table.put("jeusType", "JDBCDataSourceService");
        table.put("JeusManager", nodeName);
        table.put("name", dataSourceId);
        ObjectName queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        Set<ObjectName> names = serverConn.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        if (names.size() == 0) {
            throw new JeusRuntimeException(JeusMessage_JMX._120, dataSourceId);
        }
        return names.iterator().next();
    }

    public static ObjectName[] queryJDBCClusterDataSourceServices(MBeanServerConnection serverConn, String dataSourceId) throws Exception {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JeusService");
        table.put("jeusType", "JDBCClusterDataSourceService");
        table.put("name", dataSourceId);
        ObjectName queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        Set<ObjectName> names = serverConn.queryNames(queryName, null);
        if (names.size() == 0) {
            throw new JeusRuntimeException(JeusMessage_JMX._118, dataSourceId);
        }
        return names.toArray(new ObjectName[names.size()]);
    }

    public static ObjectName queryJDBCClusterDataSourceService(MBeanServerConnection serverConn, String nodeName, String dataSourceId) throws Exception {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JeusService");
        table.put("jeusType", "JDBCClusterDataSourceService");
        table.put("JeusManager", nodeName);
        table.put("name", dataSourceId);
        ObjectName queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        Set<ObjectName> names = serverConn.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        if (names.size() == 0) {
            throw new JeusRuntimeException(JeusMessage_JMX._118, dataSourceId);
        }
        return names.iterator().next();
    }

    public static ObjectName queryJDBCConnectionInfo(MBeanServerConnection utility, String containerName, String dataSourceName) throws IllegalJeusSystemNameException, IOException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JDBCConnectionInfo");
        if (dataSourceName != null) {
            table.put("name", dataSourceName);
        }
        if (containerName != null) {
            table.put("JMXManager", jeus.util.StringUtil.getJMXManagerValue(containerName));
        }
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        if (names.size() == 0) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_130, new String[]{containerName, dataSourceName});
        }
        return names.iterator().next();
    }

    public static ObjectName queryJCAConnectionFactory(MBeanServerConnection utility, String containerName, String poolId) throws IllegalJeusSystemNameException, IOException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JCAConnectionFactory");
        if (poolId != null) {
            table.put("name", poolId);
        }
        if (containerName != null) {
            table.put("JMXManager", jeus.util.StringUtil.getJMXManagerValue(containerName));
        }
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        if (names.size() == 0) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_130, new String[]{containerName, poolId});
        }
        return names.iterator().next();
    }

    public static ObjectName queryJMSResource(MBeanServerConnection utility, String containerName, String name, String j2eeType, String jeusType) throws IOException, IllegalJeusSystemNameException {
        ObjectName queryName;
        if (name == null && jeusType == null && j2eeType == null && containerName == null) {
            throw new JeusRuntimeException("all parameters are null");
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (name != null) {
            table.put("name", name);
        }
        if (jeusType != null) {
            table.put("jeusType", jeusType);
        }
        if (j2eeType != null) {
            table.put("j2eeType", j2eeType);
        }
        if (containerName != null) {
            table.put("J2EEServer", containerName);
            table.put("JMXManager", jeus.util.StringUtil.getJMXManagerValue(containerName));
        }
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        if (names.size() == 0) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_122, new String[]{containerName, name, jeusType});
        }
        return names.iterator().next();
    }

    public static ObjectName[] queryRemoteWebServerInfo(MBeanServerConnection utility, String containerConnected) throws IOException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JeusService");
        table.put("JMXManager", containerConnected);
        table.put("JeusManager", containerConnected);
        table.put("jeusType", "RemoteWebtob");
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        return names.toArray(new ObjectName[names.size()]);
    }

    public static ObjectName queryJTAResource(MBeanServerConnection utility, String containerName) throws IOException, IllegalJeusSystemNameException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JTAResource");
        if (containerName != null) {
            table.put("J2EEServer", containerName);
            table.put("JMXManager", jeus.util.StringUtil.getJMXManagerValue(containerName));
        }
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        if (names.size() == 0) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_67, containerName);
        }
        return names.iterator().next();
    }

    public static ObjectName[] queryJTAResources(MBeanServerConnection utility) throws IOException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JTAResource");
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        Set<ObjectName> set = utility.queryNames(queryName, null);
        return set.toArray(new ObjectName[set.size()]);
    }

    public static Object invokeWithTargetModuleID(MBeanServerConnection msc, TargetModuleID moduleId, String invokeMethod, Object[] param, String[] types) throws MalformedObjectNameException, ReflectionException, IOException, MBeanException, InstanceNotFoundException {
        ObjectName obName = new ObjectName(moduleId.getModuleID());
        return msc.invoke(obName, invokeMethod, param, types);
    }

    public static ObjectName queryJDBCResourceService(MBeanServerConnection utility, String nodeName) throws IOException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JeusService");
        table.put("jeusType", "JDBCResourceService");
        if (nodeName != null) {
            table.put("JeusManager", nodeName);
            table.put("JMXManager", nodeName);
        }
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        if (names.size() == 0) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_68, nodeName);
        }
        return names.iterator().next();
    }

    public static ObjectName[] queryJDBCResourceServices(MBeanServerConnection utility) throws IOException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JeusService");
        table.put("jeusType", "JDBCResourceService");
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        return names.toArray(new ObjectName[names.size()]);
    }

    public static Object getAttributeWithTargetModuleID(MBeanServerConnection msc, TargetModuleID moduleId, String attributeName) throws MalformedObjectNameException, ReflectionException, IOException, InstanceNotFoundException, MBeanException, AttributeNotFoundException {
        ObjectName obName = new ObjectName(moduleId.getModuleID());
        return msc.getAttribute(obName, attributeName);
    }

    public static ObjectName[] queryJ2EEApplications(MBeanServerConnection utility, String containerName) throws IOException, IllegalJeusSystemNameException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "J2EEApplication");
        if (containerName != null) {
            table.put("J2EEServer", containerName);
            table.put("JMXManager", jeus.util.StringUtil.getJMXManagerValue(containerName));
        }
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56, (Throwable)e);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        ObjectName[] result = new ObjectName[names.size()];
        return names.toArray(result);
    }

    public static ObjectName queryEngineMo(MBeanServerConnection utility, String containerName, String engineName) throws IOException, IllegalJeusSystemNameException {
        ObjectName queryName;
        String jeusType = StringUtil.getEngineJeusType(engineName);
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JeusService");
        if (jeusType != null) {
            table.put("jeusType", jeusType);
        }
        if (containerName != null) {
            table.put("JeusManager", jeus.util.StringUtil.getNodeNameFromContainerName(containerName));
            table.put("J2EEServer", containerName);
            table.put("JMXManager", jeus.util.StringUtil.getJMXManagerValue(containerName));
        }
        if (engineName != null) {
            table.put("name", engineName);
        }
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        if (names.size() == 0) {
            throw new JeusRuntimeException(JeusMessage_JMX._81, engineName);
        }
        return names.iterator().next();
    }

    public static ObjectName[] queryWebModules(MBeanServerConnection utility) throws IOException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "WebModule");
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        return names.toArray(new ObjectName[names.size()]);
    }

    public static ObjectName queryWebModule(MBeanServerConnection utility, String containerConnected, String moduleName) throws IOException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("name", moduleName);
        table.put("j2eeType", "WebModule");
        table.put("J2EEServer", containerConnected);
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56, (Throwable)e);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        if (names.size() == 0) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_123, new String[]{moduleName, containerConnected});
        }
        return names.iterator().next();
    }

    public static ObjectName queryServlet(MBeanServerConnection utility, String containerConnected, String moduleName, String servletName) throws IOException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "Servlet");
        table.put("name", servletName);
        table.put("WebModule", moduleName);
        table.put("J2EEServer", containerConnected);
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56, (Throwable)e);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        if (names.size() == 0) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_124, new String[]{moduleName, servletName, containerConnected});
        }
        return names.iterator().next();
    }

    public static ObjectName queryWebEngine(MBeanServerConnection utility, String containerName) throws IOException, IllegalJeusSystemNameException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JeusService");
        table.put("jeusType", "WebEngine");
        if (containerName != null) {
            table.put("J2EEServer", containerName);
            table.put("JMXManager", jeus.util.StringUtil.getJMXManagerValue(containerName));
        }
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_139, (Throwable)e);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_141);
        }
        if (names.size() == 0) {
            return null;
        }
        return names.iterator().next();
    }

    public static ObjectName queryWebGroup(MBeanServerConnection utility, String containerConnected, String groupName) throws IOException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JeusService");
        table.put("jeusType", "ContextGroup");
        table.put("name", groupName);
        table.put("J2EEServer", containerConnected);
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56, (Throwable)e);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        if (names.size() == 0) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_126, new String[]{groupName, containerConnected});
        }
        return names.iterator().next();
    }

    public static ObjectName queryObjectName(MBeanServerConnection utility, String containerConnected, ObjectName queryName) throws IOException {
        Set<ObjectName> names = utility.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        if (names.size() == 0) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_127, new String[]{queryName.toString(), containerConnected});
        }
        return names.iterator().next();
    }

    public static ObjectName queryWebPool(MBeanServerConnection utility, String containerConnected, String groupname, String listenerName) throws IOException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JeusService");
        table.put("jeusType", "ThreadPool_WEBC");
        table.put("WebListener", listenerName);
        if (groupname != null) {
            table.put("ContextGroup", groupname);
        }
        table.put("J2EEServer", containerConnected);
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56, (Throwable)e);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        if (names.size() == 0) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_128, new String[]{groupname, listenerName, containerConnected});
        }
        return names.iterator().next();
    }

    public static ObjectName[] queryJ2EEDeployedObjects(MBeanServerConnection utility, String nodeName, String containerName, String moduleMBeanType, String moduleName) throws IOException, IllegalJeusSystemNameException {
        Vector objectNames = new Vector();
        if (containerName != null) {
            objectNames.addAll(JMXUtility.queryJ2EEDeployedObject(utility, containerName, moduleMBeanType, moduleName));
        } else {
            Vector containers = JMXUtility.getContainerNames(utility, nodeName);
            Iterator iter = containers.iterator();
            while (iter.hasNext()) {
                try {
                    objectNames.addAll(JMXUtility.queryJ2EEDeployedObject(utility, (String)iter.next(), moduleMBeanType, moduleName));
                }
                catch (IllegalJeusSystemNameException e) {}
            }
        }
        return objectNames.toArray(new ObjectName[objectNames.size()]);
    }

    private static Set queryJ2EEDeployedObject(MBeanServerConnection utility, String containerName, String moduleMBeanType, String moduleName) throws IOException, IllegalJeusSystemNameException {
        ObjectName queryName;
        if (moduleName == null && containerName == null && moduleMBeanType == null) {
            throw new JeusRuntimeException("all parameters are null");
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (moduleName != null) {
            table.put("name", moduleName);
        }
        if (containerName != null) {
            table.put("J2EEServer", containerName);
            table.put("JMXManager", jeus.util.StringUtil.getJMXManagerValue(containerName));
        }
        QueryExp exp = null;
        if (moduleMBeanType != null) {
            table.put("j2eeType", moduleMBeanType);
        } else {
            exp = Query.in(Query.attr("J2EEType"), new ValueExp[]{new StringValueExp("J2EEApplication"), new StringValueExp("EJBModule"), new StringValueExp("WebModule"), new StringValueExp("AppClientModule"), new StringValueExp("ResourceAdapterModule")});
        }
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56, (Throwable)e);
        }
        return utility.queryNames(queryName, exp);
    }

    public static ObjectName queryLogService(MBeanServerConnection utility, String nodeName, String containerName) throws IOException, IllegalJeusSystemNameException {
        ObjectName queryName;
        String jmxManagerValue;
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (containerName != null && !jeus.util.StringUtil.isDefaultContainerName(containerName)) {
            table.put("J2EEServer", containerName);
            nodeName = jeus.util.StringUtil.getNodeNameFromContainerName(containerName);
            jmxManagerValue = jeus.util.StringUtil.getJMXManagerValue(containerName);
        } else {
            jmxManagerValue = nodeName;
        }
        if (nodeName != null) {
            table.put("JeusManager", nodeName);
        }
        table.put("j2eeType", "JeusService");
        table.put("jeusType", "JeusLogService");
        if (jmxManagerValue != null) {
            table.put("JMXManager", jmxManagerValue);
        }
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        if (names.size() == 0) {
            throw new JeusRuntimeException(JeusMessage_JMX._82, containerName == null ? nodeName : containerName);
        }
        return names.iterator().next();
    }

    public static ObjectName[] queryJ2EEDeployedEJBApplications(MBeanServerConnection utility, String managerName, String engineContainerName, String moduleName) throws IOException, IllegalJeusSystemNameException {
        ObjectName[] moduleObjectNames = JMXUtility.queryJ2EEDeployedObjects(utility, managerName, engineContainerName, null, moduleName);
        ArrayList<ObjectName> ejbNameList = new ArrayList<ObjectName>();
        for (ObjectName objectName : moduleObjectNames) {
            String moduleType = objectName.getKeyProperty("j2eeType");
            if (!moduleType.equals("EJBModule")) continue;
            ejbNameList.add(objectName);
        }
        return ejbNameList.toArray(new ObjectName[ejbNameList.size()]);
    }

    public static ArrayList<ObjectName> queryJ2EEDeployedEJBApplicationList(MBeanServerConnection utility, String managerName, String engineContainerName, String moduleName) throws IOException, IllegalJeusSystemNameException {
        ObjectName[] moduleObjectNames = JMXUtility.queryJ2EEDeployedObjects(utility, managerName, engineContainerName, null, moduleName);
        ArrayList<ObjectName> ejbNameList = new ArrayList<ObjectName>();
        for (ObjectName objectName : moduleObjectNames) {
            String moduleType = objectName.getKeyProperty("j2eeType");
            if (!moduleType.equals("EJBModule")) continue;
            ejbNameList.add(objectName);
        }
        return ejbNameList;
    }

    public static ObjectName[] queryJ2EEDeployedApplications(MBeanServerConnection utility, String nodeName, String containerName, String moduleMBeanType, String moduleName) throws IOException, IllegalJeusSystemNameException {
        ArrayList<ObjectName> nameList = JMXUtility.queryJ2EEDeployedApplicationList(utility, nodeName, containerName, moduleMBeanType, moduleName);
        return nameList.toArray(new ObjectName[nameList.size()]);
    }

    public static ArrayList<ObjectName> queryJ2EEDeployedApplicationList(MBeanServerConnection utility, String nodeName, String containerName, String moduleMBeanType, String moduleName) throws IOException, IllegalJeusSystemNameException {
        ObjectName[] moduleObjectNames = JMXUtility.queryJ2EEDeployedObjects(utility, nodeName, containerName, moduleMBeanType, moduleName);
        ArrayList<ObjectName> nameList = new ArrayList<ObjectName>();
        for (int i = 0; i < moduleObjectNames.length; ++i) {
            ObjectName moduleObjectName = moduleObjectNames[i];
            String j2eeApp = moduleObjectName.getKeyProperty("J2EEApplication");
            if (j2eeApp != null && !j2eeApp.equals("null")) continue;
            nameList.add(moduleObjectName);
        }
        return nameList;
    }

    public static ObjectName querySecurityService(MBeanServerConnection utility, String name, String nodeName) throws IOException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JeusService");
        table.put("jeusType", "SecurityService");
        if (name != null) {
            table.put("name", name);
        }
        if (nodeName != null) {
            table.put("JMXManager", nodeName);
        }
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56, (Throwable)e);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        if (names.size() == 0) {
            throw new JeusRuntimeException("There is no security domain");
        }
        return names.iterator().next();
    }

    public static ObjectName querySecurityDomainService(MBeanServerConnection utility, String name, String domainName, String jeusType, String nodeName) throws IOException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JeusService");
        if (domainName != null) {
            table.put("SecurityDomain", domainName);
        }
        if (name != null) {
            table.put("name", name);
        }
        if (jeusType != null) {
            table.put("jeusType", jeusType);
        }
        if (nodeName != null) {
            table.put("JMXManager", nodeName);
        }
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56, (Throwable)e);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        if (names.size() == 0) {
            throw new JeusRuntimeException("There is no security domain");
        }
        return names.iterator().next();
    }

    public static ObjectName[] queryObjectNameArrayWithTable(MBeanServerConnection utility, Hashtable table) throws JeusRuntimeException {
        Set<ObjectName> names;
        ObjectName queryName;
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException("failed to make the ObjectName", (Throwable)e);
        }
        try {
            names = utility.queryNames(queryName, null);
        }
        catch (IOException e) {
            throw new JeusRuntimeException("failed to query : " + queryName, (Throwable)e);
        }
        return names.toArray(new ObjectName[names.size()]);
    }

    public static ObjectName querySecurityDomain(MBeanServerConnection utility, String name, String jeusType, String nodeName) throws IOException {
        ObjectName queryName;
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("j2eeType", "JeusService");
        if (name != null) {
            table.put("name", name);
        }
        if (jeusType != null) {
            table.put("jeusType", jeusType);
        }
        if (nodeName != null) {
            table.put("JMXManager", nodeName);
        }
        try {
            queryName = JMXUtility.getPatternedObjectName("JEUS", table);
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56, (Throwable)e);
        }
        Set<ObjectName> names = utility.queryNames(queryName, null);
        if (names.size() > 1) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56);
        }
        if (names.size() == 0) {
            throw new JeusRuntimeException("There is no security domain");
        }
        return names.iterator().next();
    }

    public static String getNodeOrContainerName(ObjectName parentName) {
        String j2eeServer;
        String parentJ2eeType = parentName.getKeyProperty("j2eeType");
        String string = j2eeServer = "J2EEServer".equals(parentJ2eeType) ? parentName.getKeyProperty("name") : parentName.getKeyProperty("J2EEServer");
        if (j2eeServer != null) {
            return j2eeServer;
        }
        return parentName.getKeyProperty("JMXManager");
    }

    public static void setNodeObjectName(ObjectName objectName) {
        nodeObjectName = objectName;
    }

    public static String makeObjectNameFromMap(Map prop, String[] parentMap) {
        StringBuffer buffer = new StringBuffer("JEUS").append(":");
        JMXUtility.addKeyProperty("j2eeType", prop, buffer, true);
        JMXUtility.addKeyProperty("jeusType", prop, buffer, true);
        JMXUtility.addKeyProperty("JMXManager", prop, buffer, true);
        if (parentMap != null) {
            for (int i = 0; i < parentMap.length; ++i) {
                String parentKey = parentMap[i];
                JMXUtility.addKeyProperty(parentKey, prop, buffer, true);
            }
        }
        JMXUtility.addKeyProperty("isTargetable", prop, buffer, true);
        String nameValue = (String)prop.remove("name");
        for (Map.Entry entry : prop.entrySet()) {
            JMXUtility.addKeyProperty((String)entry.getKey(), entry.getValue(), buffer, true);
        }
        JMXUtility.addKeyProperty("name", nameValue, buffer, false);
        return buffer.toString();
    }

    private static void addKeyProperty(String key, Map prop, StringBuffer buffer, boolean addComma) {
        Object obj = prop.remove(key);
        if (obj != null) {
            JMXUtility.addKeyProperty(key, obj, buffer, addComma);
        }
    }

    private static void addKeyProperty(String key, Object obj, StringBuffer buffer, boolean addComma) {
        buffer.append(key).append('=').append(obj);
        if (addComma) {
            buffer.append(',');
        }
    }

    public static Vector getContainerNames(MBeanServerConnection utility, String nodeName) throws IOException {
        Vector<String> containerNames = new Vector<String>();
        Set objectNames = JMXUtility.queryContainerManager(utility, nodeName);
        for (Object objectName : objectNames) {
            ContainerManagerServiceMBean manager = JMXUtility.getProxy(utility, (ObjectName)objectName, ContainerManagerServiceMBean.class, false);
            containerNames.addAll(manager.getBootedContainerList());
        }
        return containerNames;
    }

    public static Vector queryMBeanList(MBeanServerConnection utility, String nodeName, String objectName) throws IOException {
        ObjectName queryName;
        Vector<ObjectName> mbeanList = new Vector<ObjectName>();
        if (objectName != null && objectName.length() > 0) {
            try {
                queryName = new ObjectName(objectName);
            }
            catch (MalformedObjectNameException e) {
                throw new JeusRuntimeException(JeusMessage_JMX.JMX_56, (Throwable)e);
            }
        }
        try {
            queryName = new ObjectName("*:*");
        }
        catch (MalformedObjectNameException e) {
            throw new JeusRuntimeException(JeusMessage_JMX.JMX_56, (Throwable)e);
        }
        if (nodeName != null) {
            mbeanList.addAll(JMXUtility.queryMBeanListFromNodeName(utility, nodeName, queryName));
        } else {
            mbeanList.addAll(utility.queryNames(queryName, null));
        }
        return mbeanList;
    }

    private static Vector queryMBeanListFromNodeName(MBeanServerConnection utility, String nodeName, ObjectName objectName) throws IOException {
        if (utility == null) {
            throw new JeusRuntimeException("MBeanServerConnection utility is null");
        }
        if (nodeName == null) {
            throw new JeusRuntimeException("node name is null");
        }
        if (objectName == null) {
            throw new JeusRuntimeException("object name is null");
        }
        Vector<ObjectName> mbeanList = new Vector<ObjectName>();
        Hashtable<String, String> propertyList = objectName.getKeyPropertyList();
        String jmxManager = propertyList.get("JMXManager");
        if (jmxManager == null || jmxManager.length() <= 0) {
            ObjectName queryName;
            propertyList.put("JMXManager", nodeName);
            try {
                queryName = JMXUtility.getPatternedObjectName(objectName.getDomain(), propertyList);
            }
            catch (MalformedObjectNameException e) {
                throw new JeusRuntimeException(JeusMessage_JMX.JMX_56, (Throwable)e);
            }
            mbeanList.addAll(utility.queryNames(queryName, null));
            Vector containers = JMXUtility.getContainerNames(utility, nodeName);
            for (Object container : containers) {
                if (container.equals(nodeName + "_default")) continue;
                propertyList.put("JMXManager", (String)container);
                try {
                    queryName = JMXUtility.getPatternedObjectName(objectName.getDomain(), propertyList);
                }
                catch (MalformedObjectNameException e) {
                    throw new JeusRuntimeException(JeusMessage_JMX.JMX_56, (Throwable)e);
                }
                mbeanList.addAll(utility.queryNames(queryName, null));
            }
        } else {
            ObjectName queryName;
            Vector containers;
            if (!nodeName.equals(jmxManager) && !(containers = JMXUtility.getContainerNames(utility, nodeName)).contains(jmxManager)) {
                throw new JeusRuntimeException("\"JMXManager=" + jmxManager + "\"" + " is invalid");
            }
            try {
                queryName = JMXUtility.getPatternedObjectName(objectName.getDomain(), propertyList);
            }
            catch (MalformedObjectNameException e) {
                throw new JeusRuntimeException(JeusMessage_JMX.JMX_56, (Throwable)e);
            }
            mbeanList.addAll(utility.queryNames(queryName, null));
        }
        return mbeanList;
    }

    public static ObjectName makeJeusManagerObjectName(String managerName) throws MalformedObjectNameException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("j2eeType", "JeusService");
        props.put("jeusType", "JeusManager");
        props.put("JMXManager", managerName);
        props.put("name", managerName);
        return new ObjectName("JEUS", props);
    }

    public static ObjectName makeJ2EEServerObjectName(String managerName, String engineContainerId) throws MalformedObjectNameException, IllegalJeusSystemNameException {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("j2eeType", "J2EEServer");
        props.put("JMXManager", jeus.util.StringUtil.getJMXManagerValue(engineContainerId));
        props.put("isTargetable", "true");
        props.put("JeusManager", managerName);
        props.put("name", engineContainerId);
        return new ObjectName("JEUS", props);
    }
}

