/*
 * Decompiled with CFR 0.152.
 */
package jeus.management;

import java.io.ObjectInputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.remote.MBeanServerForwarder;
import javax.security.auth.Subject;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.spi.LoginService;
import jeus.util.JeusRuntimeException;
import jeus.util.message.JeusMessage_JMXRemote;

public class JeusMBeanServerAccessController
implements MBeanServerForwarder {
    private jeus.security.base.Subject subject;
    private MBeanServer mbs;

    public JeusMBeanServerAccessController(jeus.security.base.Subject subject, MBeanServer server) {
        this.mbs = server;
        this.subject = subject;
    }

    public JeusMBeanServerAccessController() {
    }

    public MBeanServer getMBeanServer() {
        return this.mbs;
    }

    public void setMBeanServer(MBeanServer mbs) {
        if (mbs == null) {
            throw new IllegalArgumentException("Null MBeanServer");
        }
        if (this.mbs != null) {
            throw new IllegalArgumentException("MBeanServer object already initialized");
        }
        this.mbs = mbs;
    }

    private void login() {
        boolean needLogin;
        jeus.security.base.Subject s = null;
        if (this.subject == null) {
            needLogin = this.getSubjectFromAcc() != null;
            if (needLogin) {
                try {
                    s = jeus.security.base.Subject.fromJAASSubject(this.getSubjectFromAcc());
                }
                catch (ServiceException e) {
                    throw new JeusRuntimeException(JeusMessage_JMXRemote.JMX_45);
                }
                catch (Throwable e) {
                    throw new JeusRuntimeException("Exception occurred", e);
                }
            }
        } else {
            s = this.subject;
            needLogin = true;
        }
        if (needLogin) {
            try {
                LoginService.login(s);
            }
            catch (SecurityException e) {
                throw new JeusRuntimeException(JeusMessage_JMXRemote.JMX_45);
            }
            catch (Throwable e) {
                throw new JeusRuntimeException("Exception occurred", e);
            }
        }
    }

    private Subject getSubjectFromAcc() {
        final AccessControlContext acc = AccessController.getContext();
        Subject s = System.getSecurityManager() == null ? Subject.getSubject(acc) : (Subject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Subject.getSubject(acc);
            }
        });
        return s;
    }

    private void logout() {
        boolean needLogout = this.subject == null ? this.getSubjectFromAcc() != null : true;
        if (needLogout) {
            try {
                LoginService.logout();
            }
            catch (Exception e) {
                throw new JeusRuntimeException("Exception occurred", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        try {
            this.login();
            this.getMBeanServer().addNotificationListener(name, listener, filter, handback);
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        try {
            this.login();
            this.getMBeanServer().addNotificationListener(name, listener, filter, handback);
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            this.login();
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                Object object = this.getMBeanServer().instantiate(className);
                this.checkClassLoader(object);
                ObjectInstance objectInstance = this.getMBeanServer().registerMBean(object, name);
                return objectInstance;
            }
            ObjectInstance objectInstance = this.getMBeanServer().createMBean(className, name);
            return objectInstance;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            this.login();
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                Object object = this.getMBeanServer().instantiate(className, params, signature);
                this.checkClassLoader(object);
                ObjectInstance objectInstance = this.getMBeanServer().registerMBean(object, name);
                return objectInstance;
            }
            ObjectInstance objectInstance = this.getMBeanServer().createMBean(className, name, params, signature);
            return objectInstance;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        try {
            this.login();
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                Object object = this.getMBeanServer().instantiate(className, loaderName);
                this.checkClassLoader(object);
                ObjectInstance objectInstance = this.getMBeanServer().registerMBean(object, name);
                return objectInstance;
            }
            ObjectInstance objectInstance = this.getMBeanServer().createMBean(className, name, loaderName);
            return objectInstance;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        try {
            this.login();
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                Object object = this.getMBeanServer().instantiate(className, loaderName, params, signature);
                this.checkClassLoader(object);
                ObjectInstance objectInstance = this.getMBeanServer().registerMBean(object, name);
                return objectInstance;
            }
            ObjectInstance objectInstance = this.getMBeanServer().createMBean(className, name, loaderName, params, signature);
            return objectInstance;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        try {
            this.login();
            ObjectInputStream objectInputStream = this.getMBeanServer().deserialize(name, data);
            return objectInputStream;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        try {
            this.login();
            ObjectInputStream objectInputStream = this.getMBeanServer().deserialize(className, data);
            return objectInputStream;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        try {
            this.login();
            ObjectInputStream objectInputStream = this.getMBeanServer().deserialize(className, loaderName, data);
            return objectInputStream;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        try {
            this.login();
            Object object = this.getMBeanServer().getAttribute(name, attribute);
            return object;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        try {
            this.login();
            AttributeList attributeList = this.getMBeanServer().getAttributes(name, attributes);
            return attributeList;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        try {
            this.login();
            ClassLoader classLoader = this.getMBeanServer().getClassLoader(loaderName);
            return classLoader;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        try {
            this.login();
            ClassLoader classLoader = this.getMBeanServer().getClassLoaderFor(mbeanName);
            return classLoader;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoaderRepository getClassLoaderRepository() {
        try {
            this.login();
            ClassLoaderRepository classLoaderRepository = this.getMBeanServer().getClassLoaderRepository();
            return classLoaderRepository;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultDomain() {
        try {
            this.login();
            String string = this.getMBeanServer().getDefaultDomain();
            return string;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDomains() {
        try {
            this.login();
            String[] stringArray = this.getMBeanServer().getDomains();
            return stringArray;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getMBeanCount() {
        try {
            this.login();
            Integer n = this.getMBeanServer().getMBeanCount();
            return n;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        try {
            this.login();
            MBeanInfo mBeanInfo = this.getMBeanServer().getMBeanInfo(name);
            return mBeanInfo;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        try {
            this.login();
            ObjectInstance objectInstance = this.getMBeanServer().getObjectInstance(name);
            return objectInstance;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object instantiate(String className) throws ReflectionException, MBeanException {
        try {
            this.login();
            Object object = this.getMBeanServer().instantiate(className);
            return object;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        try {
            this.login();
            Object object = this.getMBeanServer().instantiate(className, params, signature);
            return object;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        try {
            this.login();
            Object object = this.getMBeanServer().instantiate(className, loaderName);
            return object;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        try {
            this.login();
            Object object = this.getMBeanServer().instantiate(className, loaderName, params, signature);
            return object;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        try {
            this.login();
            this.checkMLetAddURL(name, operationName);
            Object object = this.getMBeanServer().invoke(name, operationName, params, signature);
            return object;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        try {
            this.login();
            boolean bl = this.getMBeanServer().isInstanceOf(name, className);
            return bl;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(ObjectName name) {
        try {
            this.login();
            boolean bl = this.getMBeanServer().isRegistered(name);
            return bl;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set queryMBeans(ObjectName name, QueryExp query) {
        try {
            this.login();
            Set<ObjectInstance> set = this.getMBeanServer().queryMBeans(name, query);
            return set;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set queryNames(ObjectName name, QueryExp query) {
        try {
            this.login();
            Set<ObjectName> set = this.getMBeanServer().queryNames(name, query);
            return set;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        try {
            this.login();
            ObjectInstance objectInstance = this.getMBeanServer().registerMBean(object, name);
            return objectInstance;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.login();
            this.getMBeanServer().removeNotificationListener(name, listener);
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.login();
            this.getMBeanServer().removeNotificationListener(name, listener, filter, handback);
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.login();
            this.getMBeanServer().removeNotificationListener(name, listener);
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.login();
            this.getMBeanServer().removeNotificationListener(name, listener, filter, handback);
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            this.login();
            this.getMBeanServer().setAttribute(name, attribute);
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        try {
            this.login();
            AttributeList attributeList = this.getMBeanServer().setAttributes(name, attributes);
            return attributeList;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        try {
            this.login();
            this.getMBeanServer().unregisterMBean(name);
        }
        finally {
            this.logout();
        }
    }

    private void checkClassLoader(Object object) throws java.lang.SecurityException {
        if (object instanceof ClassLoader) {
            throw new java.lang.SecurityException("Access denied! Creating an MBean that is a ClassLoader is forbidden unless a security manager is installed.");
        }
    }

    private void checkMLetAddURL(ObjectName name, String operationName) throws InstanceNotFoundException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null && operationName.equals("addURL") && this.getMBeanServer().isInstanceOf(name, "javax.management.loading.MLet")) {
            throw new java.lang.SecurityException("Access denied! MLet method addURL cannot be invoked unless a security manager is installed.");
        }
    }
}

