/*
 * Decompiled with CFR 0.152.
 */
package jeus.management;

import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import jeus.management.enterprise.agent.MEJBUtility;
import jeus.util.JeusRuntimeException;
import jeus.util.properties.JeusManagerPropertyValues;
import jeus.util.properties.JeusNetPropertyValues;

public class RemoteMBeanServerFactory {
    public static final String SYSTEM_DOMAIN = "JEUS";

    public static MBeanServerConnection getMBeanServer() {
        try {
            return MEJBUtility.getMEJBUtility(RemoteMBeanServerFactory.getEnv(null, null, null, null));
        }
        catch (Exception e) {
            throw new JeusRuntimeException(e);
        }
    }

    public static MBeanServerConnection getMBeanServer(Hashtable env) {
        try {
            return MEJBUtility.getMEJBUtility(RemoteMBeanServerFactory.getEnv(env, null, null, null));
        }
        catch (Exception e) {
            throw new JeusRuntimeException(e);
        }
    }

    public static MBeanServerConnection getDedicatedMBeanServer(Hashtable env, String host, boolean isNode) {
        try {
            if (!isNode) {
                int index = host.lastIndexOf(95);
                if (index < 0) {
                    throw new JeusRuntimeException("container name is not specified.");
                }
                String node = host.substring(0, index);
                env.put("java.naming.provider.url", node);
            }
            return ((MEJBUtility)RemoteMBeanServerFactory.getMBeanServer(env)).getRemoteMBeanServer(host);
        }
        catch (Exception e) {
            throw new JeusRuntimeException(e);
        }
    }

    public static MBeanServerConnection getMBeanServer(String host) {
        try {
            return MEJBUtility.getMEJBUtility(RemoteMBeanServerFactory.getEnv(null, host, null, null));
        }
        catch (Exception e) {
            throw new JeusRuntimeException(e);
        }
    }

    public static MBeanServerConnection getDedicatedMBeanServer(String host, boolean isNode) {
        try {
            if (!isNode) {
                int index = host.lastIndexOf(95);
                if (index < 0) {
                    throw new JeusRuntimeException("container name is not specified.");
                }
                String node = host.substring(0, index);
                return ((MEJBUtility)RemoteMBeanServerFactory.getMBeanServer(node)).getRemoteMBeanServer(host);
            }
            return ((MEJBUtility)RemoteMBeanServerFactory.getMBeanServer(host)).getRemoteMBeanServer(host);
        }
        catch (Exception e) {
            throw new JeusRuntimeException(e);
        }
    }

    public static MBeanServerConnection getMBeanServer(String host, String user, String password) {
        try {
            return MEJBUtility.getMEJBUtility(RemoteMBeanServerFactory.getEnv(null, host, user, password));
        }
        catch (Exception e) {
            throw new JeusRuntimeException(e);
        }
    }

    public static MBeanServerConnection getDedicatedMBeanServer(String host, String user, String password, boolean isNode) {
        try {
            if (!isNode) {
                int index = host.lastIndexOf(95);
                if (index < 0) {
                    throw new JeusRuntimeException("container name is not specified.");
                }
                String node = host.substring(0, index);
                return ((MEJBUtility)RemoteMBeanServerFactory.getMBeanServer(node, user, password)).getRemoteMBeanServer(host);
            }
            return ((MEJBUtility)RemoteMBeanServerFactory.getMBeanServer(host, user, password)).getRemoteMBeanServer(host);
        }
        catch (Exception e) {
            throw new JeusRuntimeException(e);
        }
    }

    private static Hashtable getEnv(Hashtable env, String host, String user, String password) {
        if (env == null) {
            env = new Hashtable<String, Object>();
        }
        if (host == null) {
            host = (String)env.get("java.naming.provider.url");
        }
        if (host == null) {
            String sHost = System.getProperty("java.naming.provider.url");
            host = sHost != null ? sHost : JeusNetPropertyValues.LOCAL_LOOPBACK_ADDRESS;
        }
        if (!env.contains("java.naming.factory.initial") && System.getProperty("java.naming.factory.initial") == null) {
            env.put("java.naming.factory.initial", "jeus.jndi.JNSContextFactory");
        }
        env.put("java.naming.provider.url", host);
        if (user == null || password == null) {
            user = (String)env.get("java.naming.security.principal");
            password = (String)env.get("java.naming.security.credentials");
        }
        if (user == null || password == null) {
            user = System.getProperty("java.naming.security.principal");
            password = System.getProperty("java.naming.security.credentials");
        }
        if (user != null && password != null) {
            env.put("USE_SECURITY_FOR_MEJB_UTILITY", Boolean.TRUE);
            env.put("java.naming.security.principal", user);
            env.put("java.naming.security.credentials", password);
        }
        return env;
    }

    public static MBeanServerConnection getLocalMBeanServer() {
        String containerName = JeusManagerPropertyValues.containerName;
        return RemoteMBeanServerFactory.getDedicatedMBeanServer(containerName, false);
    }
}

