/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.enterprise.agent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import jeus.management.enterprise.agent.JMXConnectorNotReachableException;
import jeus.management.enterprise.agent.MBeanServerChecker;
import jeus.management.enterprise.agent.MEJBUtility;
import jeus.util.message.JeusMessage_JMX;
import jeus.util.properties.JeusPropertyValues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNDIMBeanServerChecker
extends MBeanServerChecker {
    private InitialContext ic;

    public JNDIMBeanServerChecker(String serverName, MBeanServer server, Hashtable jndiEnv) throws NamingException {
        super(serverName, server, jndiEnv);
        this.ic = new InitialContext(jndiEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> checkNewMBeanServer() {
        Object ne;
        if (this.isConnecting) {
            JNDIMBeanServerChecker jNDIMBeanServerChecker = this;
            synchronized (jNDIMBeanServerChecker) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    logger.log(Level.FINEST, "This thread is interrupted", (Throwable)e);
                }
                return Collections.emptyList();
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        InitialContext checkIC = null;
        try {
            try {
                checkIC = new InitialContext(this.jndiEnv);
                ne = checkIC.list("mgmt/rmbs/");
                while (ne.hasMore()) {
                    NameClassPair b = ne.next();
                    String jndiName = b.getName();
                    if (this.cachedConnector.containsKey(jndiName) || this.serverName != null && jndiName.endsWith(this.serverName)) continue;
                    this.isConnecting = true;
                    list.add(jndiName);
                }
                ne = list;
                Object var7_10 = null;
                if (checkIC == null) return ne;
            }
            catch (NamingException e) {
                if (logger.isLoggable(JeusMessage_JMX.JMX_04_LEVEL)) {
                    logger.log(JeusMessage_JMX.JMX_04_LEVEL, JeusMessage_JMX.JMX_04, (Throwable)e);
                }
                List<String> list2 = Collections.emptyList();
                Object var7_11 = null;
                if (checkIC == null) return list2;
                try {
                    checkIC.close();
                    return list2;
                }
                catch (NamingException e2) {
                    // empty catch block
                }
                return list2;
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (checkIC == null) throw throwable;
            try {}
            catch (NamingException e2) {
                throw throwable;
            }
            checkIC.close();
            throw throwable;
        }
        try {}
        catch (NamingException e2) {
            // empty catch block
            return ne;
        }
        checkIC.close();
        return ne;
    }

    private boolean isInClusterForNodeOrContainerName(String nodeName) {
        if (JeusPropertyValues.JEUS_CATEGORY == 0) {
            return true;
        }
        int index = nodeName.lastIndexOf(95);
        if (index >= 0) {
            return MEJBUtility.isInCluster(nodeName.substring(0, index)) || MEJBUtility.isInCluster(nodeName);
        }
        return MEJBUtility.isInCluster(nodeName);
    }

    @Override
    protected synchronized void connectServer(String dedicatedJMXManagerName) throws JMXConnectorNotReachableException {
        MBeanServerConnection sc;
        JMXConnector connector;
        if (!this.isInClusterForNodeOrContainerName(dedicatedJMXManagerName)) {
            throw new JMXConnectorNotReachableException("The node or container " + dedicatedJMXManagerName + " is not reachable from this node, maybe ClusterService has not detected the node yet");
        }
        String jndiName = "mgmt/rmbs/" + dedicatedJMXManagerName;
        try {
            connector = (JMXConnector)this.ic.lookup(jndiName);
        }
        catch (NameNotFoundException e) {
            throw new JMXConnectorNotReachableException("The node or container " + dedicatedJMXManagerName + " is not reachable from this node");
        }
        catch (NamingException e) {
            throw new JMXConnectorNotReachableException(e.getMessage(), (Throwable)e);
        }
        if (logger.isLoggable(JeusMessage_JMX.JMX_05_LEVEL)) {
            logger.log(JeusMessage_JMX.JMX_05_LEVEL, JeusMessage_JMX.JMX_05, (Object)dedicatedJMXManagerName);
        }
        try {
            connector.connect();
            sc = connector.getMBeanServerConnection();
        }
        catch (IOException ex) {
            block9: {
                try {
                    connector.close();
                }
                catch (Exception e) {
                    if (!logger.isLoggable(JeusMessage_JMX.JMX_09_LEVEL)) break block9;
                    logger.log(JeusMessage_JMX.JMX_09_LEVEL, JeusMessage_JMX.JMX_09, (Throwable)e);
                }
            }
            throw new JMXConnectorNotReachableException(ex.getMessage(), (Throwable)ex);
        }
        this.cachedConnector.put(dedicatedJMXManagerName, connector);
        this.cachedMBeanServer.put(dedicatedJMXManagerName, sc);
        this.cachedMBeanServerSet.add(sc);
    }

    @Override
    public void closeConnection() {
        super.closeConnection();
        if (this.ic != null) {
            try {
                this.ic.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }
}

