/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.enterprise.agent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.NamingException;
import jeus.management.enterprise.agent.JMXConnectorNotReachableException;
import jeus.management.enterprise.agent.MBeanServerChecker;
import jeus.util.message.JeusMessage_JMXRemote;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxMPMBeanServerChecker
extends MBeanServerChecker {
    public static Object JMXServiceURL_KEY = "JMXServiceURLs";
    private Map jmxServiceUrls;

    public JmxMPMBeanServerChecker(String serverName, MBeanServer server, Hashtable jndiEnv) throws NamingException {
        super(serverName, server, jndiEnv);
        this.jmxServiceUrls = (Map)jndiEnv.get(JMXServiceURL_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> checkNewMBeanServer() {
        if (this.isConnecting) {
            JmxMPMBeanServerChecker jmxMPMBeanServerChecker = this;
            synchronized (jmxMPMBeanServerChecker) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    logger.log(Level.FINEST, "This thread is interrupted", (Throwable)e);
                }
            }
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : this.jmxServiceUrls.keySet()) {
            String name = (String)o;
            if (this.cachedConnector.containsKey(name) || this.serverName != null && name.equals(this.serverName)) continue;
            this.isConnecting = true;
            list.add(name);
        }
        return list;
    }

    @Override
    protected synchronized void connectServer(String dedicatedJMXManagerName) throws JMXConnectorNotReachableException {
        MBeanServerConnection sc;
        JMXServiceURL url = (JMXServiceURL)this.jmxServiceUrls.get(dedicatedJMXManagerName);
        JMXConnector connector = null;
        try {
            connector = JMXConnectorFactory.connect(url, this.getConnectorEnv(url));
            if (logger.isLoggable(JeusMessage_JMXRemote.JMX_05_LEVEL)) {
                logger.log(JeusMessage_JMXRemote.JMX_05_LEVEL, JeusMessage_JMXRemote.JMX_05, (Object)dedicatedJMXManagerName);
            }
            connector.connect();
            sc = connector.getMBeanServerConnection();
        }
        catch (IOException ex) {
            block6: {
                try {
                    if (connector != null) {
                        connector.close();
                    }
                }
                catch (Exception e) {
                    if (!logger.isLoggable(JeusMessage_JMXRemote.JMX_09_LEVEL)) break block6;
                    logger.log(JeusMessage_JMXRemote.JMX_09_LEVEL, JeusMessage_JMXRemote.JMX_09, (Throwable)e);
                }
            }
            throw new JMXConnectorNotReachableException(ex);
        }
        this.cachedConnector.put(dedicatedJMXManagerName, connector);
        this.cachedMBeanServer.put(dedicatedJMXManagerName, sc);
        this.cachedMBeanServerSet.add(sc);
    }

    protected Hashtable getConnectorEnv(JMXServiceURL url) {
        return this.jndiEnv;
    }
}

