/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.enterprise.agent;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import jeus.management.enterprise.agent.JMXConnectorNotReachableException;
import jeus.management.enterprise.agent.MBSCAlreadyClosedException;
import jeus.security.util.LoginUtil;
import jeus.util.JeusRuntimeException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JMXRemote;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MBeanServerChecker {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.management");
    protected Map<String, MBeanServerConnection> cachedMBeanServer = Collections.synchronizedMap(new HashMap());
    protected Map<String, JMXConnector> cachedConnector = Collections.synchronizedMap(new HashMap());
    protected Set<MBeanServerConnection> cachedMBeanServerSet = Collections.synchronizedSet(new HashSet());
    protected boolean isConnecting;
    protected Hashtable jndiEnv;
    private MBeanServer server;
    protected String serverName;

    public MBeanServerChecker(String serverName, MBeanServer server, Hashtable jndiEnv) {
        this.server = server;
        this.serverName = serverName;
        if (serverName != null && server != null) {
            this.cachedMBeanServer.put(serverName, server);
        }
        this.cachedMBeanServerSet.addAll(this.cachedMBeanServer.values());
        this.jndiEnv = jndiEnv;
    }

    public abstract List<String> checkNewMBeanServer();

    public String[] getRemoteMBeanServerNames(boolean checkConnection) throws MBSCAlreadyClosedException {
        this.getRemoteMBeanServers();
        if (checkConnection) {
            Map.Entry[] entries;
            for (Map.Entry entry : entries = this.cachedConnector.entrySet().toArray(new Map.Entry[this.cachedConnector.entrySet().size()])) {
                String serverName = (String)entry.getKey();
                try {
                    this.cachedMBeanServer.get(serverName).getMBeanCount();
                }
                catch (IOException e) {
                    this.removeMBeanServerCached(serverName);
                }
            }
        }
        return this.cachedConnector.keySet().toArray(new String[this.cachedConnector.keySet().size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MBeanServerConnection> getRemoteMBeanServers() {
        List<String> newServerBindings = this.checkNewMBeanServer();
        if (newServerBindings.isEmpty()) {
            return this.cachedMBeanServerSet;
        }
        LoginUtil.loginCodeSubjectWithRuntimeException();
        try {
            for (String jndiName : newServerBindings) {
                try {
                    this.connectServer(jndiName);
                }
                catch (JMXConnectorNotReachableException e) {
                    if (!logger.isLoggable(Level.FINEST)) continue;
                    logger.log(Level.FINEST, "The node or container " + jndiName + " is not reachable", (Throwable)e);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(JeusMessage_JMXRemote.JMX_03_LEVEL)) continue;
                    logger.log(JeusMessage_JMXRemote.JMX_03_LEVEL, JeusMessage_JMXRemote.JMX_03, jndiName, (Throwable)e);
                }
            }
        }
        finally {
            this.isConnecting = false;
            Iterator<MBeanServerConnection> i$ = this;
            synchronized (i$) {
                this.notifyAll();
            }
            LoginUtil.logoutWithRuntimeException();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "before return mbean server set");
            for (MBeanServerConnection mBeanServerConnection : this.cachedMBeanServerSet) {
                logger.log(Level.FINER, "cached mbean server : " + mBeanServerConnection);
            }
        }
        return this.cachedMBeanServerSet;
    }

    public MBeanServerConnection getRemoteMBeanServerNames(String dedicatedJMXManagerName) throws JMXConnectorNotReachableException {
        if (dedicatedJMXManagerName == null) {
            if (this.server != null) {
                return this.server;
            }
            throw new JeusRuntimeException("This JVM does not have local MBeanServer");
        }
        if (this.serverName != null && this.serverName.equals(dedicatedJMXManagerName)) {
            return this.server;
        }
        return (MBeanServerConnection)this.getEntity(dedicatedJMXManagerName, this.cachedMBeanServer);
    }

    public JMXConnector getRemoteJMXConnector(String dedicatedJMXManagerName) throws JMXConnectorNotReachableException {
        if (this.serverName != null && this.serverName.equals(dedicatedJMXManagerName)) {
            return null;
        }
        return (JMXConnector)this.getEntity(dedicatedJMXManagerName, this.cachedConnector);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getEntity(String dedicatedJMXManagerName, Map map) throws JMXConnectorNotReachableException {
        Object sc = map.get(dedicatedJMXManagerName);
        if (sc != null) {
            return sc;
        }
        MBeanServerChecker mBeanServerChecker = this;
        synchronized (mBeanServerChecker) {
            try {
                while (this.isConnecting) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.FINEST, "This thread is interrupted", (Throwable)e);
                    }
                    if ((sc = map.get(dedicatedJMXManagerName)) == null) continue;
                    Object e = sc;
                    return e;
                }
                this.isConnecting = true;
                this.connectServer(dedicatedJMXManagerName);
                Object e = map.get(dedicatedJMXManagerName);
                return e;
            }
            catch (JMXConnectorNotReachableException e) {
                throw e;
            }
            finally {
                this.isConnecting = false;
                this.notifyAll();
            }
        }
    }

    protected abstract void connectServer(String var1) throws JMXConnectorNotReachableException;

    public synchronized void removeMBeanServerCached(MBeanServerConnection svr) throws MBSCAlreadyClosedException {
        this.cachedMBeanServerSet.remove(svr);
        for (String serverName : this.cachedMBeanServer.keySet()) {
            MBeanServerConnection server = this.cachedMBeanServer.get(serverName);
            if (!server.equals(svr)) continue;
            this.cachedMBeanServer.remove(serverName);
            JMXConnector con = this.cachedConnector.remove(serverName);
            try {
                con.close();
            }
            catch (IOException ex) {
                if (!logger.isLoggable(JeusMessage_JMXRemote.JMX_09_LEVEL)) break;
                logger.log(JeusMessage_JMXRemote.JMX_09_LEVEL, JeusMessage_JMXRemote.JMX_09, (Throwable)ex);
            }
            break;
        }
    }

    private synchronized void removeMBeanServerCached(String serverName) throws MBSCAlreadyClosedException {
        block3: {
            MBeanServerConnection removedMbsc = this.cachedMBeanServer.remove(serverName);
            this.cachedMBeanServerSet.remove(removedMbsc);
            JMXConnector con = this.cachedConnector.remove(serverName);
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (IOException ex) {
                if (!logger.isLoggable(JeusMessage_JMXRemote.JMX_09_LEVEL)) break block3;
                logger.log(JeusMessage_JMXRemote.JMX_09_LEVEL, JeusMessage_JMXRemote.JMX_09, (Throwable)ex);
            }
        }
    }

    public void closeConnection() {
        this.cachedMBeanServerSet.clear();
        this.cachedMBeanServer.clear();
        for (JMXConnector jmxConnector : this.cachedConnector.values()) {
            try {
                jmxConnector.close();
            }
            catch (IOException e) {
                if (!logger.isLoggable(JeusMessage_JMXRemote.JMX_09_LEVEL)) continue;
                logger.log(JeusMessage_JMXRemote.JMX_09_LEVEL, JeusMessage_JMXRemote.JMX_09, (Throwable)e);
            }
        }
        this.cachedConnector.clear();
    }
}

