/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.enterprise.agent;

import java.io.IOException;
import java.io.NotSerializableException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import jeus.management.JMXManagerException;
import jeus.management.JeusMBeanServerAccessController;
import jeus.management.enterprise.agent.ClusterChecker;
import jeus.management.enterprise.agent.DefaultMBeanServerCheckerFactory;
import jeus.management.enterprise.agent.JMXConnectorNotReachableException;
import jeus.management.enterprise.agent.MBSCAlreadyClosedException;
import jeus.management.enterprise.agent.MBeanServerChecker;
import jeus.management.enterprise.agent.MBeanServerCheckerFactory;
import jeus.management.remote.security.JeusSecurityClientHandler;
import jeus.security.base.AnonymousSubject;
import jeus.security.base.Subject;
import jeus.security.spi.LoginService;
import jeus.security.util.LoginUtil;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusPort;
import jeus.util.JeusRuntimeException;
import jeus.util.SecurityUtil;
import jeus.util.VirtualDNS;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JMXRemote;
import jeus.util.properties.JeusNetPropertyValues;

public class MEJBUtility
implements MBeanServerConnection {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.management");
    private static final ConcurrentMap<Hashtable, MEJBUtility> utilityMap = new ConcurrentHashMap<Hashtable, MEJBUtility>();
    public static final String JEUS_SECURITY_SUBJECT_KEY = "JeusSecuritySubject";
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private static MBeanServer localMBeanServer;
    private static String localMBeanServerName;
    static ClusterChecker clusterChecker;
    private static final ThreadLocal doNotRetry;
    private MBeanServerChecker mbeanServerChecker;
    private MBeanServer server;
    private Hashtable jndiEnv;
    private static MBeanServerCheckerFactory mbeanServerCheckerFactory;

    private MEJBUtility(MBeanServer server, String serverName, Subject subject, Hashtable jndiEnv) throws JMXManagerException {
        if (logger.isLoggable(JeusMessage_JMXRemote.JMX_1_LEVEL)) {
            logger.log(JeusMessage_JMXRemote.JMX_1_LEVEL, JeusMessage_JMXRemote.JMX_1, (Object)subject);
        }
        this.server = server;
        if (server != null) {
            server = new JeusMBeanServerAccessController(subject, server);
        }
        this.jndiEnv = jndiEnv;
        this.mbeanServerChecker = mbeanServerCheckerFactory.createMBeanServerChecker(serverName, server, jndiEnv);
    }

    public static MEJBUtility getMEJBUtility() throws JMXManagerException {
        return MEJBUtility.getMEJBUtility(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MEJBUtility getMEJBUtility(Hashtable jndiEnv) throws JMXManagerException {
        String serverName;
        jndiEnv = jndiEnv == null ? new Hashtable() : new Hashtable<String, Object>(jndiEnv);
        int baseport = JeusPort.JeusBase;
        if (jndiEnv.get("java.naming.provider.url") != null) {
            serverName = (String)jndiEnv.get("java.naming.provider.url");
            if (serverName.lastIndexOf(":") == -1) {
                serverName = VirtualDNS.getRealNodeName(serverName);
            }
            int index = serverName.lastIndexOf(":");
            baseport = Integer.parseInt(serverName.substring(index + 1));
            serverName = serverName.substring(0, index);
            jndiEnv.put("java.naming.provider.url", serverName + ":" + baseport);
        } else {
            jndiEnv.put("java.naming.provider.url", JeusNetPropertyValues.LOCAL_LOOPBACK_ADDRESS);
            serverName = JeusNetPropertyValues.LOCAL_LOOPBACK_ADDRESS;
        }
        try {
            String username;
            Subject loginSubject = LoginService.getCurrentSubject();
            Object credential = jndiEnv.get("java.naming.security.credentials");
            if (loginSubject == null || loginSubject instanceof AnonymousSubject) {
                SecurityUtil.installClientSecurity(serverName + ":" + baseport);
                username = (String)jndiEnv.get("java.naming.security.principal");
                if (credential instanceof X509Certificate) {
                    loginSubject = new Subject(null, null);
                    loginSubject.getPublicCredentials().add(credential);
                    LoginUtil.loginWithRuntimeException(loginSubject);
                } else if (username != null && credential != null) {
                    loginSubject = Subject.makeSubject(username, (String)credential);
                    LoginUtil.loginWithRuntimeException(loginSubject);
                }
            } else {
                username = (String)jndiEnv.get("java.naming.security.principal");
                if (credential instanceof X509Certificate) {
                    loginSubject = new Subject(null, null);
                    loginSubject.getPrivateCredentials().add(credential);
                } else if (username != null && credential != null) {
                    loginSubject = Subject.makeSubject(username, (String)credential);
                }
            }
            jndiEnv.put("jeus.jndi.jns.loginsubject", loginSubject);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new JMXManagerException(e.toString());
        }
        Subject s = JeusSecurityClientHandler.putSubject(jndiEnv);
        MEJBUtility util = (MEJBUtility)utilityMap.get(jndiEnv);
        if (util != null) return util;
        Class<MEJBUtility> clazz = MEJBUtility.class;
        synchronized (MEJBUtility.class) {
            util = (MEJBUtility)utilityMap.get(jndiEnv);
            if (util != null) return util;
            util = new MEJBUtility(localMBeanServer, localMBeanServerName, s, jndiEnv);
            utilityMap.put(jndiEnv, util);
            // ** MonitorExit[var6_8] (shouldn't be in output)
            return util;
        }
    }

    public synchronized String[] getRemoteMBeanServerNames(boolean checkConnection) throws MBSCAlreadyClosedException {
        return this.mbeanServerChecker.getRemoteMBeanServerNames(checkConnection);
    }

    public MBeanServerConnection getRemoteMBeanServer(String dedicatedJMXManagerName) throws JMXConnectorNotReachableException, IOException {
        this.checkConnection();
        return this.mbeanServerChecker.getRemoteMBeanServerNames(dedicatedJMXManagerName);
    }

    static boolean isInCluster(String nodeName) {
        return clusterChecker == null || clusterChecker.isInWorkingCluster(nodeName);
    }

    public synchronized JMXConnector getRemoteJMXConnector(String dedicatedJMXManagerName) throws MBSCAlreadyClosedException, JMXConnectorNotReachableException {
        this.checkConnection();
        return this.mbeanServerChecker.getRemoteJMXConnector(dedicatedJMXManagerName);
    }

    private MBeanServerConnection findServer(ObjectName name) throws IOException, InstanceNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("The ObjectName object is null");
        }
        String dedicatedJMXManager = name.getKeyProperty("JMXManager");
        if (dedicatedJMXManager != null) {
            return this.getRemoteMBeanServer(dedicatedJMXManager);
        }
        throw new InstanceNotFoundException(ErrorMsgManager.getLocalizedString(JeusMessage_JMXRemote.JMX_07));
    }

    public Set queryNames(ObjectName name, QueryExp query) throws IOException {
        String dedicatedJMXManager;
        this.checkConnection();
        if (name != null && (dedicatedJMXManager = name.getKeyProperty("JMXManager")) != null) {
            MBeanServerConnection server = this.getRemoteMBeanServer(dedicatedJMXManager);
            try {
                return server.queryNames(name, query);
            }
            catch (NotSerializableException ex) {
                throw ex;
            }
            catch (IOException e) {
                if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                    logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
                }
                if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                    logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)e);
                }
                this.mbeanServerChecker.removeMBeanServerCached(server);
                server = this.getRemoteMBeanServer(dedicatedJMXManager);
                return server.queryNames(name, query);
            }
        }
        HashSet<ObjectName> names = null;
        boolean needRetry = false;
        Iterator<MBeanServerConnection> servers = null;
        for (int retryCount = 0; retryCount <= 1; ++retryCount) {
            names = new HashSet<ObjectName>();
            servers = this.mbeanServerChecker.getRemoteMBeanServers().iterator();
            while (servers.hasNext()) {
                MBeanServerConnection iiopserver = servers.next();
                try {
                    names.addAll(iiopserver.queryNames(name, query));
                }
                catch (NotSerializableException ex) {
                    throw ex;
                }
                catch (IOException e) {
                    if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                        logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
                    }
                    if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                        logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)e);
                    }
                    servers.remove();
                    this.mbeanServerChecker.removeMBeanServerCached(iiopserver);
                    needRetry = true;
                }
            }
            if (needRetry) continue;
            return names;
        }
        return names;
    }

    public boolean isRegistered(ObjectName name) throws IOException {
        this.checkConnection();
        try {
            MBeanServerConnection svr = this.findServer(name);
            try {
                return svr.isRegistered(name);
            }
            catch (NotSerializableException ex) {
                throw ex;
            }
            catch (IOException ex) {
                if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                    logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
                }
                if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                    logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)ex);
                }
                this.mbeanServerChecker.removeMBeanServerCached(svr);
                svr = this.findServer(name);
                return svr.isRegistered(name);
            }
        }
        catch (InstanceNotFoundException ex) {
            throw new JeusRuntimeException(ex);
        }
    }

    public Integer getMBeanCount() throws IOException {
        this.checkConnection();
        int i = 0;
        Set<MBeanServerConnection> syncServerSet = Collections.synchronizedSet(this.mbeanServerChecker.getRemoteMBeanServers());
        Iterator<MBeanServerConnection> servers = syncServerSet.iterator();
        while (servers.hasNext()) {
            MBeanServerConnection iiopserver = servers.next();
            try {
                i += iiopserver.getMBeanCount().intValue();
            }
            catch (NotSerializableException ex) {
                throw ex;
            }
            catch (IOException ex) {
                if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                    logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
                }
                if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                    logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)ex);
                }
                this.mbeanServerChecker.removeMBeanServerCached(iiopserver);
                i = 0;
                servers = this.mbeanServerChecker.getRemoteMBeanServers().iterator();
            }
        }
        return i;
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        this.checkConnection();
        MBeanServerConnection server = this.findServer(name);
        try {
            return server.getMBeanInfo(name);
        }
        catch (NotSerializableException ex) {
            throw ex;
        }
        catch (IOException ex) {
            if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
            }
            if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)ex);
            }
            this.mbeanServerChecker.removeMBeanServerCached(server);
            server = this.findServer(name);
            return server.getMBeanInfo(name);
        }
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        this.checkConnection();
        MBeanServerConnection svr = this.findServer(name);
        try {
            return svr.getAttribute(name, attribute);
        }
        catch (NotSerializableException ex) {
            throw ex;
        }
        catch (IOException ex) {
            if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
            }
            if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)ex);
            }
            this.mbeanServerChecker.removeMBeanServerCached(svr);
            svr = this.findServer(name);
            return svr.getAttribute(name, attribute);
        }
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        this.checkConnection();
        MBeanServerConnection svr = this.findServer(name);
        try {
            return svr.getAttributes(name, attributes);
        }
        catch (NotSerializableException ex) {
            throw ex;
        }
        catch (IOException ex) {
            if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
            }
            if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)ex);
            }
            this.mbeanServerChecker.removeMBeanServerCached(svr);
            svr = this.findServer(name);
            return svr.getAttributes(name, attributes);
        }
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        this.checkConnection();
        MBeanServerConnection svr = this.findServer(name);
        try {
            svr.setAttribute(name, attribute);
        }
        catch (NotSerializableException ex) {
            throw ex;
        }
        catch (IOException ex) {
            if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
            }
            if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)ex);
            }
            this.mbeanServerChecker.removeMBeanServerCached(svr);
            svr = this.findServer(name);
            svr.setAttribute(name, attribute);
        }
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        this.checkConnection();
        MBeanServerConnection svr = this.findServer(name);
        try {
            return svr.setAttributes(name, attributes);
        }
        catch (NotSerializableException ex) {
            throw ex;
        }
        catch (IOException ex) {
            if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
            }
            if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)ex);
            }
            this.mbeanServerChecker.removeMBeanServerCached(svr);
            svr = this.findServer(name);
            return svr.setAttributes(name, attributes);
        }
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        this.checkConnection();
        MBeanServerConnection svr = this.findServer(name);
        try {
            return svr.invoke(name, operationName, params, signature);
        }
        catch (NotSerializableException ex) {
            throw ex;
        }
        catch (IOException ex) {
            if (doNotRetry.get() != null) {
                throw ex;
            }
            if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
            }
            if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)ex);
            }
            this.mbeanServerChecker.removeMBeanServerCached(svr);
            svr = this.findServer(name);
            return svr.invoke(name, operationName, params, signature);
        }
    }

    public String getDefaultDomain() {
        if (this.server != null) {
            return this.server.getDefaultDomain();
        }
        return null;
    }

    public String[] getDomains() throws IOException {
        this.checkConnection();
        ArrayList<String> domainList = new ArrayList<String>();
        Set<MBeanServerConnection> syncServerSet = Collections.synchronizedSet(this.mbeanServerChecker.getRemoteMBeanServers());
        Iterator<MBeanServerConnection> servers = syncServerSet.iterator();
        while (servers.hasNext()) {
            MBeanServerConnection iiopserver = servers.next();
            try {
                String[] domains = iiopserver.getDomains();
                domainList.addAll(Arrays.asList(domains));
            }
            catch (NotSerializableException ex) {
                throw ex;
            }
            catch (IOException ex) {
                if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                    logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
                }
                if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                    logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)ex);
                }
                this.mbeanServerChecker.removeMBeanServerCached(iiopserver);
                servers = this.mbeanServerChecker.getRemoteMBeanServers().iterator();
                domainList = new ArrayList();
            }
        }
        return domainList.toArray(new String[domainList.size()]);
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        this.checkConnection();
        try {
            MBeanServerConnection server = this.findServer(name);
            try {
                return server.createMBean(className, name);
            }
            catch (NotSerializableException ex) {
                throw ex;
            }
            catch (IOException ex) {
                if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                    logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
                }
                if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                    logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)ex);
                }
                this.mbeanServerChecker.removeMBeanServerCached(server);
                server = this.findServer(name);
                return server.createMBean(className, name);
            }
        }
        catch (InstanceNotFoundException ex) {
            throw new JeusRuntimeException(ex);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        this.checkConnection();
        MBeanServerConnection server = this.findServer(name);
        try {
            return server.createMBean(className, name, loaderName);
        }
        catch (NotSerializableException ex) {
            throw ex;
        }
        catch (IOException ex) {
            if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
            }
            if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)ex);
            }
            this.mbeanServerChecker.removeMBeanServerCached(server);
            server = this.findServer(name);
            return server.createMBean(className, name, loaderName);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        this.checkConnection();
        try {
            MBeanServerConnection server = this.findServer(name);
            try {
                return server.createMBean(className, name, params, signature);
            }
            catch (NotSerializableException ex) {
                throw ex;
            }
            catch (IOException ex) {
                if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                    logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
                }
                if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                    logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)ex);
                }
                this.mbeanServerChecker.removeMBeanServerCached(server);
                server = this.findServer(name);
                return server.createMBean(className, name, params, signature);
            }
        }
        catch (InstanceNotFoundException ex) {
            throw new JeusRuntimeException(ex);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        this.checkConnection();
        MBeanServerConnection server = this.findServer(name);
        try {
            return server.createMBean(className, name, loaderName, params, signature);
        }
        catch (NotSerializableException ex) {
            throw ex;
        }
        catch (IOException ex) {
            if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
            }
            if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)ex);
            }
            this.mbeanServerChecker.removeMBeanServerCached(server);
            server = this.findServer(name);
            return server.createMBean(className, name, loaderName, params, signature);
        }
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        this.checkConnection();
        MBeanServerConnection svr = this.findServer(name);
        try {
            svr.unregisterMBean(name);
        }
        catch (NotSerializableException ex) {
            throw ex;
        }
        catch (IOException ex) {
            if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
            }
            if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)ex);
            }
            this.mbeanServerChecker.removeMBeanServerCached(svr);
            svr = this.findServer(name);
            svr.unregisterMBean(name);
        }
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
        this.checkConnection();
        MBeanServerConnection server = this.findServer(name);
        try {
            return server.getObjectInstance(name);
        }
        catch (NotSerializableException ex) {
            throw ex;
        }
        catch (IOException ex) {
            if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
            }
            if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)ex);
            }
            this.mbeanServerChecker.removeMBeanServerCached(server);
            server = this.findServer(name);
            return server.getObjectInstance(name);
        }
    }

    public Set queryMBeans(ObjectName name, QueryExp query) throws IOException {
        String dedicatedJMXManager;
        this.checkConnection();
        HashSet<ObjectInstance> names = new HashSet<ObjectInstance>();
        if (name != null && (dedicatedJMXManager = name.getKeyProperty("JMXManager")) != null) {
            MBeanServerConnection server = this.getRemoteMBeanServer(dedicatedJMXManager);
            try {
                return server.queryMBeans(name, query);
            }
            catch (NotSerializableException ex) {
                throw ex;
            }
            catch (IOException ex) {
                if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                    logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
                }
                if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                    logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)ex);
                }
                this.mbeanServerChecker.removeMBeanServerCached(server);
                server = this.getRemoteMBeanServer(dedicatedJMXManager);
                return server.queryMBeans(name, query);
            }
        }
        Set<MBeanServerConnection> syncServerSet = Collections.synchronizedSet(this.mbeanServerChecker.getRemoteMBeanServers());
        Iterator<MBeanServerConnection> servers = syncServerSet.iterator();
        while (servers.hasNext()) {
            MBeanServerConnection iiopserver = servers.next();
            try {
                names.addAll(iiopserver.queryMBeans(name, query));
            }
            catch (NotSerializableException ex) {
                throw ex;
            }
            catch (IOException ex) {
                if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                    logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
                }
                if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                    logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)ex);
                }
                this.mbeanServerChecker.removeMBeanServerCached(iiopserver);
                servers = this.mbeanServerChecker.getRemoteMBeanServers().iterator();
                names = new HashSet();
            }
        }
        return names;
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        this.checkConnection();
        if (name == null) {
            throw new IllegalArgumentException("The ObjectName object is null");
        }
        String dedicatedJMXManager = name.getKeyProperty("JMXManager");
        if (dedicatedJMXManager == null) {
            throw new IllegalArgumentException("The ObjectName object for MEJBUtility should contain JMXManager property key to perform this operation");
        }
        MBeanServerConnection svr = this.getRemoteMBeanServer(dedicatedJMXManager);
        try {
            svr.addNotificationListener(name, listener, filter, handback);
        }
        catch (NotSerializableException ex) {
            throw ex;
        }
        catch (IOException ex) {
            if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
            }
            if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)ex);
            }
            this.mbeanServerChecker.removeMBeanServerCached(svr);
            svr = this.findServer(name);
            svr.addNotificationListener(name, listener, filter, handback);
        }
        JMXConnector connector = this.getRemoteJMXConnector(dedicatedJMXManager);
        if (connector != null) {
            connector.addConnectionNotificationListener(listener, filter, handback);
        }
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        this.checkConnection();
        MBeanServerConnection svr = this.findServer(name);
        try {
            svr.addNotificationListener(name, listener, filter, handback);
        }
        catch (NotSerializableException ex) {
            throw ex;
        }
        catch (IOException ex) {
            if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
            }
            if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)ex);
            }
            this.mbeanServerChecker.removeMBeanServerCached(svr);
            svr = this.findServer(name);
            svr.addNotificationListener(name, listener, filter, handback);
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.checkConnection();
        if (name == null) {
            throw new IllegalArgumentException("The ObjectName object is null");
        }
        String dedicatedJMXManager = name.getKeyProperty("JMXManager");
        if (dedicatedJMXManager == null) {
            throw new IllegalArgumentException("The ObjectName object for MEJBUtility should contain JMXManager property key to perform this operation");
        }
        MBeanServerConnection svr = this.getRemoteMBeanServer(dedicatedJMXManager);
        try {
            svr.removeNotificationListener(name, listener);
        }
        catch (NotSerializableException ex) {
            throw ex;
        }
        catch (IOException ex) {
            if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
            }
            if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)ex);
            }
            this.mbeanServerChecker.removeMBeanServerCached(svr);
            svr = this.findServer(name);
            svr.removeNotificationListener(name, listener);
        }
        JMXConnector connector = this.getRemoteJMXConnector(dedicatedJMXManager);
        if (connector != null) {
            connector.removeConnectionNotificationListener(listener);
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.checkConnection();
        if (name == null) {
            throw new IllegalArgumentException("The ObjectName object is null");
        }
        String dedicatedJMXManager = name.getKeyProperty("JMXManager");
        if (dedicatedJMXManager == null) {
            throw new InstanceNotFoundException(ErrorMsgManager.getLocalizedString(JeusMessage_JMXRemote.JMX_07));
        }
        MBeanServerConnection svr = this.getRemoteMBeanServer(dedicatedJMXManager);
        try {
            svr.removeNotificationListener(name, listener, filter, handback);
        }
        catch (NotSerializableException ex) {
            throw ex;
        }
        catch (IOException ex) {
            if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
            }
            if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)ex);
            }
            this.mbeanServerChecker.removeMBeanServerCached(svr);
            svr = this.findServer(name);
            svr.removeNotificationListener(name, listener, filter, handback);
        }
        JMXConnector connector = this.getRemoteJMXConnector(dedicatedJMXManager);
        if (connector != null) {
            connector.removeConnectionNotificationListener(listener, filter, handback);
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.checkConnection();
        MBeanServerConnection svr = this.findServer(name);
        try {
            svr.removeNotificationListener(name, listener);
        }
        catch (NotSerializableException ex) {
            throw ex;
        }
        catch (IOException ex) {
            if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
            }
            if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)ex);
            }
            this.mbeanServerChecker.removeMBeanServerCached(svr);
            svr = this.findServer(name);
            svr.removeNotificationListener(name, listener);
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.checkConnection();
        MBeanServerConnection svr = this.findServer(name);
        try {
            svr.removeNotificationListener(name, listener, filter, handback);
        }
        catch (NotSerializableException ex) {
            throw ex;
        }
        catch (IOException ex) {
            if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
            }
            if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)ex);
            }
            this.mbeanServerChecker.removeMBeanServerCached(svr);
            svr = this.findServer(name);
            svr.removeNotificationListener(name, listener, filter, handback);
        }
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
        this.checkConnection();
        MBeanServerConnection svr = this.findServer(name);
        try {
            return svr.isInstanceOf(name, className);
        }
        catch (NotSerializableException ex) {
            throw ex;
        }
        catch (IOException ex) {
            if (logger.isLoggable(JeusMessage_JMXRemote.JMX_08_LEVEL)) {
                logger.log(JeusMessage_JMXRemote.JMX_08_LEVEL, JeusMessage_JMXRemote.JMX_08);
            }
            if (logger.isLoggable(JeusMessage_JMXRemote._80_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._80_LEVEL, JeusMessage_JMXRemote._80, (Throwable)ex);
            }
            this.mbeanServerChecker.removeMBeanServerCached(svr);
            svr = this.findServer(name);
            return svr.isInstanceOf(name, className);
        }
    }

    public static void clear() {
        MEJBUtility[] i = utilityMap.values().toArray(new MEJBUtility[0]);
        for (int j = 0; j < i.length; ++j) {
            MEJBUtility mejbUtility = i[j];
            mejbUtility.closeConnection();
        }
        utilityMap.clear();
    }

    public void closeConnection() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.mbeanServerChecker.closeConnection();
        }
    }

    private void checkConnection() throws MBSCAlreadyClosedException {
        if (this.isClosed.get()) {
            throw new MBSCAlreadyClosedException("JMX Connectors are already closed");
        }
    }

    public Object getCredential() {
        return this.jndiEnv.get("jeus.subject");
    }

    public static void setMBeanServer(MBeanServer mBeanServer) {
        localMBeanServer = mBeanServer;
    }

    public static void setServerName(String jmxMgrName) {
        localMBeanServerName = jmxMgrName;
    }

    public static void setClusterChecker(ClusterChecker jeusServer) {
        clusterChecker = jeusServer;
    }

    public static void setMBeanServerCheckerFactory(MBeanServerCheckerFactory jeusServer) {
        mbeanServerCheckerFactory = jeusServer;
    }

    public static void setNotRetry(boolean notRetry) {
        if (notRetry) {
            doNotRetry.set(doNotRetry);
        } else {
            doNotRetry.set(null);
        }
    }

    static {
        doNotRetry = new ThreadLocal();
        Class<?> c = null;
        try {
            c = MEJBUtility.class.getClassLoader().loadClass("jeus.management.enterprise.agent.JeusMBeanServerCheckerFactory");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (c != null) {
            try {
                mbeanServerCheckerFactory = (MBeanServerCheckerFactory)c.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else {
            mbeanServerCheckerFactory = new DefaultMBeanServerCheckerFactory();
        }
    }
}

