/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.statistics;

import java.util.concurrent.atomic.AtomicLong;
import javax.management.j2ee.statistics.CountStatistic;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.util.StringUtil;

public class CountStatisticImpl
extends StatisticImpl
implements CountStatistic {
    private volatile AtomicLong count = new AtomicLong();

    public CountStatisticImpl(String pName, String pUnit, String pDesc) {
        super(pName, pUnit, pDesc);
    }

    public CountStatisticImpl(String sName, String pName, String pUnit, String pDesc) {
        super(sName, pName, pUnit, pDesc);
    }

    public long getCount() {
        return this.count.get();
    }

    public void increase() {
        this.count.incrementAndGet();
        this.sampled();
    }

    public long incrementAndGet() {
        long c = this.count.incrementAndGet();
        this.sampled();
        return c;
    }

    public void increase(long amount) {
        this.count.addAndGet(amount);
        this.sampled();
    }

    public void decrease() {
        this.count.decrementAndGet();
        this.sampled();
    }

    public void setValue(long value) {
        this.count.set(value);
        this.sampled();
    }

    public void reset() {
        this.count.set(0L);
        this.sampled();
    }

    public void update(CountStatisticImpl stats) {
        super.update(stats);
        this.count = stats.count;
    }

    public String getShortStats() {
        return "C:" + this.count.get();
    }

    public String getStatisticName() {
        return "CountStatistic";
    }

    public String toString() {
        String stat = super.toString();
        StringBuilder buffer = new StringBuilder(stat).append(StringUtil.lineSeparator);
        buffer.append('\t').append("count : ").append(this.count.get()).append(StringUtil.lineSeparator);
        return buffer.toString();
    }
}

