/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.statistics;

import java.util.concurrent.atomic.AtomicLong;
import javax.management.j2ee.statistics.RangeStatistic;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.util.StringUtil;

public class RangeStatisticImpl
extends StatisticImpl
implements RangeStatistic {
    private final AtomicLong high = new AtomicLong(0L);
    private final AtomicLong low = new AtomicLong(0L);
    private final AtomicLong current = new AtomicLong(0L);

    public RangeStatisticImpl(String pName, String pUnit, String pDesc) {
        super(pName, pUnit, pDesc);
    }

    public RangeStatisticImpl(String sName, String pName, String pUnit, String pDesc) {
        super(sName, pName, pUnit, pDesc);
    }

    public long getHighWaterMark() {
        return this.high.get();
    }

    public long getLowWaterMark() {
        return this.low.get();
    }

    public long getCurrent() {
        return this.current.get();
    }

    private void setWaterMark(long currentValue) {
        block2: {
            while (true) {
                long high = this.high.get();
                long low = this.low.get();
                if (currentValue > high) {
                    if (!this.high.compareAndSet(high, currentValue)) continue;
                    return;
                }
                if (currentValue >= low) break block2;
                if (this.low.compareAndSet(low, currentValue)) break;
            }
            return;
        }
    }

    public void increase() {
        this.increase(1);
    }

    public void increase(int amount) {
        this.sampled();
        long currentValue = this.current.addAndGet(amount);
        this.high.compareAndSet(0L, currentValue);
        this.setWaterMark(currentValue);
    }

    public void decrease() {
        this.decrease(1);
    }

    public void decrease(int amount) {
        this.sampled();
        long currentValue = this.current.addAndGet(-amount);
        this.low.compareAndSet(0L, currentValue);
        this.setWaterMark(currentValue);
    }

    public void set(long value) {
        this.sampled();
        this.current.set(value);
        this.high.compareAndSet(0L, value);
        this.low.compareAndSet(0L, value);
        this.setWaterMark(value);
    }

    public String getShortStats() {
        return "R:" + this.high.get() + ":" + this.current.get() + ":" + this.low.get();
    }

    public String getStatisticName() {
        return "RangeStatistic";
    }

    public String toString() {
        String stat = super.toString();
        StringBuffer buffer = new StringBuffer(stat).append(StringUtil.lineSeparator);
        buffer.append('\t').append("High watermark : ").append(this.high.get()).append(StringUtil.lineSeparator);
        buffer.append('\t').append("Current : ").append(this.current.get()).append(StringUtil.lineSeparator);
        buffer.append('\t').append("Low watermark : ").append(this.low.get()).append(StringUtil.lineSeparator);
        return buffer.toString();
    }
}

