/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.statistics;

import java.io.Serializable;
import java.util.Date;
import jeus.management.j2ee.statistics.Statistic;
import jeus.util.StringUtil;

public abstract class StatisticImpl
implements Statistic,
Serializable {
    protected final String name;
    protected final String unit;
    protected final String desc;
    protected final String shortName;
    protected volatile long startTime;
    protected volatile long lastSampleTime;
    private volatile transient String debugName;

    public StatisticImpl(String pName, String pUnit, String pDescription) {
        this(pName, pName, pUnit, pDescription);
    }

    public StatisticImpl(String sName, String pName, String pUnit, String pDescription) {
        this.name = pName;
        this.unit = pUnit;
        this.desc = pDescription;
        this.shortName = sName;
        this.startTime = System.currentTimeMillis();
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getDescription() {
        return this.desc;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getLastSampleTime() {
        return this.lastSampleTime;
    }

    public void update(StatisticImpl stats) {
        this.startTime = stats.startTime;
        this.lastSampleTime = stats.lastSampleTime;
        this.debugName = null;
    }

    public String toString() {
        String s = this.debugName;
        if (s == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.name).append(" [").append(this.getStatisticName()).append(']').append(" : ").append(StringUtil.lineSeparator);
            buffer.append('\t').append("description : ").append(this.desc).append(StringUtil.lineSeparator);
            buffer.append('\t').append("unit : ").append(this.unit).append(StringUtil.lineSeparator);
            buffer.append('\t').append("statistic start time : ").append(new Date(this.startTime)).append(StringUtil.lineSeparator);
            buffer.append('\t').append("last sample time : ").append(new Date(this.startTime)).append(StringUtil.lineSeparator);
            this.debugName = s = buffer.toString();
        }
        return s;
    }

    protected void sampled() {
        this.lastSampleTime = System.currentTimeMillis();
    }
}

