/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.j2ee.statistics;

import java.util.concurrent.atomic.AtomicLong;
import javax.management.j2ee.statistics.TimeStatistic;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.util.StringUtil;

public class TimeStatisticImpl
extends StatisticImpl
implements TimeStatistic {
    private final AtomicLong count = new AtomicLong(0L);
    private final AtomicLong maxTime = new AtomicLong(0L);
    private final AtomicLong minTime = new AtomicLong(0L);
    private final AtomicLong totalTime = new AtomicLong(0L);

    public TimeStatisticImpl(String pName, String pUnit, String pDesc) {
        super(pName, pUnit, pDesc);
    }

    public TimeStatisticImpl(String sName, String pName, String pUnit, String pDesc) {
        super(sName, pName, pUnit, pDesc);
    }

    public long getCount() {
        return this.count.get();
    }

    public long getMaxTime() {
        return this.maxTime.get();
    }

    public long getMinTime() {
        return this.minTime.get();
    }

    public long getTotalTime() {
        return this.totalTime.get();
    }

    public void addData(long time) {
        if (time <= 0L) {
            return;
        }
        this.totalTime.addAndGet(time);
        if (time > this.maxTime.get()) {
            this.maxTime.set(time);
        }
        if (!this.minTime.compareAndSet(0L, time) && time < this.minTime.get()) {
            this.minTime.set(time);
        }
        this.count.incrementAndGet();
        this.sampled();
    }

    public void reset() {
        this.count.set(0L);
        this.maxTime.set(0L);
        this.minTime.set(0L);
        this.totalTime.set(0L);
    }

    public String getShortStats() {
        return "T:" + this.minTime.get() + ":" + this.maxTime.get() + ":" + this.totalTime.get();
    }

    public String getStatisticName() {
        return "TimeStatistic";
    }

    public void update(TimeStatisticImpl stats) {
        super.update(stats);
        this.count.set(stats.count.get());
        this.maxTime.set(stats.maxTime.get());
        this.minTime.set(stats.minTime.get());
        this.totalTime.set(stats.totalTime.get());
    }

    public String toString() {
        String stat = super.toString();
        StringBuffer buffer = new StringBuffer(stat).append(StringUtil.lineSeparator);
        buffer.append('\t').append("Sample Count : ").append(this.count.get()).append(StringUtil.lineSeparator);
        buffer.append('\t').append("Min time : ").append(this.minTime.get()).append(StringUtil.lineSeparator);
        buffer.append('\t').append("Max time : ").append(this.maxTime.get()).append(StringUtil.lineSeparator);
        buffer.append('\t').append("Total time : ").append(this.totalTime.get()).append(StringUtil.lineSeparator);
        return buffer.toString();
    }
}

