/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.remote;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Map;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.generic.MessageConnectionServer;
import jeus.io.SocketListener;
import jeus.management.JeusMBeanServerAccessController;
import jeus.management.remote.generic.ClientSynchroMessageNonblockingConnectionImpl;
import jeus.management.remote.generic.SynchroMessageNonblockingConnectionServerImpl;
import jeus.management.remote.jeusmp.OneSocketNonblockingConnection;
import jeus.management.remote.jeusmp.OneSocketNonblockingConnectionServer;
import jeus.management.remote.jeusmp.SocketNonblockingConnection;
import jeus.management.remote.jeusmp.SocketNonblockingConnectionServer;
import jeus.management.remote.security.JeusSecurityClientHandler;
import jeus.security.base.Subject;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JMXRemote;
import jeus.util.properties.JeusJMXPropertyValues;
import jeus.util.properties.JeusNetPropertyValues;

public class JeusMPUtility {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.management.remote");

    public static JMXConnectorServer exportJeusMPConnector(int connectorPort, int basePort, String virtualID, Hashtable env) throws IOException {
        SocketListener connectionServer;
        JMXServiceURL url;
        if (connectorPort == 0) {
            url = new JMXServiceURL("jmxmp", JeusNetPropertyValues.LOCAL_HOSTADDRESS, basePort, virtualID);
            connectionServer = new OneSocketNonblockingConnectionServer(url, env);
        } else {
            url = new JMXServiceURL("jmxmp", JeusNetPropertyValues.LOCAL_HOSTADDRESS, connectorPort);
            connectionServer = new SocketNonblockingConnectionServer(url, env);
        }
        if (logger.isLoggable(JeusMessage_JMXRemote.JMX_138_LEVEL)) {
            logger.log(JeusMessage_JMXRemote.JMX_138_LEVEL, JeusMessage_JMXRemote.JMX_138, (Object)url.toString());
        }
        env.put("jmx.remote.profiles", "JEUS/PLAIN");
        env.put("jmx.remote.protocol.provider.pkgs", "jeus.management.remote.protocol");
        env.put("jmx.remote.server.address.wildcard", "true");
        env.put("jmx.remote.profile.provider.pkgs", "jeus.management.remote.profile");
        env.put("com.sun.jmx.remote.generic.synchro.server", new SynchroMessageNonblockingConnectionServerImpl((MessageConnectionServer)((Object)connectionServer), env));
        JMXConnectorServer cs = JMXConnectorServerFactory.newJMXConnectorServer(url, env, JeusJMXPropertyValues.mBeanServer);
        cs.setMBeanServerForwarder(new JeusMBeanServerAccessController());
        cs.start();
        return cs;
    }

    public static JMXConnector createJeusMPClient(String protocol, String host, int port, String urlPath, Hashtable environment, int checktmout) throws IOException {
        Object[] urlAndEnv = JeusMPUtility.createJeusMPURLAndEnv(protocol, host, port, urlPath, environment, checktmout);
        return JMXConnectorFactory.connect((JMXServiceURL)urlAndEnv[0], (Map)urlAndEnv[1]);
    }

    public static Object[] createJeusMPURLAndEnv(String protocol, String host, int port, String urlPath, Hashtable environment, int checktmout) throws MalformedURLException {
        JMXServiceURL url = new JMXServiceURL(protocol, host, port, urlPath);
        Hashtable t = JeusMPUtility.createJeusMPEnv(environment, url, checktmout);
        return new Object[]{url, t};
    }

    public static Hashtable createJeusMPEnv(Hashtable environment, JMXServiceURL url, int checktmout) {
        Hashtable<String, Object> t = new Hashtable<String, Object>(environment);
        String urlForOnePort = url.getURLPath();
        SocketNonblockingConnection connection = urlForOnePort == null || urlForOnePort.equals("") ? new SocketNonblockingConnection(url.getHost(), url.getPort(), checktmout) : new OneSocketNonblockingConnection(url.getHost(), url.getPort(), url.getURLPath(), checktmout);
        t.put("jmx.remote.profiles", "JEUS/PLAIN");
        t.put("jmx.remote.profile.provider.pkgs", "jeus.management.remote.profile");
        t.put("jmx.remote.protocol.provider.pkgs", "jeus.management.remote.protocol");
        String jmxmpRequestWaitTime = System.getProperty("jmx.remote.x.request.timeout");
        if (jmxmpRequestWaitTime != null) {
            t.put("jmx.remote.x.request.timeout", jmxmpRequestWaitTime);
            if (logger.isLoggable(JeusMessage_JMXRemote._151_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._151_LEVEL, JeusMessage_JMXRemote._151, (Object)jmxmpRequestWaitTime);
            }
        }
        t.put("com.sun.jmx.remote.generic.synchro.client", new ClientSynchroMessageNonblockingConnectionImpl(connection, t));
        Subject s = (Subject)t.get("jeus.subject");
        if (s == null) {
            JeusSecurityClientHandler.putSubject(t);
        }
        return t;
    }
}

