/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.remote.generic;

import com.sun.jmx.remote.generic.ClientAdmin;
import com.sun.jmx.remote.generic.ClientSynchroMessageConnection;
import com.sun.jmx.remote.generic.DefaultConfig;
import com.sun.jmx.remote.generic.SynchroCallback;
import com.sun.jmx.remote.opt.util.EnvHelp;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.generic.ConnectionClosedException;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.CloseMessage;
import javax.management.remote.message.MBeanServerRequestMessage;
import javax.management.remote.message.MBeanServerResponseMessage;
import javax.management.remote.message.Message;
import javax.management.remote.message.NotificationRequestMessage;
import javax.management.remote.message.NotificationResponseMessage;
import jeus.management.remote.generic.MessageReader;
import jeus.management.remote.jeusmp.SocketNonblockingConnection;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JMXRemote;

public class ClientSynchroMessageNonblockingConnectionImpl
implements ClientSynchroMessageConnection,
MessageReader {
    private transient int[] connectionLock = new int[0];
    private transient MessageConnection connection;
    private transient ClientAdmin clientAdmin = null;
    private Map env;
    private transient long wtimeout;
    private transient HashMap waitingList = new HashMap();
    private transient Message notifResp = null;
    private final transient int[] notifLock = new int[0];
    private static final int UNCONNECTED = 1;
    private static final int CONNECTING = 2;
    private static final int CONNECTED = 3;
    private static final int FAILED = 4;
    private static final int TERMINATED = 5;
    private int state = 1;
    private int[] stateLock = new int[0];
    private long waitConnectedState;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.jmx.jmxmp");
    private SynchroCallback callback;

    public ClientSynchroMessageNonblockingConnectionImpl(MessageConnection mc, Map env) {
        if (mc == null) {
            throw new IllegalArgumentException("Null message connection.");
        }
        this.connection = mc;
        this.env = env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Map env) throws IOException {
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 1) {
                if (logger.isLoggable(JeusMessage_JMXRemote._85_LEVEL)) {
                    logger.log(JeusMessage_JMXRemote._85_LEVEL, JeusMessage_JMXRemote._85, (Object)this);
                }
                HashMap newEnv = new HashMap();
                if (this.env != null) {
                    newEnv.putAll(this.env);
                }
                if (env != null) {
                    newEnv.putAll(env);
                }
                this.wtimeout = DefaultConfig.getRequestTimeout(newEnv);
                this.waitConnectedState = DefaultConfig.getTimeoutForWaitConnectedState(newEnv);
                this.clientAdmin = DefaultConfig.getClientAdmin(newEnv);
                this.state = 2;
                this.stateLock.notifyAll();
                this.connection.connect(newEnv);
                this.connection = this.clientAdmin.connectionOpen(this.connection);
                this.env = newEnv;
                ((SocketNonblockingConnection)this.connection).setMessageReader(this);
                this.state = 3;
                this.stateLock.notifyAll();
            } else if (this.state == 4 || this.state == 3) {
                if (logger.isLoggable(JeusMessage_JMXRemote._86_LEVEL)) {
                    logger.log(JeusMessage_JMXRemote._86_LEVEL, JeusMessage_JMXRemote._86, (Object)this);
                }
                if (this.state == 3) {
                    this.state = 4;
                    this.stateLock.notifyAll();
                }
                this.state = 2;
                this.stateLock.notifyAll();
                int[] newEnv = this.connectionLock;
                synchronized (this.connectionLock) {
                    this.connection.connect(this.env);
                    this.connection = this.clientAdmin.connectionOpen(this.connection);
                    // ** MonitorExit[newEnv] (shouldn't be in output)
                    if (logger.isLoggable(JeusMessage_JMXRemote._87_LEVEL)) {
                        logger.log(JeusMessage_JMXRemote._87_LEVEL, JeusMessage_JMXRemote._87, (Object)this);
                    }
                    ConnectionClosedException ce = new ConnectionClosedException("The connection has been closed by the server.");
                    HashMap hashMap = this.waitingList;
                    synchronized (hashMap) {
                        for (Long id : this.waitingList.keySet()) {
                            ResponseMsgWrapper rm;
                            ResponseMsgWrapper responseMsgWrapper = rm = (ResponseMsgWrapper)this.waitingList.get(id);
                            synchronized (responseMsgWrapper) {
                                if (!rm.got) {
                                    rm.got = true;
                                    rm.msg = ce;
                                }
                                rm.notify();
                            }
                        }
                        this.waitingList.clear();
                    }
                    this.state = 3;
                    ((SocketNonblockingConnection)this.connection).setMessageReader(this);
                    this.stateLock.notifyAll();
                }
            } else {
                this.checkState();
            }
            {
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            {
                if (logger.isLoggable(JeusMessage_JMXRemote._88_LEVEL)) {
                    logger.log(JeusMessage_JMXRemote._88_LEVEL, JeusMessage_JMXRemote._88, (Object)this);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendOneWay(Message msg) throws IOException {
        if (logger.isLoggable(JeusMessage_JMXRemote._89_LEVEL)) {
            logger.log(JeusMessage_JMXRemote._89_LEVEL, JeusMessage_JMXRemote._89, (Object)this);
        }
        this.checkState();
        int[] nArray = this.connectionLock;
        synchronized (this.connectionLock) {
            this.connection.writeMessage(msg);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Message sendWithReturn(Message msg) throws IOException {
        this.checkState();
        Message ret = null;
        if (logger.isLoggable(JeusMessage_JMXRemote._90_LEVEL)) {
            logger.log(JeusMessage_JMXRemote._90_LEVEL, JeusMessage_JMXRemote._90, new Object[]{msg, this});
        }
        if (msg instanceof NotificationRequestMessage) {
            this.notifResp = null;
            int[] nArray = this.connectionLock;
            // MONITORENTER : this.connectionLock
            this.connection.writeMessage(msg);
            // MONITOREXIT : nArray
            nArray = this.notifLock;
            // MONITORENTER : this.notifLock
            while (true) {
                if (this.notifResp != null) {
                    ret = this.notifResp;
                    this.notifResp = null;
                    // MONITOREXIT : nArray
                    return ret;
                }
                try {
                    this.notifLock.wait();
                }
                catch (InterruptedException ire) {
                    InterruptedIOException iioe = new InterruptedIOException(ire.toString());
                    EnvHelp.initCause(iioe, ire);
                    throw iioe;
                }
            }
        }
        if (!(msg instanceof MBeanServerRequestMessage)) throw new IOException("Unknow message type: " + msg);
        Long id = new Long(((MBeanServerRequestMessage)msg).getMessageId());
        boolean retried = false;
        while (true) {
            ResponseMsgWrapper mwrapper = new ResponseMsgWrapper();
            Object object = this.waitingList;
            // MONITORENTER : object
            this.waitingList.put(id, mwrapper);
            // MONITOREXIT : object
            object = this.connectionLock;
            // MONITORENTER : this.connectionLock
            this.connection.writeMessage(msg);
            // MONITOREXIT : object
            long remainingTime = this.wtimeout;
            long startTime = System.currentTimeMillis();
            if (this.env.get("jmx.remote.x.request.timeout") != null && logger.isLoggable(JeusMessage_JMXRemote._152_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._152_LEVEL, JeusMessage_JMXRemote._152, (Object)new Long(remainingTime).toString());
            }
            Object object2 = mwrapper;
            // MONITORENTER : object2
            while (!mwrapper.got && remainingTime > 0L) {
                try {
                    mwrapper.wait(remainingTime);
                }
                catch (InterruptedException ie) {
                    break;
                }
                remainingTime = this.wtimeout - (System.currentTimeMillis() - startTime);
            }
            // MONITOREXIT : object2
            if (logger.isLoggable(JeusMessage_JMXRemote._153_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._153_LEVEL, JeusMessage_JMXRemote._153, (Object)new Long(remainingTime).toString());
            }
            object2 = this.waitingList;
            // MONITORENTER : object2
            this.waitingList.remove(id);
            // MONITOREXIT : object2
            if (!mwrapper.got) {
                if (this.isTerminated()) throw new IOException("The connection has been closed or broken.");
                throw new InterruptedIOException("Waiting response timeout: " + this.wtimeout);
            }
            if (mwrapper.msg instanceof MBeanServerResponseMessage) {
                return (MBeanServerResponseMessage)mwrapper.msg;
            }
            if (!(mwrapper.msg instanceof ConnectionClosedException)) throw new IOException("Got wrong response: " + mwrapper.msg);
            if (this.isTerminated()) throw (ConnectionClosedException)mwrapper.msg;
            if (retried) {
                throw (ConnectionClosedException)mwrapper.msg;
            }
            if (logger.isLoggable(JeusMessage_JMXRemote._91_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._91_LEVEL, JeusMessage_JMXRemote._91);
            }
            retried = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (logger.isLoggable(JeusMessage_JMXRemote._92_LEVEL)) {
            logger.log(JeusMessage_JMXRemote._92_LEVEL, JeusMessage_JMXRemote._92);
        }
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 5) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.state = 5;
            if (logger.isLoggable(JeusMessage_JMXRemote._93_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._93_LEVEL, JeusMessage_JMXRemote._93);
            }
            if (this.connection != null) {
                this.connection.close();
            }
            this.clientAdmin.connectionClosed(this.connection);
            if (logger.isLoggable(JeusMessage_JMXRemote._94_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._94_LEVEL, JeusMessage_JMXRemote._94);
            }
            HashMap hashMap = this.waitingList;
            synchronized (hashMap) {
                for (ResponseMsgWrapper rm : this.waitingList.values()) {
                    ConnectionClosedException ce = new ConnectionClosedException("The connection has been closed by the server.");
                    ResponseMsgWrapper responseMsgWrapper = rm;
                    synchronized (responseMsgWrapper) {
                        if (!rm.got) {
                            rm.got = true;
                            rm.msg = ce;
                        }
                        rm.notify();
                    }
                }
                this.waitingList.clear();
            }
            this.stateLock.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getConnectionId() {
        return this.clientAdmin.getConnectionId();
    }

    public MessageConnection getAsynchroConnection() {
        return this.connection;
    }

    public void connectionException(Exception ex) {
        if (this.callback != null) {
            this.callback.connectionException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void readMessage(Message msg) {
        try {
            block20: {
                block21: {
                    block19: {
                        if (!(msg instanceof NotificationResponseMessage)) break block19;
                        int[] nArray = this.notifLock;
                        // MONITORENTER : this.notifLock
                        this.notifResp = (NotificationResponseMessage)msg;
                        this.notifLock.notify();
                        // MONITOREXIT : nArray
                        break block20;
                    }
                    if (!(msg instanceof MBeanServerResponseMessage)) break block21;
                    Object object = this.waitingList;
                    // MONITORENTER : object
                    ResponseMsgWrapper mwrapper = (ResponseMsgWrapper)this.waitingList.get(new Long(((MBeanServerResponseMessage)msg).getMessageId()));
                    // MONITOREXIT : object
                    if (mwrapper == null) {
                        this.checkState();
                        if (logger.isLoggable(JeusMessage_JMXRemote._95_LEVEL)) {
                            logger.log(JeusMessage_JMXRemote._95_LEVEL, JeusMessage_JMXRemote._95);
                        }
                        break block20;
                    } else {
                        object = mwrapper;
                        // MONITORENTER : object
                        mwrapper.setMsg(msg);
                        mwrapper.notify();
                        // MONITOREXIT : object
                    }
                    break block20;
                }
                try {
                    Message resp = this.callback.execute(msg);
                    if (resp != null) {
                        int[] nArray = this.connectionLock;
                        // MONITORENTER : this.connectionLock
                        this.connection.writeMessage(resp);
                        // MONITOREXIT : nArray
                    }
                }
                catch (Exception ie) {
                    int[] nArray = this.stateLock;
                    // MONITORENTER : this.stateLock
                    if (this.state == 3 && this.callback != null) {
                        this.callback.connectionException(ie);
                    }
                    // MONITOREXIT : nArray
                }
            }
            if (!(msg instanceof CloseMessage)) return;
            return;
        }
        catch (Exception eee) {
            eee.printStackTrace();
        }
    }

    public void setSynchroCallback(SynchroCallback callback) {
        this.callback = callback;
    }

    private void checkState() throws IOException {
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 3) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (this.state == 5) {
                throw new IOException("The connection has been closed.");
            }
            long remainingTime = this.waitConnectedState;
            long startTime = System.currentTimeMillis();
            while (this.state != 3 && this.state != 5 && remainingTime > 0L) {
                try {
                    this.stateLock.wait(remainingTime);
                }
                catch (InterruptedException ire) {
                    break;
                }
                remainingTime = this.waitConnectedState - (System.currentTimeMillis() - startTime);
            }
            if (this.state == 3) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            throw new IOException("The connection is not currently established.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTerminated() {
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.state == 5;
        }
    }

    private static class ResponseMsgWrapper {
        public boolean got = false;
        public Object msg = null;

        public void setMsg(Message msg) {
            this.got = true;
            this.msg = msg;
        }
    }
}

